/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class Date
implements Serializable,
Cloneable,
Comparable {
    private transient Calendar cal = null;
    private transient long fastTime;
    private static Calendar staticCal = null;
    private static Calendar utcCal = null;
    private static int defaultCenturyStart = 0;
    private static final long serialVersionUID = 7523967970034938905L;
    private static SoftReference simpleFormatter = null;
    private static SoftReference gmtFormatter = null;
    private static final String[] wtb = new String[]{"am", "pm", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december", "gmt", "ut", "utc", "est", "edt", "cst", "cdt", "mst", "mdt", "pst", "pdt"};
    private static final int[] ttb = new int[]{14, 1, 0, 0, 0, 0, 0, 0, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 10000, 10000, 10000, 10300, 10240, 10360, 10300, 10420, 10360, 10480, 10420};

    public int getDate() {
        return this.getField(5);
    }

    public int getDay() {
        return this.getField(7) - 1;
    }

    public int getHours() {
        return this.getField(11);
    }

    public int getMinutes() {
        return this.getField(12);
    }

    public int getMonth() {
        return this.getField(2);
    }

    public int getSeconds() {
        return this.getField(13);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTimezoneOffset() {
        int n2;
        if (this.cal == null) {
            if (staticCal == null) {
                Date.makeStaticCalendars();
            }
            Calendar calendar = staticCal;
            synchronized (calendar) {
                staticCal.setTimeZone(TimeZone.getDefault());
                staticCal.setTimeInMillis(this.getTime());
                n2 = staticCal.get(15) + staticCal.get(16);
            }
        } else {
            TimeZone timeZone = TimeZone.getDefault();
            if (!timeZone.equals(this.cal.getTimeZone())) {
                long l2 = this.cal.getTimeInMillis();
                this.cal.setTimeZone(TimeZone.getDefault());
                this.cal.setTimeInMillis(l2);
            }
            n2 = this.cal.get(15) + this.cal.get(16);
        }
        return -(n2 / 1000 / 60);
    }

    public int getYear() {
        return this.getField(1) - 1900;
    }

    public int hashCode() {
        long l2 = this.getTime();
        return (int)l2 ^ (int)(l2 >> 32);
    }

    public long getTime() {
        return this.getTimeImpl();
    }

    private final long getTimeImpl() {
        return this.cal == null ? this.fastTime : this.cal.getTimeInMillis();
    }

    public Date() {
        this(System.currentTimeMillis());
    }

    private static synchronized void makeStaticCalendars() {
        if (staticCal == null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            utcCal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            defaultCenturyStart = gregorianCalendar.get(1) - 80;
            staticCal = gregorianCalendar;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getField(int n2) {
        if (this.cal == null) {
            if (staticCal == null) {
                Date.makeStaticCalendars();
            }
            Calendar calendar = staticCal;
            synchronized (calendar) {
                staticCal.setTimeZone(TimeZone.getDefault());
                staticCal.setTimeInMillis(this.fastTime);
                return staticCal.get(n2);
            }
        }
        TimeZone timeZone = TimeZone.getDefault();
        if (!timeZone.equals(this.cal.getTimeZone())) {
            long l2 = this.cal.getTimeInMillis();
            this.cal.setTimeZone(TimeZone.getDefault());
            this.cal.setTimeInMillis(l2);
        }
        return this.cal.get(n2);
    }

    public void setDate(int n2) {
        this.setField(5, n2);
    }

    public void setHours(int n2) {
        this.setField(11, n2);
    }

    public void setMinutes(int n2) {
        this.setField(12, n2);
    }

    public void setMonth(int n2) {
        this.setField(2, n2);
    }

    public void setSeconds(int n2) {
        this.setField(13, n2);
    }

    public void setYear(int n2) {
        this.setField(1, n2 + 1900);
    }

    private final void setField(int n2, int n3) {
        if (this.cal == null) {
            this.cal = new GregorianCalendar();
            this.cal.setTimeInMillis(this.fastTime);
        }
        this.cal.set(n2, n3);
    }

    public Date(int n2, int n3, int n4) {
        this(n2, n3, n4, 0, 0, 0);
    }

    public Date(int n2, int n3, int n4, int n5, int n6) {
        this(n2, n3, n4, n5, n6, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long UTC(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (utcCal == null) {
            Date.makeStaticCalendars();
        }
        Calendar calendar = utcCal;
        synchronized (calendar) {
            utcCal.clear();
            utcCal.set(n2 + 1900, n3, n4, n5, n6, n7);
            return utcCal.getTimeInMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date(int n2, int n3, int n4, int n5, int n6, int n7) {
        if (staticCal == null) {
            Date.makeStaticCalendars();
        }
        Calendar calendar = staticCal;
        synchronized (calendar) {
            staticCal.setTimeZone(TimeZone.getDefault());
            staticCal.clear();
            staticCal.set(n2 + 1900, n3, n4, n5, n6, n7);
            this.fastTime = staticCal.getTimeInMillis();
        }
    }

    public Date(long l2) {
        this.fastTime = l2;
    }

    public void setTime(long l2) {
        if (this.cal == null) {
            this.fastTime = l2;
        } else {
            this.cal.setTimeInMillis(l2);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.fastTime = objectInputStream.readLong();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeLong(this.getTimeImpl());
    }

    public Object clone() {
        Date date = null;
        try {
            date = (Date)super.clone();
            if (date.cal != null) {
                date.cal = (Calendar)date.cal.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return date;
    }

    public int compareTo(Object object) {
        return this.compareTo((Date)object);
    }

    public boolean equals(Object object) {
        return object instanceof Date && this.getTime() == ((Date)object).getTime();
    }

    public String toGMTString() {
        DateFormat dateFormat = null;
        if (gmtFormatter != null) {
            dateFormat = (DateFormat)gmtFormatter.get();
        }
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            gmtFormatter = new SoftReference(dateFormat);
        }
        return dateFormat.format(this);
    }

    public String toLocaleString() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        return dateFormat.format(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        DateFormat dateFormat = null;
        if (simpleFormatter != null) {
            dateFormat = (DateFormat)simpleFormatter.get();
        }
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
            simpleFormatter = new SoftReference(dateFormat);
        }
        DateFormat dateFormat2 = dateFormat;
        synchronized (dateFormat2) {
            dateFormat.setTimeZone(TimeZone.getDefault());
            return dateFormat.format(this);
        }
    }

    public static long parse(String string) {
        block45: {
            if (staticCal == null) {
                Date.makeStaticCalendars();
            }
            int n2 = Integer.MIN_VALUE;
            int n3 = -1;
            int n4 = -1;
            int n5 = -1;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            int n10 = 0;
            int n11 = -1;
            int n12 = -1;
            int n13 = -1;
            int n14 = 0;
            if (string != null) {
                int n15 = string.length();
                block0: while (n10 < n15) {
                    int n16;
                    n9 = string.charAt(n10);
                    ++n10;
                    if (n9 <= 32 || n9 == 44) continue;
                    if (n9 == 40) {
                        n16 = 1;
                        while (n10 < n15) {
                            n9 = string.charAt(n10);
                            ++n10;
                            if (n9 == 40) {
                                ++n16;
                                continue;
                            }
                            if (n9 != 41 || --n16 > 0) continue;
                            continue block0;
                        }
                        continue;
                    }
                    if (48 <= n9 && n9 <= 57) {
                        n11 = n9 - 48;
                        while (n10 < n15) {
                            char c2 = string.charAt(n10);
                            n9 = c2;
                            if ('0' > c2 || n9 > 57) break;
                            n11 = n11 * 10 + n9 - 48;
                            ++n10;
                        }
                        if (n14 == 43 || n14 == 45 && n2 != Integer.MIN_VALUE) {
                            n11 = n11 < 24 ? (n11 *= 60) : n11 % 100 + n11 / 100 * 60;
                            if (n14 == 43) {
                                n11 = -n11;
                            }
                            if (n13 != 0 && n13 != -1) break block45;
                            n13 = n11;
                        } else if (n11 >= 70) {
                            if (n2 != Integer.MIN_VALUE || n9 > 32 && n9 != 44 && n9 != 47 && n10 < n15) break block45;
                            n2 = n11;
                        } else if (n9 == 58) {
                            if (n5 < 0) {
                                n5 = (byte)n11;
                            } else {
                                if (n6 >= 0) break block45;
                                n6 = (byte)n11;
                            }
                        } else if (n9 == 47) {
                            if (n3 < 0) {
                                n3 = (byte)(n11 - 1);
                            } else {
                                if (n4 >= 0) break block45;
                                n4 = (byte)n11;
                            }
                        } else {
                            if (n10 < n15 && n9 != 44 && n9 > 32 && n9 != 45) break block45;
                            if (n5 >= 0 && n6 < 0) {
                                n6 = (byte)n11;
                            } else if (n6 >= 0 && n7 < 0) {
                                n7 = (byte)n11;
                            } else if (n4 < 0) {
                                n4 = (byte)n11;
                            } else {
                                if (n2 != Integer.MIN_VALUE || n3 < 0 || n4 < 0) break block45;
                                n2 = n11;
                            }
                        }
                        n14 = 0;
                        continue;
                    }
                    if (n9 == 47 || n9 == 58 || n9 == 43 || n9 == 45) {
                        n14 = n9;
                        continue;
                    }
                    n16 = n10 - 1;
                    while (n10 < n15 && (65 <= (n9 = (int)string.charAt(n10)) && n9 <= 90 || 97 <= n9 && n9 <= 122)) {
                        ++n10;
                    }
                    if (n10 <= n16 + 1) break block45;
                    int n17 = wtb.length;
                    while (--n17 >= 0) {
                        if (!wtb[n17].regionMatches(true, 0, string, n16, n10 - n16)) continue;
                        int n18 = ttb[n17];
                        if (n18 == 0) break;
                        if (n18 == 1) {
                            if (n5 <= 12 && n5 >= 1) {
                                if (n5 >= 12) break;
                                n5 += 12;
                                break;
                            }
                            break block45;
                        }
                        if (n18 == 14) {
                            if (n5 <= 12 && n5 >= 1) {
                                if (n5 != 12) break;
                                n5 = 0;
                                break;
                            }
                            break block45;
                        }
                        if (n18 <= 13) {
                            if (n3 < 0) {
                                n3 = (byte)(n18 - 2);
                                break;
                            }
                            break block45;
                        }
                        n13 = n18 - 10000;
                        break;
                    }
                    if (n17 >= 0) {
                        n14 = 0;
                        continue;
                    }
                    break block45;
                }
                if (n2 != Integer.MIN_VALUE && n3 >= 0 && n4 >= 0) {
                    if (n2 < 100 && (n2 += defaultCenturyStart / 100 * 100) < defaultCenturyStart) {
                        n2 += 100;
                    }
                    n2 -= 1900;
                    if (n7 < 0) {
                        n7 = 0;
                    }
                    if (n6 < 0) {
                        n6 = 0;
                    }
                    if (n5 < 0) {
                        n5 = 0;
                    }
                    if (n13 == -1) {
                        return new Date(n2, n3, n4, n5, n6, n7).getTime();
                    }
                    return Date.UTC(n2, n3, n4, n5, n6, n7) + (long)(n13 * 60000);
                }
            }
        }
        throw new IllegalArgumentException();
    }

    public Date(String string) {
        this(Date.parse(string));
    }

    public int compareTo(Date date) {
        long l2;
        long l3 = this.getTime();
        return l3 < (l2 = date.getTime()) ? -1 : (l3 == l2 ? 0 : 1);
    }

    public boolean after(Date date) {
        return this.getTime() > date.getTime();
    }

    public boolean before(Date date) {
        return this.getTime() < date.getTime();
    }
}

