/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import javax.swing.SwingUtilities;
import javax.swing.SystemEventQueueUtilities;
import javax.swing.Timer;

class TimerQueue
implements Runnable {
    private static final Object sharedInstanceKey = new StringBuffer("TimerQueue.sharedInstanceKey");
    private static final Object expiredTimersKey = new StringBuffer("TimerQueue.expiredTimersKey");
    Timer firstTimer;
    boolean running;
    private static final Object classLock = new Object();

    synchronized long postExpiredTimers() {
        long l2;
        do {
            Timer timer;
            if ((timer = this.firstTimer) == null) {
                return 0L;
            }
            long l3 = System.currentTimeMillis();
            l2 = timer.expirationTime - l3;
            if (l2 > 0L) continue;
            try {
                timer.post();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.removeTimer(timer);
            if (timer.isRepeats()) {
                this.addTimer(timer, l3 + (long)timer.getDelay());
            }
            try {
                this.wait(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (l2 <= 0L);
        return l2;
    }

    public TimerQueue() {
        this.start();
    }

    public synchronized void run() {
        try {
            while (this.running) {
                long l2 = this.postExpiredTimers();
                try {
                    this.wait(l2);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (ThreadDeath threadDeath) {
            this.running = false;
            Timer timer = this.firstTimer;
            while (timer != null) {
                timer.cancelEvent();
                timer = timer.nextTimer;
            }
            SystemEventQueueUtilities.restartTimerQueueThread();
            throw threadDeath;
        }
    }

    synchronized void start() {
        if (this.running) {
            throw new RuntimeException("Can't start a TimerQueue that is already running");
        }
        SwingUtilities.doPrivileged(new Runnable(){

            public void run() {
                Thread thread = new Thread(TimerQueue.this, "TimerQueue");
                thread.setDaemon(true);
                thread.setPriority(5);
                thread.start();
            }
        });
        this.running = true;
    }

    synchronized void stop() {
        this.running = false;
        this.notify();
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TimerQueue (");
        Timer timer = this.firstTimer;
        while (timer != null) {
            stringBuffer.append(timer.toString());
            timer = timer.nextTimer;
            if (timer == null) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    synchronized void removeTimer(Timer timer) {
        if (!timer.running) {
            return;
        }
        Timer timer2 = null;
        Timer timer3 = this.firstTimer;
        boolean bl2 = false;
        while (timer3 != null) {
            if (timer3 == timer) {
                bl2 = true;
                break;
            }
            timer2 = timer3;
            timer3 = timer3.nextTimer;
        }
        if (!bl2) {
            return;
        }
        if (timer2 == null) {
            this.firstTimer = timer.nextTimer;
        } else {
            timer2.nextTimer = timer.nextTimer;
        }
        timer.expirationTime = 0L;
        timer.nextTimer = null;
        timer.running = false;
    }

    synchronized boolean containsTimer(Timer timer) {
        return timer.running;
    }

    synchronized void addTimer(Timer timer, long l2) {
        if (timer.running) {
            return;
        }
        Timer timer2 = null;
        Timer timer3 = this.firstTimer;
        while (timer3 != null && timer3.expirationTime <= l2) {
            timer2 = timer3;
            timer3 = timer3.nextTimer;
        }
        if (timer2 == null) {
            this.firstTimer = timer;
        } else {
            timer2.nextTimer = timer;
        }
        timer.expirationTime = l2;
        timer.nextTimer = timer3;
        timer.running = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimerQueue sharedInstance() {
        Object object = classLock;
        synchronized (object) {
            TimerQueue timerQueue = (TimerQueue)SwingUtilities.appContextGet(sharedInstanceKey);
            if (timerQueue == null) {
                timerQueue = new TimerQueue();
                SwingUtilities.appContextPut(sharedInstanceKey, timerQueue);
            }
            return timerQueue;
        }
    }
}

