/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTEvent;
import java.util.HashSet;
import java.util.Hashtable;
import sun.awt.AppContext;

public final class AWTAutoShutdown
implements Runnable {
    private static final AWTAutoShutdown theInstance = new AWTAutoShutdown();
    private final Object mainLock = new Object();
    private final Object activationLock = new Object();
    private final HashSet busyThreadSet = new HashSet(7);
    private boolean toolkitThreadBusy = false;
    private final Hashtable peerMap = new PeerMap();
    private Thread blockerThread = null;
    private boolean timeoutPassed = false;
    private static final int SAFETY_TIMEOUT = 1000;

    private AWTAutoShutdown() {
    }

    private void activateBlockerThread() {
        Thread thread = new Thread(this, "AWT-Shutdown");
        thread.setDaemon(false);
        this.blockerThread = thread;
        thread.start();
        try {
            this.mainLock.wait();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("AWT blocker activation interrupted:");
            interruptedException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyPeerMapUpdated() {
        Object object = this.activationLock;
        synchronized (object) {
            Object object2 = this.mainLock;
            synchronized (object2) {
                if (!this.isReadyToShutdown() && this.blockerThread == null) {
                    this.activateBlockerThread();
                } else {
                    this.mainLock.notifyAll();
                    this.timeoutPassed = false;
                }
            }
        }
    }

    public static void notifyToolkitThreadBusy() {
        AWTAutoShutdown.getInstance().setToolkitBusy(true);
    }

    public static void notifyToolkitThreadFree() {
        AWTAutoShutdown.getInstance().setToolkitBusy(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        boolean bl2 = false;
        Object object = this.mainLock;
        synchronized (object) {
            try {
                try {
                    this.mainLock.notifyAll();
                    block7: while (this.blockerThread == thread) {
                        this.mainLock.wait();
                        this.timeoutPassed = false;
                        while (this.isReadyToShutdown()) {
                            if (this.timeoutPassed) {
                                this.timeoutPassed = false;
                                this.blockerThread = null;
                                continue block7;
                            }
                            this.timeoutPassed = true;
                            this.mainLock.wait(1000L);
                        }
                    }
                    Object var6_4 = null;
                    if (this.blockerThread == thread) {
                        this.blockerThread = null;
                    }
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                    Object var6_5 = null;
                    if (this.blockerThread == thread) {
                        this.blockerThread = null;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (this.blockerThread == thread) {
                    this.blockerThread = null;
                }
                throw throwable;
            }
        }
        if (!bl2) {
            AppContext.stopEventDispatchThreads();
        }
    }

    private boolean isReadyToShutdown() {
        return !this.toolkitThreadBusy && this.peerMap.isEmpty() && this.busyThreadSet.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setToolkitBusy(boolean bl2) {
        if (bl2 != this.toolkitThreadBusy) {
            Object object = this.activationLock;
            synchronized (object) {
                Object object2 = this.mainLock;
                synchronized (object2) {
                    if (bl2 != this.toolkitThreadBusy) {
                        if (bl2) {
                            if (this.blockerThread == null) {
                                this.activateBlockerThread();
                            } else if (this.isReadyToShutdown()) {
                                this.mainLock.notifyAll();
                                this.timeoutPassed = false;
                            }
                            this.toolkitThreadBusy = bl2;
                        } else {
                            this.toolkitThreadBusy = bl2;
                            if (this.isReadyToShutdown()) {
                                this.mainLock.notifyAll();
                                this.timeoutPassed = false;
                            }
                        }
                    }
                }
            }
        }
    }

    static AWTEvent getShutdownEvent() {
        return new AWTEvent(AWTAutoShutdown.getInstance(), 0){};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyThreadBusy(Thread thread) {
        Object object = this.activationLock;
        synchronized (object) {
            Object object2 = this.mainLock;
            synchronized (object2) {
                if (this.blockerThread == null) {
                    this.activateBlockerThread();
                } else if (this.isReadyToShutdown()) {
                    this.mainLock.notifyAll();
                    this.timeoutPassed = false;
                }
                this.busyThreadSet.add(thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyThreadFree(Thread thread) {
        Object object = this.activationLock;
        synchronized (object) {
            Object object2 = this.mainLock;
            synchronized (object2) {
                this.busyThreadSet.remove(thread);
                if (this.isReadyToShutdown()) {
                    this.mainLock.notifyAll();
                    this.timeoutPassed = false;
                }
            }
        }
    }

    public Hashtable getPeerMap() {
        return this.peerMap;
    }

    public static AWTAutoShutdown getInstance() {
        return theInstance;
    }

    static final class PeerMap
    extends Hashtable {
        PeerMap() {
        }

        public Object remove(Object object) {
            Object object2 = super.remove(object);
            AWTAutoShutdown.getInstance().notifyPeerMapUpdated();
            return object2;
        }

        public Object put(Object object, Object object2) {
            Object object3 = super.put(object, object2);
            AWTAutoShutdown.getInstance().notifyPeerMapUpdated();
            return object3;
        }
    }
}

