/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.io.File;
import java.io.FileInputStream;
import java.util.Locale;
import java.util.Properties;
import sun.awt.SunToolkit;
import sun.io.CharacterEncoding;

public abstract class FontProperties
extends Properties {
    protected static String osVersion;
    protected static String osName;
    private static final String[] fontNames;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = !FontProperties.class.desiredAssertionStatus();
        fontNames = new String[]{"serif", "sansserif", "monospaced", "dialog", "dialoginput"};
    }

    public FontProperties() {
        super(FontProperties.getDefaultFontProperties());
        this.setOsNameAndVersion();
        this.initializeProperties();
    }

    private void initializeProperties() {
        String string = System.getProperty("user.home");
        String string2 = System.getProperty("java.home");
        if (string2 == null) {
            throw new Error("java.home property not set");
        }
        Locale locale = SunToolkit.getStartupLocale();
        String string3 = locale.getLanguage();
        String string4 = locale.getCountry();
        String string5 = System.getProperty("file.encoding");
        String string6 = CharacterEncoding.aliasName(string5);
        if (string6 == null) {
            string6 = string5;
        }
        try {
            File file = null;
            if (string4 != null) {
                file = this.tryOpeningFontProp(file, string, string3, string4 + "_" + string6);
                file = this.tryOpeningFontProp(file, string2, string3, string4 + "_" + string6);
                file = this.tryOpeningFontProp(file, string, string3, string4);
                file = this.tryOpeningFontProp(file, string2, string3, string4);
            }
            file = this.tryOpeningFontProp(file, string, string3, string6);
            file = this.tryOpeningFontProp(file, string2, string3, string6);
            file = this.tryOpeningFontProp(file, string, string3, null);
            file = this.tryOpeningFontProp(file, string2, string3, null);
            file = this.tryOpeningFontProp(file, string, string6, null);
            file = this.tryOpeningFontProp(file, string2, string6, null);
            file = this.tryOpeningFontProp(file, string, null, null);
            if ((file = this.tryOpeningFontProp(file, string2, null, null)) != null) {
                FileInputStream fileInputStream = new FileInputStream(file.getPath());
                this.load(fileInputStream);
                fileInputStream.close();
                if (("ja".equals(string3) || "zh".equals(string3) || "ko".equals(string3) || "iw".equals(string3) || "th".equals(string3) || "hi".equals(string3)) && this.isOriginalFP(file)) {
                    this.put("_PLSF_LANGUAGE", string3);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setOsNameAndVersion() {
        osName = System.getProperty("os.name");
        osVersion = System.getProperty("os.version");
    }

    public boolean supportPLSF() {
        return false;
    }

    protected boolean isOriginalFP(File file) {
        return false;
    }

    public static boolean isLogicalFontFamilyName(String string) {
        string = string.toLowerCase(Locale.ENGLISH);
        for (int i2 = 0; i2 < fontNames.length; ++i2) {
            if (!string.equals(fontNames[i2])) continue;
            return true;
        }
        return false;
    }

    private static Properties getDefaultFontProperties() {
        Properties properties = new Properties();
        properties.put("serif.0", "unknown");
        properties.put("sansserif.0", "unknown");
        properties.put("monospaced.0", "unknown");
        properties.put("dialog.0", "unknown");
        properties.put("dialoginput.0", "unknown");
        properties.put("default.0", "sansserif");
        return properties;
    }

    public String getAliasedFamilyName(String string) {
        if (!$assertionsDisabled && FontProperties.isLogicalFontFamilyName(string)) {
            throw new AssertionError();
        }
        string = string.toLowerCase(Locale.ENGLISH);
        String string2 = this.getProperty("alias." + string);
        if (string2 != null) {
            for (int i2 = 0; i2 < fontNames.length; ++i2) {
                if (!string2.equals(fontNames[i2])) continue;
                return string2;
            }
        }
        return null;
    }

    protected String getCompatibilityFamilyName(String string) {
        if ((string = string.toLowerCase(Locale.ENGLISH)).equals("timesroman")) {
            return "serif";
        }
        if (string.equals("helvetica")) {
            return "sansserif";
        }
        if (string.equals("courier")) {
            return "monospaced";
        }
        return null;
    }

    public FontProperties applyPreferLocaleSpecificFonts(FontProperties fontProperties) {
        return this;
    }

    public abstract String getFallbackFamilyName(String var1, String var2);

    private File tryOpeningFontProp(File file, String string, String string2, String string3) {
        File file2;
        if (file != null) {
            return file;
        }
        String string4 = string + File.separator + "lib" + File.separator + "font.properties";
        if (string2 != null) {
            string4 = string4 + "." + string2;
            if (string3 != null) {
                string4 = string4 + "_" + string3;
            }
        }
        if (osVersion != null && osName != null && (file2 = new File(string4 + "." + osName + osVersion)) != null && file2.canRead()) {
            return file2;
        }
        if (osName != null && (file2 = new File(string4 + "." + osName)) != null && file2.canRead()) {
            return file2;
        }
        if (osVersion != null && (file2 = new File(string4 + "." + osVersion)) != null && file2.canRead()) {
            return file2;
        }
        file2 = new File(string4);
        if (file2 != null && file2.canRead()) {
            return file2;
        }
        return null;
    }
}

