/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.Converters;
import sun.nio.cs.HistoricallyNamedCharset;

public abstract class StreamDecoder
extends Reader {
    private static final int DEFAULT_BYTE_BUFFER_SIZE = 8192;
    private volatile boolean isOpen = true;
    private boolean haveLeftoverChar = false;
    private char leftoverChar;
    private static volatile boolean channelsAvailable;
    static final /* synthetic */ boolean $assertionsDisabled;

    public int read() throws IOException {
        return this.read0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read0() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.haveLeftoverChar) {
                this.haveLeftoverChar = false;
                return this.leftoverChar;
            }
            char[] cArray = new char[2];
            int n2 = this.read(cArray, 0, 2);
            switch (n2) {
                case -1: {
                    return -1;
                }
                case 2: {
                    this.leftoverChar = cArray[1];
                    this.haveLeftoverChar = true;
                }
                case 1: {
                    return cArray[0];
                }
            }
            if (!$assertionsDisabled) {
                throw new AssertionError(n2);
            }
            return -1;
        }
    }

    static {
        $assertionsDisabled = !StreamDecoder.class.desiredAssertionStatus();
        channelsAvailable = true;
    }

    private StreamDecoder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isOpen) {
                return;
            }
            this.implClose();
            this.isOpen = false;
        }
    }

    private void ensureOpen() throws IOException {
        if (!this.isOpen) {
            throw new IOException("Stream closed");
        }
    }

    abstract void implClose() throws IOException;

    abstract boolean implReady();

    private boolean isOpen() {
        return this.isOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.haveLeftoverChar || this.implReady();
        }
    }

    abstract int implRead(char[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(char[] cArray, int n2, int n3) throws IOException {
        int n4 = n2;
        int n5 = n3;
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n4 < 0 || n4 > cArray.length || n5 < 0 || n4 + n5 > cArray.length || n4 + n5 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n5 == 0) {
                return 0;
            }
            int n6 = 0;
            if (this.haveLeftoverChar) {
                cArray[n4] = this.leftoverChar;
                ++n4;
                this.haveLeftoverChar = false;
                n6 = 1;
                if (--n5 == 0 || !this.implReady()) {
                    return n6;
                }
            }
            if (n5 == 1) {
                int n7 = this.read0();
                if (n7 == -1) {
                    return n6 == 0 ? -1 : n6;
                }
                cArray[n4] = (char)n7;
                return n6 + 1;
            }
            return n6 + this.implRead(cArray, n4, n4 + n5);
        }
    }

    private StreamDecoder(Object object) {
        super(object);
    }

    abstract String encodingName();

    public String getEncoding() {
        if (this.isOpen()) {
            return this.encodingName();
        }
        return null;
    }

    private static FileChannel getChannel(FileInputStream fileInputStream) {
        if (!channelsAvailable) {
            return null;
        }
        try {
            return fileInputStream.getChannel();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            channelsAvailable = false;
            return null;
        }
    }

    public static StreamDecoder forDecoder(ReadableByteChannel readableByteChannel, CharsetDecoder charsetDecoder, int n2) {
        return new CharsetSD(readableByteChannel, charsetDecoder, n2);
    }

    public static StreamDecoder forInputStreamReader(InputStream inputStream, Object object, String string) throws UnsupportedEncodingException {
        String string2 = string;
        if (string2 == null) {
            string2 = Converters.getDefaultEncodingName();
        }
        if (!Converters.isCached(0, string2)) {
            try {
                if (Charset.isSupported(string2) && !string2.equalsIgnoreCase("PCK")) {
                    return new CharsetSD(inputStream, object, Charset.forName(string2));
                }
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
        }
        return new ConverterSD(inputStream, object, string2);
    }

    public static StreamDecoder forInputStreamReader(InputStream inputStream, Object object, Charset charset) {
        return new CharsetSD(inputStream, object, charset);
    }

    public static StreamDecoder forInputStreamReader(InputStream inputStream, Object object, CharsetDecoder charsetDecoder) {
        return new CharsetSD(inputStream, object, charsetDecoder);
    }

    private static class CharsetSD
    extends StreamDecoder {
        private Charset cs;
        private CharsetDecoder decoder;
        private ByteBuffer bb;
        private InputStream in;
        private ReadableByteChannel ch;
        static final /* synthetic */ boolean $assertionsDisabled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int readBytes() throws IOException {
            int n2;
            this.bb.compact();
            try {
                if (this.ch != null) {
                    n2 = this.ch.read(this.bb);
                    if (n2 < 0) {
                        int n3 = n2;
                        return n3;
                    }
                } else {
                    int n4;
                    n2 = this.bb.limit();
                    int n5 = this.bb.position();
                    if (!$assertionsDisabled && n5 > n2) {
                        throw new AssertionError();
                    }
                    int n6 = n4 = n5 <= n2 ? n2 - n5 : 0;
                    if (!$assertionsDisabled && n4 <= 0) {
                        throw new AssertionError();
                    }
                    int n7 = this.in.read(this.bb.array(), this.bb.arrayOffset() + n5, n4);
                    if (n7 < 0) {
                        int n8 = n7;
                        return n8;
                    }
                    if (n7 == 0) {
                        throw new IOException("Underlying input stream returned zero bytes");
                    }
                    if (!$assertionsDisabled && n7 > n4) {
                        throw new AssertionError((Object)("n = " + n7 + ", rem = " + n4));
                    }
                    this.bb.position(n5 + n7);
                }
            }
            finally {
                this.bb.flip();
            }
            n2 = this.bb.remaining();
            if (!$assertionsDisabled && n2 == 0) {
                throw new AssertionError(n2);
            }
            return n2;
        }

        static {
            $assertionsDisabled = !(class$sun$nio$cs$StreamDecoder == null ? (class$sun$nio$cs$StreamDecoder = StreamDecoder.class$("sun.nio.cs.StreamDecoder")) : class$sun$nio$cs$StreamDecoder).desiredAssertionStatus();
        }

        void implClose() throws IOException {
            if (this.ch != null) {
                this.ch.close();
            } else {
                this.in.close();
            }
        }

        boolean implReady() {
            return this.bb.hasRemaining() || this.inReady();
        }

        private boolean inReady() {
            try {
                return this.in != null && this.in.available() > 0 || this.ch instanceof FileChannel;
            }
            catch (IOException iOException) {
                return false;
            }
        }

        int implRead(char[] cArray, int n2, int n3) throws IOException {
            if (!$assertionsDisabled && n3 - n2 <= 1) {
                throw new AssertionError();
            }
            CharBuffer charBuffer = CharBuffer.wrap(cArray, n2, n3 - n2);
            if (charBuffer.position() != 0) {
                charBuffer = charBuffer.slice();
            }
            boolean bl2 = false;
            while (true) {
                CoderResult coderResult;
                if ((coderResult = this.decoder.decode(this.bb, charBuffer, bl2)).isUnderflow()) {
                    if (bl2 || !charBuffer.hasRemaining() || charBuffer.position() > 0 && !this.inReady()) break;
                    int n4 = this.readBytes();
                    if (n4 >= 0) continue;
                    bl2 = true;
                    if (charBuffer.position() == 0 && !this.bb.hasRemaining()) break;
                    this.decoder.reset();
                    continue;
                }
                if (coderResult.isOverflow()) {
                    if (!$assertionsDisabled && charBuffer.position() <= 0) {
                        throw new AssertionError();
                    }
                    break;
                }
                coderResult.throwException();
            }
            if (bl2) {
                this.decoder.reset();
            }
            if (charBuffer.position() == 0) {
                if (bl2) {
                    return -1;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            return charBuffer.position();
        }

        String encodingName() {
            return this.cs instanceof HistoricallyNamedCharset ? ((HistoricallyNamedCharset)((Object)this.cs)).historicalName() : this.cs.name();
        }

        CharsetSD(ReadableByteChannel readableByteChannel, CharsetDecoder charsetDecoder, int n2) {
            this.in = null;
            this.ch = readableByteChannel;
            this.decoder = charsetDecoder;
            this.cs = charsetDecoder.charset();
            this.bb = ByteBuffer.allocate(n2 < 0 ? 8192 : n2);
            this.bb.flip();
        }

        CharsetSD(InputStream inputStream, Object object, Charset charset) {
            this(inputStream, object, charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
        }

        CharsetSD(InputStream inputStream, Object object, CharsetDecoder charsetDecoder) {
            super(object);
            this.cs = charsetDecoder.charset();
            this.decoder = charsetDecoder;
            if (this.ch == null) {
                this.in = inputStream;
                this.ch = null;
                this.bb = ByteBuffer.allocate(8192);
            }
            this.bb.flip();
        }
    }

    private static class ConverterSD
    extends StreamDecoder {
        private final InputStream in;
        private ByteToCharConverter btc;
        private byte[] bb;
        private int nBytes = 0;
        private int nextByte = 0;

        void implClose() throws IOException {
            this.in.close();
        }

        private void malfunction() {
            throw new InternalError("Converter malfunction (" + this.btc.getCharacterEncoding() + ") -- please submit a bug report via " + System.getProperty("java.vendor.url.bug"));
        }

        boolean implReady() {
            return this.nextByte < this.nBytes || this.inReady();
        }

        private boolean inReady() {
            try {
                return this.in.available() > 0;
            }
            catch (IOException iOException) {
                return false;
            }
        }

        private int convertInto(char[] cArray, int n2, int n3) throws IOException {
            int n4 = 0;
            if (this.nextByte < this.nBytes) {
                try {
                    n4 = this.btc.convert(this.bb, this.nextByte, this.nBytes, cArray, n2, n3);
                    this.nextByte = this.nBytes;
                    if (this.btc.nextByteIndex() != this.nextByte) {
                        this.malfunction();
                    }
                }
                catch (ConversionBufferFullException conversionBufferFullException) {
                    this.nextByte = this.btc.nextByteIndex();
                    n4 = this.btc.nextCharIndex() - n2;
                }
            }
            return n4;
        }

        private int flushInto(char[] cArray, int n2, int n3) throws IOException {
            int n4 = 0;
            try {
                n4 = this.btc.flush(cArray, n2, n3);
            }
            catch (ConversionBufferFullException conversionBufferFullException) {
                n4 = this.btc.nextCharIndex() - n2;
            }
            return n4;
        }

        int implRead(char[] cArray, int n2, int n3) throws IOException {
            int n4 = 0;
            if (this.nextByte < this.nBytes) {
                n4 = this.convertInto(cArray, n2, n3);
            }
            while (n2 + n4 < n3) {
                if (this.nBytes != -1) {
                    if (n4 > 0 && !this.inReady()) break;
                    this.nBytes = this.in.read(this.bb);
                }
                if (this.nBytes == -1) {
                    this.nBytes = 0;
                    if ((n4 += this.flushInto(cArray, n2 + n4, n3)) != 0) break;
                    return -1;
                }
                this.nextByte = 0;
                n4 += this.convertInto(cArray, n2 + n4, n3);
            }
            return n4;
        }

        String encodingName() {
            return this.btc.getCharacterEncoding();
        }

        private ConverterSD(ReadableByteChannel readableByteChannel, String string) throws UnsupportedEncodingException {
            this(Channels.newInputStream(readableByteChannel), null, string);
            this.lock = this;
        }

        private ConverterSD(InputStream inputStream, Object object, String string) throws UnsupportedEncodingException {
            super(object);
            this.in = inputStream;
            this.btc = ByteToCharConverter.getConverter(string);
            this.bb = new byte[8192];
        }
    }
}

