/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import sun.security.util.BitArray;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.Gregorian;

class DerInputBuffer
extends ByteArrayInputStream
implements Cloneable {
    public int hashCode() {
        int n2 = 0;
        int n3 = this.available();
        int n4 = this.pos;
        for (int i2 = 0; i2 < n3; ++i2) {
            n2 += this.buf[n4 + i2] * i2;
        }
        return n2;
    }

    int peek() throws IOException {
        if (this.pos >= this.count) {
            throw new IOException("out of data");
        }
        return this.buf[this.pos];
    }

    byte[] getBitString() throws IOException {
        return this.getBitString(this.available());
    }

    byte[] toByteArray() {
        int n2 = this.available();
        if (n2 <= 0) {
            return null;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.buf, this.pos, byArray, 0, n2);
        return byArray;
    }

    public int getInteger(int n2) throws IOException {
        BigInteger bigInteger = this.getBigInteger(n2);
        if (bigInteger.compareTo(BigInteger.valueOf(Integer.MIN_VALUE)) < 0) {
            throw new IOException("Integer below minimum valid value");
        }
        if (bigInteger.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            throw new IOException("Integer exceeds maximum valid value");
        }
        return bigInteger.intValue();
    }

    void truncate(int n2) throws IOException {
        if (n2 > this.available()) {
            throw new IOException("insufficient data");
        }
        this.count = this.pos + n2;
    }

    public byte[] getBitString(int n2) throws IOException {
        if (n2 > this.available()) {
            throw new IOException("short read of bit string");
        }
        if (n2 == 0) {
            throw new IOException("Invalid encoding: zero length bit string");
        }
        byte by = this.buf[this.pos];
        if (by < 0 || by > 7) {
            throw new IOException("Invalid number of padding bits");
        }
        byte[] byArray = new byte[n2 - 1];
        System.arraycopy(this.buf, this.pos + 1, byArray, 0, n2 - 1);
        if (by != 0) {
            int n3 = n2 - 2;
            byArray[n3] = (byte)(byArray[n3] & 255 << by);
        }
        this.skip(n2);
        return byArray;
    }

    DerInputBuffer(byte[] byArray) {
        super(byArray);
    }

    DerInputBuffer(byte[] byArray, int n2, int n3) {
        super(byArray, n2, n3);
    }

    public boolean equals(Object object) {
        if (object instanceof DerInputBuffer) {
            return this.equals((DerInputBuffer)object);
        }
        return false;
    }

    BigInteger getBigInteger(int n2) throws IOException {
        if (n2 > this.available()) {
            throw new IOException("short read of integer");
        }
        if (n2 == 0) {
            throw new IOException("Invalid encoding: zero length Int value");
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.buf, this.pos, byArray, 0, n2);
        this.skip(n2);
        return new BigInteger(byArray);
    }

    public Date getGeneralizedTime(int n2) throws IOException {
        if (n2 > this.available()) {
            throw new IOException("short read of DER Generalized Time");
        }
        if (n2 < 13 || n2 > 19) {
            throw new IOException("DER Generalized Time length error");
        }
        return this.getTime(n2, true);
    }

    public Date getUTCTime(int n2) throws IOException {
        if (n2 > this.available()) {
            throw new IOException("short read of DER UTC Time");
        }
        if (n2 < 11 || n2 > 17) {
            throw new IOException("DER UTC Time length error");
        }
        return this.getTime(n2, false);
    }

    private Date getTime(int n2, boolean bl2) throws IOException {
        int n3;
        int n4;
        String string = null;
        if (bl2) {
            string = "Generalized";
            n4 = 1000 * Character.digit((char)this.buf[this.pos++], 10);
            n4 += 100 * Character.digit((char)this.buf[this.pos++], 10);
            n4 += 10 * Character.digit((char)this.buf[this.pos++], 10);
            n4 += Character.digit((char)this.buf[this.pos++], 10);
            n2 -= 2;
        } else {
            string = "UTC";
            n4 = 10 * Character.digit((char)this.buf[this.pos++], 10);
            n4 = (n4 += Character.digit((char)this.buf[this.pos++], 10)) < 50 ? (n4 += 2000) : (n4 += 1900);
        }
        int n5 = 10 * Character.digit((char)this.buf[this.pos++], 10);
        n5 += Character.digit((char)this.buf[this.pos++], 10);
        int n6 = 10 * Character.digit((char)this.buf[this.pos++], 10);
        n6 += Character.digit((char)this.buf[this.pos++], 10);
        int n7 = 10 * Character.digit((char)this.buf[this.pos++], 10);
        n7 += Character.digit((char)this.buf[this.pos++], 10);
        int n8 = 10 * Character.digit((char)this.buf[this.pos++], 10);
        n8 += Character.digit((char)this.buf[this.pos++], 10);
        if ((n2 -= 10) == 3 || n2 == 7) {
            n3 = 10 * Character.digit((char)this.buf[this.pos++], 10);
            n3 += Character.digit((char)this.buf[this.pos++], 10);
            n2 -= 2;
        } else {
            n3 = 0;
        }
        if (n5 == 0 || n6 == 0 || n5 > 12 || n6 > 31 || n7 >= 24 || n8 >= 60 || n3 >= 60) {
            throw new IOException("Parse " + string + " time, invalid format");
        }
        CalendarDate calendarDate = new CalendarDate(n4, n5 - 1, n6);
        calendarDate.setTimeOfDay(((n7 * 60 + n8) * 60 + n3) * 1000);
        long l2 = Gregorian.dateToMillis(calendarDate);
        if (n2 != 1 && n2 != 5) {
            throw new IOException("Parse " + string + " time, invalid offset");
        }
        switch (this.buf[this.pos++]) {
            case 43: {
                int n9 = 10 * Character.digit((char)this.buf[this.pos++], 10);
                int n10 = 10 * Character.digit((char)this.buf[this.pos++], 10);
                if ((n9 += Character.digit((char)this.buf[this.pos++], 10)) >= 24 || (n10 += Character.digit((char)this.buf[this.pos++], 10)) >= 60) {
                    throw new IOException("Parse " + string + " time, +hhmm");
                }
                l2 -= (long)((n9 * 60 + n10) * 60 * 1000);
                break;
            }
            case 45: {
                int n11 = 10 * Character.digit((char)this.buf[this.pos++], 10);
                int n12 = 10 * Character.digit((char)this.buf[this.pos++], 10);
                if ((n11 += Character.digit((char)this.buf[this.pos++], 10)) >= 24 || (n12 += Character.digit((char)this.buf[this.pos++], 10)) >= 60) {
                    throw new IOException("Parse " + string + " time, -hhmm");
                }
                l2 += (long)((n11 * 60 + n12) * 60 * 1000);
                break;
            }
            case 90: {
                break;
            }
            default: {
                throw new IOException("Parse " + string + " time, garbage offset");
            }
        }
        return new Date(l2);
    }

    BitArray getUnalignedBitString() throws IOException {
        if (this.pos >= this.count) {
            return null;
        }
        int n2 = this.available();
        int n3 = this.buf[this.pos] & 0xFF;
        if (n3 > 7) {
            throw new IOException("Invalid value for unused bits: " + n3);
        }
        byte[] byArray = new byte[n2 - 1];
        int n4 = byArray.length == 0 ? 0 : byArray.length * 8 - n3;
        System.arraycopy(this.buf, this.pos + 1, byArray, 0, n2 - 1);
        BitArray bitArray = new BitArray(n4, byArray);
        this.pos = this.count;
        return bitArray;
    }

    DerInputBuffer dup() {
        try {
            DerInputBuffer derInputBuffer = (DerInputBuffer)this.clone();
            derInputBuffer.mark(Integer.MAX_VALUE);
            return derInputBuffer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalArgumentException(cloneNotSupportedException.toString());
        }
    }

    boolean equals(DerInputBuffer derInputBuffer) {
        if (this == derInputBuffer) {
            return true;
        }
        int n2 = this.available();
        if (derInputBuffer.available() != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.buf[this.pos + i2] == derInputBuffer.buf[derInputBuffer.pos + i2]) continue;
            return false;
        }
        return true;
    }
}

