/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import sun.security.util.BitArray;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class UniqueIdentity {
    private BitArray id;

    public boolean[] getId() {
        if (this.id == null) {
            return null;
        }
        return this.id.toBooleanArray();
    }

    public UniqueIdentity(byte[] byArray) {
        this.id = new BitArray(byArray.length * 8, byArray);
    }

    public String toString() {
        return "UniqueIdentity:" + this.id.toString() + "\n";
    }

    public UniqueIdentity(BitArray bitArray) {
        this.id = bitArray;
    }

    public UniqueIdentity(DerInputStream derInputStream) throws IOException {
        DerValue derValue = derInputStream.getDerValue();
        this.id = derValue.getUnalignedBitString(true);
    }

    public void encode(DerOutputStream derOutputStream, byte by) throws IOException {
        byte[] byArray = this.id.toByteArray();
        int n2 = byArray.length * 8 - this.id.length();
        derOutputStream.write(by);
        derOutputStream.putLength(byArray.length + 1);
        derOutputStream.write(n2);
        derOutputStream.write(byArray);
    }

    public UniqueIdentity(DerValue derValue) throws IOException {
        this.id = derValue.getUnalignedBitString(true);
    }
}

