c cktools.for
c Program to check routines provided in 'optools.dll'
      PROGRAM CKTOOLS
      WRITE(*,*) "Begin CKTOOLS; check routines in 'optools.dll'"
c  100 WRITE(*,900)
c      READ(*,*) I
      CALL LINSOL()
      CALL DLINSOL()
      CALL LPSOL()
      CALL DLPSOL()
      CALL LPSOL1()
      CALL DLPSOL1()
      CALL EIGEN()
      CALL DEIGEN()
      CALL EIGEN1()
      CALL DEIGEN1()
      CALL MINV()
      CALL DMINV()
c      IF(I.GT.0) GOTO 100
      WRITE(*,*) "End CKTOOLS"
  900 FORMAT('Routine to test?')
      END

c ----------------------------------------------
c Solve a linear system
c ----------------------------------------------
      SUBROUTINE LINSOL()
      INTEGER I,N,LDA,IPATH
      REAL A(3,3),B(3),X(3)
      DATA A/33.0, -24.0, 18.0,
     +       16.0, -10.0, -11.0,
     +       72.0, -57.0, 7.0/
      DATA B/129.0, -96.0, 8.5/
      WRITE(*,*) "Begin LINSOL; check linear solver"
c solution is <1.0, 1.5, 1.0>
      N = 3
      LDA = 3
      IPATH = 1
      CALL XLSLRG(N,A,LDA,B,IPATH,X);
      CALL RVOUT(N,X)
      RETURN
      END

c ----------------------------------------------
c Solve a linear system
c ----------------------------------------------
      SUBROUTINE DLINSOL()
      INTEGER I,N,LDA,IPATH
      DOUBLE PRECISION A(3,3),B(3),X(3)
      DATA A/33.0, -24.0, 18.0,
     +       16.0, -10.0, -11.0,
     +       72.0, -57.0, 7.0/
      DATA B/129.0, -96.0, 8.5/
      WRITE(*,*) "Begin DLINSOL; check linear solver"
c solution is <1.0, 1.5, 1.0>
      N = 3
      LDA = 3
      IPATH = 1
      CALL XDLSLRG(N,A,LDA,B,IPATH,X);
      CALL DVOUT(N,X)
      RETURN
      END

c ----------------------------------------------
c Solve a LP problem
c Minimize     -x1 - 3*x2 
c Subject to:   x1 + x2 <= 1.5
c               x1 + x2 >= 0.5
c               x1 E (0,1)
c               x2 E (0,1)
c ----------------------------------------------
      SUBROUTINE LPSOL()
      IMPLICIT REAL (A-H,O-Z)
      IMPLICIT INTEGER (I-M)
      DIMENSION A(2,2),B(2),C(2),X(2),IRTYPE(2)
     & ,XLB(2),XUB(2),XSOL(2),DSOL(2)
      !DEC$ ATTRIBUTES DLLIMPORT :: XDLPRS
      DATA XLB/2*0.0/, XUB/2*1.0/
      DATA A/4*1.0/, B/1.5, 0.5/, C/-1.0, -3.0/
      DATA IRTYPE/1, 2/
      WRITE(*,*) "Begin LPSOL; check LP solver"
      M=2
      N=2
      LDA=2
      CALL XDLPRS(M,N,A,LDA,B,B,C,IRTYPE,XLB,XUB,OBJ,
     & XSOL,DSOL)
C show solution
      WRITE(*,900) OBJ
      CALL RVOUT(N,XSOL)
  900 FORMAT("F = ",F10.4)
      RETURN
      END

c ----------------------------------------------
      SUBROUTINE DLPSOL()
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-M)
      DIMENSION A(2,2),B(2),C(2),X(2),IRTYPE(2)
     & ,XLB(2),XUB(2),XSOL(2),DSOL(2)
      !DEC$ ATTRIBUTES DLLIMPORT :: XDDLPRS
      DATA XLB/2*0.0/, XUB/2*1.0/
      DATA A/4*1.0/, B/1.5, 0.5/, C/-1.0, -3.0/
      DATA IRTYPE/1, 2/
      WRITE(*,*) "Begin DLPSOL; check LP solver"
      M=2
      N=2
      LDA=2
      CALL XDDLPRS(M,N,A,LDA,B,B,C,IRTYPE,XLB,XUB,OBJ,
     & XSOL,DSOL)
C show solution
      WRITE(*,900) OBJ
      CALL DVOUT(N,XSOL)
  900 FORMAT("F = ",F10.4)
      RETURN
      END

c ----------------------------------------------
      SUBROUTINE LPSOL1()
      IMPLICIT REAL (A-H,O-Z)
      IMPLICIT INTEGER (I-M)
      DIMENSION A(2,2),B(2),C(2),X(2),IRTYPE(2)
     & ,XLB(2),XUB(2),XSOL(2),DSOL(2),WK(60),IWK(64)
      !DEC$ ATTRIBUTES DLLIMPORT :: XD2PRS
      DATA XLB/2*0.0/, XUB/2*1.0/
      DATA A/4*1.0/, B/1.5, 0.5/, C/-1.0, -3.0/
      DATA IRTYPE/1, 2/
      WRITE(*,*) "Begin LPSOL1; check LP solver"
      M=2
      N=2
      LDA=2
      CALL XD2PRS(M,N,A,LDA,B,B,C,IRTYPE,XLB,XUB,OBJ,
     & XSOL,DSOL,WK,IWK)
C show solution
      WRITE(*,900) OBJ
      CALL RVOUT(N,XSOL)
  900 FORMAT("F = ",F10.4)
      RETURN
      END

c ----------------------------------------------
      SUBROUTINE DLPSOL1()
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-M)
      DIMENSION A(2,2),B(2),C(2),X(2),IRTYPE(2)
     & ,XLB(2),XUB(2),XSOL(2),DSOL(2),WK(60),IWK(64)
      !DEC$ ATTRIBUTES DLLIMPORT :: XDD2PRS
      DATA XLB/2*0.0/, XUB/2*1.0/
      DATA A/4*1.0/, B/1.5, 0.5/, C/-1.0, -3.0/
      DATA IRTYPE/1, 2/
      WRITE(*,*) "Begin DLPSOL1; check LP solver"
      M=2
      N=2
      LDA=2
      CALL XDD2PRS(M,N,A,LDA,B,B,C,IRTYPE,XLB,XUB,OBJ,
     & XSOL,DSOL,WK,IWK)
C show solution
      WRITE(*,900) OBJ
      CALL DVOUT(N,XSOL)
  900 FORMAT("F = ",F10.4)
      RETURN
      END

c ----------------------------------------------
c Routine for eigenvalues
c ----------------------------------------------
      SUBROUTINE EIGEN()
      IMPLICIT REAL (A-H,O-Z)
      IMPLICIT INTEGER (I-M)
      PARAMETER (N=4,LDA=N,LDEVEC=N)
      REAL A(LDA,N),EVAL(N),EVEC(LDEVEC,N)
      LOGICAL SMALL
      DATA A/5.0, 4.0, 1.0, 1.0,
     +       4.0, 5.0, 1.0, 1.0,
     +       1.0, 1.0, 4.0, 2.0,
     +       1.0, 1.0, 2.0, 4.0/
      WRITE(*,*) "Begin EIGEN; check eigenvalue solver"
      NEVEC=2
      SMALL=.FALSE.
      CALL XEVESF(N,NEVEC,A,LDA,SMALL,EVAL,EVEC,LDEVEC)
c show solution
      CALL RVOUT(NEVEC,EVAL)
      DO 200 I=1,N
      WRITE(*,900) I,(EVEC(I,J),J=1,NEVEC)
  200 CONTINUE
  900 FORMAT(I5,10(F10.4))
      RETURN
      END

c ----------------------------------------------
c Routine for eigenvalues
c ----------------------------------------------
      SUBROUTINE DEIGEN()
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-M)
      PARAMETER (N=4,LDA=N,LDEVEC=N)
      DOUBLE PRECISION A(LDA,N),EVAL(N),EVEC(LDEVEC,N)
      LOGICAL SMALL
      DATA A/5.0, 4.0, 1.0, 1.0,
     +       4.0, 5.0, 1.0, 1.0,
     +       1.0, 1.0, 4.0, 2.0,
     +       1.0, 1.0, 2.0, 4.0/
      WRITE(*,*) "Begin DEIGEN; check eigenvalue solver"
      NEVEC=2
      SMALL=.FALSE.
      CALL XDEVESF(N,NEVEC,A,LDA,SMALL,EVAL,EVEC,LDEVEC)
c show solution
      CALL DVOUT(NEVEC,EVAL)
      DO 200 I=1,N
      WRITE(*,900) I,(EVEC(I,J),J=1,NEVEC)
  200 CONTINUE
  900 FORMAT(I5,10(F10.4))
      RETURN
      END

c ----------------------------------------------
c Routine for eigenvalues
c ----------------------------------------------
      SUBROUTINE EIGEN1()
      IMPLICIT REAL (A-H,O-Z)
      IMPLICIT INTEGER (I-M)
      PARAMETER (N=3,LDA=N,LDB=N,LDEVEC=N)
      REAL A(LDA,N),B(LDA,N),EVAL(N),EVEC(LDEVEC,N)
      DATA A/1.1, 1.2, 1.4,
     +       1.2, 1.3, 1.5,
     +       1.4, 1.5, 1.6/
      DATA B/2.0, 1.0, 0.0,
     +       1.0, 2.0, 1.0,
     +       0.0, 1.0, 2.0/
      WRITE(*,*) "Begin EIGEN1; check eigenvalue solver"
      CALL XGVCSP(N,A,LDA,B,LDB,EVAL,EVEC,LDEVEC)
c show solution
      CALL RVOUT(N,EVAL)
      DO 200 I=1,N
      WRITE(*,900) I,(EVEC(I,J),J=1,N)
  200 CONTINUE
  900 FORMAT(I5,10(F10.4))
      RETURN
      END

c ----------------------------------------------
c Routine for eigenvalues
c ----------------------------------------------
      SUBROUTINE DEIGEN1()
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-M)
      PARAMETER (N=3,LDA=N,LDB=N,LDEVEC=N)
      DOUBLE PRECISION A(LDA,N),B(LDA,N),EVAL(N),EVEC(LDEVEC,N)
      DATA A/1.1, 1.2, 1.4,
     +       1.2, 1.3, 1.5,
     +       1.4, 1.5, 1.6/
      DATA B/2.0, 1.0, 0.0,
     +       1.0, 2.0, 1.0,
     +       0.0, 1.0, 2.0/
      WRITE(*,*) "Begin DEIGEN1; check eigenvalue solver"
      CALL XDGVCSP(N,A,LDA,B,LDB,EVAL,EVEC,LDEVEC)
c show solution
      CALL DVOUT(N,EVAL)
      DO 200 I=1,N
      WRITE(*,900) I,(EVEC(I,J),J=1,N)
  200 CONTINUE
  900 FORMAT(I5,10(F10.4))
      RETURN
      END

c ----------------------------------------------
c Compute the inverse of a matrix
c ----------------------------------------------
      SUBROUTINE MINV()
      INTEGER I,J,N
      REAL A(3,3),AINV(3,3)
      DATA A/ 1.0, -3.0,  2.0,
     +       -3.0, 10.0, -5.0,
     +        2.0, -5.0,  6.0/
      WRITE(*,*) "Begin MINV; check matrix inverse"
      N = 3
      CALL XLINDS(N,A,N,AINV,N)
c show solution
      DO 200 I=1,N
      WRITE(*,900) I,(AINV(I,J),J=1,N)
  200 CONTINUE
  900 FORMAT(I5,10(F10.4))
      RETURN
      END

c ----------------------------------------------
c Compute the inverse of a matrix
c ----------------------------------------------
      SUBROUTINE DMINV()
      INTEGER I,J,N
      DOUBLE PRECISION A(3,3),AINV(3,3)
      DATA A/ 1.0, -3.0,  2.0,
     +       -3.0, 10.0, -5.0,
     +        2.0, -5.0,  6.0/
      WRITE(*,*) "Begin DMINV; check matrix inverse"
      N = 3
      CALL XDLINDS(N,A,N,AINV,N)
c show solution
      DO 200 I=1,N
      WRITE(*,900) I,(AINV(I,J),J=1,N)
  200 CONTINUE
  900 FORMAT(I5,10(F10.4))
      RETURN
      END

c ----------------------------------------------
      SUBROUTINE RVOUT(N,V)
      INTEGER I
      REAL V(1)
      DO 100 I=1,N
      WRITE(*,900) I,V(I)
  100 CONTINUE
  900 FORMAT(I5,2F10.4)
      RETURN
      END

c ----------------------------------------------
      SUBROUTINE DVOUT(N,V)
      INTEGER I
      DOUBLE PRECISION V(1)
      DO 100 I=1,N
      WRITE(*,900) I,V(I)
  100 CONTINUE
  900 FORMAT(I5,2F10.4)
      RETURN
      END

