c optools.for
c Selected IMSL routines
c
c       linear systems
c               DLSLRG
c               LSLRG
c       linear programming
c               DLPRS
c               DDLPRS
c               D2PRS
c               DD2PRS
c       eigenvalue problems
c               EVESF
c               DEVESF
c               GVCSP
c               DGVCSP
c       matrix inversion
c               LINDS
c               DLINDS

c ----------------------------------------------
c Solve a LP problem; min c^T x | BL <= Ax <= BU
c arguments
c       M       number of constraints
c       N       number of variables
c       A       coeficients
c       LDA     leading dimension of A (as declared by dim statement)
c       BL      lower limit for b
c       BU      upper limit for b
c       C       objective coeficients
c       IRTYPE  vector indicating type of constraint, values 
c               for row i are:
c                       0       bl =  (Ax)i  = bu
c                       1             (Ax)i <= bu
c                       2       bl <= (Ax)i
c                       3       bl <= (Ax)i <= bu
c       XLB     lower bound on vars
c       XUB     upper bound on vars
c       OBJ     objective value
c       XSOL    primal solution
c       DSOL    dual solution
      SUBROUTINE XDLPRS(M,N,A,LDA,BL,BU,C,IRTYPE,XLB,XUB,OBJ,
     & XSOL,DSOL)
      !DEC$ ATTRIBUTES DLLEXPORT :: XDLPRS
      USE IMSL
      IMPLICIT REAL (A-H,O-Z)
      IMPLICIT INTEGER (I-M)
      DIMENSION X(1),A(1),BL(1),BU(1),C(1),IRTYPE(1),
     & XLB(1),XUB(1),XSOL(1),DSOL(1)
      CALL DLPRS(M,N,A,LDA,BL,BU,C,IRTYPE,XLB,XUB,OBJ,
     & XSOL,DSOL)
      RETURN
      END

c ----------------------------------------------
c Solve a LP problem; min c^T x | BL <= Ax <= BU
c arguments - same as XDLPRS but double precision
      SUBROUTINE XDDLPRS(M,N,A,LDA,BL,BU,C,IRTYPE,XLB,XUB,OBJ,
     & XSOL,DSOL)
      !DEC$ ATTRIBUTES DLLEXPORT :: XDDLPRS
      USE IMSL
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-M)
      DIMENSION X(1),A(1),BL(1),BU(1),C(1),IRTYPE(1),
     & XLB(1),XUB(1),XSOL(1),DSOL(1)
      CALL DDLPRS(M,N,A,LDA,BL,BU,C,IRTYPE,XLB,XUB,OBJ,
     & XSOL,DSOL)
      RETURN
      END

c ----------------------------------------------
c Solve a LP problem; same as XDLPRS but with workspace
c explicitly allocated.
c arguments
c       WK      real work vector, length M*(M+28)
c       IWK     integer work vector, length 29*M+3*NVAR
      SUBROUTINE XD2PRS(M,N,A,LDA,BL,BU,C,IRTYPE,XLB,XUB,OBJ,
     & XSOL,DSOL,WK,IWK)
      !DEC$ ATTRIBUTES DLLEXPORT :: XD2PRS
      USE IMSL
      IMPLICIT REAL (A-H,O-Z)
      IMPLICIT INTEGER (I-M)
      DIMENSION X(1),A(1),BL(1),BU(1),C(1),IRTYPE(1),
     & XLB(1),XUB(1),XSOL(1),DSOL(1),AWK(1),WK(1),IWK(1)
      LDAWK=1
      CALL D2PRS(M,N,A,LDA,BL,BU,C,IRTYPE,XLB,XUB,OBJ,
     & XSOL,DSOL,AWK,LDAWK,WK,IWK)
      RETURN
      END

c ----------------------------------------------
c Solve a LP problem; same as XD2PRS but double precision
      SUBROUTINE XDD2PRS(M,N,A,LDA,BL,BU,C,IRTYPE,XLB,XUB,OBJ,
     & XSOL,DSOL,WK,IWK)
      !DEC$ ATTRIBUTES DLLEXPORT :: XDD2PRS
      USE IMSL
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-M)
      DIMENSION X(1),A(1),BL(1),BU(1),C(1),IRTYPE(1),
     & XLB(1),XUB(1),XSOL(1),DSOL(1),AWK(1),WK(1),IWK(1)
      LDAWK=1
      CALL DD2PRS(M,N,A,LDA,BL,BU,C,IRTYPE,XLB,XUB,OBJ,
     & XSOL,DSOL,AWK,LDAWK,WK,IWK)
      RETURN
      END

c ----------------------------------------------
c Solve a linear system of equations
c arguments
c       N       number of equations
c       A       coefficient matrix
c       LDA     leading dimension of A (as declared by dim statement)
c       B       rhs vector
c       IPATH   1 for A x = b; 2 for A^T x = b (transpose A)
c       X       solution
      SUBROUTINE XLSLRG(N,A,LDA,B,IPATH,X)
      !DEC$ ATTRIBUTES DLLEXPORT :: XLSLRG
      USE IMSL
      IMPLICIT REAL (A-H,O-Z)
      IMPLICIT INTEGER (I-M)
      DIMENSION A(1),B(1),X(1)
      CALL LSLRG(N,A,LDA,B,IPATH,X)
      END

c ----------------------------------------------
c Solve a linear system of equations
c arguments - same as XLSLRG but double precision
      SUBROUTINE XDLSLRG(N,A,LDA,B,IPATH,X)
      !DEC$ ATTRIBUTES DLLEXPORT :: XDLSLRG
      USE IMSL
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-M)
      DIMENSION A(1),B(1),X(1)
      CALL DLSLRG(N,A,LDA,B,IPATH,X)
      END

c ----------------------------------------------
c Compute largest or smallest eigenvalues and vectors
c arguments
c       N       order of matrix
c       NEVEC   number of vectors to compute
c       A       matrix
c       LDA     leading dimension of A (as declared by dim statement)
c       SMALL   logical value; .TRUE. for smallest, .FALSE. for largest
c       EVAL    eigenvalues
c       EVEC    eigenvectors
c       LDEVEC  leading dimension of EVEC (as declared by dim statement)
      SUBROUTINE XEVESF(N,NEVEC,A,LDA,SMALL,EVAL,EVEC,LDEVEC)
      !DEC$ ATTRIBUTES DLLEXPORT :: XEVESF
      USE IMSL
      IMPLICIT REAL (A-H,O-Z)
      IMPLICIT INTEGER (I-M)
      LOGICAL SMALL
      DIMENSION A(1),B(1),X(1)
      CALL EVESF(N,NEVEC,A,LDA,SMALL,EVAL,EVEC,LDEVEC)
      END

c ----------------------------------------------
c Compute largest or smallest eigenvalues and vectors
c arguments - same as XEVESF but double precision
      SUBROUTINE XDEVESF(N,NEVEC,A,LDA,SMALL,EVAL,EVEC,LDEVEC)
      !DEC$ ATTRIBUTES DLLEXPORT :: XDEVESF
      USE IMSL
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-M)
      LOGICAL SMALL
      DIMENSION A(1),B(1),X(1)
      CALL DEVESF(N,NEVEC,A,LDA,SMALL,EVAL,EVEC,LDEVEC)
      END

c ----------------------------------------------
c Compute the inverse of a real symmetric positive definite matrix
c arguments
c       N       order of matrix
c       A       matrix
c       LDA     leading dimension of A (as declared by dim statement)
c       AINV    inverse of A
c       LDAINV  leading dimension of AINV (as declared by dim statement)
      SUBROUTINE XLINDS(N,A,LDA,AINV,LDAINV)
      !DEC$ ATTRIBUTES DLLEXPORT :: XLINDS
      USE IMSL
      IMPLICIT REAL (A-H,O-Z)
      IMPLICIT INTEGER (I-M)
      DIMENSION A(1),AINV(1)
      CALL LINDS(N,A,LDA,AINV,LDAINV)
      END

c ----------------------------------------------
c Compute the inverse of a real symmetric positive definite matrix
c arguments - same as XLINDS but double precision
      SUBROUTINE XDLINDS(N,A,LDA,AINV,LDAINV)
      !DEC$ ATTRIBUTES DLLEXPORT :: XDLINDS
      USE IMSL
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-M)
      DIMENSION A(1),AINV(1)
      CALL DLINDS(N,A,LDA,AINV,LDAINV)
      END

c ----------------------------------------------
c Compute the eigenvalues and vectors to A z = l B z
c arguments - similar to XEVESF
      SUBROUTINE XGVCSP(N,A,LDA,B,LDB,EVAL,EVEC,LDEVEC)
      !DEC$ ATTRIBUTES DLLEXPORT :: XGVCSP
      USE IMSL
      IMPLICIT REAL (A-H,O-Z)
      IMPLICIT INTEGER (I-M)
      DIMENSION A(1),B(1),EVAL(1),EVEC(1)
      CALL GVCSP(N,A,LDA,B,LDB,EVAL,EVEC,LDEVEC)
      END

c ----------------------------------------------
c Compute the eigenvalues and vectors to A z = l B z
c arguments - same as XGVCSP but double precision
      SUBROUTINE XDGVCSP(N,A,LDA,B,LDB,EVAL,EVEC,LDEVEC)
      !DEC$ ATTRIBUTES DLLEXPORT :: XDGVCSP
      USE IMSL
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      IMPLICIT INTEGER (I-M)
      DIMENSION A(1),B(1),EVAL(1),EVEC(1)
      CALL DGVCSP(N,A,LDA,B,LDB,EVAL,EVEC,LDEVEC)
      END

