#include <math.h>
#include "cmath.h"

/* *****************************SSP371      SIMQ */
/*        SUBROUTINE SIMQ */
/*        PURPOSE */
/*           OBTAIN SOLUTION OF A SET OF SIMULTANEOUS LINEAR EQUATIONS, */
/*           AX=B */
/*        USAGE */
/*           CALL SIMQ(A,B,N,KS) */
/*        DESCRIPTION OF PARAMETERS */
/*           A - MATRIX OF COEFFICIENTS STORED COLUMNWISE.  THESE ARE */
/*               DESTROYED IN THE COMPUTATION.  THE SIZE OF MATRIX A IS */
/*               N BY N. */
/*           B - VECTOR OF ORIGINAL CONSTANTS (LENGTH N). THESE ARE */
/*               REPLACED BY FINAL SOLUTION VALUES, VECTOR X. */
/*           N - NUMBER OF EQUATIONS AND VARIABLES. N MUST BE .GT. ONE. */
/*           KS - OUTPUT DIGIT */
/*                0 FOR A NORMAL SOLUTION */
/*                1 FOR A SINGULAR SET OF EQUATIONS */
/*        REMARKS */
/*           MATRIX A MUST BE GENERAL. */
/*           IF MATRIX IS SINGULAR , SOLUTION VALUES ARE MEANINGLESS. */
/*           AN ALTERNATIVE SOLUTION MAY BE OBTAINED BY USING MATRIX */
/*           INVERSION (MINV) AND MATRIX PRODUCT (GMPRD). */
/*        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED */
/*           NONE */
/*        METHOD */
/*           METHOD OF SOLUTION IS BY ELIMINATION USING LARGEST PIVOTAL */
/*           DIVISOR. EACH STAGE OF ELIMINATION CONSISTS OF INTERCHANGING */
/*           ROWS WHEN NECESSARY TO AVOID DIVISION BY ZERO OR SMALL */
/*           ELEMENTS. */
/*           THE FORWARD SOLUTION TO OBTAIN VARIABLE N IS DONE IN */
/*           N STAGES. THE BACK SOLUTION FOR THE OTHER VARIABLES IS */
/*           CALCULATED BY SUCCESSIVE SUBSTITUTIONS. FINAL SOLUTION */
/*           VALUES ARE DEVELOPED IN VECTOR B, WITH VARIABLE 1 IN B(1), */
/*           VARIABLE 2 IN B(2),........, VARIABLE N IN B(N). */
/*           IF NO PIVOT CAN BE FOUND EXCEEDING A TOLERANCE OF 0.0, */
/*           THE MATRIX IS CONSIDERED SINGULAR AND KS IS SET TO 1. THIS */
/*           TOLERANCE CAN BE MODIFIED BY REPLACING THE FIRST STATEMENT. */
/*     .................................................................. */

int simq(double *a, double *b, double *x, int dim) {
// real *a, *b;
// integer *n, *ks;

    /* System generated locals */
    int i__1, i__2, i__3, n, ks;
    double r__1;

    /* Local variables */
    // these were all static in the C code
    double biga;
    int imax;
    double save;
    int ixjx, i__, j, k, i1, i2, ia, ib, ic, ij, jj, it, ix, jx, 
	    jy, ny, ixj, jjx, iqs;
    double tol;
    int i;

    x[0] = 0.0;

/*        FORWARD SOLUTION */

    /* Parameter adjustments */
    // --b;
    // --a;

    imax = 0;

    /* Function Body */
    tol = 0.0;
    ks = 0;
    jj = -dim;
    i__1 = dim;
    for (j = 1; j <= i__1; ++j) {
	jy = j + 1;
	jj = jj + dim + 1;
	biga = 0.0;
	it = jj - j;
	i__2 = dim;
	for (i__ = j; i__ <= i__2; ++i__) {
	    /* SEARCH FOR MAXIMUM COEFFICIENT IN COLUMN */
	    ij = it + i__;
	    if (abs(biga) - abs(a[ij]) >= 0.0) {
		// goto L30;
	    } else {
	      biga = a[ij];
	      imax = i__;
	    }
	}

	/* TEST FOR PIVOT LESS THAN TOLERANCE (SINGULAR MATRIX) */
	if (abs(biga) - tol <= 0.0) {
	  ks = 1;
	  return ks;
	}

	/* INTERCHANGE ROWS IF NECESSARY */
	i1 = j + dim * (j - 2);
	it = imax - j;
	i__2 = dim;
	for (k = j; k <= i__2; ++k) {
	    i1 += dim;
	    i2 = i1 + it;
	    save = a[i1];
	    a[i1] = a[i2];
	    a[i2] = save;
	    /* DIVIDE EQUATION BY LEADING COEFFICIENT */
	    a[i1] /= biga;
	}
	save = b[imax];
	b[imax] = b[j];
	b[j] = save / biga;

	/* ELIMINATE NEXT VARIABLE */
	if (j - dim != 0) {
	iqs = dim * (j - 1);
	i__2 = dim;
	for (ix = jy; ix <= i__2; ++ix) {
	    ixj = iqs + ix;
	    it = j - ix;
	    i__3 = dim;
	    for (jx = jy; jx <= i__3; ++jx) {
		ixjx = dim * (jx - 1) + ix;
		jjx = ixjx + it;
		a[ixjx] -= a[ixj] * a[jjx];
	    }
	    b[ix] -= b[j] * a[ixj];
	}

	} else break;	    // goto L70;

    }

/* BACK SOLUTION */

// L70:
    ny = dim - 1;
    it = dim * dim;
    i__2 = ny;
    for (j = 1; j <= i__2; ++j) {
	ia = it - j;
	ib = dim - j;
	ic = dim;
	i__1 = j;
	for (k = 1; k <= i__1; ++k) {
	    b[ib] -= a[ia] * b[ic];
	    ia -= dim;
	    --ic;
	}
    }
    return ks;
}
// end of simq

/************************************************
 * Solve Ax = b using Gaussian elimination 
 *
 * This is the simplest form of solving simultaneous equations. No
 * checks for singularity are performed. Pivoting is also not done. 
 *
 */
int solve (double *a, double *b, double *x, int dim) {
	int i, ii, j, rows, cols;
	double lead;

	rows = dim;
	cols = dim;
	for(i=0; i<rows; i++) x[i] = b[i];

	// cout << " matrix a\n" << a << endl;
	// cout << " initial x\n" << x << endl;

	/* create upper triangular matrix (zeros below diagonal) */
	for(i=0; i<rows; i++) {
	    // assert (a[i*dim+i] != 0);			// no zeros on main diagonal

	    // zero column i in all rows below this one
	    for(ii=i+1; ii<rows; ii++) {
		x[ii] =  x[ii] - a[ii*dim+i] / a[i*dim+i] * x[i]; 
		// save the lead term of this row for row operation
		lead = a[ii*dim+i]; 
		for(j = i; j < cols; j++) {
		  a[ii*dim+j] =  a[ii*dim+j] - lead / a[i*dim+i] * a[i*dim+j]; 
	    	}
	    }
	}

	/* now zero upper part (above diagonal), start from bottom */
	for(i=rows-1; i>=0; i--) {
	    // assert (a[i*dim+i] != 0);			// no zeros on main diagonal
	    // zero column i in all rows above this one
	    for (ii = 0; ii < i; ii++) {
		// printf("ii: %d\n", ii);
	    	// no need to explicitly put the zeros in matrix a, only do x
		x[ii] -=  a[ii*dim+i] / a[i*dim+i] * x[i]; 
	    }
	    x[i] /= a[i*dim+i];
	    // printf(" \t inside solve, soln: %d, %f\n", i, x.m[i]);
	}

	// a.del();
	// b.del();
	return 0;
}

