%Optimum Fixed Beam
clear all
alen=100.;
nit=10;
nodes=21; %must be an odd number
nseg=nodes-1;
dx=alen/(nseg)
small=1.;
inodes1=nodes-2;
amom=zeros(nodes,1);
lb=-6.*ones(nodes,1);
ub=+6.*ones(nodes,1);
xx=0;
%Use initial solution for a fixed beam
for i=1:nodes
    amom(i)=(-alen^2/12.+xx*alen/2.-xx*xx/2.);
    xx=xx+dx;
end
%Finite difference solution
for iter=1:nit
    iter
    fac=fac*1.;
    Aeq=zeros(inodes1,nodes);
    beq=zeros(inodes1,1);
    for i=1:inodes1
        beq(i)=-1.;
        Aeq(i,i+1)=-2./(dx*dx);
        Aeq(i,i+2)=1./(dx*dx);
        Aeq(i,i)=1./(dx*dx);
        beq(i)=beq(i)+amom(i+1)*2./(dx*dx);
        beq(i)=beq(i)-amom(i+2)*1./(dx*dx);
        beq(i)=beq(i)-amom(i)*1./(dx*dx);
        end;
        %
    for i=1:nodes
        f(i)=sign(amom(i))*dx;
    end
        f(1)=f(1)/2.
        f(nodes)=f(nodes)/2.
    [x,fval,exitflag,output,lambda]=linprog(f,[],[],Aeq,beq,lb,ub)
    %Increment the moments
    for j=1:nodes
        amom(j)=amom(j)+x(j);
    end
end
%Plot moment diagram
    x=1:1:nodes;
    amom
    plot(x,amom(x))
    set(findobj('Type','line'),'Color','k')
    pause
 
