%Optimum Fixed Plate Design Using Symmetry
clear all
alen=100.;
nit=60;
nodes=31; %must be an odd number
nseg=nodes-1;
dx=alen/(nseg);
small=1.;
nodes1=(nodes+1)/2;
nodes2=nodes1^2;
inodes1=nodes1-1;
inodes2=inodes1^2;
amomx=zeros(nodes2,1);
amomy=zeros(nodes2,1);
amomxy=zeros(nodes2,1);
lb=-10.*ones(3*nodes2,1);
ub=+10.*ones(3*nodes2,1);
xx=0.;
%Initial moments (1/2 load in each direction)
for i=1:nodes1
    for j=1:inodes1
    amomx(i+j*nodes1)=(-alen^2/12.+xx*alen/2.-xx*xx/2.)/(2.);
    amomy(j+(i-1)*nodes1+1)=(-alen^2/12.+xx*alen/2.-xx*xx/2.)/(2.);
    end
    xx=xx+dx;
end
fac=1.;
for iter=1:nit
    iter
    fac=fac*1.;
    Aeq=zeros(inodes2+2*inodes1,3*nodes2);
    beq=zeros(inodes2+2*inodes1,1);
    f=zeros(3*nodes2,1);
    num=1;
    for i=1:inodes1
        for j=1:inodes1
% Mx,xx
        beq(num)=-1.;
        num1=num+nodes1+i;
        Aeq(num,3*num1-2)=-2./(dx*dx);
        Aeq(num,3*num1-2-3)=1./(dx*dx);
        beq(num)=beq(num)+amomx(num1)*2./(dx*dx);
        beq(num)=beq(num)-amomx(num1-1)*1./(dx*dx);
        if j == inodes1
        Aeq(num,3*num1-2-3)=1./(dx*dx);
        beq(num)=beq(num)-amomx(num1-1)*1./(dx*dx);
        else;
        Aeq(num,3*num1-2+3)=1./(dx*dx);
        beq(num)=beq(num)-amomx(num1+1)*1./(dx*dx);
        end;
        %
        %My,yy
        Aeq(num,3*num1-1)=-2./(dx*dx);
        Aeq(num,3*num1-1-nodes1*3)=1./(dx*dx);
        beq(num)=beq(num)+amomy(num1)*2./(dx*dx);
        beq(num)=beq(num)-amomy(num1-nodes1)*1./(dx*dx);
        if i == inodes1
        Aeq(num,3*num1-1-nodes1*3)=1./(dx*dx);
        beq(num)=beq(num)-amomy(num1-nodes1)*1./(dx*dx);
        else
        Aeq(num,3*num1-1+nodes1*3)=1./(dx*dx);
        beq(num)=beq(num)-amomy(num1+nodes1)*1./(dx*dx);
        end
        %
        %-2Mxy,xy
        if (i < inodes1) && (j < inodes1)
        Aeq(num,3*num1-3*(nodes1-1))=2./(dx*dx*4);
        Aeq(num,3*num1+3*(nodes1-1))=2./(dx*dx*4);
        Aeq(num,3*num1+3*(nodes1+1))=-2./(dx*dx*4);
        Aeq(num,3*num1-3*(nodes1+1))=-2./(dx*dx*4);
        beq(num)=beq(num)-amomxy(num1-nodes1+1)*2./(dx*dx*4);
        beq(num)=beq(num)-amomxy(num1+nodes1-1)*2./(dx*dx*4);
        beq(num)=beq(num)+amomxy(num1-nodes1-1)*2./(dx*dx*4);
        beq(num)=beq(num)+amomxy(num1+nodes1+1)*2./(dx*dx*4);
        end
        if (i == inodes1) && (j ~= inodes1)
        Aeq(num,3*num1-3*(nodes1-1))=+4./(dx*dx*4);
        Aeq(num,3*num1-3*(nodes1+1))=-4./(dx*dx*4);
        beq(num)=beq(num)-amomxy(num1-nodes1+1)*4./(dx*dx*4);
        beq(num)=beq(num)+amomxy(num1-nodes1-1)*4./(dx*dx*4);
        end
        if (i ~= inodes1) && (j == inodes1)
        Aeq(num,3*num1+3*(nodes1-1))=+4./(dx*dx*4);
        Aeq(num,3*num1-3*(nodes1+1))=-4./(dx*dx*4);
        beq(num)=beq(num)-amomxy(num1+nodes1-1)*4./(dx*dx*4);
        beq(num)=beq(num)+amomxy(num1-nodes1-1)*4./(dx*dx*4);
        end
        if (i == inodes1) && (j == inodes1)
        Aeq(num,3*num1-3*(nodes1+1))=-8./(dx*dx*4);
        beq(num)=beq(num)+amomxy(num1-nodes1-1)*8./(dx*dx*4);
        end
        num=num+1;
        end
    end
    i=1;
    j=1;
    for ii=1:nodes2
        iii=ii;
    [dmx1,dmy1,dmxy1]=variar(iii,amomx,amomy,amomxy);
    [da]=area(i,j,dx,inodes1);
    f(3*iii-2)=dmx1*da;
    f(3*iii-1)=dmy1*da;
    f(3*iii)=dmxy1*da;
    j=j+1;
    if j>nodes1
        j=1;
        i=i+1;
    end
    end
    for i=1:inodes1
  % Qy=0
        Aeq(inodes2+2*i-1,3*(nodes2-(i)))=-.5/dx; 
        if i ~= 1
        Aeq(inodes2+2*i-1,3*(nodes2-(i-1)+1))=.5/dx;
        else
        Aeq(inodes2+2*i-1,3*(nodes2-(i)))=-1./dx;
        end
  %Qx=0
        Aeq(inodes2+2*i,3*nodes1*(i))=-.5/dx;
        if i ~= inodes1
        Aeq(inodes2+2*i,3*nodes1*(i+2))=.5/dx; 
        else
        Aeq(inodes2+2*i,3*nodes1*(i))=-1./dx;    
        end
   end  
    [x,fval,exitflag,output,lambda]=linprog(f,[],[],Aeq,beq,lb,ub)
    for j=1:nodes2
        amomx(j)=amomx(j)+x(3*j-2);
        amomy(j)=amomy(j)+x(3*j-1);
        amomxy(j)=amomxy(j)+x(3*j);
    end
    for i=1:nodes2
        disp([i,amomx(i),amomy(i),amomxy(i)])
    end
    for i=1:nodes2*3
    lb(i)=lb(i)*fac;
    ub(i)=ub(i)*fac;
    end
end
%Plot results
    [x,y]=meshgrid(1:1:nodes1,1:1:nodes1);
    z=y.*1+x.*nodes1-nodes1;
    z=amomx(z);
    mesh(x,y,z)
    colormap('lines')
    pause
    z=y.*1+x.*nodes1-nodes1;
    z=amomy(z);
    mesh(x,y,z)
    colormap ('lines')
    pause
    z=y.*1+x.*nodes1-nodes1;
    z=amomxy(z);
    mesh(x,y,z)
    colormap ('lines')
    pause
 
