C     PLANE STRESS FINITE ELEMENT PROGRAM 
      DIMENSION NP(300,3),B(3),CZ(3),AZ(3),AY(3),S(100)
     1 ,Str(3,100),PSAVE(1000),DEP(3,3)
      DOUBLE PRECISION R(200),P(200),C(200,200),F1,F2
      FY=36000.
      E=29.E6 
      ANU=.3 
      E1N=E/(1.-ANU*ANU) 
      ON2=.5-ANU/2. 
  100 READ(50,150) NB,NN,NS 
      NNN=NN-NS 
      READ (50,156) (R(2*I-1),R(2*I),PSAVE(2*I-1),PSAVE(2*I),I=1,NN) 
      WRITE (60,157) 
      WRITE (60,158) (I,R(2*I-1),R(2*I),PSAVE(2*I-1),PSAVE(2*I),I=1,NN) 
      N=2*NN
      DO 99 I=1,NB
      DO 99 J=1,3
   99 STR(J,I)=0.
      NIT=50
      DO 98 ITER=1,NIT
      WRITE(60,*) '*****', ITER
C
C     SET UP SYSTEM MATRIX
      DO 30 I=1,N
      P(I)=PSAVE(I)*1./FLOAT(NIT)
      DO 30 J=1,N 
   30 C(I,J)=0. 
      N=2*NNN
      IF(ITER.EQ.1)
     1 WRITE (60,159) 
      L11=0 
      L=0 
  201 L=L+1
      IF(ITER.EQ.1)
     1 READ(50,151) (NP(L,I),I=1,3),S(L)
      IF(ITER.EQ.1)
     1 WRITE(60,160) L,(NP(L,I),I=1,3),S(L) 
      CALL ABC(NP,L,B,CZ,R,AREA)
      CALL YIELD(FY,STR,PAR,L,ITER)
      CALL PLAS(STR,L,E1N,ON2,ANU,DEP)
  104 DO 13 L1=1,3 
      IR=2*NP(L,L1) 
      IF(IR.GT.N) GO TO 13 
      DO 14 L2=1,3 
      IS=2*NP(L,L2) 
      IF(IS.GT.N) GO TO 14
      IF(ITER.EQ.1) GO TO 91
      IF(PAR.GT.0.) GO TO 91
      Z11=S(L)*.25/AREA 
      C(IR-1,IS-1)=C(IR-1,IS-1)+Z11*(DEP(1,1)*B(L1)*B(L2)
     1 +DEP(1,3)*B(L1)*CZ(L2)+CZ(L1)*(DEP(3,1)*B(L2)+DEP(3,3)*
     1 CZ(L2)))
      C(IR-1,IS  )=C(IR-1,IS  )+Z11*(B(L1)*(DEP(1,2)*CZ(L2)+
     1 DEP(1,3)*B(L2))+CZ(L1)*(DEP(3,2)*CZ(L2)+DEP(3,3)*B(L2)))
      C(IR,IS-1)=C(IR,IS-1)+Z11*(CZ(L1)*(DEP(2,1)*B(L2)+DEP(2,3)*CZ(L2))
     1 +B(L1)*(DEP(3,1)*B(L2)+DEP(3,3)*CZ(L2)))
      C(IR,IS)=C(IR,IS)+Z11*(CZ(L1)*(CZ(L2)*DEP(2,2)+DEP(2,3)*B(L2))
     1 +B(L1)*(DEP(3,2)*CZ(L2)+DEP(3,3)*B(L2)))
      GO TO 14
  91  Z11=E1N*S(L)*.25/AREA 
      C(IR-1,IS-1)=C(IR-1,IS-1)+Z11*B(L1)*B(L2) 
     1 +Z11*ON2*CZ(L1)*CZ(L2) 
      C(IR-1,IS  )=C(IR-1,IS  )+Z11*(ANU*B(L1)*CZ(L2) 
     1 +ON2*B(L2)*CZ(L1)) 
      C(IR,IS-1)=C(IR,IS-1)+Z11*ON2*B(L1)*CZ(L2) 
     1 +Z11*ANU*B(L2)*CZ(L1) 
      C(IR,IS)=C(IR,IS)+Z11*(CZ(L1)*CZ(L2)+ON2*B(L1)*B(L2)) 
   14 CONTINUE 
   13 CONTINUE 
   12 IF(L-NB) 201,202,202 
C
C     SOLVE THE SYSTEM 
  202 M=N-1 
      DO 17 I=1,M 
      L=I+1 
      DO 17 J=L,N 
      IF (C(J,I))19,17,19 
   19  DO 18 K=L,N 
   18 C(J,K)=C(J,K)-C(I,K)*C(J,I)/C(I,I) 
      P(J)=P(J)-P(I)          *C(J,I)/C(I,I) 
   17 CONTINUE 
      P(N)=P(N)/C(N,N) 
      DO 20 I=1,M 
      K=N-I 
      L=K+1 
      DO 21 J=L,N 
   21 P(K)=P(K)-P(J)*C(K,J) 
      P(K)=P(K)/C(K,K) 
   20 CONTINUE 
C
C     OUTPUT DISPLACEMENTS
      WRITE (60,161) 
      WRITE (60,152)(I,P(2*I-1),P(2*I),I=1,NNN) 
      WRITE (60,162) 
      L11=1 
      L=0 
  203 L=L+1 
      CALL ABC(NP,L,B,CZ,R,AREA) 
      CALL YIELD(FY,STR,PAR,L,ITER)
      CALL PLAS(STR,L,E1N,ON2,ANU,DEP)
  102 DO 204 K=1,3 
  204 AZ(K)=0. 
      DO 34 L1=1,3 
      IR=2*NP(L,L1) 
      IF(IR.GT.N) GO TO 34 
      AZ(1)=AZ(1)+B(L1)*P(IR-1)*.5/AREA 
      AZ(2)=AZ(2)+CZ(L1)*P(IR)*.5/AREA 
      AZ(3)=AZ(3)+(CZ(L1)*P(IR-1)+B(L1)*P(IR))*.5/AREA 
   34 CONTINUE
      IF (PAR.GT.0.)GO TO 134
      DO 136 LI=1,3
      AY(LI)=0.
      DO 136 LJ=1,3
  136 AY(LI)=AY(LI)+DEP(LI,LJ)*AZ(LJ)
      GO TO 137
  134 AY(1)=E1N*(AZ(1)+ANU*AZ(2)) 
      AY(2)=E1N*(ANU*AZ(1)+AZ(2)) 
      AY(3)=E1N*ON2*AZ(3) 
  137 WRITE(60,952) L,(AZ(I),I=1,3),(AY(I),I=1,3)
      STR(1,L)=STR(1,L)+AY(1)
      STR(2,L)=STR(2,L)+AY(2)
      STR(3,L)=STR(3,L)+AY(3)
   22 IF(L-NB) 203,888,888 
  888 CONTINUE
   98 CONTINUE
      STOP
  150 FORMAT(3(I4,3X)) 
  151 FORMAT(3I5,8X,E20.8) 
  156 FORMAT(8X,4F11.6) 
  152 FORMAT(I10,2D20.8) 
  952 FORMAT(I10,6D20.8) 
  157 FORMAT(1H1,18X,11HCOORDINATES,32X,5HLOADS/ 
     114X,1HX,19X,1HY,18X,2HPX,18X,2HPY//) 
  158 FORMAT(I4,4D20.8) 
  159 FORMAT(1H1,2X,7HELEMENT,13X,13HELEMENT NODES,15X,9HTHICKNESS//) 
  160 FORMAT(4I10,E20.8) 
  161 FORMAT(1H1,13HDISPLACEMENTS/20X,1HX,19X,1HY//) 
  162 FORMAT(1H1,35X,7HSTRAINS,52X,8HSTRESSES//3X,7HELEMENT, 
     1 9X,2HEX,18X,2HEY,18X,2HGA,18X,2HSX,18X,2HSY,18X,3HTAU//)
      END
C
      SUBROUTINE YIELD(FY,STR,PAR,L,ITER)
      DIMENSION STR(3,100)
      PAR=1.
      IF((SQRT(STR(1,L)**2-STR(1,L)*STR(2,L)+STR(2,L)**2
     1 +3.*STR(3,L)**2) -FY).GT.0.) PAR=-1.
      IF(PAR.LT.0.) WRITE (60,*) 'ELEMENT',L,'  YIELDING',
     1 '   ITER =',ITER
      RETURN
      END 
C
      SUBROUTINE PLAS(STR,L,E1N,ON2,ANU,DEP)
      DIMENSION STR(3,100),DELF(3),D(3,3),DEP(3,3),DEPS(3,3)
      DELF(1)=2.*STR(1,L)-STR(2,L)
      DELF(2)=-STR(1,L)+2.*STR(2,L)
      DELF(3)=6.*STR(3,L)
      D(1,1)=E1N
      D(2,2)=E1N
      D(1,2)=ANU*E1N
      D(1,3)=0.
      D(2,1)=D(1,2)
      D(2,3)=0.
      D(3,1)=0.
      D(3,2)=0.
      D(3,3)=ON2*E1N
      DDD=0.
      DO 1 I=1,3
      DO 1 J=1,3
    1 DDD=DDD+DELF(I)*D(I,J)*DELF(J)
      DO 2 I=1,3
      DO 2 K=1,3
      DEP(I,K)=0.
      DO 2 J=1,3
    2 DEP(I,K)=DEP(I,K)+DELF(I)*DELF(J)*D(J,K)
      DO 3 I=1,3
      DO 3 J=1,3
      DEPS(I,J)=-DEP(I,J)/DDD
    3 IF(I.EQ.J)DEPS(I,J)=DEPS(I,J)+1.
      DO 4 I=1,3
      DO 4 J=1,3
      DEP(I,J)=0.
      DO 4 K=1,3
    4 DEP(I,J)=DEP(I,J)+D(I,K)*DEPS(K,J)
      RETURN
      END
C
      SUBROUTINE ABC(NP,L,B,CZ,R,AREA)
      DIMENSION NP(300,3),B(1),CZ(1)
      DOUBLE PRECISION R(1)
      I=NP(L,1) 
      J=NP(L,2) 
      M=NP(L,3) 
      B(1)=-R(2*M)+R(2*J) 
      B(2)=R(2*M)-R(2*I) 
      B(3)=-R(2*J)+R(2*I) 
      CZ(1)=R(2*M-1)-R(2*J-1) 
      CZ(2)=-R(2*M-1)+R(2*I-1) 
      CZ(3)=R(2*J-1)-R(2*I-1) 
      AREA=.5*(R(2*I)*CZ(1)+R(2*J)*CZ(2)+R(2*M)*CZ(3)) 
      RETURN
      END




