C     PLANE STRESS FINITE ELEMENT PROGRAM
c     OPTIMIZATION USING ITERATIVE DESIGN
      DIMENSION NP(200,3),B(3),CZ(3),AZ(3),AY(3),S(200)
     1 ,sig(200,3)
      DOUBLE PRECISION R(200),P(200),C(200,200),F1,F2
     1, psave(200)
      E=29.E6
      fy=36000.
      ANU=.3 
      E1N=E/(1.-ANU*ANU) 
      ON2=.5-ANU/2. 
  100 READ(50,150) NB,NN,NS 
      NNN=NN-NS 
      READ (50,156) (R(2*I-1),R(2*I),Psave(2*I-1),
     1 Psave(2*I),I=1,NN)
      WRITE (60,157) 
      WRITE (60,158) (I,R(2*I-1),R(2*I),Psave(2*I-1),
     1 Psave(2*I),I=1,NN)
      N=2*NN
C
C     SET UP SYSTEM MATRIX
      nit=40
      do 9999 iter=1,nit
      volume=0.
      DO 30 I=1,N
      p(i)=psave(i)
      DO 30 J=1,N 
   30 C(I,J)=0. 
      N=2*NNN 
      WRITE (60,159) 
      L11=0 
      L=0 
  201 L=L+1
      if(iter.eq.1)
     1 READ(50,151) (NP(L,I),I=1,3),S(L) 
      WRITE(60,160) L,(NP(L,I),I=1,3),S(L) 
      call bc(np,r,b,cz,area,l)
  104 DO 13 L1=1,3 
      IR=2*NP(L,L1) 
      IF(IR.GT.N) GO TO 13 
      DO 14 L2=1,3 
      IS=2*NP(L,L2) 
      IF(IS.GT.N) GO TO 14 
      if(iter.ne.1) go to 5555
      Z11=E1N*S(L)*.25/AREA
      C(IR-1,IS-1)=C(IR-1,IS-1)+Z11*B(L1)*B(L2) 
     1 +Z11*ON2*CZ(L1)*CZ(L2) 
      C(IR-1,IS  )=C(IR-1,IS  )+Z11*(ANU*B(L1)*CZ(L2) 
     1 +ON2*B(L2)*CZ(L1)) 
      C(IR,IS-1)=C(IR,IS-1)+Z11*ON2*B(L1)*CZ(L2) 
     1 +Z11*ANU*B(L2)*CZ(L1) 
      C(IR,IS)=C(IR,IS)+Z11*(CZ(L1)*CZ(L2)+ON2*B(L1)*B(L2))
      go to 14
 5555 Z11=2.*fy*fy*S(L)*.25/AREA
      C(IR-1,IS-1)=C(IR-1,IS-1)+Z11*B(L1)*B(L2)*.6667
     1 +Z11*CZ(L1)*CZ(L2)/6. 
      C(IR-1,IS  )=C(IR-1,IS  )+Z11*(B(L1)*CZ(L2)/3. 
     1 +B(L2)*CZ(L1)/6.) 
      C(IR,IS-1)=C(IR,IS-1)+Z11*B(L1)*CZ(L2)/6. 
     1 +Z11*B(L2)*CZ(L1)/3. 
      C(IR,IS)=C(IR,IS)+Z11*(CZ(L1)*CZ(L2)*.6667+B(L1)*B(L2)/6.) 
   14 CONTINUE 
   13 CONTINUE 
   12 IF(L-NB) 201,202,202 
C
C     SOLVE THE SYSTEM 
  202 M=N-1 
      DO 17 I=1,M 
      L=I+1 
      DO 17 J=L,N 
      IF (C(J,I))19,17,19 
   19  DO 18 K=L,N 
   18 C(J,K)=C(J,K)-C(I,K)*C(J,I)/C(I,I) 
      P(J)=P(J)-P(I)          *C(J,I)/C(I,I) 
   17 CONTINUE 
      P(N)=P(N)/C(N,N) 
      DO 20 I=1,M 
      K=N-I 
      L=K+1 
      DO 21 J=L,N 
   21 P(K)=P(K)-P(J)*C(K,J) 
      P(K)=P(K)/C(K,K) 
   20 CONTINUE 
C
C     OUTPUT DISPLACEMENTS
      WRITE (60,161) 
      WRITE (60,152)(I,P(2*I-1),P(2*I),I=1,NNN) 
      WRITE (60,162) 
      L11=1 
      L=0 
  203 L=L+1
      call bc(np,r,b,cz,area,l)
  102 DO 204 K=1,3 
  204 AZ(K)=0. 
      DO 34 L1=1,3 
      IR=2*NP(L,L1) 
      IF(IR.GT.N) GO TO 34 
      AZ(1)=AZ(1)+B(L1)*P(IR-1)*.5/AREA 
      AZ(2)=AZ(2)+CZ(L1)*P(IR)*.5/AREA 
      AZ(3)=AZ(3)+(CZ(L1)*P(IR-1)+B(L1)*P(IR))*.5/AREA 
   34 CONTINUE
      if(iter.ne.1)e1n=2.*fy*fy
      AY(1)=E1N*(AZ(1)*.6667+.3333*AZ(2)) 
      AY(2)=E1N*(.3333*AZ(1)+.6667*AZ(2)) 
      AY(3)=E1N*AZ(3)/6.
      WRITE(60,952) L,(AZ(I),I=1,3),(AY(I),I=1,3)
      do 567 k=1,3
  567 sig(l,k)=ay(k)
      call mises(sig,s,fy,l)
      volume=volume+area*s(l)
   22 IF(L-NB) 203,888,888 
  888 continue
      write(60,*) 'iteration',iter,'volume',volume
 9999 continue
      stop
  150 FORMAT(3(I4,3X)) 
  151 FORMAT(3I5,8X,E20.8) 
  156 FORMAT(8X,4F11.6) 
  152 FORMAT(I10,2D20.8) 
  952 FORMAT(I10,6D20.8) 
  157 FORMAT(1H1,18X,11HCOORDINATES,32X,5HLOADS/ 
     114X,1HX,19X,1HY,18X,2HPX,18X,2HPY//) 
  158 FORMAT(I4,4D20.8) 
  159 FORMAT(1H1,2X,7HELEMENT,13X,13HELEMENT NODES,15X,9HTHICKNESS//) 
  160 FORMAT(4I10,E20.8) 
  161 FORMAT(1H1,13HDISPLACEMENTS/20X,1HX,19X,1HY//) 
  162 FORMAT(1H1,35X,7HSTRAINS,52X,8HSTRESSES//3X,7HELEMENT, 
     1 9X,2HEX,18X,2HEY,18X,2HGA,18X,2HSX,18X,2HSY,18X,3HTAU//) 
      END
c
      subroutine bc(np,r,b,cz,area,l)
      dimension np(200,3),b(1),cz(1)
      double precision r(1)
  101 I=NP(L,1) 
      J=NP(L,2) 
      M=NP(L,3) 
      B(1)=-R(2*M)+R(2*J) 
      B(2)=R(2*M)-R(2*I) 
      B(3)=-R(2*J)+R(2*I) 
      CZ(1)=R(2*M-1)-R(2*J-1) 
      CZ(2)=-R(2*M-1)+R(2*I-1) 
      CZ(3)=R(2*J-1)-R(2*I-1) 
      AREA=.5*(R(2*I)*CZ(1)+R(2*J)*CZ(2)+R(2*M)*CZ(3)) 
      return
      end
c
      subroutine mises(sig,s,fy,l)
      dimension s(1), sig(200,3)
      phi=sqrt(sig(l,1)**2-sig(l,1)*sig(l,2)+sig(l,2)**2
     1 +3.*sig(l,3)**2)
      s(l)=s(l)*phi/fy
      return
      end

