C     PROGRAM 3. plateit.for
C     Optimal Sandwich Plate Using Finite Differences
      dimension amx(100),amy(100),amxy(100)
      DOUBLE PRECISION P(100),C(100,100)
C
C     INITIALIZE PARAMETERS/ARRAYS
C
      E = 29.0D06
      anu=.2
      fy=36000.
      H=4.
c100   READ(50,150)Nit, nodes 
150   FORMAT (3I5)
      WRITE(60,150)Nit, nodes
      alen=100.
c     NODES MUST BE ODD
      nodes=19
      nit = 20
      nseg=nodes-1
      dx=alen/float(nseg)
      nodes1=(nodes+1)/2
      inodes1=nodes1-1
      n=inodes1**2
      in=inodes1
      D2=DX**2
      D4=DX**4
      vol=0.
C
      DO 9999 ITER=1,NIT
      T=1.
C
C     SET UP SYSTEM MATRIX
C
      DO 30 I = 1,N
      p(i)=1.
      DO 30 J = 1,N 
   30 C(I,J) = 0.
C
      DO 999 L=1,N
      IROW=(L-1)/(IN)+1
      ICOL=L-(IROW-1)*IN
      IF (ITER.NE.1)call thick(amx(l),amy(l),amxy(l),t,fy,h)
      vol=vol+t
      if(iter.ne.1) go to 435
      ak11=E*t**3/(12.*(1.-anu**2))
      ak12=ak11*anu
      ak33=ak11*(1.-anu)/2.
      akb=ak11*(2.*anu+4.*(1.-anu)/2.)
      go to 436
  435 ak11=2.*fy*.66667*h*t/d2
      ak12=ak11/2.
      ak33=ak11/4.
      akb=2.*ak12+4.*ak33
  436 continue
      WRITE(60,*)L,IROW,ICOL,T
      c(L,L)=C(L,L)+6.*AK11/D4
      if(icol.ne.1) go to 333
      c(l,l)=c(l,l)+ak11/d4
      go to 340
  333 if(icol.ne.2)go to 335
      c(l,l-1)=c(l,l-1)-4.*ak11/d4
      go to 340
  335 c(l,l-2)=c(l,l-2)+ak11/d4
      c(l,l-1)=c(l,l-1)-4.*ak11/d4
      if(icol.ne.in)go to 337
      c(l,l-2)=c(l,l-2)+ak11/d4
      c(l,l-1)=c(l,l-1)-4.*ak11/d4
      go to 341
  337 if(icol.ne.in-1)go to 340
      c(l,l)=c(l,l)+ak11/d4
      c(l,l+1)=c(l,l+1)-4.*ak11/d4
      go to 341
  340 c(l,l+1)=c(l,l+1)-4.*ak11/d4
      c(l,l+2)=c(l,l+2)+ak11/d4
  341 continue

c
      c(L,L)=C(L,L)+6.*AK11/D4
      if(irow.ne.1) go to 1333
      c(l,l)=c(l,l)+ak11/d4
      go to 1340
 1333 if(irow.ne.2)go to 1335
      c(l,l-in)=c(l,l-in)-4.*ak11/d4
      go to 1340
 1335 c(l,l-2*in)=c(l,l-2*in)+ak11/d4
      c(l,l-1*in)=c(l,l-1*in)-4.*ak11/d4
      if(irow.ne.in)go to 1337
      c(l,l-2*in)=c(l,l-2*in)+ak11/d4
      c(l,l-in)=c(l,l-in)-4.*ak11/d4
      go to 1341
 1337 if(irow.ne.in-1)go to 1340
      c(l,l)=c(l,l)+ak11/d4
      c(l,l+1*in)=c(l,l+1*in)-4.*ak11/d4
      go to 1341
 1340 c(l,l+1*in)=c(l,l+1*in)-4.*ak11/d4
      c(l,l+2*in)=c(l,l+2*in)+ak11/d4
 1341 continue
C CENTER
      C(L,L)=C(L,L)+4.*AKB/D4
      IF(IROW.NE.1) C(L,L-IN)=C(L,L-IN)-2.*AKB/D4
      if (irow.ne.in) C(L,L+IN)=C(L,L+IN)-2.*AKB/D4
      if (irow.eq.in) C(L,L-IN)=C(L,L-IN)-2.*AKB/D4
C LEFT
      IF(ICOL.NE.1)C(L,L-1)=C(L,L-1)-2.*AKB/D4
      IF(IROW.NE.1.and.icol.ne.1) C(L,L-IN-1)=C(L,L-IN-1)+1.*AKB/D4
      IF(ICOL.NE.1.and.irow.ne.in)C(L,L+IN-1)=C(L,L+IN-1)+1.*AKB/D4
      IF(IROW.EQ.IN.AND.ICOL.NE.1)C(L,L-IN-1)=C(L,L-IN-1)+
     1 1.*AKB/D4
C RIGHT
      if(icol.ne.in)C(L,L+1)=C(L,L+1)-2.*AKB/D4
      if(icol.eq.in)C(L,L-1)=C(L,L-1)-2.*AKB/D4
      IF(IROW.NE.1.and.icol.ne.in) C(L,L-IN+1)=C(L,L-IN+1)+1.*AKB/D4
      IF(IROW.NE.1.and.icol.eq.in) C(L,L-IN-1)=C(L,L-IN-1)+1.*AKB/D4
      IF(IROW.NE.in.and.icol.ne.in) C(L,L+IN+1)=C(L,L+IN+1)+1.*AKB/D4
      IF(IROW.eq.in.and.icol.ne.in) C(L,L-IN+1)=C(L,L-IN+1)+1.*AKB/D4
      IF(IROW.eq.in.and.icol.eq.in) C(L,L-IN-1)=C(L,L-IN-1)+1.*AKB/D4
      if(irow.ne.in.and.icol.eq.in) c(l,l+in-1)=c(l,l+in-1)+1.*akb/d4
151   FORMAT (2I5,8X,E10.6) 
160   FORMAT (3I10,E20.8) 
 999  CONTINUE
      write(60,*)'ITER',ITER,'VOLUME',VOL
c      WRITE(60,*)((I,J,C(I,J),J=1,N),I=1,N)
C
C     SOLVE FOR JOINT DISPLACEMENTS
C
      M = N - 1 
      DO 17 I = 1,M 
      L = I + 1 
      DO 17 J = L,N 
      IF(C(J,I)) 19,17,19 
   19 DO 18 K = L,N 
   18 C(J,K) = C(J,K) - C(I,K)*C(J,I)/C(I,I) 
      P(J) = P(J) - P(I)*C(J,I)/C(I,I) 
   17 CONTINUE
      P(N) = P(N)/C(N,N) 
      DO 20 I = 1,M 
      K = N - I 
      L = K + 1 
      DO 21 J = L,N 
   21 P(K) = P(K) - P(J)*C(K,J) 
      P(K) = P(K)/C(K,K) 
   20 CONTINUE 
      WRITE(60,161)(I,P(i),I=1,N)
  161 FORMAT (1H1,13HDISPLACEMENTS/20X,1HX,19X,1HY//
     1//(I10,D20.8))
C
C     COMPUTE MEMBER FORCES AND DISPLACEMENTS
C
      DO 998 I=1,N
      IROW=(i-1)/(IN)+1
      IF (ITER.NE.1)call thick(amx(i),amy(i),amxy(i),t,fy,h)
      ICOL=i-(IROW-1)*IN
      IF(ICOL.NE.1.AND.ICOL.NE.IN) YXX=(P(I+1)+P(I-1)-2.*P(I))/D2
      if(icol.eq.1) YXX=(P(I+1)-2.*P(I))/D2
      if(icol.eq.in)yxx=(P(I-1)+P(I-1)-2.*P(I))/D2
      IF(IROW.NE.1.AND.ROW.NE.IN)YYY=(P(I+IN)+P(I-IN)-2.*P(I))/D2
      if(irow.eq.1) Yyy=(P(I+in)-2.*P(I))/D2
      if(irow.eq.in)yyy=(P(I-in)+P(I-in)-2.*P(I))/D2
      yxy=0.
      if(irow.eq.in.or.icol.eq.in) go to 899
      if(irow.eq.1.and.icol.eq.1) yxy=-1.*p(I+IN+1)*.25/D2
      if(irow.eq.1.and.icol.eq.1) GO TO 899
      IF(IROW.NE.1) GO TO 898
      YXY=(P(I+IN-1)-P(I+IN+1))*.25/D2
      GO TO 899
  898 IF(ICOL.NE.1) GOTO 897
      YXY=(P(I-IN+1)-P(I+IN+1))*.25/D2
      GO TO 899
  897 YXY=(P(I+1-IN)+P(I-1+IN)-P(I+1+IN)-P(I-1-IN))*.25/D2
  899 amx(i)=AK11*YXX+AK12*YYY
      amy(i)=AK12*YXX+AK11*YYY
      amxy(i)=-2.*AK33*YXY
      WRITE(60,1000) I,amx(i),amy(i),amxy(i) 
  998 CONTINUE
      VOL=0.
 9999 continue
      STOP
 1000 FORMAT (I10,3D20.8) 
      END
c
      subroutine thick(amx,amy,amxy,t,fy,h)
      t=sqrt(amx**2-amx*amy+amy**2+3.*amxy**2)/(fy*h)
      return
      end
