%
% Clear previous files
  clear all
  clc
%
% Parameters shared with the ODE routine
  global ncall n alp bet
  n=21;
  alp=-.5;
  dalp=.5;
  dbet=.2;
  nstep1=0;
  fid=fopen('alpout.m','r');
  for nstep=1:4
      bet=-.2;
      alp=alp+dalp;
  for mstep=1:4
      bet=bet+dbet;
      nstep1=nstep1+1
%
% Initial condition
  for i=1:(n-1)*2
    u0(i)=0.; 
  end  
%
% Independent variable for ODE integration
  t0=0.0;
  tf=8.;
  np=100;
  tout=linspace(t0,tf,np); 
  nout=n-1;
  ncall=0;
%
% ODE itegration
  %reltol=1.0e-04; abstol=1.0e-04;
  %options=odeset('RelTol',reltol,'AbsTol',abstol);
  mf=1;
  if(mf==1) % explicit FDs 
      [t,y]=ode45(@pde_1,tout,u0); end 
  %  [t,y]=ode23s(@pde_1,tout,u0,options); end 
  if(mf==2) ndss=4; % ndss = 2, 4, 6, 8 or 10 required
    [t,u]=ode15s(@pde_2,tout,u0,options); end
  if(mf==3) ndss=42; % ndss = 42, 44, 46, 48 or 50 required 
    [t,u]=ode15s(@pde_3,tout,u0,options); end
%       
% Store numerical and analytical solutions, errors at x = 1/2
  %Plot displacement at top
  for i=1:np
    u_plot(i)=y(i,(n-1)*2);  
  end
  num1=max(u_plot);
  num2=min(u_plot);
  A(nstep1,1)=alp;
  A(nstep1,2)=num1;
  A(nstep1,3)=num2;
  A(nstep1,4)=bet;
 % fwrite(fid,A(3));
%
% Display selected output
  %fprintf('\n mf = %2d   abstol = %8.1e   reltol = %8.1e\n',...
         % mf,abstol,reltol);
  %fprintf('\n     t   u(.5,t)   \n');
  %for i=1:5:nout   
    %  fprintf('%6.3f%15.6f\n',...
     %       t(i),u_plot(i));
  %end
  fprintf('\n ncall = %4d\n',ncall);
%
% Plot numerical solution at top
 % figure(1);
  %subplot(1,2,1)
  %plot(t,u_plot); axis tight
%  $title('u(top) vs t'); xlabel('t'); ylabel('u(top,t)')
  %subplot(1,2,2)
  %plot(t,err_plot); axis tight
  %title('Err u(0.5,t) vs t'); xlabel('t'); ylabel('Err u(0.5,t)')
  %print -deps pde.eps; print -dps pde.ps
%
% Plot numerical solution in 3D perspective
  %figure(2);
  %colormap('Gray');
  %C=ones(n-1,np);
  g=linspace(0,1,n-1); % For distance x
  for i=1:np
      for j=1:n-1
          v(i,j)=y(i,j+n-1);
      end
  end
  %h1 = waterfall(t,g,v',C); 
  %axis('tight');
  %grid off
  %xlabel('t, time')
  %ylabel('x, distance')
  %zlabel('u(x,t)')
  %s1 = sprintf('Beam Equation - MOL Solution');
  %sTmp = sprintf('u(x,0) = 0');
  %s2 = sprintf('Initial condition: %s', sTmp);
  %title([{s1}, {s2}], 'fontsize', 12);
  v = [0.8616   -0.5076    0.0000   -0.1770
       0.3712    0.6301    0.6820   -0.8417
       0.3462    0.5876   -0.7313    8.5590
            0         0         0    1.0000];
  %view(v);
  %rotate3d on;
  end
  end
 %% fclose(fid);
 save A;