c     program LPIP!
c     optimization using interior point lp
c     this code is described in Arbel
c     it uses the subroutine SIMQ from the IBM SSP
      DIMENSION ST(1000)
      max=1000
 100  READ(50,150)NLP,MLP 
 150  FORMAT (3I5)
      NST1=1
      NST2=NST1+NLP**2
      NST3=NST2+NLP*MLP
      NST4=NST3+NLP
      NST5=NST4+NLP
      NST6=NST5+MLP
      NST7=NST6+MLP**2
      NST8=NST7+MLP
      NST9=NST8+NLP
      NST10=NST9+NLP
      NST11=NST10+MLP*NLP
      IF (NST11.GT.MAX) WRITE(60,*) 'MAX STORAGE IN ST',NST11
      CALL XYZ(MLP,NLP,
     1 ST(NST1),ST(NST2),ST(NST3),ST(NST4),
     1 ST(NST5),ST(NST6),ST(NST7),ST(NST8),ST(NST9),
     2 ST(NST10))
      STOP
      END
C
      SUBROUTINE XYZ(MLP,NLP,      
     1 D,A,X,C,B,ADA,ADC,Z,DX,WORK)
      DIMENSION D(NLP,NLP),A(MLP,NLP),X(NLP),C(NLP),B(MLP),ADA(MLP,MLP)
     1 ,ADC(MLP),Z(NLP),DX(NLP),WORK(MLP,NLP)
      WRITE(60,1000) Nlp,Mlp
      READ(50,7001) ((A(I,J),J=1,Nlp),I=1,Mlp)
      READ(50,7000) (B(I),I=1,Mlp)
      READ(50,7000) (C(I),I=1,Nlp) 
      READ(50,7000) (X(I),I=1,Nlp)
      WRITE(60,2001) ((I,J,A(I,J),J=1,Nlp),I=1,Mlp)
      WRITE(60,7000) (B(I),I=1,Mlp)
      WRITE(60,7000) (C(I),I=1,Nlp) 
      WRITE(60,7000) (X(I),I=1,Nlp)
 7001 FORMAT(7F5.0)
 1000 FORMAT(8I5)
 7000 FORMAT(8F10.3)
 2001 FORMAT(2I5,E20.8)
      CALL INTLP(D,A,X,C,B,ADA,ADC,Z,DX,WORK,10,NLP,MLP)
	STOP
	END
C
      SUBROUTINE INTLP(D,A,X,C,B,ADA,ADC,Z,DX,WORK,ITER,N,M)
      DIMENSION D(N,N),A(M,N),X(N),C(N),B(M),ADA(M,M)
     1 ,ADC(M),Z(N),DX(N),WORK(M,N)
      DO 998 JTER=1,ITER
      do 2004 i=1,n
      do 2005 j=1,n
      D(i,j)=0.
 2005 if(i.eq.j) d(i,j)=x(i)**2
 2004 continue
      do 2006 i=1,m
      do 2006 j=1,n
      work(i,j)=0.
      do 2006 k=1,n
 2006 work(i,j)=work(i,j)+a(i,k)*d(k,j)
      do 2007 i=1,m
      do 2007 j=1,m
      ada(i,j)=0.
      do 2007 k=1,n
 2007 ada(i,j)=ada(i,j)+work(i,k)*a(j,k)
      do 2008 i=1,m
      adc(i)=0.
      do 2008 j=1,n
 2008 adc(i)=adc(i)+work(i,j)*c(J)
      WRITE(60,*)ADA,ADC
      call simq(ADA,ADC,M,KS)
      WRITE(60,*) 'Y'
      write(60,*)(adc(i),i=1,m)
      do 2009 i=1,N
      z(i)=c(i)
      do 2009 j=1,M
 2009 z(i)=z(i)-a(j,i)*ADC(J)
      write(60,*) 'dx'
      do 3010 i=1,n 
      dx(i)=0.
      do 2010 j=1,n
 2010 dx(i)=dx(i)-d(i,j)*z(j)
 3010 write(60,*) dx(i)
      alpha=0.
      do 2011 i=1,n
      if(dx(i).gE.0.)go to 2011
      alpha=aMAX1(alpha,-(Dx(i)/x(i)))
 2011 continue
      write(60,*) 'alpha', alpha
      rho=.95
      OBJ=0.
      do 2012 i=1,n
      x(i)=x(i)+rho*dx(i)/ALPHA
 2012 OBJ=OBJ+C(I)*X(I)
      WRITE(60,*) 'X'
      write(60,*)(x(i),i=1,n)
      WRITE(60,*) 'OBJECTIVE FUNCTION',OBJ
 998    CONTINUE
      RETURN
      END

C
C*****************************SSP371      SIMQ
C
C     ..................................................................
C
C        SUBROUTINE SIMQ
C
C        PURPOSE
C           OBTAIN SOLUTION OF A SET OF SIMULTANEOUS LINEAR EQUATIONS,
C           AX=B
C
C        USAGE
C           CALL SIMQ(A,B,N,KS)
C
C        DESCRIPTION OF PARAMETERS
C           A - MATRIX OF COEFFICIENTS STORED COLUMNWISE.  THESE ARE
C               DESTROYED IN THE COMPUTATION.  THE SIZE OF MATRIX A IS
C               N BY N.
C           B - VECTOR OF ORIGINAL CONSTANTS (LENGTH N). THESE ARE
C               REPLACED BY FINAL SOLUTION VALUES, VECTOR X.
C           N - NUMBER OF EQUATIONS AND VARIABLES. N MUST BE .GT. ONE.
C           KS - OUTPUT DIGIT
C                0 FOR A NORMAL SOLUTION
C                1 FOR A SINGULAR SET OF EQUATIONS
C
C        REMARKS
C           MATRIX A MUST BE GENERAL.
C           IF MATRIX IS SINGULAR , SOLUTION VALUES ARE MEANINGLESS.
C           AN ALTERNATIVE SOLUTION MAY BE OBTAINED BY USING MATRIX
C           INVERSION (MINV) AND MATRIX PRODUCT (GMPRD).
C
C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED
C           NONE
C
C        METHOD
C           METHOD OF SOLUTION IS BY ELIMINATION USING LARGEST PIVOTAL
C           DIVISOR. EACH STAGE OF ELIMINATION CONSISTS OF INTERCHANGING
C           ROWS WHEN NECESSARY TO AVOID DIVISION BY ZERO OR SMALL
C           ELEMENTS.
C           THE FORWARD SOLUTION TO OBTAIN VARIABLE N IS DONE IN
C           N STAGES. THE BACK SOLUTION FOR THE OTHER VARIABLES IS
C           CALCULATED BY SUCCESSIVE SUBSTITUTIONS. FINAL SOLUTION
C           VALUES ARE DEVELOPED IN VECTOR B, WITH VARIABLE 1 IN B(1),
C           VARIABLE 2 IN B(2),........, VARIABLE N IN B(N).
C           IF NO PIVOT CAN BE FOUND EXCEEDING A TOLERANCE OF 0.0,
C           THE MATRIX IS CONSIDERED SINGULAR AND KS IS SET TO 1. THIS
C           TOLERANCE CAN BE MODIFIED BY REPLACING THE FIRST STATEMENT.
C
C     ..................................................................
C
      SUBROUTINE SIMQ(A,B,N,KS)
      DIMENSION A(1),B(1)
C
C        FORWARD SOLUTION
C
      TOL=0.0
      KS=0
      JJ=-N
      DO 65 J=1,N
      JY=J+1
      JJ=JJ+N+1
      BIGA=0
      IT=JJ-J
      DO 30 I=J,N
C
C        SEARCH FOR MAXIMUM COEFFICIENT IN COLUMN
C
      IJ=IT+I
      IF(ABS(BIGA)-ABS(A(IJ))) 20,30,30
   20 BIGA=A(IJ)
      IMAX=I
   30 CONTINUE
C
C        TEST FOR PIVOT LESS THAN TOLERANCE (SINGULAR MATRIX)
C
      IF(ABS(BIGA)-TOL) 35,35,40
   35 KS=1
      RETURN
C
C        INTERCHANGE ROWS IF NECESSARY
C
   40 I1=J+N*(J-2)
      IT=IMAX-J
      DO 50 K=J,N
      I1=I1+N
      I2=I1+IT
      SAVE=A(I1)
      A(I1)=A(I2)
      A(I2)=SAVE
C
C        DIVIDE EQUATION BY LEADING COEFFICIENT
C
   50 A(I1)=A(I1)/BIGA
      SAVE=B(IMAX)
      B(IMAX)=B(J)
      B(J)=SAVE/BIGA
C
C        ELIMINATE NEXT VARIABLE
C
      IF(J-N) 55,70,55
   55 IQS=N*(J-1)
      DO 65 IX=JY,N
      IXJ=IQS+IX
      IT=J-IX
      DO 60 JX=JY,N
      IXJX=N*(JX-1)+IX
      JJX=IXJX+IT
   60 A(IXJX)=A(IXJX)-(A(IXJ)*A(JJX))
   65 B(IX)=B(IX)-(B(J)*A(IXJ))
C
C        BACK SOLUTION
C
   70 NY=N-1
      IT=N*N
      DO 80 J=1,NY
      IA=IT-J
      IB=N-J
      IC=N
      DO 80 K=1,J
      B(IB)=B(IB)-A(IA)*B(IC)
      IA=IA-N
   80 IC=IC-1
      RETURN
      END
