#!/bin/tcsh
#
# This script initializes the environment variables PATH and INVERTDIR. It
# should be called (with "source initinvert.csh") before running the inversion
# and plot programs.
#
# Per default it is assumed, that the directory invert is located inside
# the current directory, which is the project directory where the .def-files
# are located. After running this file, you can start invert, plotmap and
# plotprofile using exactly these names. 
#
# However, if you want to install the INVERT package only once e.g. in
# $HOME/Invert", then copy the subdirectory invert into that directory and
# replace the value of INVERTDIR below with "$HOME/Invert/invert".
#
# In that case it makes sense to copy this file into your HOME-directory and
# add the following into a separate line of your ~/.tcshrc, ~/.cshrc or
# ~/.login file: "source initinvert.csh". Than you do not have to call this
# file anymore to initialize the environment variables.
#
# (C) 2008 Peter L. Smilde
#

setenv INVERTDIR ./invert
#setenv INVERTDIR ${HOME}/Invert/invert

setenv PATH ${INVERTDIR}:${PATH}
