#!/usr/bin/gawk -f
#
# This script returns the minimum and maximum values of columns 2 to 6 (and
# possibly  8) and the relative number of points in x and y direction and the
# found data codes (column 7) of an INVERT observations-, .mod-, or .res-File.
#
# If the minimum and maximum value of columns 4 to 6 and 8 is equal, they are
# offset by a -1/+1.
#
# The relative number of points is the quotient of the total number of points
# proportional both numbers are still proportional to to the range in each
# direction.
#
# Lines with less than 7 entries and lines starting with ! or # are skipped.
#
# Variables assignments expected on the command line:
# nxmin:     Minimum relative number of points in x direction.
# nymin:     Minimum relative number of points in y direction.
#
# Dependencies on external programs:
#   gawk
#
# (C) 2008 Peter L. Smilde
#

function min(x,xmin) {
	return x<xmin ? x : xmin;
}

function max(x,xmax) {
	return x>xmax ? x : xmax;
}

BEGIN {
	nxy = 0;
	somin = 0;
	somax = 0;
}

/^[^#!]/ && NF>=7 {
  if (nxy==0) {
    xmin  = $2;
		xmax  = $2;
		ymin  = $3;
		ymax  = $3;
		gmin  = $4;
		gmax  = $4;
		simin = $5;
		simax = $5;
		zmin  = $6;
		zmax  = $6;
		dc[$7] = $7; 
		if (NF>=8) {
			somin = $8;
			somax = $8;
		}
		nxy   = 1;
	}
  else {
    xmin  = min($2,xmin);
    xmax  = max($2,xmax);
    ymin  = min($3,ymin);
    ymax  = max($3,ymax);
    gmin  = min($4,gmin);
    gmax  = max($4,gmax);
    simin = min($5,zmin);
    simax = max($5,zmax);
    zmin  = min($6,zmin);
    zmax  = max($6,zmax);
		if (!($7 in dc)) {
			dc[$7] = $7;
		}
		if (NF>=8) {
			somin  = min($6,zmin);
			somax  = max($6,zmax);
		}
		++nxy;
	}
}

END {
	dx = xmax - xmin;
	dy = ymax - ymin;

	nxmin = max(nxmin, 1);
	nymin = max(nymin, 1);

	if (dx>0 && dy>0) {
		nx = max(sqrt(dx/dy * nxy), nxmin);
		ny = max(dy/dx * nx, nymin);
		nx = max(dx/dy * ny, nxmin);
	}
	else if (dx>0) {
		nx = max(nxy, nxmin);
		ny = 1;
	}
	else if (dy>0) {
		nx = 1;
		ny = max(nxy, nymin);
	}

	if (gmax == gmin) {
		gmin -= 1;
		gmax += 1;
	}

	if (simax == simin) {
		simin -= 1;
		simax += 1;
	}

	if (zmax == zmin) {
		zmin -= 1;
		zmax += 1;
	}

	if (somax == somin) {
		somin -= 1;
		somax += 1;
	}

	format=OFMT " " OFMT " " OFMT " " OFMT " " OFMT " " OFMT " " OFMT " " OFMT " " OFMT " " OFMT " " OFMT " " OFMT " %d %d "
  printf(format, xmin,xmax,ymin,ymax,gmin,gmax,simin,simax,zmin,zmax,somin,somax,int(nx)+1,int(ny)+1);
	for (i in dc) {
		printf("%d ",dc[i]);
	}
}
