#!/usr/bin/gawk -f
#
# This script returns the first 7 columns of an INVERT observations-,
# .mod-, or .res-file with an additional offset for the x and/or y-coordinates.
# Lines with less than 6 entries and lines starting with ! or # are skipped.
# The 7 entries of all other lines are two times written to stdout: the first
# block of lines with negative offset, the second time with postitve offset.
# Both blocks are separated by an empty line.
#
# Variables assignments expected on the command line (unassigned variables
# imply an offset value of 0):
#  xoffset
#  yoffset
#
# Dependencies on external programs:
#   gawk
#
# (C) 2008 Peter L. Smilde
#

/^[^!#]/ && NF>=7 {
	 ++i;
	 n[i]=$1;
	 x[i]=$2;
	 y[i]=$3;
	 g[i]=$4;
	 s[i]=$5;
	 z[i]=$6;
	 c[i]=$7;
}

END {
	for (k=-1; k<=1; k+=2) {
		for (j=1; j<=i; ++j) {
			print n[j],x[j]+k*xoffset,y[j]+k*yoffset,g[j],s[j],z[j],c[j];
		}
		print "";
	}
}
