#!/bin/bash
#
# This script initializes the environment variables PATH and INVERTDIR. It
# should be called (with ". initinvert.sh" (note the initial period)) before
# running the inversion and plot programs.
#
# Per default it is assumed, that the directory invert is located inside the
# current directory, which is the project directory where the .def-files are
# located. After running this file, you can start invert, plotmap and
# plotprofile using exactly these names.
#
# However, if you want to install the INVERT package only once e.g. in
# $HOME/Invert", then copy the subdirectory invert into that directory and
# replace the value of INVERTDIR below with "$HOME/Invert/invert"
#
# In that case it makes sense to copy this file into your HOME-directory and
# add the following into a separate line of your ~/.bash_profile,
# ~/bash_login or ~/.profile file: ". initinvert.sh" (note the initial period).
# Than you do not have to call this file anymore to initialize the environment
# variables.
#
# (C) 2008 Peter L. Smilde
#

export INVERTDIR=./invert
#export INVERTDIR=${HOME}/Invert/invert

export PATH=${INVERTDIR}:${PATH}
