#!/usr/bin/gawk -f
#
# This script splits the given file according to the data codes in column 7. 
#
# Lines with less than 7 entries and lines starting with ! or # are skipped.
#
# Variables assignments expected on the command line:
# name:      Path and first part of filename of files to be created. This name
#            is appended with the data code number and the suffix ".dat"
#
# Dependencies on external programs:
#   gawk
#
# (C) 2008 Peter L. Smilde
#

/^[^#!]/ && NF>=7 {
	 if (!($7 in dc)) {
		 dc[$7] = $7;
		 print $0 > name $7 ".dat"
	 }
	 else {
		 print $0 >> name $7 ".dat"
	 }
}
