################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox) 
#       version 1.0 from 2/25/10. You can find more information at 
#       http://algorithmics.molgen.mpg.de/CATBox/
#
#	file:   Kruskal.pro
#	author: Torsten Pattberg (pattberg@zpr.uni-koeln.de)
#               Alexander Schliep (alexander@schliep.org)
#
#       Copyright (C) 1998-2010, Winfried Hochstaettler und Alexander Schliep
#	and (c) 2010 Springer Verlag.
#       
#       All rights reserved. Do not distribute. 
#	See http://schliep.org/CATBox for more information.
#




#
#       This file is version $Revision: 1.1 $ 
#                       from $Date: 2004/02/06 16:58:26 $
#             last change by $Author: schliep $.
#
#
################################################################################

#### Options #################################################
breakpoints = [11]
interactive = []
graphDisplays = 2
about = '''<HTML>
<HEAD>
<TITLE>Minimal Spanning Tree - Kruskal Find Circuit</TITLE>
</HEAD>
<BODY>

<H1>Minimal Spanning Tree - Kruskal Find Circuit</H1>

This algorithm finds a minimal spanning tree in an undirected graph.
This is a naive implementation which performs a shortest path search
on the partial tree to determine whether adding an edge will introduce
a circuit.


<H3>Visualization (Main Graph)</H3>

<H5>Vertex Colors</H5>
<dl>
<dt><colordef color="red"><colordef color="green"><colordef color="blue">...</dt> <dd>Vertex (and edge) colors designate the connected
components in the subgraph induced by the trees during the
computation. Therefore, each vertex has its own colors initially.</dd>
</dl>


<H5>Edge Colors</H5>
<dl>

<dt><colordef color="#EEEEEE"></dt> <dd>Initial color for edges. Edges
of this color have not been considered for inclusion in the MST yet.</dd>

<dt><colordef color="yellow"></dt> <dd>Color of the edge being
considered. (transient)</dd>

<dt><colordef color="green"></dt> <dd>Color of an edge which does not
create a circuit. (transient)</dd>

<dt><colordef color="grey"></dt> <dd>Color of edges which are not part
of the MST.</dd>

<dt><colordef color="red"><colordef color="green"><colordef
color="blue">...</dt> <dd>Edges which are part of the MST..</dd>

</dl>


<H3>Visualization (Find Circuit)</H3>

<H5>Vertex Colors</H5>

<dl>

<dt><colordef color="#000099"></dt> <dd>Initial vertex color if no
shortest path search is possible because one or both vertices are not
yet present in the graph.</dd>

<dt><colordef color="#EEEEEE"></dt> <dd>Vertices not yet visited by
the shortest path search.</dd>

<dt><colordef color="blue"></dt> <dd>Vertices visited and waiting to
be processed by the shortest path search.</dd>

<dt><colordef color="grey"></dt> <dd>Vertices visited and processed by
the shortest path search.</dd>

<dt><colordef color="red"></dt> <dd>Vertices which are on the shortest
path.</dd>

</dl>


<H5>Edge Colors</H5>

<dl>

<dt><colordef color="#EEEEEE"></dt> <dd>Initial color for edges.</dd>

<dt><colordef color="grey"></dt> <dd>Edges traversed in the search
which are not part of the shortest path.</dd>

<dt><colordef color="red"></dt> <dd>Edges on the shortest path.</dd>

</dl>





</BODY></HTML>
'''

self.NeededProperties({'EdgeWeights':1,'Undirected':1})

#### Misc ####################################################
True = 1
False = 0

class MySubGraph(AnimatedSubGraph):
    def __init__(self, graph, animator, sp_graph, sp_animator, component):
        AnimatedSubGraph.__init__(self, graph, animator)
        self.sp_graph = sp_graph
        self.sp_animator = sp_animator
        self.component = component

    def AddEdge(self, u, v):
	C = self.component[u]
	D = self.component[v]

        if not self.sp_graph.QVertex(u):
            e = self.superGraph.GetEmbedding(u)
            self.sp_animator.AddVertex(e.x, e.y, u)
        if not self.sp_graph.QVertex(v):
            e = self.superGraph.GetEmbedding(v)
            self.sp_animator.AddVertex(e.x, e.y, v)
        self.sp_animator.AddEdge(u, v)

	if C.Order() < D.Order():
            D.AddSubGraph(C)
	    for w in C.Vertices():
	        self.component[w] = D
	else:
            C.AddSubGraph(D)
	    for w in D.Vertices():
	        self.component[w] = C

	self.component[u].AddEdge(u,v)
        
        
weight = G.edgeWeights[0]
component = {}
Edges = G.Edges()

H = SubGraph(G)
self.OpenSecondaryGraph(H, stripPath(self.graphFileName) + " (find circuit)")
HA = self.GUI.secondaryGraphDisplay
T = MySubGraph(G,A,H,HA,component)
AddEdge = lambda u, v, t=T: t.AddEdge(u,v)

#### Graphinformer ###########################################

#### Internal functions ######################################
class ShortestPathFinder:
    def __init__(self, sp_graph, sp_animator, main_animator):
        self.graph = sp_graph
        self.animator = sp_animator
        self.main_animator = main_animator
        self.lastS = 0
        self.lastT = 0

    def __call__(self, s, t):
        if self.lastS:
            self.animator.SetVertexAnnotation(self.lastS,'')
            self.animator.SetVertexAnnotation(self.lastT,'')

        if s in self.graph.Vertices() and t in self.graph.Vertices():
            self.animator.SetVertexAnnotation(s,'s')
            self.animator.SetVertexAnnotation(t,'t')
            self.lastS, self.lastT = s, t
            Path = shortestPath(self.graph, self.animator, s, t)
        else:
            self.animator.SetAllEdgesColor(A.g.cEdgeDefault)
            self.animator.SetAllVerticesColor(A.g.cVertexDefault)
            Path = []
        if Path:
            self.main_animator.SetEdgeColor(s,t,"grey")
        else:
            self.main_animator.SetEdgeColor(s,t,"green")
        return Path

ShortestPath = ShortestPathFinder(H, HA, A)

def byWeight(x,y):
    if weight[x] == weight[y]:
        return 0
    elif weight[x] > weight[y]:
        return 1
    else:
        return -1

def Sort(E,b):
    E.sort(b)
    return ContainerWrapper(A, E,"yellow")

cm = ComponentMaker(G,A)
for v in G.vertices:
    component[v] = cm.NewComponent()
    component[v].AddVertex(v)
