################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox) 
#       version 1.0 from 2/25/10. You can find more information at 
#       http://algorithmics.molgen.mpg.de/CATBox/
#
#	file:   Kruskal.pro
#	author: Torsten Pattberg (pattberg@zpr.uni-koeln.de)
#               Alexander Schliep (alexander@schliep.org)
#
#       Copyright (C) 1998-2010, Winfried Hochstaettler und Alexander Schliep
#	and (c) 2010 Springer Verlag.
#       
#       All rights reserved. Do not distribute. 
#	See http://schliep.org/CATBox for more information.
#




#
#       This file is version $Revision: 1.1 $ 
#                       from $Date: 2004/02/06 16:58:26 $
#             last change by $Author: schliep $.
#
#
################################################################################

#### Options #################################################
breakpoints = [2,22]
interactive = []
graphDisplays = 1

##about = """<HTML>
##<HEAD>
##<TITLE>Minimal Spanning Tree - Kruskal Trace</TITLE>
##</HEAD>
##<BODY>

##<H1>Minimal Spanning Tree - Kruskal Trace</H1>

##This algorithm computes a minimal spanning tree in an undirected graph
##while allowing tracing into the relevant subroutines. Implementation
##uses component[v] to support efficient implementation of
##CreatingCircuit.




##<H3>Visualization (Main Graph)</H3>

##<H5>Vertex Colors</H5>
##<dl>
##<dt><colordef color="red"><colordef color="green"><colordef color="blue">...</dt> <dd>Vertex (and edge) colors designate the connected
##components in the subgraph induced by the trees during the
##computation. Therefore, each vertex has its own colors initially.</dd>
##</dl>


##<H5>Edge Colors</H5>
##<dl>

##<dt><colordef color="#EEEEEE"></dt> <dd>Initial color for edges. Edges
##of this color have not been considered for inclusion in the MST yet.</dd>

##<dt><colordef color="yellow"></dt> <dd>Color of the edge being
##considered. (transient)</dd>

##<dt><colordef color="grey"></dt> <dd>Color of edges which are not part
##of the MST.</dd>

##<dt><colordef color="red"><colordef color="green"><colordef
##color="blue">...</dt> <dd>Edges which are part of the MST..</dd>

##</dl>




##</BODY></HTML>
##"""

#### Misc ####################################################
weight = G.edgeWeights[0]

class VertexComponent(AnimatedVertexLabeling):
    def __setitem__(self, v, val):
        VertexLabeling.__setitem__(self, v, val)
        self.Animator.SetVertexColor(v,val.Color)
        self.Animator.BlinkVertex(v) 
component = VertexComponent(A)
Edges = G.Edges()

def MergeComponents(src, dest):
    if Order(src) < Order(dest):
        component[u].AddEdge(u,v)
    else:
        component[v].AddEdge(u,v)
    dest.AddSubGraph(src)
    
def Order(G):
    return G.Order()

def byWeight(x, y):
    if weight[x] == weight[y]:
        return 0
    elif weight[x] > weight[y]:
        return 1
    else:
        return -1

def SameComponent(u,v):
    if (component[u] == component[v]):
        A.SetEdgeColor(u, v, "grey")
        return True
    else:
        return False
    
def Sort(E, b):
    E.sort(b)
    return ContainerWrapper(A, E, "yellow")

cm = ComponentMaker(G, A)
for v in G.vertices:
    component[v] = cm.NewComponent()
    component[v].AddVertex(v)
    
