################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox)
#       version 1.0 from 2/25/10. You can find more information at
#       http://algorithmics.molgen.mpg.de/CATBox/
#
#	file:   MSTInteractive.pro
#	author: Torsten Pattberg (pattberg@zpr.uni-koeln.de)
#               Alexander Schliep (alexander@schliep.org)
#
#       Copyright (C) 1998-2010, Winfried Hochstaettler und Alexander Schliep
#	and (c) 2010 Springer Verlag.
#       
#       All rights reserved. Do not distribute. 
#	See http://schliep.org/CATBox for more information.
#




#      
#       This file is version $Revision: 1.5 $ 
#                       from $Date: 2004/02/06 17:01:25 $
#             last change by $Author: schliep $.
#
#
################################################################################

#### Options #################################################

breakpoints = [12]
interactive = [3]
graphDisplays = 1
about = """<HTML>

<HEAD>
<TITLE>Minimal Spanning Tree - Interactive</TITLE>
</HEAD>
<BODY>

<H1>Minimal Spanning Tree - Interactive</H1>

This algorithm allows the user to interactively build a minimal
spanning tree in an undirected graph

<H3>Visualization</H3>

<H5>Vertex Colors</H5>
<dl>

<dt><colordef color="red"><colordef color="green"> <colordef color="blue">...</dt> <dd>Vertex (and edge) colors designate the connected
components in the subgraph induced by the trees during the
computation. Therefore, each vertex has its own colors initially.</dd>

<dt><colordef color="yellow"></dt> <dd>Vertices on a circuit are
displayed in this color. (transient)</dd>

</dl>


<H5>Edge Colors</H5>

<dl>

<dt><colordef color="#EEEEEE"></dt> <dd>Edges of this color are not
part of the MST.</dd>

<dt><colordef color="yellow"></dt> <dd>Color of edges on a
circuit. (transient)</dd>

<dt><colordef color="red"></dt> <dd>The edge of maximal weight on a
circuit. (transient)</dd>

<dt><colordef color="red"><colordef color="green"><colordef
color="blue">...</dt> <dd>Edges which are part of the MST..</dd>





</BODY></HTML>
"""

self.NeededProperties({'EdgeWeights':1,'Undirected':1})

#### Misc ####################################################

ready           = 0
MSTweight       = 0

#### Wrapper #################################################

class EdgeSet(Set):

    def Delete(self, e):
	try:
            Set.Delete(self,(e[0],e[1]))
        except:
            try:
                Set.Delete(self,(e[1],e[0]))
            except:
                raise ValueError, "(%d,%d) is not an edge" % e

#### Lambdas #################################################

MergeComponents = lambda src, dest: dest.AddSubGraph(src)
NewComponent    = lambda cm = ComponentMaker(G,A): cm.NewComponent()
Order           = lambda G: G.Order()

#### Graph management ########################################

A.ShowGraph(G, stripPath(self.graphFileName))

#### Variables ###############################################

weight          = G.edgeWeights[0]
component       = {}
parent          = {}

#### Graphinformer ###########################################

class WeightedGraphInformer(GraphInformer):

    def EdgeInfo(self,tail,head):
        w = self.G.edgeWeights[0][(tail, head)]

        if A.GetEdgeColor(tail,head) == component[tail].Color:

    	    if self.G.edgeWeights[0].QInteger():
	        return "Weight of edge (%d,%d): %d - Weight of component: %d" % (tail, head, w, component[tail].Weight()) 
	    else:
	        return "Weight of edge (%d,%d): %f - Weight of component: %f" % (tail, head, w, component[tail].Weight()) 

        else:

    	    if self.G.edgeWeights[0].QInteger():
	        return "Weight of edge (%d,%d): %d" % (tail, head, w) 
	    else:
	        return "Weight of edge (%d,%d): %f" % (tail, head, w) 

    def DefaultInfo(self):
        if Order(component[1]) == G.Order():

            if self.G.edgeWeights[0].QInteger():
                return "Weight of spanning tree: %d - MST weight is: %d" %(component[1].Weight(),MSTweight)
	    else:
	        return "Weight of spanning tree: %f - MST weight is: %f" %(component[1].Weight(),MSTweight) 
        else:
            max = -gInfinity
            comp = None
            for v in G.vertices:
                if component[v]:
                    if max < component[v].Weight():
                        max  = component[v].Weight()
                        comp = component[v]
           
            text=comp.vertices

            if comp.Order()>4:
                text="[%s,%s,%s,...]"%(text[0],text[1],text[2])

            if self.G.edgeWeights[0].QInteger():
	        return "Component %s has maximal weight: %d - MST weight is %d" %(text,max,MSTweight) 
	    else:
	        return "Component %s has maximal weight: %f - MST weight is %f" %(text,max,MSTweight) 

#### Internal functions ######################################


def SameComponent(u,v):
    return component[u] == component[v]


def AddEdgeToComponent(e):
    if e not in component[e[0]].Edges():
        component[e[0]].AddEdge(e)
    else:
        A.SetEdgeColor(e[0],e[1],component[e[0]].Color)

    return None


def DeleteEdge(edge, circuit, tree):

    circuit.DeleteEdge(edge[0],edge[1])
    tree.DeleteEdge(edge[0],edge[1])
    A.SetEdgeColor(edge[0],edge[1],"#EEEEEE")

    for e in circuit.Edges():
        A.SetEdgeColor(e[0],e[1],component[edge[0]].Color)
        A.SetVertexColor(e[0],component[edge[0]].Color)
        A.SetVertexColor(e[1],component[edge[0]].Color)
    return None


def PickEdge():
    def filter(e):
        return e in E
    e = self.PickEdge(default=list(E)[0], filter=filter)
    A.SetEdgeColor(e[0],e[1],"green")
    A.BlinkEdge(e[0],e[1])
    E.Delete(e)
    return e


def FindCircuit(u, tree):

    found = 0

    for v in tree.vertices:
        parent[v] = None

    V = Stack()
    V.Push(u)

    while V.IsNotEmpty() and not found:
        v = V.Pop()
        for w in tree.Neighborhood(v):
            
            if parent[v] != w:
                if parent[w] == None:
                    parent[w] = v
                    V.Push(w)
                else:
                    found = 1
                    break

    if not found:
        return None

    else:
        Circuit = AnimatedSubGraph(G,A,"yellow")

        Circuit.AddEdge(v,w)

        while w != u:
            Circuit.AddEdge(w,parent[w])
            w = parent[w]

        while v != u:
            Circuit.AddEdge(v,parent[v])
            v = parent[v]

        return Circuit


def Merge(u,v):
    C = component[u]
    D = component[v]
    if Order(C) < Order(D):
	MergeComponents(C,D)    
	for w in Vertices(C):
	    component[w] = D
    else:
	MergeComponents(D,C)
	for w in Vertices(D):
	    component[w] = C
    
    AddEdgeToComponent((u,v))
    return


def MaximalWeightEdge(circuit):

    max = -gInfinity
    maxEdge = None

    for e in circuit.Edges():
        if weight[e] > max:
            max = weight[e]
            maxEdge = e

    A.SetEdgeColor(maxEdge[0],maxEdge[1],"red")
    A.BlinkEdge(maxEdge[0],maxEdge[1])

    return maxEdge

#### Internal initialisation #################################

#calculate MSTweight:
for v in G.vertices:
    component[v]=v

E = EdgeSet()

Edges = G.Edges()

while Edges:                     
    (u,v) = ArgMin(Edges,weight)
    Edges.remove((u,v))
    if component[v] != component[u]:
        MSTweight = MSTweight + weight[(u,v)]
        cv=component[v]
        cu=component[u]
        for w in G.vertices:
            if component[w] == cv:
                component[w] = cu

for v in G.vertices:
    component[v] = NewComponent()
    component[v].AddVertex(v)

for e in G.Edges():
    E.Add(e)
A.SetAllEdgesColor('#444444')


A.RegisterGraphInformer(WeightedGraphInformer(G))






