################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox) 
#       version 1.0 from 2/25/10. You can find more information at
#       http://algorithmics.molgen.mpg.de/CATBox/
#
#	file:   LabelCorrecting.pro
#	author: Torsten Pattberg (pattberg@zpr.uni-koeln.de)
#               Alexander Schliep (alexander@schliep.org)
#
#       Copyright (C) 1998-2010, Winfried Hochstaettler und Alexander Schliep
#	and (c) 2010 Springer Verlag.
#       
#       All rights reserved. Do not distribute. 
#	See http://schliep.org/CATBox for more information.
#




#
#       This file is version $Revision: 1.1 $ 
#                       from $Date: 2004/02/06 16:30:46 $
#             last change by $Author: schliep $.
#
#
################################################################################

#### Options #################################################

breakpoints = [7]
interactive = [1]
graphDisplays = 1
about = """<HTML>
<HEAD>
<TITLE>Shortest Path - Label Correcting</TITLE>
</HEAD>
<BODY>

This algorithm finds a shortest path tree from the source s
to all other vertices in a connected, undirected graph.

</BODY></HTML>
"""

root = None


class MyGraphInformer(WeightedGraphInformer):

    def VertexInfo(self,v):
	if v == root:
            return "Vertex %d is root of tree" % (v)
	elif dist[v] == gInfinity:
            return "Vertex %d is not in tree" % (v)
	elif self.G.edgeWeights[0].QInteger():
            return "Vertex %d has predecessor %d and distance %d" % (v,
                                                     pred[v],dist[v])
	else:
            return "Vertex %d has predecessor %d and distance %f" % (v,
                                                     pred[v],dist[v])

def pickCallback(v):
    A.SetVertexAnnotation(v,"s")
    global root
    root = v

PickVertex   = lambda f=pickCallback: self.PickVertex(1,None,f)
Neighborhood = lambda v, a=A, g=G: AnimatedNeighborhood(a,g,v,["red"])

length       = G.edgeWeights[0]
pred         = AnimatedPredecessor(A)
Q            = AnimatedVertexQueue(A,"blue","red")
dist         = {}

A.SetAllVerticesColor("#EEEEEE")

for v in G.vertices:
	dist[v] = gInfinity
	pred[v] = None

A.RegisterGraphInformer(MyGraphInformer(G,"length"))

