################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox) 
#       version 1.0 from 2/25/10. You can find more information at 
#       http://algorithmics.molgen.mpg.de/CATBox/
#
#	file:   Dijkstra.pro
#	author: Alexander Schliep (schliep@zpr.uni-koeln.de)
#
#       Copyright (C) 1998-2010, Winfried Hochstaettler und Alexander Schliep
#	and (c) 2010 Springer Verlag.
#       
#       All rights reserved. Do not distribute. 
#	See http://schliep.org/CATBox for more information.
#




#
#       This file is version $Revision: 1.15 $ 
#                       from $Date: 2003/11/12 13:36:20 $
#             last change by $Author: schliep $.
#
#
################################################################################

#### Options #################################################

breakpoints = [6]
interactive = [1]
graphDisplays = 1
about = """<HTML>
<HEAD>
<TITLE>Shortest Path - Dijkstra</TITLE>
</HEAD>
<BODY>

This algorithm finds a shortest path tree from the source s
to all other vertices in a connected, undirected graph.

</BODY></HTML>
"""

class MyGraphInformer(WeightedGraphInformer):

    def VertexInfo(self,v):
	if dist[v] == 0:
            return "Vertex %d is root of tree" % (v)
	elif dist[v] == gInfinity:
            return "Vertex %d is not in tree" % (v)
	elif self.G.edgeWeights[0].QInteger():
            return "Vertex %d has predecessor %d and distance %d" % (v, 
                                                     pred[v],dist[v])
	else:
            return "Vertex %d has predecessor %d and distance %f" % (v, 
                                                     pred[v],dist[v])

class MyAnimatedVertexSet(AnimatedVertexSet):
    def Remove(self, v):
        if v and pred[v]:
            A.SetEdgeColor(pred[v], v, 'red')
        AnimatedVertexSet.Remove(self, v)


pickCallback = lambda v, a=A: A.SetVertexAnnotation(v,"s")
PickVertex = lambda f=pickCallback: self.PickVertex(1, None, f)
pickMinimal = lambda V, d: ArgMin(V.vertices, d)
Neighborhood = lambda v,a=A,g=G: AnimatedNeighborhood(a, g, v,
                                                      ignoreColors=['#EE9900',"red"])

length = G.edgeWeights[0]
pred = AnimatedPredecessor(A, predColor='#EE9900')
dist = AnimatedVertexLabeling(A)
W = MyAnimatedVertexSet(A,color='red',addcolor='blue',trackLast=True)
  
for v in G.vertices:
    dist[v] = gInfinity
    pred[v] = None

A.RegisterGraphInformer(MyGraphInformer(G,"length"))
