################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox) 
#       version  1.0 from 2/25/10. You can find more information at 
#       http://algorithmics.molgen.mpg.de/CATBox/
#
#	file:   FindpathEuclid.pro
#	author: Torsten Pattberg (pattberg@zpr.uni-koeln.de)
#               Alexander Schliep (alexander@schliep.org)
#
#       Copyright (C) 1998-2010, Winfried Hochstaettler und Alexander Schliep
#	and (c) 2010 Springer Verlag.
#       
#       All rights reserved. Do not distribute. 
#	See http://schliep.org/CATBox for more information.
#




#
#       This file is version $Revision: 1.10 $ 
#                       from $Date: 2003/05/30 17:43:01 $
#             last change by $Author: schliep $.
#
#
################################################################################

#### Options #################################################

breakpoints = [12]
interactive = [1,2]
graphDisplays = 1
about = """<HTML>
<HEAD>
<TITLE>Shortest Path - Find Path Euclid</TITLE>
</HEAD>
<BODY>

This algorithm finds a shortest path from the source to the sink in a graph
with euclidian distances.

</BODY></HTML>
"""

class MyGraphInformer(WeightedGraphInformer):
    def VertexInfo(self,v):
	if dist[v] == 0:
            return "Vertex %d is root of tree, eucl. distance to t is %f" % (v,distance[v])
	elif dist[v] == gInfinity:
            return "Vertex %d is not in tree, eucl. distance to t is %f" % (v,distance[v])
	elif self.G.edgeWeights[0].QInteger():
            return "Vertex %d has predecessor %d and distance %d, eucl. distance to t is %f" % (v,
                                                     pred[v],dist[v],distance[v])
	else:
            return "Vertex %d has predecessor %d and distance %f, eucl. distance to t is %f" % (v,
                                                     pred[v],dist[v],distance[v])

from math import sqrt

def pickCallback(A,v,type):
    if type == "s":
        A.SetVertexAnnotation(v,type,"green")
    else:
        A.SetVertexAnnotation(v,type,"red")
    return

pickCallbackSource = lambda v, type="s", a=A: pickCallback(a,v,type)
PickSource         = lambda f=pickCallbackSource: self.PickVertex(1,None,f)
pickCallbackSink   = lambda v, type="t", a=A: pickCallback(a,v,type)
PickSink           = lambda f=pickCallbackSink: self.PickVertex(G.Order(),None,f)
ShowPath           = lambda u,v: showPathByPredecessorArray(u,v,pred,A,"yellow")
Neighborhood       = lambda v,a=A,g=G: AnimatedNeighborhood(a,g,v,["red"])


length       = G.edgeWeights[0]
pred         = AnimatedPredecessor(A)
dist         = VertexLabeling()
PQ           = AnimatedVertexPriorityQueue(A)
distance     = {}
coo          = G.embedding

for v in G.vertices:
    pred[v] = None
    dist[v] = gInfinity
    distance[v] = gInfinity

A.RegisterGraphInformer(MyGraphInformer(G,"length"))
