################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox) 
#       version  1.0 from 2/25/10. You can find more information at 
#       http://algorithmics.molgen.mpg.de/CATBox/
#
#	file:   NegativeCircuits.pro
#	author: Alexander Schliep (alexander@schliep.org)
#
#       Copyright (C) 1998-2010, Winfried Hochstaettler und Alexander Schliep
#	and (c) 2010 Springer Verlag.
#       
#       All rights reserved. Do not distribute. 
#	See http://schliep.org/CATBox for more information.
#




#       
#       This file is version $Revision: 1.1 $ 
#                       from $Date: 2004/02/06 14:28:44 $
#             last change by $Author: schliep $.
#
#
################################################################################

#### Options #################################################

breakpoints = [14]
interactive = [1]
graphDisplays = 1
about = """<HTML>
<HEAD>
<TITLE>Shortest Path - Negative Circuits</TITLE>
</HEAD>
<BODY>

This algorithm finds a negative circuit in a graph,
if one exists.

</BODY></HTML>
"""

root = None


class MyGraphInformer(WeightedGraphInformer):

    def VertexInfo(self,v):
	if v == root:
            return "Vertex %d is root of tree" % (v)
	elif dist[v] == gInfinity:
            return "Vertex %d is not in tree" % (v)
	elif self.G.edgeWeights[0].QInteger():
            return "Vertex %d has predecessor %d and distance %d" % (v,
                                                     pred[v],dist[v])
	else:
            return "Vertex %d has predecessor %d and distance %f" % (v,
                                                     pred[v],dist[v])

def pickCallback(v):
    A.SetVertexAnnotation(v,"s")
    global root
    root = v

PickVertex   = lambda f=pickCallback: self.PickVertex(1,None,f)
Neighborhood = lambda v, a=A, g=G: AnimatedNeighborhood(a,g,v,["red"])

length = G.edgeWeights[0]
pred = AnimatedPredecessor(A)
NOW = AnimatedVertexQueue(A,"blue","grey")
NEXT = AnimatedVertexQueue(A,"red","grey")

dist = {}
marked = AnimatedVertexLabeling(A, color="yellow")
circuit = AnimatedSubGraph(G,A,"yellow")

A.SetAllVerticesColor("green")

for v in G.vertices:
	dist[v] = gInfinity
	pred[v] = None

A.RegisterGraphInformer(MyGraphInformer(G,"length"))

