################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox)
#       version 1.0 from 2/25/10. You can find more information at
#       http://algorithmics.molgen.mpg.de/CATBox/
#
#	file:   PreflowPush.pro
#	author: Torsten Pattberg (pattberg@zpr.uni-koeln.de)
#               Alexander Schliep (alexander@schliep.org)
#
#       Copyright (C) 1998-2010, Winfried Hochstaettler und Alexander Schliep
#	and (c) 2010 Springer Verlag.
#       
#       All rights reserved. Do not distribute. 
#	See http://schliep.org/CATBox for more information.
#




#
#       This file is version $Revision: 1.16 $ 
#                       from $Date: 2002/12/27 12:38:49 $
#             last change by $Author: schliep $.
#
#
################################################################################

#### Options #################################################

breakpoints = [9,29]
interactive = [1,2]
graphDisplays = 2
about = """<HTML>
<HEAD>
<TITLE>Maximal Flow - Preflow Push</TITLE>
</HEAD>
<BODY>

This algorithm finds a maximal flow in a directed graph. 

</BODY></HTML>
"""
self.NeededProperties({'EdgeWeights':1,'Directed':1,'Simple':1})

from math import *

True            = 1
False           = 0
OldExcessVertex = 1

#### Graph management ########################################

import copy
R  = copy.deepcopy(G)

self.OpenSecondaryGraph(R,stripPath(self.graphFileName)+" (residual network)")

RA = self.GUI.secondaryGraphDisplay
G.CalculateWidthFromWeight(0.7)
A.ShowGraph(G, stripPath(self.graphFileName))

#### Wrapper #################################################

def InitPotential(s,t):
    (dist, dummy) = BFS(G,t,'backward')
    for v in G.vertices:
        pot[v] = dist[v]
    pot[s] = G.Order()

#### Internal functions ######################################

def FindExcessVertex():
    global OldExcessVertex

    RA.SetAllEdgesColor("black")
    maxpot  = 0
    maxpotv = None

    for v in Vertices():
	if excess(v) > 0:
	    if (v != s) and (v != t):
		if pot[v] > maxpot:
		    maxpot  = pot[v]
                    maxpotv = v

    if maxpotv:
        RA.SetVertexFrameWidth(OldExcessVertex,2)
        RA.SetVertexFrameWidth(maxpotv,6)
        OldExcessVertex = maxpotv
                
    return maxpotv

def _ShowCut(A,R,s):
    Q = Queue() # Component S of s is green, component T of t is red 
    C = [s]     # edges between S and T are yellow

    pred = {}
    for v in R.vertices:
	pred[v] = None	
    Q.Append(s)

    while Q.IsNotEmpty():
	v = Q.Top()
	for w in R.Neighborhood(v):
	    if pred[w] == None and w != s:
		pred[w] = v
		Q.Append(w)
		C.append(w)

    A.SetAllVerticesColor("red")

    for v in C:
        A.SetVertexColor(v,"green")
	for w in G.Neighborhood(v):
	    if not w in C:
		A.SetEdgeColor(v,w,"yellow")

    return None

def Min(a,b):

    minimum = a
    if b < a:
        minimum = b

    RA.graphInformer.SetDefaultInfo("delta = %d"%minimum)
    RA.UpdateInfo("delta = %d"%minimum)

    return minimum

def _minResNeighborPot(v,R,RA):

    RA.BlinkVertex(v)

    minimum = gInfinity

    for u in R.Neighborhood(v):
	if minimum > pot[u]:
            minimum = pot[u]

    return minimum

#### Lambdas #################################################

Neighborhood          = lambda v, ra=RA, r=R: AnimatedNeighborhood(ra,r,v)
Vertices              = lambda g=G: g.vertices
Order                 = lambda g=G: g.Order()
ShowCut               = lambda s,a=A,r=R: _ShowCut(a,r,s)
minResNeighborPot     = lambda v,r=R,ra=RA: _minResNeighborPot(v,r,ra)
ForwardEdge           = lambda u,v,g=G: g.QEdge(u,v)

#### Variables ###############################################

def pickCallback(A,RA,v,type):

    if type == "s":
        A.SetVertexAnnotation(v,type,"green")
        flow.excess[v] = gInfinity        
        RA.SetVertexColor(v,"green")
    else:
        A.SetVertexAnnotation(v,type,"red")
        flow.excess[v] = -gInfinity
        RA.SetVertexColor(v,"red")
    return


flow   = FlowWrapper(G,A,R,RA,G.edgeWeights[0],R.edgeWeights[0])

cap         = lambda e: flow.cap[e]
res         = lambda e: flow.res[e]
excess      = lambda v: flow.excess[v]
pot         = AnimatedPotential(2*G.Order()-1,A,RA)

pickCallbackSource = lambda v, type="s", a=A,ra=RA: pickCallback(a,ra,v,type)
PickSource         = lambda f=pickCallbackSource: self.PickVertex(1,None,f)
pickCallbackSink   = lambda v, type="t", a=A,ra=RA: pickCallback(a,ra,v,type)
PickSink           = lambda f=pickCallbackSink: self.PickVertex(G.Order(),None,f)

class PotentialResidualGraphInformer(ResidualGraphInformer):
    def __init__(self,G,flow,pot):
	ResidualGraphInformer.__init__(self,G,flow)
        self.pot = pot

    def VertexInfo(self,v):
        return "%s - potential: %s" % (ResidualGraphInformer.VertexInfo(self,v), self.pot[v])


#### Internal initialisation #################################

RA.SetAllVerticesColor("grey")

A.RegisterGraphInformer(FlowGraphInformer(G,flow))
RA.RegisterGraphInformer(PotentialResidualGraphInformer(R,flow,pot))

