################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox)
#       version 1.0 from 2/25/10. You can find more information at
#       http://algorithmics.molgen.mpg.de/CATBox/
#
#	file:   CostScaling.pro
#	author: Torsten Pattberg (pattberg@zpr.uni-koeln.de)
#               Alexander Schliep (alexander@schliep.org)
#
#       Copyright (C) 1998-2010, Winfried Hochstaettler und Alexander Schliep
#	and (c) 2010 Springer Verlag.
#       
#       All rights reserved. Do not distribute. 
#	See http://schliep.org/CATBox for more information.
#




#
#       This file is version $Revision: 1.5 $ 
#                       from $Date: 2004/02/06 14:30:39 $
#             last change by $Author: wh $.
#
#
################################################################################

#### Options #################################################

breakpoints = [15,24]
interactive = []
graphDisplays = 2
about = """<HTML>
<HEAD>
<TITLE>Minimum Cost Flows - Cost Scaling</TITLE>
</HEAD>
<BODY>


</BODY></HTML>
"""
self.NeededProperties({'EdgeWeights':2, 'VertexWeights':1})

from math import log, ceil, floor
import copy

oldactive = 0
eps = 0


class AdmissibleEdgeWrapper(ReducedCostsWrapper):

    def __setitem__(self, e, val):
        self.cost[e] = val
        rc = self.cost[e] - self.pot[e[0]] + self.pot[e[1]]
	try:
            if rc < 0:
                self.A.SetEdgeColor(e[0],e[1],"red")
            else:
                self.A.SetEdgeColor(e[0],e[1],"grey")
        except:
            None



R  = copy.deepcopy(G)

self.OpenSecondaryGraph(R, stripPath(self.graphFileName) + " (admissible network)")

RA = self.GUI.secondaryGraphDisplay
G.CalculateWidthFromWeight(0.7)

A.ShowGraph(G, stripPath(self.graphFileName))



class MyFlowWrapper(FlowWrapper):

    def __setitem__(self, e, val):
        FlowWrapper.__setitem__(self,e,val)
        cost[e] = cost[e]             ## update the coloring
        cost[(e[1],e[0])] = -cost[e]

class MyResidualGraphInformer(ResidualGraphInformer):

    def EdgeInfo(self,v,w):
        return "Edge (%d,%d) - residual capacity: %d - cost: %d - reduced cost: %d" % (v, w, self.res[(v,w)],cost[(v,w)],ReducedCosts((v,w)))

    def DefaultInfo(self):
        global eps
        return "eps = %d"%eps


pot    = VisibleVertexLabeling(RA)
cost   = AdmissibleEdgeWrapper(RA,G.edgeWeights[1],pot)
flow   = MyFlowWrapper(G,A,R,RA,G.edgeWeights[0],R.edgeWeights[0],G.vertexWeights[0])

cap          = lambda e: flow.cap[e]
excess       = lambda v: flow.excess[v]
res          = lambda e: flow.res[e]
ForwardEdge  = lambda u,v,g=G: g.QEdge(u,v)
Edges        = lambda g=G: g.Edges()
Neighborhood = lambda v, r=R: r.Neighborhood(v)

def ActiveVertex():
    global oldactive

    for v in G.vertices:
        if excess(v) > 0:
            if v != oldactive:
                try:
                    RA.SetVertexFrameWidth(oldactive,2)
                except:
                    None
                oldactive = v

	    RA.SetVertexFrameWidth(v,6)
            return v

    return None


def max_edge_cost():

    max = -gInfinity

    for e in G.Edges():

        if max < abs(cost[e]):
            max = abs(cost[e])

    return max


def Lower(v,d):
    
    RA.BlinkVertex(v,"blue")
    pot[v] = pot[v] - d

    for u in R.OutNeighbors(v):
        cost[(v,u)]=-cost[(u,v)]
    for u in R.InNeighbors(v):
        cost[(u,v)]=-cost[(v,u)]

    return None

def RecalculateCosts():         # for integer eps
    C = max_edge_cost()
    for (v,w) in G.Edges():
        cost[(v,w)] = cost[(v,w)]*(G.Order()+1)
        cost[(w,v)] = -cost[(v,w)]
    return int (2**ceil( log(G.Order()*C+1)/log(2) ))


def Min(a,b):

    m = a
    if b < a:
        m = b

    RA.graphInformer.SetDefaultInfo("delta = %d"%m)
    RA.UpdateInfo("delta = %d"%m)
    return m



A.SetAllVerticesColor("gray")
RA.SetAllVerticesColor("gray")

for u in G.vertices:
    pot[u] = 0
    if excess(u) > 0:
        A.SetVertexColor(u,"green")
        A.SetVertexAnnotation(u,excess(u),"green")
    elif excess(u) < 0:
        A.SetVertexColor(u,"red")
        A.SetVertexAnnotation(u,excess(u),"red")

for e in G.Edges():
    cost[e[1],e[0]] = -cost[e]

A.RegisterGraphInformer(FlowGraphInformer(G,flow))
RA.RegisterGraphInformer(MyResidualGraphInformer(R,flow))








