################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox)
#       version 1.0 from 2/25/10. You can find more information at
#       http://algorithmics.molgen.mpg.de/CATBox/
#
#	file:   SuccessiveShortestPaths.pro
#	author: Torsten Pattberg (pattberg@zpr.uni-koeln.de)
#               Alexander Schliep (alexander@schliep.org)
#
#       Copyright (C) 1998-2010, Winfried Hochstaettler und Alexander Schliep
#	and (c) 2010 Springer Verlag.
#       
#       All rights reserved. Do not distribute. 
#	See http://schliep.org/CATBox for more information.
#




#
#       This file is version $Revision: 1.12 $ 
#                       from $Date: 2004/03/19 13:30:32 $
#             last change by $Author: schliep $.
#
#
################################################################################

#### Options #################################################

breakpoints = [21,27]
interactive = []
graphDisplays = 2
about = """<HTML>
<HEAD>
<TITLE>Minimum Cost Flows - Successive Shortest Paths</TITLE>
</HEAD>
<BODY>


</BODY></HTML>
"""

self.NeededProperties({'EdgeWeights':2, 'VertexWeights':1})

def ReducedCosts((u,v)):
    return cost[(u,v)] + pot[u] - pot[v]

#### Wrapper #################################################

class MyFlowWrapper(FlowWrapper):
    """ Update the ReducedCosts coloring after each action
    """
    def __setitem__(self, e, val):
        FlowWrapper.__setitem__(self,e,val)
        cost[e] = cost[e]             
        cost[(e[1],e[0])] = -cost[e]

#### GraphInformer ###########################################

class MyResidualGraphInformer(ResidualGraphInformer):
    """ Also show the reduced costs
    """
    def EdgeInfo(self,v,w):
        return "Edge (%d,%d) - residual capacity: %d - cost: %d - reduced cost: %d" % (v, w, self.res[(v,w)],cost[(v,w)],ReducedCosts((v,w)))

#### Graph management ########################################

import copy
R  = copy.deepcopy(G)
self.OpenSecondaryGraph(R, stripPath(self.graphFileName) + " (residual network)")
RA = self.GUI.secondaryGraphDisplay
G.CalculateWidthFromWeight(0.7)
A.ShowGraph(G, stripPath(self.graphFileName))

#### Variables ###############################################

pot  = VisibleVertexLabeling(RA)
cost = ReducedCostsWrapper(RA,G.edgeWeights[1],pot)
flow = MyFlowWrapper(G,A,R,RA,G.edgeWeights[0],R.edgeWeights[0],G.vertexWeights[0])
pred = {}
dist = {}

#### Lambdas #################################################

Neighborhood     = lambda u,r=R: r.Neighborhood(u)
Order            = lambda g=G: g.Order()
ShortestPathDist = lambda r=R: DetermineShortestPathDistances_(r)
cap              = lambda e: flow.cap[e]
excess           = lambda v: flow.excess[v]
res              = lambda e: flow.res[e]
ForwardEdge      = lambda u,v,g=G: g.QEdge(u,v)

#### Datastructures ##########################################

S = AnimatedVertexStack(RA,"green")
D = AnimatedVertexStack(RA,"red")

#### Functions ###############################################

def LiftVertices(dist):
    for v in R.vertices:
	if dist[v] != gInfinity:
            pot[v] = pot[v] + dist[v]
    for (u,v) in R.Edges():
   	if ReducedCosts((u,v)) > 0:
           #pot[u] = pot[u] -
           ReducedCosts((u,v))
        cost[(u,v)]=cost[(u,v)] #recoloring
    return


def IncreaseFlow(P,delta): 
    for e in P.Edges():
        if ForwardEdge(e[0],e[1]):
            flow[(e[0],e[1])] = flow[(e[0],e[1])] + delta
        else:
            flow[(e[1],e[0])] = flow[(e[1],e[0])] - delta
    return


def min(a,b,c):
    m = a
    if b < m:
        m = b
    if c < m:
        m = c
    RA.graphInformer.SetDefaultInfo("delta = %d"%m)
    RA.UpdateInfo("delta = %d"%m)
    return m


def FindShortestPath(w):
    P = AnimatedSubGraph(R,RA,"blue")
    while not (w == pred[w]):
        P.AddEdge(pred[w],w)
        w = pred[w]
    return (w,P)


def MinResCap(Graph):
    min = gInfinity
    e = None
    for i in Graph.Edges():
        if res(i) < min:
            min = res(i)
	    e = i
    RA.SetEdgeColor(e[0],e[1],"yellow")
    return min

def DetermineShortestPathDistances_(R):
    NOW  = Queue()
    NEXT = Queue()
    for u in R.vertices:
        if excess(u) > 0:
        	NOW.Append(u)
	        dist[u] = 0
		pred[u] = u
        else:
        	dist[u] = gInfinity
        	pred[u] = None
    counter = 0

    while 1:
        if NOW.IsEmpty():
            if NEXT.IsEmpty():
                return True
            else:
                counter = counter + 1
                if counter > Order():
                    print "ERROR"
                    return False
                while NEXT.IsNotEmpty():
                    u = NEXT.Top()
                    NOW.Append(u)
        else:
            u = NOW.Top()
	    for v in R.OutNeighbors(u):
	        if (dist[v] > dist[u] + ReducedCosts((u,v))):
                    dist[v] = dist[u] + ReducedCosts((u,v))
                    pred[v] = u
                    if not (NOW.Contains(v) or NEXT.Contains(v)):
                        NEXT.Append(v)



#### Initialisation ##########################################

A.SetAllVerticesColor("grey")
RA.SetAllVerticesColor("grey")

for u in G.vertices:
    dist[u] = gInfinity
    pred[u] = None
    pot[u]  = 0
    if excess(u) > 0:
        A.SetVertexColor(u,"green")
        A.SetVertexAnnotation(u,excess(u),"green")
    elif excess(u) < 0:
        A.SetVertexColor(u,"red")
        A.SetVertexAnnotation(u,excess(u),"red")

for e in G.Edges():
    cost[e] = cost[e] # recoloring
    cost[e[1],e[0]] = -cost[e]

A.RegisterGraphInformer(FlowGraphInformer(G,flow))
RA.RegisterGraphInformer(MyResidualGraphInformer(R,flow))


