################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox)
#       version 1.0 from 2/25/10. You can find more information at
#       http://algorithmics.molgen.mpg.de/CATBox/
#
#	file:   Bipartite.pro
#	author: Torsten Pattberg (pattberg@zpr.uni-koeln.de)
#               Alexander Schliep (alexander@schliep.org)
#
#       Copyright (C) 1998-2010, Winfried Hochstaettler und Alexander Schliep
#	and (c) 2010 Springer Verlag.
#       
#       All rights reserved. Do not distribute. 
#	See http://schliep.org/CATBox for more information.
#




##
#
################################################################################

#### Options #################################################

breakpoints = [62]
interactive = []
graphDisplays = 1
about = """<HTML>
<HEAD>
<TITLE>Matching - Bipartite</TITLE>
</HEAD>
<BODY>

This algorithm finds a maximum matching in a bipartite graph with partition
V (red) and W (green). To proove the result it will show a minimum edge cover
that has (in bipartite graphs) the same cardinality as the maximum matching.

</BODY></HTML>
"""

#### Wrapper #################################################

class MatchingGraphInformer(GraphInformer):

    def EdgeInfo(self,tail,head):
        if (tail,head) in M.Edges():
            return "Edge (%d,%d) is a matching edge"%(tail, head)
        else:
            return "Edge (%d,%d) is not a matching edge"%(tail, head)

    def VertexInfo(self,v):
        if v in V.vertices:
            set = "V"
        else:
            set = "W"

        if pred[v] == v:
            info = " is exposed"
        elif pred[v] != None:
            info = " has predecessor %s"%pred[v]
        else:
            info = " has no predecessor"

        return "Vertex %d in %s %s"%(v, set, info)

#### Graph management ########################################

M = AnimatedSubGraph(G, A, "blue")
V = AnimatedSubGraph(G, A, "#99ff99")
W = AnimatedSubGraph(G, A, "#ff9999")
Q = AnimatedVertexQueue(A, "#00cc00", "#00cc00")

class MyAnimatedPredecessor(AnimatedPredecessor):

    def __setitem__(self, v, val):
	try:
	    oldVal = VertexLabeling.__getitem__(self, v)
	    if oldVal != None:
                if self.leaveColors == None or not (self.Animator.GetEdgeColor(oldVal,v) in self.leaveColors):
                    self.Animator.SetEdgeColor(oldVal,v,"grey")
	except:
	    pass

	if val != None:
	    try:
                if v in V.vertices:
                    self.Animator.SetVertexColor(v,"#00cc00")
                    self.Animator.SetEdgeColor(val,v,"blue")
                else:
                    self.Animator.SetVertexColor(v,"red")
                    self.Animator.SetEdgeColor(val,v,"#ccccff")
            except:
                pass
        else:
            if v in V.vertices:
                self.Animator.SetVertexColor(v,"#99ff99")
            else:
                self.Animator.SetVertexColor(v,"#ff9999")

        VertexLabeling.__setitem__(self, v, val)


#### Variables ###############################################

dist = {}
pred = MyAnimatedPredecessor(A,["blue"])

#### Internal functions ######################################


def DeleteLabels():
    Q.Clear()
    for v in G.vertices:
        pred[v] = None
    A.SetAllEdgesColor("black", None, ["blue"])


highlightID = None

def ShowPath(P):
    global highlightID
    if highlightID:
        A.HidePath(highlightID)
        highlightID = None
    if P:
        # Fix orientations of edges
        if len(P) > 1:
            for i, e in enumerate(P[:-1]):
                if e[0] in P[i+1]: # (u,v),(v,w)
                    P[i] = e[1], e[0]
            if P[-1][1] in P[-2]:
                P[-1] = (P[-1][1], P[-1][0])
        V = [P[0][0]] + [v for u,v in P]
        #print P, V
        highlightID = A.HighlightPath(V, 'yellow')
    return P

def HidePath(P):
    global highlightID
    if highlightID:
        A.HidePath(highlightID)
        highlightID = None
    return P

FindPartition = lambda g=G, a=A: _FindPartition(g,a)

def _FindPartition(G,A):

    Q = Queue()

    for v in G.vertices:

        if dist[v] == None:
            dist[v] = 0
            Q.Append(v)
            V.AddVertex(v)

            while Q.IsNotEmpty():
                v = Q.Top()

                for w in G.Neighborhood(v):

                    if dist[w] == None:
                        dist[w] = dist[v] + 1
                        Q.Append(w)

                        if dist[w] % 2 == 1:
                            W.AddVertex(w)
                        else:
                            V.AddVertex(w)

    return (V, W)


ShowVertexCover = lambda v,w,a=A: _ShowVertexCover(v,w,a)

def _ShowVertexCover(V,W,A):

    for v in V.vertices:
        if not pred[v]:
            A.SetVertexFrameWidth(v,6)
        else:
            A.SetVertexFrameWidth(v,2)
    for v in W.vertices:
        if pred[v]:
            A.SetVertexFrameWidth(v,6)
        else:
            A.SetVertexFrameWidth(v,2)

#### Lambdas #################################################

Neighborhood    = lambda v, g=G, a=A: AnimatedNeighborhood(a,g,v,["blue"])
MatchingPartner = lambda v: M.Neighborhood(v)[0]

#### Internal initialisation #################################

for v in G.vertices:
    dist[v] = None
    pred[v] = None

A.RegisterGraphInformer(MatchingGraphInformer(G))
