################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox) 
#       version 1.0 from 2/25/10. You can find more information at 
#       http://algorithmics.molgen.mpg.de/CATBox/
#
#	file:   BFS-Components.py
#	author: Alexander Schliep (alexander@schliep.org)
#
#       Copyright (C) 1998-2010, Winfried Hochstaettler und Alexander Schliep
#	and (c) 2010 Springer Verlag.
#       
#       All rights reserved. Do not distribute. 
#	See http://schliep.org/CATBox for more information.
#




#
#       This file is version $Revision: 1.2 $
#                       from $Date: 2003/06/03 20:10:45 $
#             last change by $Author: schliep $.
#
#
################################################################################

# Options ----------------------------------------------------------------------
breakpoints = []
interactive = []
graphDisplays = 1
about = """<HTML>
<HEAD>
<TITLE>Connected Components with Breadth-First-Search </TITLE>
</HEAD>
<BODY>

This algorithm finds connected components in a graph by performing one
breadth-first-search per component.  It visualises the predecessor
tree being built and the BFS vertex labels.  See Chapter 2 in the
CATBox book.

<H3>Visualization</H3>

<H5>Vertex Colors</H5>
<dl>
<dt><colordef color="#EEEEEE"></dt> <dd>Initial color for vertices that
have neither been <em>visited</em> nor <em>processed</em>.</dd>

<dt><colordef color="blue"></dt> <dd>Vertices which have been
<em>visited</em> as a neighbor while <em>processing</em> the
<em>active</em> vertex.</dd>

<dt><colordef color="red"></dt> <dd>First component only: Vertices of this color have been <em>processed</em>; i.e., their neighbors have been explored.
Processed vertices will get different colors in other components.
</dd>

<dt><colordef color="black"></dt> <dd>The vertex being <em>processed</em> is
displayed with a wide outline in this color.</dd>

</dl>


<H5>Edge Colors</H5>
<dl>
<dt><colordef color="#EEEEEE"></dt> <dd>Initial color for edges. Edges
of this color have not been <em>traversed</em> yet.</dd>

<dt><colordef color="yellow"></dt> <dd>Color of the edge being <em>traversed</em>.</dd>

<dt><colordef color="red"></dt> <dd>First component only: Traversed
edges displayed in the color are part of the BFS tree. A different
color will be used in other components</dd>

<dt><colordef color="grey"></dt> <dd>Color of edges traversed which
are not part of the DFS tree.</dd>


</dl>

<H5>Further elements</H5> <dl> <dt><colordef color="black"></dt>
<dd>The BFS label assigned to visited vertices is displayed in this color.</dd> </dl>



</BODY></HTML>
"""
#--------------------------------------------------------------------------------
class BlinkVisibleVertexLabeling(VisibleVertexLabeling):
    def __getitem__(self,v):
        self.A.BlinkVertex(v)
        return VisibleVertexLabeling.__getitem__(self,v)

label = BlinkVisibleVertexLabeling(A)
pred = AnimatedPredecessor(A)
component = {}
Q = AnimatedVertexQueue(A,"blue","red")
def NewComponent(cm=ComponentMaker(G,A,['blue','#0000FF'])):
    result = cm.NewComponent()
    Q.ColorOff=cm.LastComponentColor()
    pred.predColor = cm.LastComponentColor()
    return result

ComponentColors = lambda cm = ComponentMaker(G,A): cm.colors
Neighborhood = lambda v,a=A,g=G: AnimatedNeighborhood(a,g,v,ComponentColors())
Vertices = G.Vertices()

class MyGraphInformer(GraphInformer):

    def __init__(self, G):
	GraphInformer.__init__(self, G)
        self.label = label

    def VertexInfo(self,v):
	if label[v]:
	    return "Vertex %d - label %d" % (v, label[v])
	elif v in Q.contents:
            return "Vertex %d - Queue position %d"%(v, Q.contents.index(v) + 1)
	else:
            return "Vertex %d - not visited yet" % v
        return

A.SetAllVerticesColor("#EEEEEE")
for v in G.Vertices():
    label[v] = None
    component[v] = None
    pred[v] = None

A.RegisterGraphInformer(MyGraphInformer(G))
