################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox) 
#       version 1.0 from 2/25/10. You can find more information at 
#       http://algorithmics.molgen.mpg.de/CATBox/
#
#	file:   DFS-Traversal.py
#	author: Torsten Pattberg (pattberg@zpr.uni-koeln.de)
#               Alexander Schliep (alexander@schliep.org)
#
#       Copyright (C) 1998-2010, Winfried Hochstaettler und Alexander Schliep
#	and (c) 2010 Springer Verlag.
#       
#       All rights reserved. Do not distribute. 
#	See http://schliep.org/CATBox for more information.
#




#
#       This file is version $Revision: 1.1 $ 
#                       from $Date: 2004/02/06 16:45:35 $
#             last change by $Author: schliep $.
#
#
################################################################################

# Options ----------------------------------------------------------------------
breakpoints = [13]
interactive = [12]
graphDisplays = 1
about = """<HTML>
<HEAD>
<TITLE>Recursive Depth-First-Search Traversal</TITLE>
</HEAD>
<BODY>

<H1>Depth-First-Search (DFS) Traversal</H1>

This algorithm traverses a graph in depth-first order and visualizes
the predecessor tree being built and the DFS vertex labels. See
Chapter 2 in the CATBox book. Recursive implementation.

<H3>Visualization</H3>

<H5>Vertex Colors</H5>
<dl>
<dt><colordef color="#EEEEEE"></dt> <dd>Initial color for vertices that
have neither been <em>visited</em> nor <em>processed</em>.</dd>

<dt><colordef color="red"></dt> <dd>Vertices of this color have been <em>processed</em>; i.e.,
their neighbors have been explored.</dd>

<dt><colordef color="black"></dt> <dd>The vertices being <em>processed</em> are
displayed with a wide outline in this color. Note that multiple vertices
are processed simultaneously.</dd>

</dl>


<H5>Edge Colors</H5>
<dl>
<dt><colordef color="#EEEEEE"></dt> <dd>Initial color for edges. Edges
of this color have not been <em>traversed</em> yet.</dd>

<dt><colordef color="yellow"></dt> <dd>Color of the edge being <em>traversed</em>.</dd>

<dt><colordef color="red"></dt> <dd>Traversed edges displayed in the color are
part of the BFS tree.</dd>

<dt><colordef color="grey"></dt> <dd>Color of edges traversed
which are not part of the BFS tree.</dd>


</dl>

<H5>Further elements</H5>

<dl>

<dt><colordef color="black"></dt> <dd>The DFS label assigned to
visited vertices is displayed in this color.</dd>

</dl>

</BODY></HTML>
"""
#--------------------------------------------------------------------------------

PickVertex   = lambda : self.PickVertex(1,None)
Neighborhood = lambda v,a=A,g=G: AnimatedNeighborhood(a,g,v,["red"],"white")

class VisibleAnimatedVertexLabeling(VisibleVertexLabeling,AnimatedVertexLabeling):
    def __init__(self, theAnimator, initial=0, color="blue"):
        VisibleVertexLabeling.__init__(self, theAnimator)
        AnimatedVertexLabeling.__init__(self, theAnimator, initial, color)

    def __setitem__(self, v, val):
        VisibleVertexLabeling.__setitem__(self, v, val) 
        AnimatedVertexLabeling.__setitem__(self, v, val) 
        
label = VisibleAnimatedVertexLabeling(A,0,'red')
pred  = AnimatedPredecessor(A)

A.SetAllVerticesColor("#EEEEEE")

for v in G.vertices:
    label[v] = None
