################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox) 
#       version 1.0 from 2/25/10. You can find more information at 
#       http://algorithmics.molgen.mpg.de/CATBox/
#
#	file:   Kruskal.pro
#	author: Torsten Pattberg (pattberg@zpr.uni-koeln.de)
#               Alexander Schliep (alexander@schliep.org)
#
#       Copyright (C) 1998-2010, Winfried Hochstaettler und Alexander Schliep
#	and (c) 2010 Springer Verlag.
#       
#       All rights reserved. Do not distribute. 
#	See http://schliep.org/CATBox for more information.
#




#
#       This file is version $Revision: 1.9 $ 
#                       from $Date: 2004/02/06 17:01:25 $
#             last change by $Author: schliep $.
#
#
################################################################################

#### Options #################################################

breakpoints = [4]
interactive = []
graphDisplays = 1
about = """<HTML>
<HEAD>
<TITLE>Minimal Spanning Tree - Kruskal Trace</TITLE>
</HEAD>
<BODY>
<H1>Minimal Spanning Tree - Kruskal Trace</H1>

This algorithm computes a minimal spanning tree in an undirected graph.

<H3>Visualization</H3>

<H5>Vertex Colors</H5>
<dl>
<dt><colordef color="red"><colordef color="green"><colordef color="blue">...</dt> <dd>Vertex (and edge) colors designate the connected
components in the subgraph induced by the trees during the
computation. Therefore, each vertex has its own colors initially.</dd>
</dl>


<H5>Edge Colors</H5>
<dl>
<dt><colordef color="#EEEEEE"></dt> <dd>Initial color for edges. Edges
of this color have not been considered for inclusion in the MST yet.</dd>

<dt><colordef color="yellow"></dt> <dd>Color of the edge being
considered. (transient)</dd>

<dt><colordef color="grey"></dt> <dd>Color of edges which are not part
of the MST.</dd>

<dt><colordef color="red"><colordef color="green"><colordef
color="blue">...</dt> <dd>Edges which are part of the MST..</dd>


</dl>

</BODY></HTML>
"""

#### Misc ####################################################

True  = 1
False = 0

#### Wrapper #################################################

class MySubGraph(SubGraph):

    def AddEdge(self,(u,v)):

        SubGraph.AddEdge(self,u,v)

	C = component[u]
	D = component[v]

	if Order(C) < Order(D):
	    MergeComponents(C,D)    
	    for w in Vertices(C):
	        component[w] = D
	else:
	    MergeComponents(D,C)
	    for w in Vertices(D):
	        component[w] = C

	component[u].AddEdge((u,v))

        return
  
    def CreatingCircuit(self, (u,v)):

	if (component[u] == component[v]):
            A.SetEdgeColor(u,v,"grey")
            return True
        else:
            A.SetEdgeColor(u,v,"green")
            return False
	
#### Variables ###############################################

weight          = G.edgeWeights[0]
component       = {}
Edges           = G.Edges()

#### Graph management ########################################

T = MySubGraph(G)

#### Lambdas #################################################

MergeComponents = lambda src, dest: dest.AddSubGraph(src)
NewComponent    = lambda cm = ComponentMaker(G,A): cm.NewComponent()
Order           = lambda D: D.Order()
CreatingCircuit   = lambda e, t=T: t.CreatingCircuit(e)
AddEdge         = lambda e, t=T: t.AddEdge(e)

#### Graphinformer ###########################################

class MyMSTGraphInformer(GraphInformer):

    def EdgeInfo(self,tail,head):
        w = self.G.edgeWeights[0][(tail, head)]

        if A.GetEdgeColor(tail,head) == component[tail].Color:

    	    if self.G.edgeWeights[0].QInteger():
	        return "Weight of edge (%d,%d): %d - Weight of component: %d" % (tail, head, w, component[tail].Weight()) 
	    else:
	        return "Weight of edge (%d,%d): %f - Weight of component: %f" % (tail, head, w, component[tail].Weight()) 

        else:

    	    if self.G.edgeWeights[0].QInteger():
	        return "Weight of edge (%d,%d): %d" % (tail, head, w) 
	    else:
	        return "Weight of edge (%d,%d): %f" % (tail, head, w) 

    def DefaultInfo(self):
        if Order(component[1]) == Order(G):
            if self.G.edgeWeights[0].QInteger():
	        return "Weight of minimal spanning tree: %d" %component[1].Weight() 
	    else:
	        return "Weight of minimal spanning tree: %f" %component[1].Weight() 
        else:
            max = -gInfinity
            comp = None
            for v in G.vertices:
                if component[v]:
                    if max < component[v].Weight():
                        max  = component[v].Weight()
                        comp = component[v]
           
            text=comp.vertices

            if comp.Order()>4:
                text="[%s, %s, %s, ...]"%(text[0],text[1],text[2])

            if self.G.edgeWeights[0].QInteger():
	        return "Component %s has maximal weight: %d" %(text,max) 
	    else:
	        return "Component %s has maximal weight: %f" %(text,max) 

#### Internal functions ######################################

def byWeight(x,y):
    if weight[x]==weight[y]:
        return 0
    elif weight[x]>weight[y]:
        return 1
    else:
        return -1

def Sort(E,b):
    E.sort(b)
    return ContainerWrapper(A,E,"yellow")

#### Internal initialisation #################################

for v in G.vertices:
    component[v] = NewComponent()
    component[v].AddVertex(v)

A.RegisterGraphInformer(MyMSTGraphInformer(G))



















