################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox) 
#       version 1.0 from 2/25/10. You can find more information at 
#       http://algorithmics.molgen.mpg.de/CATBox/
#
#	file:   Prim.pro
#	author: Torsten Pattberg (pattberg@zpr.uni-koeln.de)
#               Alexander Schliep (alexander@schliep.org)
#
#       Copyright (C) 1998-2010, Winfried Hochstaettler und Alexander Schliep
#	and (c) 2010 Springer Verlag.
#       
#       All rights reserved. Do not distribute. 
#	See http://schliep.org/CATBox for more information.
#




#
#       This file is version $Revision: 1.10 $ 
#                       from $Date: 2000/10/26 08:40:21 $
#             last change by $Author: pattberg $.
#
#
################################################################################

#### Options #################################################

breakpoints = [7]
interactive = [1]
graphDisplays = 1
about = """<HTML>
<HEAD>
<TITLE>Minimal Spanning Tree - Prim</TITLE>
</HEAD>
<BODY>

<H1>Minimal Spanning Tree - Prim</H1>

This algorithm finds a minimal spanning tree in a connected and
undirected graph.

<H3>Visualization</H3>

<H5>Vertex Colors</H5>
<dl>

<dt><colordef color="#EEEEEE"></dt> <dd>Initial color for
vertices.</dd>

<dt><colordef color="blue"></dt> <dd>Vertices for which
the incident edge is in F and no incident edge is in
T.</dd>

<dt><colordef color="red"></dt> <dd>Vertices which
have at least one incident edge in T.</dd>

<dt><colordef color="black"></dt> <dd>A wide outline
in this colors designates the vertex which neighborhood
the algorithm currently explores.</dd>

</dl>


<H5>Edge Colors</H5>

<dl>

<dt><colordef color="#EEEEEE"></dt> <dd>Initial color for edges.</dd>

<dt><colordef color="yellow"></dt> <dd>Color of the edge being
considered for inclusion in F (transient).</dd>

<dt><colordef color="green"></dt> <dd>The minimum weight
edge in F (transient).</dd>

<dt><colordef color="black"></dt> <dd>An edge removed from
F (transient).</dd>

<dt><colordef color="red"></dt> <dd>Edges which are part of the
MST.</dd>

<dt><colordef color="grey"></dt> <dd>Edges which are not part of the MST.</dd>


</dl>

</BODY></HTML>
"""

self.NeededProperties({'EdgeWeights':1,'Undirected':1})

#### Misc ####################################################


class MyMSTGraphInformer(MSTGraphInformer):
## Gibt zusaetlich auch den Vorgaenger eines Knotens an
    def VertexInfo(self,v):
	if pred[v]:
            return "Vertex %d at position (%d,%d) has predecessor %d" % (v, 
                                                  self.G.embedding[v].x, 
                                                  self.G.embedding[v].y,
                                                  pred[v])
	else:
            return "Vertex %d at position (%d,%d)" % (v, 
                                                  self.G.embedding[v].x, 
                                                  self.G.embedding[v].y)

class MyAnimatedSubGraph(AnimatedSubGraph):

    def MinimumEdge(self,weight):
        E = []
	for u in self.vertices:
	    for v in self.adjLists[u]:
                E.append((u,v))
	(u,v) = ArgMin(E,weight)
        self.Animator.SetEdgeColor(u,v,"green")
        if pred[v] == u:
     	    return (u,v)
        else:
 	    return (v,u)

    def Contains(self,v):
        return v in self.vertices

    def DeleteEdge(self,edge):
	try:
            AnimatedSubGraph.DeleteEdge(self,edge)
        except:
            None
	try:
            AnimatedSubGraph.DeleteEdge(self,(edge[1],edge[0]))
        except:
            None

    def IsSpanning(self):
        return len(self.vertices) >= G.Order()

#### Variables ###############################################

weight         = G.edgeWeights[0]
pred           = {}

#### Graph management ########################################

T = MyAnimatedSubGraph(G,A,"red")
F = MyAnimatedSubGraph(G,A,"blue")

#### Lambdas #################################################

Neighborhood   = lambda v, a=A, g=G: AnimatedNeighborhood(a,g,v,["red","blue"])
pickCallback   = lambda v, a=A: A.SetVertexAnnotation(v,"s")
PickVertex     = lambda f=pickCallback: self.PickVertex(1,None,f)

#### Internal functions ######################################

#### Internal initialisation #################################

for v in G.vertices:
    pred[v] = v
    weight[(v,v)] = gInfinity

A.SetAllVerticesColor("#EEEEEE")    
A.RegisterGraphInformer(MyMSTGraphInformer(G,T))
