################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox) 
#       version  1.0 from 2/25/10. You can find more information at 
#       http://algorithmics.molgen.mpg.de/CATBox/
#
#	file:   FindPath.pro
#	author: Alexander Schliep (schliep@zpr.uni-koeln.de)
#
#       Copyright (C) 1998-2010, Winfried Hochstaettler und Alexander Schliep
#	and (c) 2010 Springer Verlag.
#       
#       All rights reserved. Do not distribute. 
#	See http://schliep.org/CATBox for more information.
#




#       
#       All rights reserved. Do not distribute
#	
#
#       This file is version $Revision: 1.5 $ 
#                       from $Date: 2004/02/11 18:36:50 $
#             last change by $Author: schliep $.
#
#
################################################################################

#### Options #################################################

breakpoints = [9]
interactive = [1,2]
graphDisplays = 1
about = """<HTML>
<HEAD>
<TITLE>Shortest Path - Find Path</TITLE>
</HEAD>
<BODY>

This algorithm, a variation of Dijkstra's algorithm, finds a shortest path from 
the source to the sink in a graph.

</BODY></HTML>
"""
root = None

class MyGraphInformer(WeightedGraphInformer):
    def VertexInfo(self,v):
	if v == root:
            return "Vertex %d is root of tree" % v
	elif dist[v] == gInfinity:
            return "Vertex %d is not in tree" % v
	elif self.G.edgeWeights[0].QInteger():
            return "Vertex %d has predecessor %d and distance %d" % (v,pred[v],dist[v])
	else:
            return "Vertex %d has predecessor %d and distance %f" % (v,pred[v],dist[v])


def pickCallback(A,v,type):
    if type == "s":
        A.SetVertexAnnotation(v,type,"green")
    else:
        A.SetVertexAnnotation(v,type,"red")
    return

def pickCallbackSource(v):
    pickCallback(A, v, "s")
    global root
    root = v

PickSource         = lambda f=pickCallbackSource: self.PickVertex(1,None,f)
pickCallbackSink   = lambda v, type="t", a=A: pickCallback(a,v,type)
PickSink           = lambda f=pickCallbackSink: self.PickVertex(G.Order(),None,f)
#ShowPath           = lambda u,v: showPathByPredecessorArray(u,v,pred,A,"yellow")
Neighborhood       = lambda v,a=A,g=G: AnimatedNeighborhood(a,g,v,["red"])

def ShowPath(u,v):
    w = v
    path = []
    while w is not None:
        path.append(w)
        w = pred[w]
    id = A.HighlightPath(path, "yellow")
    #print id


length       = G.edgeWeights[0]
pred         = AnimatedPredecessor(A)
PQ           = AnimatedVertexPriorityQueue(A)
dist         = VertexLabeling()

for v in G.vertices:
    pred[v] = None
    dist[v] = gInfinity

A.RegisterGraphInformer(MyGraphInformer(G,"length"))
