################################################################################
#
#       This is part of CATBox (Combinatorial Algorithm Toolbox) 
#       version 1.0 from 2/25/10. You can find more information at
#       http://algorithmics.molgen.mpg.de/CATBox/
#
#	file:   TwoSources.pro
#	author: Torsten Pattberg (pattberg@zpr.uni-koeln.de)
#               Alexander Schliep (alexander@schliep.org)
#
#       Copyright (C) 1998-2010, Winfried Hochstaettler und Alexander Schliep
#	and (c) 2010 Springer Verlag.
#       
#       All rights reserved. Do not distribute. 
#	See http://schliep.org/CATBox for more information.
#




#
#       This file is version $Revision: 1.7 $ 
#                       from $Date: 2001/05/10 10:36:13 $
#             last change by $Author: pattberg $.
#
#
################################################################################

#### Options #################################################

breakpoints = [15]
interactive = [2,3]
graphDisplays = 1
about = """<HTML>
<HEAD>
<TITLE>Shortest Path - Two Sources</TITLE>
</HEAD>
<BODY>

This algorithm finds a shortest path (cardinality of edges)
from the source to the sink in a graph. 

</BODY></HTML>
"""
found = 0

#### Variables ###############################################

def pickCallback(A,v,type):
    if type == "s":
        A.SetVertexAnnotation(v,type,"green")
    else:
        A.SetVertexAnnotation(v,type,"red")
    return

Neighborhood       = lambda v,a=A,g=G: AnimatedNeighborhood(a,g,v,["red"])
pickCallbackSource = lambda v, type="s", a=A: pickCallback(a,v,type)
PickSource         = lambda f=pickCallbackSource: self.PickVertex(1,None,f)
pickCallbackSink   = lambda v, type="t", a=A: pickCallback(a,v,type)
PickSink           = lambda f=pickCallbackSink: self.PickVertex(G.Order(),None,f)
ShowPath           = lambda u,v: showPathByPredecessorArray(u,v,pred,A,"yellow")

T1 = AnimatedSubGraph(G,A,"red")
T2 = AnimatedSubGraph(G,A,"red")
Q1 = AnimatedVertexQueue(A, "blue", "red")
F1 = AnimatedVertexQueue(A, "#EE9900", "red")
Q2 = AnimatedVertexQueue(A, "blue", "red")
F2 = AnimatedVertexQueue(A, "#EE9900", "red")

pred  = AnimatedPredecessor(A)
level = VisibleVertexLabeling(A)
 

#### Internal initialisation #################################

A.SetAllVerticesColor("green")

for v in G.vertices:
    pred[v] = None
