%Change in Frequencies at different crack densities
clear all

in = fopen('model2.inp','r'); %input file
out1= fopen('model2.out','w'); %output file

% no of nodes
NN=fscanf(in,'%d',1);
% No. of Elements
NE=fscanf(in,'%d',1);
%no of material properties
NM=fscanf(in,'%d',1);
% Input coordinates
for i= 1:NN
cord(i)=fscanf(in,'%f',1);
end
% Input conectvity
for i= 1:NE
   for j= 1:2
      con(i,j)=fscanf(in,'%d',1); %connectvity
   end
   mat_index(i)=fscanf(in,'%d',1); % material index
   MI(i)=fscanf(in,'%f',1) ; % moment of inertia
   area(i)=fscanf(in,'%f',1); %cross-sectional area 
end
rho=fscanf(in,'%f',1) ; % Mass Density

% material properties
% Effective materials properties at different crack densities

mat1=[41.208,41.086 40.965 40.725 40.488 40.26 40.048 ...
    39.338 39.034 38.896 38.824 ]*1e3 ; 


% Element stiffness matrix



for dd1=1:11
   
for i= 1:NE
le=sqrt((cord(con(i,2))-cord(con(i,1)))^2);
prop=mat1(dd1)*MI(i)/le^3;
ke1= prop*[12,6*le, -12, 6*le ; 6*le, 4*le^2, -6*le, 2*le^2; ...
    -12, -6*le, 12,-6*le; 6*le,2*le^2, -6*le, 4*le^2] ;

for r= 1:4
for t= 1:4
ke(i,r,t)=ke1(r,t);
end
end
end

for r=1:2*NN
for t=1:2*NN
kg(r,t)=0;
end
end

for i= 1:NE
for r= 1:4
for t= 1:4
ke2(r,t)=ke(i,r,t);
end
end

for r=1:2
for t=1:2
kg(2*con(i,r)-1,2*con(i,t)-1)=kg(2*con(i,r)-1,2*con(i,t)-1)+ ...
ke2(2*r-1,2*t-1);
kg(2*con(i,r),2*con(i,t))=kg(2*con(i,r),2*con(i,t))+ke2(2*r,2*t);
kg(2*con(i,r),2*con(i,t)-1)=kg(2*con(i,r),2*con(i,t)-1)+ ke2(2*r,2*t-1);
kg(2*con(i,r)-1,2*con(i,t))=kg(2*con(i,r)-1,2*con(i,t))+ke2(2*r-1,2*t);
end
end 
end


% Calculation of Mass matrix 

for i= 1:NE
le=sqrt((cord(con(i,2))-cord(con(i,1)))^2);
prop1=rho*area(i)*le/420;
me1= prop1*[156,22*le, 54, -13*le ; 22*le, 4*le^2, 13*le, ...
    -3*le^2; 54,13*le,156, -22*le; -13*le,-3*le^2, -22*le, 4*le^2];
for r= 1:4
for t= 1:4
me(i,r,t)=me1(r,t);
end
end
end


for r=1:2*NN
for t=1:2*NN
mg(r,t)=0;
end
end

for i= 1:NE
for r= 1:4
for t= 1:4
me2(r,t)=me(i,r,t);
end
end

for r=1:2
for t=1:2
mg(2*con(i,r)-1,2*con(i,t)-1)=mg(2*con(i,r)-1,2*con(i,t)-1)...
+ me2(2*r-1,2*t-1);
mg(2*con(i,r),2*con(i,t))=mg(2*con(i,r),2*con(i,t))+me2(2*r,2*t);
%%%%%%%%modified new one
mg(2*con(i,r)-1,2*con(i,t))=mg(2*con(i,r)-1,2*con(i,t))+ me2(2*r-1,2*t);
mg(2*con(i,r),2*con(i,t)-1)=mg(2*con(i,r),2*con(i,t)-1)+me2(2*r,2*t-1);
end
end 
end
%Elimination of the fixed boundry condition 
b1=1;
for i= 3:2*NN
b2=1;
for j=3:2*NN
kg1(b1,b2)=kg(i,j);
b2=b2+1;
end
b1=b1+1;
end

%for mass
b1=1;
for i= 3:2*NN
b2=1;
for j=3:2*NN
mg1(b1,b2)=mg(i,j);
b2=b2+1;
end
b1=b1+1;
end
% Frequency calculation
[e_vect,lambda]= eig(kg1,mg1);
frq1=real(sqrt(sort(diag(lambda))));

for nn=1:8
frqdd(dd1,nn)=frq1(nn);   
end

dfrq(dd1)=((frqdd(1,1)-frqdd(dd1,1))/frqdd(1,1))*100

end %dd1

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%555
fprintf(out1,'For first mode frequency \n')
for  mm=1:11
      fprintf(out1,'%f \t',frqdd(mm,1));
   end
   fprintf(out1,'\n');
   

   fprintf(out1,'For Second mode frequency \n')
for  mm=1:11
         fprintf(out1,'%f \t',frqdd(mm,2));
   end
   fprintf(out1,'\n');
    
   fprintf(out1,'For Third mode frequency \n')
for  mm=1:11
      fprintf(out1,'%f \t',frqdd(mm,3));
   end
   fprintf(out1,'\n');

   fprintf(out1,'For Fourth mode frequency \n')
for  mm=1:11
      fprintf(out1,'%f \t',frqdd(mm,4));
   end
   fprintf(out1,'\n');
   
   fprintf(out1,'For Fifth mode frequency \n')
for  mm=1:11
      fprintf(out1,'%f \t',frqdd(mm,5));
   end
   fprintf(out1,'\n');
   
   fprintf(out1,'For Sixth mode frequency \n')
for  mm=1:11
      fprintf(out1,'%f \t',frqdd(mm,6));
   end
   fprintf(out1,'\n');
   
   fprintf(out1,'For seventh mode frequency \n')
for  mm=1:11
      fprintf(out1,'%f \t',frqdd(mm,7));
   end
   fprintf(out1,'\n');
   
   fprintf(out1,'For eighth mode frequency \n')
for  mm=1:11
      fprintf(out1,'%f \t',frqdd(mm,8));
   end
   
   fprintf(out1,'\n');
   
   
   fprintf(out1,'Change in Fundamental frequency\n')
for  mm=1:11
      fprintf(out1,'%f \t',dfrq(mm));
   end
   fprintf(out1,'\n');

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

fclose(in);
fclose(out1);
