% For reduction in stiffness due to cracks.
% Input regarding crack spacing is given in terms of (# carcks/ 10 cm)
%then l=(50/no_cracks)

clear all % N/mm^2 and mm
h1=9*0.22;  % Thickness of 90o
h2=4*0.22;   % Thickness of 0o
E_L=48000 ; E_T=13300; mu_LT= 0.235;
G_LT= 5170;
G_23=4120;
G_13=5170;


Q11=(E_L)/(1-((E_T/E_L)*mu_LT^2));
Q22=(E_T)/(1-((E_T/E_L)*mu_LT^2));
Q12=(mu_LT*E_T)/(1-((E_T/E_L)*mu_LT^2));
Q66=G_LT;


Q44 =G_23; 
Q55=G_13;  


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%55
no_ply=50
th=(pi/180)*[60 60 60 60 60 60 60 60 60 60 60 60 60 60 60 60 ...
    90 90 90 90 90 90 90    90 90 90 90 90 90 90    90 90 90 ...
    90 60 60 60 60 60 60 60 60 60 60 60 60 60 60 60 60 ];

% Calculation of U matrix
U1=(3*Q11+3*Q22+2*Q12+4*Q66)/8;
U2=(Q11-Q22)/2;
U3=(Q11+Q22-2*Q12-4*Q66)/8;
U4=(Q11+Q22+6*Q12-4*Q66)/8;
%Geometry and ply angle orientation dependent terms

%calculation cos and sin
for n=1:no_ply
C(n)=cos(th(n));
S(n)=sin(th(n));
CS(n)=C(n)*S(n);
C2(n)=cos(2*th(n));
C4(n)=cos(4*th(n));
S2(n)=sin(2*th(n));
S4(n)=sin(4*th(n));
end

% Calculation of Transformation matrix for each ply

for n=1:no_ply
Tth(n,1,1)=C(n)^2;  Tth(n,1,2)=S(n)^2 ;Tth(n,1,3)=2*CS(n);
Tth(n,2,1)=S(n)^2;  Tth(n,2,2)=C(n)^2;  Tth(n,2,3)=-2*CS(n);
Tth(n,3,1)=-CS(n);  Tth(n,3,2)=CS(n) ; Tth(n,3,3)=C(n)^2-S(n)^2;
end


% Calculation of bar_Q for each ply

for n=1:no_ply
bar_Q(n,1,1)=U1+U2*C2(n)+U3*C4(n);
bar_Q(n,1,2)= U4-U3*C4(n);
bar_Q(n,1,3)=0.5*U2*S2(n)+U3*S4(n);
bar_Q(n,2,1)=bar_Q(n,1,2);
bar_Q(n,2,2)=U1-U2*C2(n)+U3*C4(n);
bar_Q(n,2,3)=0.5*U2*S2(n)-U3*S4(n);
bar_Q(n,3,1)=bar_Q(n,1,3);
bar_Q(n,3,2)=bar_Q(n,2,3);
bar_Q(n,3,3)= 0.5*(U1-U4)-U3*C4(n);
bar_Q(n,4,4)=Q44*C(n)^2 + Q55*S(n)^2;
bar_Q(n,5,5)=Q55*C(n)^2 + Q44*S(n)^2;
end

barQ211=bar_Q(1,1,1);	barQ111=bar_Q(no_ply/2,1,1);
barQ212=bar_Q(1,1,2);	barQ112=bar_Q(no_ply/2,1,2);
barQ222=bar_Q(1,2,2);	barQ122=bar_Q(no_ply/2,2,2);
barQ266=bar_Q(1,3,3);	barQ166=bar_Q(no_ply/2,3,3);
barQ244=bar_Q(1,4,4);	barQ144=bar_Q(no_ply/2,4,4);
barQ255=bar_Q(1,5,5);	barQ155=bar_Q(no_ply/2,5,5);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

alp=((3*barQ255*barQ155)/(h1*barQ255+h2*barQ155))* ...
((h1*barQ111+h2*barQ211)/(h1*h2*barQ211*barQ111));

alp1=sqrt(alp);

alp21=((3*barQ144*barQ244)/(h1*barQ244+h2*barQ144)) ...
*((h1*barQ166+h2*barQ266)/(h1*h2*barQ166*barQ266));
alp2=sqrt(alp21);
no_cracks=input('Give crack spacing  \n')
lll= 50/no_cracks% crack spacing 
beta1=1-(tanh(alp1*lll)/(alp1*lll));
beta2=1+(h1*barQ111/(h2*barQ211))*(tanh(alp1*lll)/(alp1*lll));
beta4=1+(h1*barQ166/(h2*barQ266))*(tanh(alp2*lll)/(alp2*lll));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
betd1=1-(tanh(alp1*lll)/(alp1*lll));
betd2=1+(h1^3*barQ111/(h2^3*barQ211))*(tanh(alp1*lll)/(alp1*lll));
betd4=1+(h1^3*barQ166/(h2^3*barQ266))*(tanh(alp2*lll)/(alp2*lll));
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

bara11=(h1*barQ111+h2*barQ211)/(beta2*(h1+h2));
bara12=(beta1*h1*barQ112+beta2*h2*barQ212)/(beta2*(h1+h2));
bara22=((h1*barQ122+h2*barQ222)/(h1+h2))-((beta2-beta1) ...
*(h1*barQ112^2)/(beta2*(h1+h2)*barQ111));
bara66= (h1*barQ166+h2*barQ266)/(beta4*(h1+h2));


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
bard11=(h1^3*barQ111+h2^3*barQ211)/(betd2*(h1+h2)^3);
bard12=(betd1*h1^3*barQ112+betd2*h2^3*barQ212)/(betd2*(h1+h2)^3);
bard22=((h1^3*barQ122+h2^3*barQ222)/(h1+h2)^3)-((betd2-betd1) ...
*(h1^3*barQ112^2/(betd2*(h1+h2)^3*barQ111)));
bard66= (h1^3*barQ166+h2^3*barQ266)/(betd4*(h1+h2)^3);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


A11=bara11*(h1+h2)*2;
A12=bara12*(h1+h2)*2;
A22=bara22*(h1+h2)*2;
A66=bara66*(h1+h2)*2;

AAA=[A11 A12 0 ;A12 A22 0; 0 0 A66];

in_AAA=inv(AAA);

ttt=(h1+h2)*2

E_eff=1/(in_AAA(1,1)*ttt)  % Effective Youngs modulus 

