function classified = kmedg(k, images,iterations, w )
% takes in a (num X rows X cols) array of images and identifies k clusters 
% based on their intensity values and their proximity using the k-medoids
% approach

% Default number of iterations

endclustering = 0;
%Begin by determining the size of the images and how many are present in
%the array

totalimages=size(images,3);
rows=size(images,1);
cols=size(images,2);

%Each pixel is given an index and it's attributes are stored in 'mainarray'
%The columns of mainarray correspond to the index of the pixel, and the
%rows contain the x,y coordinates of the pixel as well as the intensities
%for each pixel

mainrows=2+totalimages;
maincols=rows*cols;
mainarray=zeros(mainrows,maincols);

%This loop populates the mainarray with the pixel attributes
count=1;
%for i=1:totalimages
    for j=1:rows
        for l=1:cols
                % pixel coords
            mainarray(1,count)=j;
            mainarray(2,count)=l;
            %intensity for the current image
            mainarray(3:mainrows,count)=images(j,l,:);
            %increment pixel index
            count=count+1;

        end
    end
%end
%The cluster assignments are kept in the clusters matrix. Row i has the
%pixel index value for each pixel in cluster i. The total number of pixels
%assigned to each cluster is kept in clustercount

clusters=zeros(maincols,k);
clustercount=zeros(k,1);

%This stores the criteria function evaluation for each cluster
norms=zeros(k,1);

%Seeds are needed for the initial run. randperm() is used
rp=randperm(maincols);

%These are three randomly selected centroids
kpoint=mainarray(:,rp(1:k));

criterion=0;

%This is the weight vector for the norm function
if (nargin == 2)
    w=ones(mainrows-1,1);
end

w=w/norm(w);

w(1)=w(1)*255/sqrt(rows^2+cols^2);
for runs = 1:iterations
    %runs

    criterionold = criterion;
    criterion = 0;
    clusters=zeros(maincols,k);
    clustercount=zeros(k,1);
    
    % This loop goes through each pixel and assigns it to the cluster with
    % the closest centroid
    for i=1:maincols
    
        force=false;
        for clust=1:k
            
            % This block computes the distance between the current pixel
            % and the current centroid
            diff=mainarray(:,i)-kpoint(:,clust);
            if ( mainarray(:,i) == kpoint(:,clust) )
                force=true;
                realk=clust;
            end

            % Computes the distance between pixels
            %distance=sqrt(diff(1)^2+diff(2)^2);
            distance=w(1)*(diff(1)^2+diff(2)^2);
            
            % Combines the distance with the differences in spectral
            % intensity
            finaldiff=sqrt([distance;diff(3:mainrows).^2]);
            % Multiples the norms by the appropriate weights determined by
            % the w vector
            norms(clust)=dot(w,finaldiff);
        end
        
        if (force == false)
            % If the centroid is not selected, determine the minimum
            % distance between centroid and the current pixel
            min=1;
            minnorm=norms(1);
            if (k>1)
                for clust=2:k
                    if (norms(clust) < minnorm)
                        min=clust;
                        minnorm=norms(clust);
                    end
                end
            end
        
        else % (force == true) case
            min = realk;
            minnorm = norms(realk);
        end

        criterion=criterion+minnorm; %norm(mainarray(:,i)-kpoint(:,min))^2;
        % Increment the count of the clusters
        clustercount(min)=clustercount(min)+1;
        % Add the pixel index to the list of pixels in the current cluster
        clusters(clustercount(min),min)=i;
    end



    % This code creates an intermediate image so that the progress of the
    % clustering can be observed
%    classified=zeros(rows,cols);
%    for m=1:k
%        for n=1:clustercount(m)
%            classified(mainarray(1,clusters(n,m)),mainarray(2,clusters(n,m)))=round(m*254/k);
%        end
%    end
%    filen=['newtesting',num2str(runs,'%04u'),'.gif'];
%    imwrite(classified,filen);

    % This loop recomputes the centroids by identifying the most central
    % member of each cluster
    if (abs(criterion-criterionold) < .00001)
        endclustering = 1;
        break
    end
    runs
    for i=1:k

        temp=clusters(1:clustercount(i),i);
        mainmean=mean(mainarray(:,temp),2);
        tempnorms= abs(mainarray(:,temp)-mainmean*ones(1,clustercount(i)));
        tempnorms(1:2,:)= tempnorms(1:2,:).^2;
        tempnorms(2,:)=sqrt(tempnorms(1,:)+tempnorms(2,:));
        tempnorms=tempnorms'*[0;w];
        %[throwaway,indices]=min(tempnorms,[],1);
        sortcluster=sortrows([tempnorms temp],1);
        kpoint(:,i)=mainarray(:,sortcluster(1,2));%temp(indices(1)));
        
        %centroid=ceil(size(sortcluster,1)/2);
        %kpoint(:,i)=mainarray(:,sortcluster(centroid,2));
        
%cut from here
%
    end
    
    if (endclustering==1)
        break
    end
    
end

% A final image mask is constructed with each pixel in the array being
% given a value corresponding to its assignment
classified=zeros(rows,cols);
for i=1:k
    for j=1:clustercount(i)
        classified(mainarray(1,clusters(j,i)),mainarray(2,clusters(j,i)))=i;
    end
end
