C
C
CMAIN->
C
C-INPUT1
C PRINT1
C INPUT2->MTIME
C         VISIT -> NUMBER
C PRINT2
C-ARCS-> REVENU
C        OUTPUT -> PAIR
C                  CODES
C        ROUTES -> TAB   ->  MIRROR
C                            COSREV -> COVER
C                                      ASSESS -> CHECK
C                                      CITIES
C                                      REVENU -> FARE
C                                      FLOW
C                            DECIDE
C                            KFORE  -> COVER
C                                      MARGIN -> FIND  ->  PAIR
C                                                          STRING
C                                                COSREV -> .
C                                                DIFFER
C                                                REVENU -> FARE
C                                      DECIDE
C                                      RMILES
C                            TABLE  -> FORE
C                                      BACK  ->  STORE
C                                      MARK
C                  CODE51
C                  CONNET -> KFORE ->  .
C        TAB   ->  .
C        OUTPUT -> PAIR
C                  CODES
C
C              UTILITY ROUTINES:  MMROW
C                                 IENTRY
C
C
C           >> MAIN HANDLES ALL DIMENSIONING, INPUTS AND INITIALIZA-
C              TIONS <<
C
C
C
C              --- NOTE ---
C
C              IN THE FOLLOWING DECLARATION STATEMENTS, THE DIMENSION
C              VARIABLES, AS A RULE, ARE DEFINED WHEN WE DIMENSION THE
C              ARRAYS, UNLESS THE DIMENSION OF AN ARRAY IS A FUNCTION
C              OF SOME OTHER VARIABLES. (E.G. MMSTOP=MSTOP+1)
C
      COMMON NCITY,NROW
C
C              NCITY = NO. OF CITIES IN THE SYSTEM
C              NROW = ROW DIMENSION OF ISET
C
      COMMON /FLEET/NTYPE,ITYPE
C
C              LABELED COMMON CONTAINS DIMENSION INFO FOR A/C FLEET
C              NTYPE    NO OF A/C TYPES IN FLEET
C              ITYPE    SEQUENCE NO OF A/C TYPE UNDER CONSIDERATION
C
C
C              ALL I/O DATA SET REFERENCE NOS. ARE DEFINED IN MAIN
C
      COMMON /SET/IREAD,IREAD1,IREAD2,IWRITE
      COMMON /EARN/GAIN
C
C                LABELED COMMON EARN CONTAINS FINANCIAL DATA.
C              IT APPEARS IN MAIN, INPUT1, PRINT1 AND DECIDE.
C              GAIN     PROFIT MARGIN IN % ABOVE D.O.C.
C
C
      DOUBLE PRECISION RPM,ASM
      COMMON /SYSTEM/RPM,ASM
C
C              LABELLED COMMON SYSTEM CONTAINS SUMMARY STATISTICS
C              FOR THE WHOLE NETWORK
C
C              RPM      REVENUE PAX. MILES REALIZED
C              ASM      AVAILABLE SEAT MILES SCHEDULED
C                  BOTH TO BE ZEROED BELOW TO KEEP RUNNING SUM
C
C
C              REVEN IS THE TEMPORARY STORAGE FOR ROUTE REVENUE
C              --- TO BE ELIMINATED IN PRODUCTION STAGE WHEN ONLY
C                  ( PROFIT=REVENUE-COST ) IS KEPT
C
      INTEGER   ISET(300,3)/900*0/
      INTEGER   PART0(300,5 )/1500*0/,PART1(300,3)/ 900*0/
C
C
C              KKROUT  NEED TO BE INITIALIZED FOR THE MIN-PATH ALGORITHM
C              (DONE IN SUBROUTINE ARCS)
C
      INTEGER   ROUT0(25,25),ROUT1(25,50),ROUT2(25,75)
C
C              REMEMBER TO CHANGE THE DIMENSIONS OF KCODE AND LCODE,
C              AS WELL AS IY0/1/2 WHEN THE AVOVE ARRAY DIMENSIONS ARE
C              CHANGED.
C
      INTEGER   IRESTR(25,25),MIDDLE(140),MLIMIT(40)
C
C              IRESTR   UPPER TRIANGLE STORES ROUTE RESTRICTION CODES
C                       LOWER TRIANGLE STORES ROUTE COMPETITION REQTS
C
C
C        MIDDLE = ARRAY CONTAINING INTERMEDIATE CITIES SPECIFIED BY
C         CODE 51
C
C        MLIMIT = ARRAY CONTAINING DELIMITERS FOR MIDDLE
C
      INTEGER   ISIZE(25,3)/ 75*0/
C
C             ISIZE(I,M) MEANS THERE ARE ISIZE(.,.)  (M-1)-STOP
C             ROUTES STARTING FROM CITY I
C
C
C              IDIST IS SET TO A LARGE NUMBER FOR MIN-PATH ALGORITHM
C
      INTEGER   IDIST(300,3)/900*30000/,NFREQ(300,3),IPAX(25,25)
C
C              IPAX     UPPER TRIANGLE STORES O-D DEMAND, LOWER TRIANGLE
C                       STORES INTERCITY DISTANCES
C
      INTEGER   NSIZE(300,2)/600*0/
C
C              NSIZE STORES BOTH  PART0/PART1 COUNTS, AND
C              CONNECTIONS
C
C             -  -  -  -  -  -  -  -  -  -
C
      CHARACTER*64 FILENAME
C
C             -  -  -  -  -  -  -  -  -  -
C
      DIMENSION REVEN(300,3)
      DIMENSION COST(300,3)
C
C              YIELD1/2 ARRAYS STORING COEFF'S FOR THE YIELD EQNS
C
      DIMENSION YIELD1(7),YIELD2(7)
C
C              KTYPE    ARRAY STORING A/C LABELS
C              ISEAT    ARRAY STORING A/C SEAT CAPACITIES
C              RANGE    ARRAY STORING A/C FLYING RANGES
C              COSTM    ARRAY STORING D.O.C. PER BLOCK MINUTE BY A/C
C              SPEED1/2 ARRAYS STORING SPEED COEFF'S OF A/C'S
C
      DIMENSION KTYPE(7),ISEAT(7),RANGE(7),COSTM(7),SPEED1(7),SPEED2(7)
C
C
C              ICODE    ARRAY STORING CITY CODES
C
      DIMENSION ICODE(25)
C
C
C              MMYY = COLUMN DIMENSIONS OF REVEN/COST/IDIST/NFREQ/
C              ISIZE/ISET
C
      DIMENSION KCODE(75),LCODE(75)
C
C              THESE TWO ARRAYS, TO BE EQUIVALENCED BELOW, ARE
C              DIMENSIONED TO THE LENGTH OF IY2 ( THE COLUMN DIMENSION
C              OF ROUT2 ).  THEY ARE USED FOR THE CURRENT VERSION OF
C              OUTPUT, AND CODES.
C
      EQUIVALENCE (KCODE(1),LCODE(1))
C
C
      DATA MMYY/3/
C
C              MTYPE    MAX NO OF A/C TYPES
C
      DATA MTYPE/7/ 
C
C              MCITY    MAX NO OF CITIES
C
      DATA MCITY/25/
C
C              THE FOLLOWING INITIALIZATION ACTUALLY NOT NECESSARY
C
      DATA COST/900*0./,REVEN/900*0./
      DATA LMID/140/,LLIM/40/,MM/0/,MMAX/1/
C
C              LMID = LENGTH OF ARRAY MIDDLE
C                  A SOLID WAY TO ESTIMATE LMID IS TO COUNT THE NO. OF
C                  INTERMEDIATE CITIES, INCLUDING 'OR' BLOCKS, BEFORE
C                  EACH RUN
C
C              LLIM = LENGTH OF ARRAY MLIMIT
C                  = (NO. OF CITY PAIRS RESTRICTED BY CODE 5)*2 + 2
C
C
C        *** THE FOLLOWING ARE DATA INPUT PARAMETERS
C             --- TO BE CHANGED WHEN DIMENSION STATEMENTS ARE CHANGED
C
C
C        IY0/IY1/IY2/IY3
C       = COLUMN DIMENSION OF ROUT0/ROUT1/ROUT2/ROUT3
C                  A GOOD ESTIMATE OF IY-MM IS NCITY*(MM+1)
C
      DATA IY0/25/ ,IY1/50/,IY2/75/
C
C              IP0/IP1 = COLUMN DIMENSION OF PART0/PART1
C
      DATA IP0/5 /,IP1/3/
C
C
      DATA INY/2/
C
C              INY = COLUMN DIMENSION OF NSIZE
C
C
C              NONE OF THE FOLLOWING ACTUALLY NEED BE INITIALIZED TO ZER
C
      DATA NFREQ/900*0/
      DATA ROUT0/625*0/,ROUT1/1250*0/,ROUT2/1875*0/
C
C
C              INITIALIZATION FOR ITEMP/JTEMP/MTEMP NECESSARY,
C              WHERE ITEMP/JTEMP/MTEMP DEFINED FOR MIN-PATH ALGO
C
C              THEY ARE SET TO 1 INSTEAD OF 0 TO AVOID HAVING A ZERO
C              SUBSCRIPT
C
      DATA ITEMP,JTEMP,MTEMP/3*1/
C
C        MNUM = NO. OF CITY PAIRS WITH RESTRICTION CODE 51
C
      MNUM=0
C
C               DEFINE FILES TO READ TO AND WRITE FROM
C
      WRITE (*,'(A\)') ' ENTER NAME OF DATA INPUT FILE: '
      READ (*,'(A\)') FILENAME
      OPEN (2, FILE = FILENAME, status = 'old')
C
      WRITE (*,'(A\)') ' ENTER NAME OF FILE TO OUTPUT RESULTS: '
      READ (*,'(A\)') FILENAME
      OPEN (3, FILE = FILENAME, status = 'new')
C
C              DEFINE DATA SET REFERECE NOS.
C
      IREAD=2
      IREAD1=2
      IREAD2=2
      IWRITE=3
C
C              ZERO RPM & ASM IN ORDER TO KEEP RUNNING SUM
C
      RPM=0.
      ASM=0.
C  *******************************************************************
C          >>>>>
C
      CALL INPUT1(              MTYPE,MCITY,NTYPE,KTYPE,ISEAT,MSTOP,
     1 FACTOR,COSTM,SPEED1,SPEED2,RANGE,ICODE,ITYPE,YIELD1,YIELD2,NPART,
     2 LEVEL,MART)
C                  !!!!!!!!!!!
C
C          <<<<<
C
C
C              LCITY = LOOPING LIMIT FOR ORIGIN CITY I
C                (E.G. SEE STAT. NO. 800 IN MAIN)
C
      LCITY=NCITY-1
C
C        SPECIAL RESTRICTION CODE 5 IS BROKEN DOWN INTO 51
C        FOR INTERMEDIATE STOPS AND 52 FOR 'BEYOND' DESIGNATIONS.
C        CODE 5 SPECIFIES A CITY PAIR WITH BOTH INTERMEDIATE
C        AND BEYOND DESIGNATIONS
C
C             GENERATING K-STOP ROUTES SEGMENT BY SEGMENT,
C             WHERE MSTOP IS THE LARGEST MSTOP-ROUTE THE USER
C             WANTS TO GENERATE
C
C              DEFINE MMSTOP TO DIMENSION ARRAYS
C                E.G. ISET(NROW,MMSTOP), ISIZE(NCITY,MMSTOP)
C
      MMSTOP=MSTOP+1
C
C              NNODE = NO. OF CITIES IN THE LONGEST POSSIBLE ROUTE
C              ACTUALLY NNODE IS DEFINED TO BE 1 ENTRY LONGER THAN
C                  NECESSARY
C
      NNODE=MSTOP+3
C
C              2-STOPS ARE THE LONGEST ROUTE A USER CAN GENERATE
C              WITH THE PRESENT CODING.  3-STOPS OR LONGER  CAN BE
C              HANDLED AFTER MODIFYING SUBROUTINES KFORE, KKFORE
C              AND POSSIBLEY BACK & LOCATE
C
C
C          >>>>>
C
C
      CALL PRINT1(       NTYPE,KTYPE,ISEAT,SPEED1,SPEED2,RANGE,COSTM,
     1 ICODE,ITYPE,MSTOP,FACTOR,YIELD1,YIELD2,NPART,LEVEL,MART)
C                            !!!!!!!!!!
C
      CALL INPUT2(LEVEL,MART,   ITYPE,SPEED1,SPEED2,NTYPE,LMID,LLIM,
     1 ICODE,IPAX,IRESTR,MIDDLE,MLIMIT,IP,IPOINT,IDIST,*9900)
C                  !!!!!!!!!!!
C
      CALL PRINT2(       ICODE,IDIST,IPAX,IRESTR,MIDDLE,MLIMIT,LMID,
     1 LLIM)
C                  !!!!!!!!!!!
C
C
C          <<<<<
C
      CALL ARCS(REVEN,MMSTOP,COST,YIELD1,YIELD2,ISEAT,COSTM,
     1 SPEED1,SPEED2,ICODE,LMID,LLIM,MM,MMAX,IY0,IY1,IY2,INY,IP0,IP1,
     2 ISET,PART0,PART1,ROUT0,ROUT1,ROUT2,      IRESTR,MIDDLE,MLIMIT,
     3 ISIZE,NSIZE,IDIST,NFREQ,IPAX,ITEMP,JTEMP,MTEMP,MNUM,FACTOR,MSTOP,
     4 NPART,LCITY,MMYY,KCODE,LCODE)
C                       !!!!!!!!!!
      STOP
9900  WRITE(IWRITE,9910)
9910  FORMAT(/ ' >>> IN MAIN - JOB TERMINATED DUE TO THE ABOVE ERROR '
     1 / )
      STOP
      END
      SUBROUTINE ARCS(REVEN,MMSTOP,COST,YIELD1,YIELD2,ISEAT,
     1 COSTM,SPEED1,SPEED2,ICODE,LMID,LLIM,MM,MMAX,IY0,IY1,IY2,INY,
     2 IP0,IP1,ISET,PART0,PART1,ROUT0,ROUT1,ROUT2,      IRESTR,MIDDLE,
     3 MLIMIT,ISIZE,NSIZE,IDIST,NFREQ,IPAX,ITEMP,JTEMP,MTEMP,MNUM,
     4 FACTOR,MSTOP,NPART,LCITY,MMYY,KCODE,LCODE)
C
C              THIS SUBROUTINE IS DEFINED FOR PROGRAMMING CONVENIENCE
C              IN OBJECT TIME DIMENSIONING. FUNCTIONALLY, THIS ROUTINE
C              SYNTHESIZES NONSTOP ROUTES, WHICH ARE THE BASIC ARCS IN
C              THE ROUTE MAP, AND CALLS ROUTES FOR SYNTHESIZING MULTI-
C              STOP ROUTES.
C
C
      COMMON NCITY,NROW
      COMMON /FLEET/NTYPE,ITYPE
      COMMON /SET/IREAD,IREAD1,IREAD2,IWRITE
      DOUBLE PRECISION RPM,ASM
      COMMON /SYSTEM/RPM,ASM
C
C                  MMYY = COLUMN DIMENSION OF REVEN/COST/IDIST/NFREQ/
C                       ISIZE/ISET, USED IN CALLING OUTPUT
C              THE COLUMN DIMENSION OF THE ABOVE MENTIONED ARRAYS HAS
C             TO BE MMYY, AND THAT OF NSIZE HAS TO BE INY, IN ORDER TO
C              BE COMPATIBLE WITH THE PRESENT VERSION OF OUTPUT
C
      DIMENSION REVEN(NROW,MMYY  ),COST(NROW,MMYY  )
      DIMENSION YIELD1(NPART),YIELD2(NPART)
      DIMENSION ISEAT(NTYPE),COSTM(NTYPE),
     1 SPEED1(NTYPE),SPEED2(NTYPE)
      DIMENSION ICODE(NCITY),KCODE(IY2),LCODE(IY2)
C
C              KCODE,LCODE ARE USED IN THE CURRENT VERSION OF OUTPUT
C
      LOGICAL DECIDE,D
      INTEGER   ISET(NROW,MMYY  ),PART0(NROW,IP0),PART1(NROW,IP1)
      INTEGER   KROUT(5),KKROUT(5)/5*0/
      INTEGER   ROUT0(NCITY,IY0),ROUT1(NCITY,IY1),ROUT2(NCITY,IY2)
      INTEGER   IRESTR(NCITY,NCITY),MIDDLE(LMID),MLIMIT(LLIM)
      INTEGER   ISIZE(NCITY,MMYY  ),NSIZE(NROW,INY)
      INTEGER   IDIST(NROW,MMYY  ),NFREQ(NROW,MMYY  ),IPAX(NCITY,NCITY)
C
      DO 200 I=1,LCITY
      JLOW=I+1
      DO 200 J=JLOW,NCITY
C
C              ONLY TAKE UPPER HALF OF SYMMETRIC MATRIX
C
      IJ=IRESTR(I,J)
410   IF(IJ .NE. 5 .AND. IJ .NE. 51) GO TO 400
      MNUM=MNUM+1
400   IF(IJ .NE. 1 .AND. IJ .NE. 4 .AND. IJ .NE. 52) GO TO 200
      ISIZE(I,1)=ISIZE(I,1)+1
      ISIZE(J,1)=ISIZE(J,1)+1
      ICOL=ISIZE(I,1)
      JCOL=ISIZE(J,1)
      ROUT0(I,ICOL)=J
      ROUT0(J,JCOL)=I
      IROW=MROW(I,J)
C
C ..........
C
C              CHECK RESTRICTION CODE 4
C
      IF(IRESTR(I,J) .EQ. 4) GO TO 200
C
C              200 = ILLEGAL ROUTE
C              FALL THROUGH = LEGAL ROUTE
C
C ..........
C
C
C              COST
C
      IFREQ=IPAX(I,J)/(ISEAT(ITYPE)*FACTOR)+.9999
      COS=COSTM(ITYPE)*IFREQ*IDIST(IROW,MMAX)
C
C              REVENUE
C
      REV=REVENU(YIELD1,YIELD2,NPART,IPAX,I,J)
      D=DECIDE(COS,REV)
      IF (D) GO TO 300
      GO TO 200
C
C              300 = ROUTE ACCEPTED
C              200 = REJECTED
C
C
C              FORE POINTER TABULATION
C              (SEE SUBROUTINE FORE FOR DETAILED COMMENTS)
C
300   ISET(IROW,MMAX)=ISIZE(I,MMAX)
      NFREQ(IROW,MMAX)=IFREQ
      COST(IROW,MMAX)=COS
C
C              *** REVEN FOR TEMPORARY USE ONLY ***
C
      REVEN(IROW,MMAX)=REV
C
C              TO COMPUTE SYSTEM LOAD FACTOR
C
      RPM=RPM+IPAX(I,J)*IPAX(J,I)
      SM=ISEAT(ITYPE)*IPAX(J,I)*IFREQ
      ASM=ASM+SM
C
200   CONTINUE
C
C             MNUM IS ACTUALLY TWICE AS LARGE CONSIDERING THE SYMMETRY
C                OF THE MATRIX
C               *** SUBJECT TO REMOVAL WHEN SUBROUTINE INPUTM IS MODIFIE
C
      MNUM = 2*MNUM
C
C        >>>>>
C
C
C              SET INDICATOR FOR OUTPUT
C
      IOUT=2
C
C
      CALL OUTPUT(IOUT,MM,IY0,IY1,IY2,IDIST,       ROUT0,ISIZE,
     1 ISET,ROUT1,ROUT2,PART0,PART1,NSIZE,     COST,NFREQ,
     2 MMYY,  REVEN,IP0,IP1,INY,  ICODE,KCODE,LCODE)
C                            !!!!!!!!!!
      CALL INTOUT(     MM,IY0,IY1,IY2,      IDIST,       ROUT0,ISIZE,
     1 ISET,ROUT1,ROUT2,PART0,PART1,NSIZE,           COST,NFREQ,
     2 MMYY,  REVEN,IP0,IP1,INY,  ICODE,KCODE,LCODE)
C
C        <<<<<
C
C
40    DO 9000 MM=1,MSTOP
      MMAX=MM+1
C
C              PREPARE ROUT FOR SYNTHESIS
C
      GO TO (100,210), MM
C
C              100/210 = TO SYNTHESISE 1/2-STOP ROUTES
C
C
100   CALL ROUTES(MM,MMAX,MSTOP,MMSTOP,ROUT0,IY0,ROUT1,IY1,ROUT2,IY2,
     1 REVEN,COST,YIELD1,YIELD2,NPART,ISET,PART0,IP0,PART1,IP1,
     2 KROUT,KKROUT,IRESTR,MIDDLE,LMID,MLIMIT,LLIM,ISIZE,
     3 IDIST,NFREQ,IPAX,NSIZE,MNUM,ITEMP,JTEMP,MTEMP,LCITY,ISEAT,COSTM,
     4 FACTOR,SPEED1,SPEED2,KROW,KROW1,KROW2)
C                            !!!!!!!!!!
      GO TO 8500
C
210   CALL ROUTES(MM,MMAX,MSTOP,MMSTOP,ROUT1,IY1,ROUT2,IY2,ROUT0,IY0,
     1 REVEN,COST,YIELD1,YIELD2,NPART,ISET,PART0,IP0,PART1,IP1,
     2 KROUT,KKROUT,IRESTR,MIDDLE,LMID,MLIMIT,LLIM,ISIZE,
     3 IDIST,NFREQ,IPAX,NSIZE,MNUM,ITEMP,JTEMP,MTEMP,LCITY,ISEAT,COSTM,
     4 FACTOR,SPEED1,SPEED2,KROW,KROW1,KROW2)
C                            !!!!!!!!!!
C
C
C              THE LAST I-J PAIR IM M-STIP LOOP IS TABULATED IN ROUTM
C              BEFORE WE GO TO (M+1)-STOPS
C
C
8500  CALL TAB(I,J,ITEMP,JTEMP,MTEMP,KROW,KROW1,KROW2,MMSTOP,   IY0,
     1 IY1,IY2,IP0,IP1,       MSTOP,     KROUT,KKROUT,ISIZE,     ROUT0,
     2 ROUT1,ROUT2,IPAX,ISEAT,COSTM,FACTOR,YIELD1,YIELD2,NPART,IRESTR,
     3 IDIST,PART0,PART1,NSIZE,ISET,NFREQ,SPEED1,SPEED2,COST,REVEN)
C                            !!!!!!!!!!
C
C
C        >>>>>
C
C
C              SET INDICATOR FOR OUTPUT
C
      IOUT=3
C
      CALL OUTPUT(IOUT,MM,IY0,IY1,IY2,IDIST,       ROUT0,ISIZE,
     1 ISET,ROUT1,ROUT2,PART0,PART1,NSIZE,     COST,NFREQ,
     2 MMYY,  REVEN,IP0,IP1,INY,  ICODE,KCODE,LCODE)
C                            !!!!!!!!!!
      CALL INTOUT(     MM,IY0,IY1,IY2,      IDIST,       ROUT0,ISIZE,
     1 ISET,ROUT1,ROUT2,PART0,PART1,NSIZE,           COST,NFREQ,
     2 MMYY,  REVEN,IP0,IP1,INY,  ICODE,KCODE,LCODE)
C
C        <<<<<
C
C
C        LOOPING MSTOP TIMES FOR M-STOP ROUTES
C
9000  CONTINUE
      RETURN
      END
      SUBROUTINE CONNET(MMSTOP,MM,IROW,IROW1,IROW2,JROW1,JROW2,I,J,
     1 K,KKR,IPAX,ROUT,NR,ROUTX,NRX,ROUTY,NRY,COST,REVEN,
     2 NFREQ,IDIST,ISET,PART0,IP0,PART1,IP1,INY,ISEAT,COSTM,FACTOR,
     3 YIELD1,YIELD2,NPART,NSIZE,SPEED1,SPEED2)
C
C              FROM A PROGRAMMING POINT OF VIEW, THIS SUBPROGRAM SERVES
C              AS INTERFACE BETWEEN ROUTES AND KFORE. THIS INTERFACE
C              IS NECESSARY IN ORDER TO SAVE THE SCRATCH PAD ROUT
C
C              YIELD1/2 ARRAYS STORING COEFF'S FOR THE YIELD EQNS
C              NPART    NO OF SEGMENTS IN YIELD EQUATION
C              NTYPE    NO OF A/C TYPES IN FLEET
C              ITYPE    SEQUENCE NO OF A/C TYPE UNDER CONSIDERATION
C              SPEED1/2 ARRAYS STORING A PAIR OF SPEED COEFF'S FOR EACH
C                       A/C TYPE
C
      COMMON NCITY,NROW
      COMMON /FLEET/NTYPE,ITYPE
      DIMENSION ISEAT(NTYPE),COSTM(NTYPE),SPEED1(NTYPE),SPEED2(NTYPE)
      DIMENSION YIELD1(NPART),YIELD2(NPART)
      DIMENSION COST(NROW,MMSTOP),REVEN(NROW,MMSTOP)
      INTEGER   ISET(NROW,MMSTOP),NFREQ(NROW,MMSTOP)
      INTEGER   ROUT(NCITY,NR),ROUTX(NCITY,NRX),ROUTY(NCITY,NRY)
      INTEGER   PART0(NROW,IP0),PART1(NROW,IP1),IPAX(NCITY,NCITY)
      INTEGER    IDIST(NROW,MMSTOP),NSIZE(NROW,INY)
C
C              NOTE - THE FOLLOWING GO TO STATEMENT HAS TO BE
C                  MODIFIED FOR GENERATING MORE THAN 2-STOPS
C
      GO TO (100,200), MM
C
C              100 = ROUT/ROUTX/ROUTY EQUATED TO ROUT0/1/2
C              200 = ROUT/ROUTX/ROUTY EQUATED TO ROUT1/2/0
C
100   CALL KFORE(MMSTOP,MM,IROW,IROW1,IROW2,I,J,K,IPAX,ROUT,
     1 ROUTX,ROUTY,NR,NRX,NRY,COST,REVEN,NFREQ,IDIST,ISET,PART0,IP0,
     2 PART1,IP1,INY,ISEAT,COSTM,FACTOR,YIELD1,YIELD2,NPART,SPEED1,
     3 SPEED2,NSIZE)
C                            !!!!!!!!!!
      RETURN
C
200   CALL KFORE(MMSTOP,MM,IROW,IROW1,IROW2,I,J,K,IPAX,ROUTY,
     1 ROUT,ROUTX,NRY,NR,NRX,COST,REVEN,NFREQ,IDIST,ISET,PART0,IP0,
     2 PART1,IP1,INY,ISEAT,COSTM,FACTOR,YIELD1,YIELD2,NPART,SPEED1,
     3 SPEED2,NSIZE)
C                            !!!!!!!!!!
C
C              TABULATE THE 'OTHER' TRANSFER STATION
C
      CALL KFORE(MMSTOP,MM,IROW,JROW1,JROW2,J,I,KKR,IPAX,
     1 ROUTY,ROUT,ROUTX,NRY,NR,NRX,COST,REVEN,NFREQ,IDIST,ISET,PART0,
     2 IP0,PART1,IP1,INY,ISEAT,COSTM,FACTOR,YIELD1,YIELD2,NPART,SPEED1,
     3 SPEED2,NSIZE)
C                            !!!!!!!!!!
      RETURN
      END
      SUBROUTINE COSREV(NEW,ISEAT,COSTM,FACTOR,I1,J1,IROW,MM,MMAX,
     1 ISET,KKROUT,PART0,IP0,PART1,IP1,YIELD1,YIELD2,NPART,IPAX,IDIST,
     2 NSIZE,INY,KFREQ,MLL,LIST,ITEST,MINDEX,COS,REV,PM,SM)
C
C              THIS SUBRPOGRAM ENUMERATES THE CITY PAIRS SERVED BY
C              A ROUTE I-...-J STORED IN KKROUT. IN DOING SO THE
C              REVENUE POTENTIAL FROM EACH OF THE CITY PAIRS ARE SUMMED
C              UP
C
C              AS CITY PAIRS ARE BEING TRACED OUT, FLOWS ARE BUNDLED
C              UP IN ALL THE SEGMENTS, THEN ROUTE FREQUENCY IS
C              ESTIMATED, AND ROUTE COST COMPUTED.
C
C                  OUTPUT: COS,REV,KFREQ,MLL,LIST,ITEST,MINDEX,PM,SM
C                  INPUT: ALL THE REST
C              YIELD1/2 ARRAYS STORING COEFF'S FOR THE YIELD EQNS
C              NPART    NO OF SEGMENTS IN YIELD EQUATION
C              NTYPE    NO OF A/C TYPES IN FLEET
C              ITYPE    SEQUENCE NO OF A/C TYPE UNDER CONSIDERATION
C              PM/SM    CONTRIBUTION TOWARDS SYSTEM PAX-MILES/SEAT-MILES
C                       DUE TO THE ROUTE UNDER CONSIDERATION
C                  I & O: MMI,I,J,
C
C                  NOTICE -MMI IS THE SAME AS MMAX, EXCEPT ITS VALUE
C                          CHANGES AFTER THIS SUBROUTINE
C                          I/J ALSO CHANGED TO ZERO AFTER RETURNING
C                          TO CALLING PROGRAM
C
      COMMON NCITY,NROW
      COMMON /FLEET/NTYPE,ITYPE
      DIMENSION ISEAT(NTYPE),COSTM(NTYPE)
      DIMENSION YIELD1(NPART),YIELD2(NPART)
      LOGICAL IJ,MN,SKIP,NEW,LOOK
      INTEGER   ISET(NROW,MMAX)
      INTEGER   PART0(NROW,IP0),PART1(NROW,IP1)
      INTEGER   IDIST(NROW,MMAX),NSIZE(NROW,INY)
      INTEGER   LIST(7,2),MINDEX(8),IPAX(NCITY,NCITY)
      INTEGER   LIMIT(7,2),ISEG(4),KKROUT(5)
       LOGICAL ITEST(7)
C
C              LIMIT STORES THE LOWER AND UPPER POSITIONS OF THE END
C              SEGMENTS OF A RTE BLK IN THE PARENT ROUTE. IT IS USED
C              TO CALL FLOW
C
      DATA LIMIT/14*0/
C
C
C              THE FOLLOWING IS AN ARTIFICE TO ENSURE THAT THE VALUES
C              I1, J1 IN THE ARGUMENT LIST ARE NOT CHANGED AFTER A CALL
C              TO COSREV
C
      MMI=MMAX
      I=I1
      J=J1
C
      IF(MM .GT. 0) GO TO 110
C
C              110 = MULTISTOP - PROCEED WITH THE MAIN BLK OF CODE
C              FALL THROUGH = NONSTOP - TAKE SHORTCUT COMPUTATION
C
      REV=REVENU(YIELD1,YIELD2,NPART,IPAX,I,J)
      KFREQ=IPAX(I,J)/(ISEAT(ITYPE)*FACTOR)+.9999
C
C              TO COMPUTE SYSTEM LOAD FACTOR
C
      PM=IPAX(I,J)*IPAX(J,I)
      SM=ISEAT(ITYPE)*IPAX(J,I)*KFREQ
      GO TO 910
C
C              LIST STORES THE ROUTE BLKS TO BE FURTHER DECOMPOSED
C
C               DEFINE LENGTH OF LIST, ML, FOR WICH SEARCH IS NEEDED
C
110   ML=0
      DO 300 II=1,MM
      MOLD=ML+1
      ML=ML+2**(II-1)
C
C              DEFINE THE COLUMN IN ISET FOR THE CORRESPONDING
C              O-D PAIR IN LIST
C
      DO 350 MI=MOLD,ML
350   MINDEX(MI)=MMI
300   MMI=MMI-1
C
C              DEFINE MINDEX FOR ALL CITY PAIRS, AND
C               DEFINE LENGTH OF LIST, MLL, WHICH IS FILLED
C
      LM1=ML+1
      LM2=ML+2**MM
      DO 250 MII=LM1,LM2
250   MINDEX(MII)=MMI
      MLL=LM2-1
C
C                LK1/LK2 =INDICES TO HELP EXTRACTNG CITY PAIRS
C              FROM KKROUT
C
      LK1=1
      LK2=MM+2
C
C              INITIALIZE ALL ROUTE SEGMENT FLOW
C
      K1=1
      K2=MMAX
C
C             DO LOOP,INSTEAD  OF A DATA STATEMENT, NECESSARY TO
C              INITIALIZE ISEG, BECAUSE INITIALIZATION NECESSARY FOR
C              EACH CALL TO COSREV
C
      DO 150 IS=1,MMAX
150   ISEG(IS)=0
C
C              TO BE SET TO ZERO EVERY TIME COSREV IS CALLED;
C              A DATA STATEMENT  WOULD NOT DO
C
900   ITEMP=0
      JTEMP=0
      LIST(1,1)=0
      LIST(1,2)=0
C
C              L = COUNTER FOR LIST STORAGE
C
      L=1
C
C                TO INITIALIZE   REV AND FLOW FOR THE O-D PAIR I-J
C
C +++++ ASSUMPTION +++++
C
C              STILL GENERATE DIRECT ROUTES EVEN THOUGH CONNECT ROUTING
C              OF FEWER INTERMEDIATE STOPS MAY EXIST
C
C          NOTICE THE VALUE OF SKIP APPLIES TO ALL 3 CALLS TO COVER
C
      SKIP=.TRUE.
C
C
      CALL COVER(IROW,MM,ISET,PART0,IP0,PART1,IP1,       SKIP,NSIZE,
     1 INY,       IPART,IROUTE,ITRANS,IFLAG,   JJCOL)
C                            !!!!!!!!!!
      IF(IFLAG .EQ. 0) GO TO 600
C
C              FALL THROUGH = TO FULLY ASSESS THE WAY IN WHICH THE
C          CITY PAIR IS COVERED
C               600 = CITY PAIR CONFIRMED TO BE NOT COVERED
C
      IF (NEW) GO TO 620
C
C              620 = 1ST TIME RTE SYNTHESIZED, NO NEED TO ASSESS
C                FALL THROUGH = IMPROVING ON RTE/RTG, ASSESSMT NEEDED
C
      CALL ASSESS(IPART,IROUTE,IROW,MM,   IROW,MMAX,PART0,PART1,IP0,
     1 IP1,       LOOK)
C                            !!!!!!!!!!
      IF (LOOK) GO TO 620
C
C              620 = CONFIRMED COVERED
C              FALL THROUGH = CONFIRMED NOT PROPERLY COVERED
C
C              INITIALIZE WITH PAX FROM I TO J, AND SET INDICATOR
C
600   REV=REVENU(YIELD1,YIELD2,NPART,IPAX,I,J)
C
      CALL FLOW(MMAX,I,J,K1,K2,IPAX,ISEG)
C                            !!!!!!!!!!
      GO TO 610
620   REV=0
C
C              THE FOLLING IS THE MAIN FUNCTION OF THIS SUBPROGRAM,
C              I.E. TO SEQUENTIALLY DECOMPOSE ALL ROUTE BLOCKS
C              TO THEIR BASIC BUILDING BLOCKS
C
610   DO 200 M=1,ML
C
C              M = COUNT OF THE ITEMS IN THE LIST SERVED
C
C
C
C              CHECK REDUNDANCY OF ADJACENT ROUTE BLOCKS
C
123   IF(LIST(M,1) .EQ. I .AND. LIST(M,2) .EQ. J) GO TO 200
C
C              THE FOLLOWING TWO STATEMENTS ARE USED TO FACILITATE
C              CALLING COVER TO CHECK WHETHER A CITY PAIR HAS BEEN
C              COVERED
C
      MMM=MINDEX(M)
      LIM=MMM-1
C
      CALL CITIES(LK1,LK2,KKROUT,IP,JQ,IJ,MP,NQ,MN)
C                            !!!!!!!!!!
C
C          GIVEN ROUTE X-.-.-X,
C              (IP,JQ) IS DEFINED TO BE THE RIGHT BKL X-(.-.-X),
C              AND (MP,JQ) THE LEFT (X-.-.)-X
C
C              ADD TO TOTAL REVENUE THE INDIVIDUAL REVENUE FROM O-D
C              PAIRS SERVED BY THIS ROUTE
C
500   IF(IP .EQ. ITEMP .AND. JQ .EQ. JTEMP) GO TO 820
      KK1=K1+1
C
C              TO CHECK WHETHER CITY PAIR IP-JQ HAS BEEN COVERED BY
C              LIM-STOP ROUTES OR PORTION OF ROUTES
C
      IROW1=MROW(IP,JQ)
C
      CALL COVER(IROW1,LIM,ISET,PART0,IP0,PART1,IP1,       SKIP,NSIZE,
     1 INY,       IPART,IROUTE,ITRANS,IFLAG,   JJCOL)
C                            !!!!!!!!!!!
      IF(IFLAG .EQ. 0) GO TO 100
C
      IF(NEW) GO TO 820
C
      CALL ASSESS(IPART,IROUTE,IROW,MM,   IROW1,LIM,PART0,PART1,IP0,
     1 IP1,       LOOK)
C                            !!!!!!!!!!
      IF(LOOK) GO TO 820
100   DREV=REVENU(YIELD1,YIELD2,NPART,IPAX,IP,JQ)
      REV=REV+DREV
C
C
C          ISEG ALWAYS CONTAINS THE CURRENT ACCUMULATION
C              OF PASSENGER FLOW ON ALL ROUTE SEGMENTS
C
12    CALL FLOW(MMAX,IP,JQ,KK1,K2,IPAX,ISEG)
C                            !!!!!!!!!!
820   KK2=K2-1
      IROW2=MROW(MP,NQ)
C
      CALL COVER(IROW2,LIM,ISET,PART0,IP0,PART1,IP1,       SKIP,NSIZE,
     1 INY,       IPART,IROUTE,ITRANS,IFLAG,   JJCOL)
C                            !!!!!!!!!!
      IF(IFLAG .EQ. 0) GO TO 550
C
      IF (NEW) GO TO 560
C
      CALL ASSESS(IPART,IROUTE,IROW,MM,   IROW2,LIM,PART0,PART1,IP0,
     1 IP1,       LOOK)
C                            !!!!!!!!!!
      IF (LOOK) GO TO 560
550   DREV=REVENU(YIELD1,YIELD2,NPART,IPAX,MP,NQ)
      REV=REV+DREV
C
C
1     CALL FLOW(MMAX,MP,NQ,K1,KK2,IPAX,ISEG)
C                            !!!!!!!!!!
560   ITEMP=MP
      JTEMP=NQ
400   IF(L .GT. MLL) GO TO 650
C
C              650 = THE COUNTER FOR LIST STORAGE, L, HAS EXCEEDED
C              THE NECESSARY LENGTH
C
      LIST(L,1)=IP
      LIST(L,2)=JQ
      ITEST(L)=IJ
      LIMIT(L,1)=KK1
      LIMIT(L,2)=K2
      LL=L+1
      LIST(LL,2)=NQ
      LIST(LL,1)=MP
      ITEST(LL)=MN
      LIMIT(LL,1)=K1
      LIMIT(LL,2)=KK2
450   L=L+2
C
C
650   I=LIST(M,1)
      J=LIST(M,2)
210   K1=LIMIT(M,1)
      K2=LIMIT(M,2)
      LK1=K1
      LK2=K2+1
200   CONTINUE
C
C              FREQUENCY ESTIMATION
C
      KFREQ=0
C
C              SYSTEM LOAD FACTOR BOOKKEEPING
C
      PM=0.
      TDIST=0.
C
C              TDIST    TOTAL ROUTE DISTANCE IN MILES
C
      DO 950  ISE=1,MMAX
C
C              LOAD FACTOR
C
      NODE1=KKROUT(ISE)
      NODE2=KKROUT(ISE+1)
      DIST=IENTRY(.FALSE.,NODE1,NODE2,IPAX,NCITY)
      PM=PM+ISEG(ISE)*DIST
C
C              SUM UP TOTAL MILEAGE DISTANCE FOR THE ROUTE
C
      TDIST=TDIST+DIST
C
C              FREQUENCY
C
      IFREQ=ISEG(ISE)/(ISEAT(ITYPE)*FACTOR)+.9999
      IF(IFREQ .LE. KFREQ) GO TO 950
      KFREQ=IFREQ
950   CONTINUE
C
C              CONTRIBUTION TOWARDS SYSTEM SEAT MILES
C
      SM=ISEAT(ITYPE)*TDIST*KFREQ
C
C              ROUTE COST
C
910   COS=COSTM(ITYPE)*KFREQ*IDIST(IROW,MMAX)
700   RETURN
      END
      SUBROUTINE KFORE(MMSTOP,MM,IROW,IROW1,IROW2,I,J,K,IPAX,
     1 ROUT0,ROUT1,ROUT2,IY0,IY1,IY2,COST,REVEN,NFREQ,IDIST,ISET,PART0,
     2 IP0,PART1,IP1,INY,ISEAT,COSTM,FACTOR,YIELD1,YIELD2,NPART,SPEED1,
     3 SPEED2,NSIZE)
C
C
C              GIVEN A PAX O-D ROUTING WHICH IS AN ILLEGAL A/C ROUTE,
C              THIS SUBROUTINE CHECKS WHETHER A COMPETITIVE A/C ROUTE
C              ALREADY EXISTS TO SERVE THE O-D TRAFFIC :
C                    - IF YES ... PAX CAN EXECUTE THEIR TRIP VIA
C                         THE LEGAL A/C ROUTE
C                    - OTHERWISE ... THE PAX ROUTING IS RECORDED AS
C                         A CONNECTING/CHANGE-OF-PLANE ITINERARY
C                          CONSISTING OF 2 A/C ROUTES
C
C                         *** NOTE ***
C                        CODING TAKES CARE OF 1-TRANSFERS ONLY
C
C                       OUTPUT: NSIZE
C                  I & O:  COST,REVEN
C                       INPUT: THE REST
C              YIELD1/2 ARRAYS STORING COEFF'S FOR THE YIELD EQNS
C              NPART    NO OF SEGMENTS IN YIELD EQUATION
C              NTYPE    NO OF A/C TYPES IN FLEET
C              ITYPE    SEQUENCE NO OF A/C TYPE UNDER CONSIDERATION
C              SPEED1/2 ARRAYS STORING A PAIR OF COEFF'S FOR EACH A/C
C                       TYPE
C
      COMMON NCITY, NROW
      COMMON /FLEET/NTYPE,ITYPE
      DOUBLE PRECISION RPM,ASM
      COMMON /SYSTEM/RPM,ASM
      DIMENSION ISEAT(NTYPE),COSTM(NTYPE),SPEED1(NTYPE),SPEED2(NTYPE)
      DIMENSION YIELD1(NPART),YIELD2(NPART)
      DIMENSION COST(NROW,MMSTOP),REVEN(NROW,MMSTOP)
      LOGICAL SKIP,D,DECIDE
      INTEGER   ISET(NROW,MMSTOP)
      INTEGER   ROUT0(NCITY,IY0),ROUT1(NCITY,IY1),ROUT2(NCITY,IY2)
      INTEGER   PART0(NROW,IP0),PART1(NROW,IP1),IPAX(NCITY,NCITY)
      INTEGER   IDIST(NROW,MMSTOP),NSIZE(NROW,INY)
      INTEGER   NFREQ(NROW,MMSTOP)
C
C              CHECK WHETHER THE 2 COMPONENT ROUTINGS (I,K) AND (K,J)
C               EXIST
C
      SKIP=.TRUE.
      CALL COVER(IROW1,MM,ISET,PART0,IP0,PART1,IP1,       SKIP,NSIZE,
     1 INY,       IPART1,IROUT1,ITRAN1,IFLAG1,    JCOL1)
C                       !!!!!!!!!!
      CALL COVER(IROW2,1,ISET,PART0,IP0,PART1,IP1,       SKIP,NSIZE,
     1 INY,       IPART2,IROUT2,ITRAN2,IFLAG2,    JCOL2)
C                       !!!!!!!!!!
C
C
C
123   IF(IFLAG1 .GT. 0 .AND. IFLAG2 .GT. 0) GO TO 300
C
C              300 = CONNECT ROUTING ESTABLISHED
C
      RETURN
C
C             TO PICK OUT THE ROUTING WITH FEWER NUMBER OF STOPS
C
300   IF(IPART1 .LT. IROUT1) GO TO 400
      MCOL=IROUT1
      GO TO 500
400   MCOL=IPART1
500   LLDIST=IDIST(IROW1,MCOL)+IDIST(IROW2,1)
C
C              CHECK WHETHER CITY PAIR HAS BEEN COVERED BY CONNECT
C              ROUTING
C
C
C                            !!!!!!!!!!
C
      IROUT3=0
      IPART3=0
      CALL CCOVER(IROW,MCOL,IP0,IP1,NSIZE,INY,       IPART3,IROUT3,
     1 ITRAN3,ICOL,IFLAG3)
C
C                            !!!!!!!!!!
C
      IF(IFLAG3 .GT. 0) GO TO 600
C
C              600 = CITY PAIR HAS BEEN COVERED BY CONNECT ROUTING
C              WITH MM OR FEWER STOPS
C              FALL THROUGH = NO CONNECT ROUTING CANDIDATE CONSIDERED
C              YET, HAVE TO CHECK WHETHER I-J IS COVERED BY DIRECT RTE
C
C
C              CHECK WHETHER DIRECT ROUTE EXISTS
C
C                       !!!!!!!!!!
C
      SKIP=.TRUE.
      CALL COVER(IROW,MM,ISET,PART0,IP0,PART1,IP1,       SKIP,NSIZE,
     1 INY,       IPART,IROUTE,ITRANS,IFLAG,   JJCOL)
C
C                       !!!!!!!!!!
C
      IF(IFLAG .GT. 0) RETURN
C
C              FALL THROUGH = NO DIRECT ROUTE, CONNECT ROUTING NECESSARY
C
      GO TO 1000
600   IF(ITRAN3 .LT. MM) RETURN
C
C              .LT. MM = ALREADY COVERED BY ROUTING OF FEWER THAN MM
C                STOPS, NO NEED TO SYNTHESIZE LONGER ROUTINGS
C              .EQ. MM = SEE WHETHER SHORTER ROUTING WITH THE SAME NO.
C                OF INTERMEDIATE STOPS CAN BE FOUND
C
      IF(LLDIST .GE. NFREQ(IROW, ICOL)) RETURN
C
C              FALL THROUGH= SHORTER ROUTING FOUND
C
C
C              TO EVALUATE THE PROFIT POTENTIAL OF THE CONNECT ROUTING
C
1000  CALL MARGIN(MMSTOP,I,K,J,IPAX,ROUT0,ROUT1,ROUT2,IY0,IY1,IY2,
     1 COST,REVEN,IDIST,IROUT1,IPART1,IROW1,JCOL1,    IROUT2,
     2IPART2,IROW2,JCOL2,    ISET,PART0,IP0,PART1,IP1,       ISEAT,
     3 COSTM,FACTOR,YIELD1,YIELD2,NPART,NSIZE,INY,IIROW,IICOL,JJROW,
     4 JJCOL,KFREQ1,KFREQ2,CCOS,CREV,   SM1,SM2)
C                            !!!!!!!!!!
      D=DECIDE(CCOS,CREV)
      IF(D) GO TO 1100
C
C              1100 = RTG PROVED TO BE PROFITABLE
C              FALL THROUGH = REJECT UNPROFITABLE RTG
C
      RETURN
C
C              RECORD CONNECT ROUTING
C                    MM =1 :     . - (K) - .
C                        2 :     . - . - (K) - .
C
1100  IF(I .GT. J) GO TO 1200
C
C              1200 = REVERSE RTE BLKS UNDER THE CONVENTION I .LT. J
C              FALL THROUGH = NORMAL SITUATION - I .LT. J
C
      ITEM1=MIN0(IPART1,IROUT1)
      ITEM2=MIN0(IPART2,IROUT2)
      GO TO 1300
1200  ITEM1=MIN0(IPART2,IROUT2)
      ITEM2=MIN0(IPART1,IROUT1)
C
C              NSIZE FORMAT FOR RECORDING TRANSFER ROUTING
C                  !------------!------------!------------!
C                    MMAX-(I,K)    MMAX-(K,J)      K
C
1300  ITEM  =ITEM1*10000+ITEM2*100+K
C
C              NOTE -
C
C              ALL THE STATISTICS FOR A CONNECT ROUTING ARE KEPT IN A
C              COLUMN LEFT-SHIFTED ONE PLACE COMPARED TO THE
C              CORRESPONDING DIRECT ROUTES
C
C
C              --- NOTE ---
C              NSIZE, AND ONLY NSIZE, IS STORED AS A MINUS (-) VALUE
C              TO FACILITATE THE ERASING PROCEDURE IN TABLE
C
      NSIZE(IROW,ICOL)=-ITEM
C
      NFREQ(IROW, ICOL)=LLDIST
C
C              STORE THE MARGINAL COST AND REVENUE DUE TO THE CONNECT
C              ROUTING
C
      COST(IROW, ICOL)=CCOS
      REVEN(IROW, ICOL)=CREV
C
C              CONVERT ROUTING BLK TIME BACK TO MILEAGE DISTANCE
C
      TIME=LLDIST
      SPEEDX=SPEED1(ITYPE)
      SPEEDY=SPEED2(ITYPE)
      DIST=RMILES(TIME,ICOL,SPEEDX,SPEEDY)
C
C              CONNECT PAX LOG THE FOLLWING PAX-MILES
C
      PAX=IENTRY(.TRUE.,I,J,IPAX,NCITY)
      PM=PAX*DIST
C
C              KEEP RUNNING SUM OF RPM AND ASM
C
      RPM=RPM+PM
      DFREQ1=KFREQ1-NFREQ(IIROW,IICOL)
      DFREQ2=KFREQ2-NFREQ(JJROW,JJCOL)
      SM=SM1*DFREQ1/KFREQ1 + SM2*DFREQ2/KFREQ2
      ASM=ASM+SM
C
C ::::::::::
C
C              *** NOTE ***
C
C              THE FOLLOWING REQUIRES IMMEDIATE ATTENTION
C
C              A CHECK SHOULD BE MADE TO SEE IF A FORMER CONNECT ROUTING
C              HAD SERVED THE CITY PAIR IROW. IF SO, NEED TO
C              (1) DECREMENT THE CORRESPONDING LOGGED PAX-MILES & SEAT-
C              MILES SINCE THE FORMER ROUTING HAS ALREADY LOGGED CERTAIN
C              PAX-MILES, AND
C              (2) RESTORE THE ORIGINAL ROUTE FREQUENCIES OF THE 2
C              COMPONENT ROUTES THAT MADE UP THE FORMER CONNECT ROUTING
C              NOTICE THIS REQUIRES BOOKKEEPING THE ORIGINAL ROUTE
C              FREQUENCIES IN AN ARRAY LIKE ISET, WHICH HAS EMPTY SPACE.
C
C ::::::::::
C
C
C              MODIFY THE FREQUENCIES ON THE ROUTES THAT PROVIDE THE
C              CONNECTION
C
      NFREQ(IIROW,IICOL)=KFREQ1
      NFREQ(JJROW,JJCOL)=KFREQ2
C
      RETURN
      END
       SUBROUTINE MARGIN(MMSTOP,I,K,J,IPAX,ROUT0,ROUT1,ROUT2,IY0,IY1,
     1 IY2,COST,REVEN,IDIST,IROUT1,IPART1,IROW1,ICOL1,    IROUT2,
     2 IPART2,IROW2,ICOL2,    ISET,PART0,IP0,PART1,IP1,       ISEAT,
     3 COSTM,FACTOR,YIELD1,YIELD2,NPART, NSIZE,INY,IROW,ICOL,JROW,JCOL,
     4 KFREQ1,KFREQ2,CCOS,CREV,   SM1,SM2)
C
C              GIVEN THAT THERE IS A CHANGE IN TRAFFIC FLOW DUE TO
C              THE INTRODUCTION OF A CONNECT ROUTING OR A NEW ROUTE,
C              THIS SUBROUTINE TRACES OUT THE MARGINAL CHANGE IN
C              COST AND REVENUE OF THE ROUTES AFFECTED.
C
C                  OUTPUT: CCOS,CREV,KFREQ1,KFREQ2,PM,SM1,SM2
C                  INPUT: ALL THE REST
C              NTYPE    NO OF A/C TYPES IN FLEET
C              ITYPE    SEQUENCE NO OF A/C TYPE UNDER CONSIDERATION
C              SM1/2    CONTRIBUTION TOWARDS SYSTEM SEAT MILES FROM THE
C                       2 ROUTES COMPONENTS OF THE CONNECT ROUTING UNDER
C                       CONSIDERATION
C
      COMMON NCITY,NROW
      COMMON /FLEET/NTYPE,ITYPE
      DIMENSION ISEAT(NTYPE),COSTM(NTYPE)
      DIMENSION COST(NROW,MMSTOP),REVEN(NROW,MMSTOP)
      DIMENSION YIELD1(NPART),YIELD2(NPART)
      LOGICAL NEW
      INTEGER   ISET(NROW,MMSTOP)
      INTEGER   PART0(NROW,IP0),PART1(NROW,IP1)
      INTEGER   ROUT0(NCITY,IY0),ROUT1(NCITY,IY1),ROUT2(NCITY,IY2)
      INTEGER   IPAX(NCITY,NCITY),KROUT1(5),KROUT2(5),IDIST(NROW,MMSTOP)
      INTEGER   NSIZE(NROW,INY),LIST1(7,2),LIST2 (7,2),
     1           INDEX1(8),INDEX2(8)
      LOGICAL ITEST1
      LOGICAL ITEST2
C
C              ADJUST O-D DEMAND DUE TO CONNECT TRAFFIC
C
      I1=MIN0(I,K)
      I2=MAX0(I,K)
      J1=MIN0(K,J)
      J2=MAX0(K,J)
C
C              II,JJ DEFINED TO COMPLY WITH THE CONVENTION THAT I IS
C              ALWAYS LESS THAN J
C
      II=MIN0(I,J)
      JJ=MAX0(I,J)
C
      IPAX(I1,I2)=IPAX(I1,I2)+IPAX(II,JJ)
      IPAX(J1,J2)=IPAX(J1,J2)+IPAX(II,JJ)
C
C              IDENTIFY THE TWO ROUTES CARRYING THE CONNECT TRAFFIC
C
      ID1=MIN0(IROUT1,IPART1)
      IF(ID1 .EQ. IROUT1) GO TO 100
C
C              100 = THE CONNECT SEGMENT IS A ROUTE
C              FALL THROUGH = THE CONNECT SEGMENT IS PART OF A ROUTE
C
      CALL FIND(MMSTOP,    IROW1,IPART1,ICOL1,ISET,PART0,IP0,
     1 PART1,IP1,ROUT0,IY0,ROUT1,IY1,ROUT2,IY2,MM1,II1,II2,IROW,ICOL,
     2 KROUT1)
C                            !!!!!!!!!!
      GO TO 150
C
100   CALL FIND1(I1,I2,IROW1,ICOL1,ISET,MMSTOP,ROUT0,IY0,ROUT1,IY1,
     1 ROUT2,IY2,MM1,KROUT1)
C                            !!!!!!!!!!
      II1=I1
      II2=I2
      IROW=IROW1
      ICOL=ICOL1
C
C              MMI IS DEFINED JUST TO FACILITATE CALLING COSREV
C
150   MMI1=ICOL
C
      ID2=MIN0(IROUT2,IPART2)
      IF(ID2 .EQ. IROUT2) GO TO 200
C
      CALL FIND(MMSTOP,    IROW2,IPART2,ICOL2,ISET,PART0,IP0,
     1 PART1,IP1,ROUT0,IY0,ROUT1,IY1,ROUT2,IY2,MM2,JJ1,JJ2,JROW,JCOL,
     2 KROUT2)
C                            !!!!!!!!!!
      GO TO 250
C
200   CALL FIND1(J1,J2,IROW2,ICOL2,ISET,MMSTOP,ROUT0,IY0,ROUT1,IY1,
     1 ROUT2,IY2,MM2,KROUT2)
C
C                            !!!!!!!!!!
      JJ1=J1
      JJ2=J2
      JROW=IROW2
      JCOL=ICOL2
250   MMI2=JCOL
C
C
C              LOGICAL VARIABLE SET TO INDICATE THAT COSREV IS CALLED
C              TO REASSESS AN ALREADY ACCEPTED RTE DUE TO CHANGES IN
C             TRAFFIC DISTRIBUTION
C
      NEW=.FALSE.
C
      CALL COSREV(NEW,ISEAT,COSTM,FACTOR,II1,II2,IROW,MM1,ICOL,
     1 ISET,KROUT1,PART0,IP0,PART1,IP1,YIELD1,YIELD2,NPART,IPAX,IDIST,
     2 NSIZE,INY, KFREQ1,MLL1,LIST1,ITEST1,INDEX1,COS1,REV1,PM1,SM1)
C                            !!!!!!!!!!
C
      CALL COSREV(NEW,ISEAT,COSTM,FACTOR,JJ1,JJ2,JROW,MM2,JCOL,
     1 ISET,KROUT2,PART0,IP0,PART1,IP1,YIELD1,YIELD2,NPART,IPAX,IDIST,
     2 NSIZE,INY, KFREQ2,MLL2,LIST2,ITEST2,INDEX2,COS2,REV2,PM2,SM2)
C                            !!!!!!!!!!
C
C              COMPUTE MARGINAL CHANGE IN FREQUENCY, COST AND REVENUE
C
      CALL DIFFER(IROW,ICOL,COS1,COST,REV1,REVEN,DCOS1,DREV1)
C                            !!!!!!!!!!
      CALL DIFFER(JROW,JCOL,COS2,COST,REV2,REVEN,DCOS2,DREV2)
C                            !!!!!!!!!!
      CCOS=DCOS1+DCOS2
C
C +++++ ASSUMPTION -
C              A CONNECT FARE IS TAKEN TO BE A 'JOINT FARE' - I.E. THE
C              SAME AS A DIRECT SERVICE FARE.
C
C              TO CHARGE A 'POINT TO POINT FARE' - I.E. A FARE FOR EACH
C              OF THE CONNECTING FLIGHTS, CHANGE THE FOLLOWING
C              STATEMENTS TO THE STATEMENT MARKED C +
C
      CREV=REVENU(YIELD1,YIELD2,NPART,IPAX,II,JJ)
C
C +   CREV=DREV1+DREV2
C
C              RESTORE IPAX
C
      IPAX(I1,I2)=IPAX(I1,I2)-IPAX(II,JJ)
      IPAX(J1,J2)=IPAX(J1,J2)-IPAX(II,JJ)
      RETURN
      END
      SUBROUTINE OUTPUT(IOUT,MM,IY0,IY1,IY2,IDIST,       ROUT0,
     1  ISIZE,ISET,ROUT1,ROUT2,PART0,PART1,NSIZE,     COST,NFREQ,
     2        MMYY,  REVEN,IP0,IP1,INY,ICODE,KCODE,LCODE)
C
      COMMON NCITY, NROW
      COMMON /SET/IREAD,IREAD1,IREAD2,IWRITE
      DOUBLE PRECISION RPM,ASM
      COMMON /SYSTEM/RPM,ASM
C
C              REVEN IS FOR TEMPORARY USE ONLY
C
      DIMENSION REVEN(NROW,MMYY  ),COST(NROW,MMYY  )
      DIMENSION ICODE(NCITY),KCODE(IY2),LCODE(IY2)
C
C              THE DIMENSION OF IY2 IS CHOSEN SO THAT A FULL SIZE ROW
C              OF ALPHA CODES CAN CORRESPOND TO A FULL SIZE ROW OF
C              ROUT0/1/2.
C
      INTEGER   ISET(NROW,MMYY)
      INTEGER   PART0(NROW,IP0),PART1(NROW,IP1)
      INTEGER   ROUT0(NCITY,IY0),ROUT1(NCITY,IY1),ROUT2(NCITY,IY2)
      INTEGER   NSIZE(NROW,INY),ISIZE(NCITY,MMYY  ),IDIST(NROW,MMYY )
      INTEGER   NFREQ(NROW,MMYY)
C
      GO TO (1000,2000,3000), IOUT
C
1000  RETURN
C
C              THE FOLLOWING BLOCK OF CODE IS REPEATED 3 TIMES FOR
C              MM = 0/1/2.  COULD PUT INTO A SUBROUTINE AFTER OUTPUT
C              IS FINALIZED
C
2000  WRITE(IWRITE,260)
260   FORMAT(////// ' NONSTOP ROUTES & ROUTINGS' //)
      WRITE(IWRITE,610)
610   FORMAT(/// 10X, ' ISIZE ---', 10X, ' ROUT0 ---' //)
      DO 630 IR0=1,NCITY
      LR0=ISIZE(IR0,1)
      KCODE(1)=IR0
      CALL CODES(KCODE,1,ICODE,NCITY,LCODE)
      WRITE(IWRITE, 100) LCODE(1), (ISIZE(IR0,JSE),JSE=1,MMYY) 
C
C              TO AVOID LR0 BEING ZERO
C
      LR0=MAX0(LR0,1)
      WRITE(IWRITE,150) (ROUT0(IR0,JR0),JR0=1,LR0)
      DO 500 K0=1,LR0
500   KCODE(K0)=ROUT0(IR0,K0)
      CALL CODES(KCODE,LR0,ICODE,NCITY,LCODE)
630   WRITE(IWRITE,200) (LCODE(L0),L0=1,LR0)
C
      GO TO 4000
C
C
3000  WRITE (IWRITE,85) MM
85    FORMAT(/////// I3, '-STOP ROUTES & ROUTINGS' //)
C
      MMAX=MM+1
C
      GO TO (8100,8200,8300), MM
8100  WRITE(IWRITE,8150)
8150  FORMAT(/// 10X, ' ISIZE ---', 10X, ' ROUT1 ---' //)
      DO 8170 IR1=1,NCITY
      LR1=ISIZE(IR1,MMAX)*MMAX
      KCODE(1)=IR1
      CALL CODES(KCODE,1,ICODE,NCITY,LCODE)
      WRITE(IWRITE, 100) LCODE(1), (ISIZE(IR1,JSE),JSE=1,MMYY)
C
C              TO AVOID LR1 BEING ZERO
C
      LR1=MAX0(LR1,1)
      WRITE(IWRITE,150) (ROUT1(IR1,JR1),JR1=1,LR1)
      DO 700 K1=1,LR1
700   KCODE(K1)=ROUT1(IR1,K1)
      CALL CODES(KCODE,LR1,ICODE,NCITY,LCODE)
8170  WRITE(IWRITE,200) (LCODE(L1),L1=1,LR1)
      GO TO 8300
C
8200  WRITE(IWRITE,8250)
8250  FORMAT(/// 10X, ' ISIZE ---', 10X, ' ROUT2 ---' //)
      DO 8270 IR2=1,NCITY
      LR2=ISIZE(IR2,MMAX)*MMAX
      KCODE(1)=IR2
      CALL CODES(KCODE,1,ICODE,NCITY,LCODE)
      WRITE(IWRITE, 100) LCODE(1),(ISIZE(IR2,JSE),JSE=1,MMYY)
C
C              TO AVOID LR2 BEING ZERO
C
      LR2=MAX0(LR2,1)
      WRITE(IWRITE,150) (ROUT2(IR2,JR2),JR2=1,LR2)
      DO 1100 K2=1,LR2
1100  KCODE(K2)=ROUT2(IR2,K2)
      CALL CODES(KCODE,LR2,ICODE,NCITY,LCODE)
8270  WRITE(IWRITE,200) (LCODE(L2),L2=1,LR2)
C
      WRITE(IWRITE,9800)
9800  FORMAT(/// 10X, ' PART1 ---' //)
      DO 9700 IRI=1,NROW
      CALL PAIR(IRI,I2,J2)
      KCODE(1)=I2
      KCODE(2)=J2
      CALL CODES(KCODE,2,ICODE,NCITY,LCODE)
9700  WRITE(IWRITE,8900) LCODE(1),LCODE(2), (PART1(IRI,JR),JR=1,IP1)
C
8300  WRITE(IWRITE,8700)
8700  FORMAT(/// 10X, 'PART0 ---' //)
      DO 8800 ILE=1,NROW
      CALL PAIR(ILE,I1,J1)
      KCODE(1)=I1
      KCODE(2)=J1
      CALL CODES(KCODE,2,ICODE,NCITY,LCODE)
8800  WRITE(IWRITE,8900) LCODE(1),LCODE(2), (PART0(ILE,JL),JL=1,IP0)
C
4000  WRITE(IWRITE,300)
300   FORMAT( /// 25X, ' IDIST ---', 25X, ' ISET --- ', 15X,
     1 ' NFREQ ---', 20X, ' NSIZE ---' //)
      DO 450 IDI=1,NROW
      CALL PAIR(IDI,I4,J4)
      KCODE(1)=I4
      KCODE(2)=J4
      CALL CODES(KCODE,2,ICODE,NCITY,LCODE)
450   WRITE(IWRITE,400) IDI,LCODE(1),LCODE(2),(IDIST(IDI,JI),JI=1,MMYY),
     1(ISET(IDI,JIS),JIS=1,MMYY),(NFREQ(IDI,JN),JN=1,MMYY),
     2 (NSIZE(IDI,JNS),JNS=1,INY)
      WRITE(IWRITE,800)
800   FORMAT(/// 20X, ' COST --- ', 40X, ' REVENUE ---' //)
      DO 850 IC=1,NROW
      CALL PAIR(IC,I3,J3)
      KCODE(1)=I3
      KCODE(2)=J3
      CALL CODES(KCODE,2,ICODE,NCITY,LCODE)
850   WRITE(IWRITE,900) LCODE(1),LCODE(2), (COST(IC,JC),JC=1,MMYY),
     1 (REVEN(IC,JRE),JRE=1,MMYY)
C
C
      WRITE(IWRITE,950)
950   FORMAT(/// ' SYSTEM SUMMARY STATISTICS ---' )
      WRITE(IWRITE,1050) RPM
1050  FORMAT(// 10X, ' REVENUE PASSENGER MILES =', F15.0 )
      WRITE(IWRITE,1150) ASM
1150  FORMAT(10X, ' AVAILABLE SEAT MILES =', F15.0 )
      RATIO=RPM/ASM
      WRITE(IWRITE,1250) RATIO
1250  FORMAT(10X, ' SYSTEM LOAD FACTOR=', F5.3)
C
C
100   FORMAT( ' ', 4X, A4, 2X, 3I4, 8X )
150   FORMAT( '+', (30X,24I4) )
200   FORMAT(32X, 24A4)
8900  FORMAT(7X, A4, ' - ', A4, 2X, 10I10)
400   FORMAT(I5,3X,A4,' - ',A4, 6X, 3I8, 11X, 3I5, 10X, 3I6, 12X, 2I8)
900   FORMAT(5X, A4, ' - ', A4,4X, 3F10.3, 20X, 3F10.3)
C
9000  RETURN
      END
      SUBROUTINE PRINT1(             NTYPE,KTYPE,ISEAT,SPEED1,SPEED2,
     1 RANGE,COSTM,      ICODE,ITYPE,MSTOP,FACTOR,YIELD1,YIELD2,NPART,
     2 LEVEL,MART)
C
C              THIS SUBROUTINE ECHO PRINTS THE AIRCRAFT, SYSTEM,
C              AIRPORT AND YIELD DATA INPUTTED IN INPUT1
C
C              THE ENTIRE ARGUMENT LIST CONTAINS INPUTS TO BE PRINTED
C
C              NTYPE    NO. OF AIRCRAFT TYPES
C              KTYPE    ARRAY STORING A/C LABELS
C              ISEAT    ARRAY STORING THE SEAT CAPACITIES OF A/C TYPES
C              SPEED1/2 ARRAYS STORING THE 2 SPEED COEFF'S OF A/C TYPES
C              RANGE    ARRAY STORING THE RANGES OF A/C'S
C              COSTM    ARRAY STORING THE D.O.C/BLK MINUTE 'S FOR A/C'S
C              ICODE    ARRAY STORING ALPHAMERIC AIRPORT CODES
C              ITYPE    AIRCRAFT TYPE USED FOR THE CURRENT RUN
C              MSTOP    NO. OF INTERMEDIATE STOPS IN THE LONGEST ROUTE
C              FACTOR   AVG LOAD FACTOR ON EACH SEGMENT OF A FLIGHT
C              YIELD    ARRAY STORING PAIRS OF YIELD/PAX COEFFICIENTS
C              NPART    NO. OF YIELD/PAX COEFF PAIRS STORED IN YIELD
C              LEVEL    DEGREE OF OPTIMISM IN DEMAND FORECAST
C              MART     TYPE OF MARKET ( NONCOMPETITIVE - 0
C                                        COMPETITIVE - 1 )
C
      COMMON NCITY,NROW
      COMMON /SET/IREAD,IREAD1,IREAD2,IWRITE
      COMMON /EARN/GAIN
C
C              GAIN     PROFIT MARGIN IN % ABOVE D.O.C.
C
      DIMENSION KTYPE(NTYPE),ISEAT(NTYPE),SPEED1(NTYPE),SPEED2( NTYPE),
     1 RANGE(NTYPE),COSTM(NTYPE),YIELD1(NTYPE),YIELD2(NTYPE)
      DIMENSION ICODE(NCITY)
C












C              TITLE
C
      WRITE(IWRITE,100)
100   FORMAT(
     1 'ROUTE IMPROVEMENT, SYNTHESIS AND EVALUATION MODEL - R.I.S.E',/)
C
C              FLEET DATA
C
      WRITE(IWRITE,200)
200   FORMAT(//  ' VEHICLE FLEET ---' /)
      WRITE(IWRITE,300)
300   FORMAT(' VEHICLE TYPE',3X, ' SEATS',5X, ' SPEED COEFF.',4X,
     1 ' RANGE',3X, ' D.O.C./BLK HR' /)
      DO 400 IT=1,NTYPE
C
C              CONVERTING COST PER MINUTE BACK TO COST PER BLOCK HR
C
      CHR=COSTM(IT)*60.
400   WRITE(IWRITE,500) KTYPE(IT),ISEAT(IT),SPEED1(IT),SPEED2(IT),
     1 RANGE(IT),CHR
500   FORMAT(2I10,4F10.3)
C
C              SYSTEM DATA
C
      WRITE(IWRITE,800)
800   FORMAT(// ' SYSTEM RUN PARAMETERS ---'/)
      WRITE(IWRITE,900) ITYPE
900   FORMAT(5X,  ' VEHICLE TYPE=',I4)
      WRITE(IWRITE,1000) MSTOP
1000  FORMAT(5X, ' NO. OF INTERMEDIATE STOPS IN THE LONGEST ROUTE=',I2)
      WRITE(IWRITE,1050) LEVEL
1050  FORMAT(5X,' DEGREE OF OPTIMISM IN DEMAND FORECAST = LEVEL ', I1,
     1 ' OF 4 CLASSES ( 0 - LEAST, TO, 3 - MOST )' )
      MART1=MART+1
      GO TO (1110,1120), MART1
1110  WRITE(IWRITE,1115)
1115  FORMAT(5X, ' TYPE OF STOP PAIR MARKET = NONCOMPETITIVE (0) ' )
      GO TO 1140
1120  WRITE(IWRITE,1125)
1125  FORMAT(5X, ' TYPE OF STOP PAIR MARKET = COMPETITIVE (1) ' )
1140  WRITE(IWRITE,1100) FACTOR
1100  FORMAT(5X, ' AVERAGE LOAD FACTOR ON EACH ROUTE SEGMENT=',F8.5)
      WRITE(IWRITE,1145) GAIN
1145  FORMAT(5X, ' A ROUTE HAS TO YIELD REVENUE AT', F10.3, ' % ABOVE
     1D.O.C. BEFORE IT IS ACCEPTED IN THE ROUTE NETWORK' )
C
C              AIRPORT DATA
C
      WRITE(IWRITE,550)
550   FORMAT(//    ' STOPS ---'/)
      DO 600 IC=1,NCITY
600   WRITE(IWRITE,700) IC, ICODE(IC)
700   FORMAT(I10,5X,A4)
C
C              YIELD DATA
C
      WRITE(IWRITE,1150)
1150  FORMAT(// ' ON THE REVENUE SIDE ---' /)
      DO 1300 IYI=1,NPART
1300  WRITE(IWRITE,1200) YIELD1(IYI),YIELD2(IYI)
1200  FORMAT(10X,' YIELD/PAX =',F8.4, ' + ',F7.5, '*DISTANCE')
      RETURN
      END
      FUNCTION RMILES(TIME,MM,SPEEDX,SPEEDY)
C
C              GIVEN THE TIME DISTANCE OF AN MM-STOP ROUTE/ROUTING IN
C              BLOCK MINUTES, THIS ROUTINE CONVERTS IT INTO MILEAGE
C              DISTANCE
C
C              INPUT:
C
C              SPEEDX/Y THE PAIR OF SPEED COEFF'S FOR THE A/C TYPE UNDER
C                       CONSIDERATION
C              TIME     THE GIVEN DISTANCE IN MINUTES
C
      REAL*8 TAIR
C
      MMAX=MM+1
C
C              TAKE BLK TIME ON GROUND OFF
C
      TAIR=TIME-MMAX*SPEEDX
C
C              CONVERT TIME IN AIR BACK TO MILEAGE
C
      RMILES=TAIR/SPEEDY
      RETURN
      END
      SUBROUTINE ROUTES(MM,MMAX,INY,MMSTOP,ROUT,NR,ROUTX,NRX,ROUTY,
     1  NRY,REVEN,COST,YIELD1,YIELD2,NPART,ISET,PART0,IP0,PART1,IP1,
     2KROUT,KKROUT,IRESTR,MIDDLE,LMID,MLIMIT,LLIM,
     3 ISIZE,IDIST,NFREQ,IPAX,NSIZE,MNUM,ITEMP,JTEMP,MTEMP,LCITY,ISEAT,
     4 COSTM,FACTOR,SPEED1,SPEED2,KROW,KROW1,KROW2)
C
C              THIS SUBROUTINE GENERATES MULTISTOP ROUTES. FROM A
C              PROGRAMMING POINT OF VIEW, MAKING ROUTES A SUBPROGRAM
C              RATHER THAN PART OF MAIN ALLOWS US TO SAVE DEFINING
C              A SCRATCH PAD ARRAY ROUT, HENCE SAVING CORE.
C
C              NOTE - INY IS THE SAME AS MSTOP
C                     KROW,KROW1/2 ARE RETURNED TO MAIN TO FACILITATE
C                     CALLING TAB
C
C              INPUT:
C
C              NPART    NO OF SEGMENTS IN YIELD EQUATION
C              YIELD1/2 ARRAYS STORING COEFF'S FOR THE YIELD EQNS
C              NTYPE    NO OF A/C TYPES IN FLEET
C              ITYPE    SEQUENCE NO OF A/C TYPE UNDER CONSIDERATION
C              SPEED1/2 ARRAYS STORING SPEED COEFF'S FOR EACH A/C TYPE
C
      COMMON NCITY,NROW
      COMMON /FLEET/NTYPE,ITYPE
      DIMENSION ISEAT(NTYPE),COSTM(NTYPE),SPEED1(NTYPE),SPEED2(NTYPE)
      DIMENSION REVEN(NROW,MMSTOP),COST(NROW,MMSTOP)
      DIMENSION YIELD1(NPART),YIELD2(NPART)
      INTEGER   ROUT(NCITY,NR),ROUTX(NCITY,NRX),ROUTY(NCITY,NRY)
      INTEGER   ISET(NROW,MMSTOP),PART0(NROW,IP0),PART1(NROW,IP1)
      INTEGER   IRESTR(NCITY,NCITY),MIDDLE(LMID),MLIMIT(LLIM)
      INTEGER   ISIZE(NCITY,MMSTOP),IDIST(NROW,MMSTOP)
      INTEGER   IPAX(NCITY,NCITY),NSIZE(NROW,INY),NFREQ(NROW,MMSTOP)
      INTEGER   KROUT(5),KKROUT(5)
C
C             THE 3 DO LOOPS I, J AND K
C
      DO 8000 I=1,LCITY
      IF (ISIZE(I,MM) .EQ. 0) GO TO 8000
      JLOW=I+1
      DO 7500 J=JLOW,NCITY
C
C              DEFINE THE ROW NO. OF SET COVERING TABLEAU
C
      IROW=MROW(I,J)
C
C             KMIN = LOWER LIMIT OF THE POINTER TO INDIVIDUAL ROUTE
C                  BLOCK (I,K) IN ROW I OF ROUT-M
C
C             THE ROUTE BLOCKS IN ROW I NEED TO BE SEARCHED ONLY ONCE
C             FOR EVERY I-J
C
      KMIN=1
C
C             L = UPPER LIMIT OF POINTER
C              THE FOLLOWING STATEMENT COULD BE PLACED RIGHT AFTER
C              STAT. NO. 800
C
      L=ISIZE(I,MM)
	 DO 7000 K=1,NCITY
      IF(I .EQ. K .OR. K .EQ. J) GO TO 7000
      IK=IENTRY(.TRUE.,I,K,IRESTR,NCITY)
      KJ=IENTRY(.TRUE.,K,J,IRESTR,NCITY)
      IF(IK .EQ. 3 .OR. KJ .EQ. 3) GO TO 7000
C
C             PICK QUALIFIED BASIC ROUTE SEGMENTS STARTING AT
C             K AND ENDING AT J
C
C
C        NOTICE THE 5 DO LOOPS MM, I, J, K AND KK, CORRESPONDING
C        TO THE NO. OF STOPS, THE ORIGIN CITY, THE DESTINATION CITY,
C        THE CONNECTING CITY AND THE NO. OF ROUTES SERVING FROM I TO K
C
C               IROW1 = ROW NO. OF ROUTE BLOCK (I,K) IN IDIST
C               IROW2 = ROW NO. OF ROUTE LINK (K,J) IN IDIST
C
C              DUMMY VARIABLES DEFINED FOR CALLING MMROW
C
      IM=I
      KM=K
      JM=J
      IROW1=MMROW(IM,KM)
      IROW2=MMROW(KM,JM)
C
C        PICK OUT ALL EXISTING M-STOP ROUTES BEGINNING AT I AND
C        ENDING AT K
C
C        CHECK CONNECTING CITY K
C
940   DO 6000 KK=KMIN,L
C
      GO TO (810,820), MM
C
C              810 = ROUT/ROUTX/ROUTY EQUATED TO ROUT0/1/2
C              820 = ROUT/ROUTX/ROUTY EQUATED TO ROUT1/2/0
C
810   CALL TAB(I,J,ITEMP,JTEMP,MTEMP,KROW,KROW1,KROW2,MMSTOP,NR,
     1 NRX,NRY,IP0,IP1,INY,KROUT,KKROUT,ISIZE,ROUT,ROUTX,ROUTY,IPAX,
     2 ISEAT,COSTM,FACTOR,YIELD1,YIELD2,NPART,IRESTR,IDIST,PART0,PART1,
     3 NSIZE,ISET,NFREQ,SPEED1,SPEED2,COST,REVEN)
C                            !!!!!!!!!!
      GO TO 830
C
820   CALL TAB(I,J,ITEMP,JTEMP,MTEMP,KROW,KROW1,KROW2,MMSTOP,NRY,NR,
     1 NRX,IP0,IP1,INY,KROUT,KKROUT,ISIZE,ROUTY,ROUT,ROUTX,IPAX,ISEAT,
     2 COSTM,FACTOR,YIELD1,YIELD2,NPART,IRESTR,IDIST,PART0,PART1,NSIZE,
     3 ISET,NFREQ,SPEED1,SPEED2,COST,REVEN)
C                            !!!!!!!!!!
C
C
830   KKK=MM*KK
      IF (ROUT(I,KKK) .GT. K) GO TO 6900
C
C             ALL ROUTE BLOCK AFTER THIS WOULD CONTAIN A 'K' GREATER
C             THAN K SPECIFIED
C
C             UPDATE LOWER LIMIT TO START NEXT SEARCH FROM THIS ROUTE
C             BLOCK FOR (K+1)
C
      IF (ROUT(I,KKK) .NE. K)  GO TO 6000
      L1=KKK-MM+1
      L2=KKK-1
C
C
C
C              KKR/JROW1/JROW2 ARE DEFINED FOR RECORDING THE 'OTHER'
C              TRANSFER STATION:   I-(KKR)-.-J
C
      KKR=K
C
C              IT/JT/KT HAVE TO BE DEFINED FOR CALLING MMROW
C
      IT=I
      JT=J
      KT=K
      JROW1=MMROW(JT,KT)
      JROW2=MMROW(KT,IT)
C
C              IF (I,J) IS AN ILLEGAL RTE,
C                    RECORD THE ROUTING IF REQUIRED
C
      IF (IRESTR(I,J) .EQ. 3) GO TO 750
C
C              750 = (I,J) RESTRICTED, CONSIDER PAX ROUTING
C
      GO TO 755
C
C              755 = (I,J) NOT RESTRICTED, RESUME NORMAL ROUTE SYNTHESIS
C
C
750   CALL CONNET(MMSTOP,MM,IROW,IROW1,IROW2,JROW1,JROW2,I,J,K,KKR,
     1 IPAX,ROUT,NR,ROUTX,NRX,ROUTY,NRY,COST,REVEN,NFREQ,
     2 IDIST,ISET, PART0,IP0,PART1,IP1,INY,ISEAT,COSTM,FACTOR,YIELD1,
     3 YIELD2,NPART,NSIZE,SPEED1,SPEED2)
C                       !!!!!!!!!!
      GO TO 6000
C
C          CHECK IF IRESTR(I,J) IS 51
C
755   IF(IRESTR(I,J) .NE. 51 .AND. IRESTR(I,J) .NE. 5) GO TO 3500
      LL=L1-1
C
C                  !!!!!!!!!!!
C
      CALL CODE51(MNUM,NR,LMID,LLIM,LL,I,I,J,KKK,IR,ROUT,MIDDLE,
     1   MLIMIT)
C
C                  !!!!!!!!!!!
C
2700  IF(IR .EQ. 0) GO TO 850
C
C              850 = CONSIDER PAX ROUTING, SINCE PRESENT (I,K) RTE
C        BLOCK IS NOT QUALIFIED TO TAG ONTO J ACCORDING TO THE 51
C        RESTRICTION OF CITY PAIR (I,J)
C
      GO TO 3500
C
C
850   CALL CONNET(MMSTOP,MM,IROW,IROW1,IROW2,JROW1,JROW2,I,J,K,KKR,
     1 IPAX,ROUT,NR,ROUTX,NRX,ROUTY,NRY,COST,REVEN,NFREQ,
     2 IDIST,ISET, PART0,IP0,PART1,IP1,INY,ISEAT,COSTM,FACTOR,YIELD1,
     3 YIELD2,NPART,NSIZE,SPEED1,SPEED2)
C                       !!!!!!!!!!
      GO TO 6000
3500  IF(MM .LT. 2) GO TO 890
      DO 4000 LL=L1,L2
C
C        CHECK THAT THE RESTRICTION CODES BETWEEN THE INTERMEDIATE
C        CITIES AND J ARE NOT VIOLATED
C
      IMM=ROUT(I,LL)
      IF(ROUT(I,LL) .EQ. J) GO TO 6000
      IMMJ=IENTRY(.TRUE.,IMM,J,IRESTR,NCITY)
      IF(IMMJ .EQ. 3) GO TO 860
      GO TO 870
C
860   CALL CONNET(MMSTOP,MM,IROW,IROW1,IROW2,JROW1,JROW2,I,J,K,KKR,
     1 IPAX,ROUT,NR,ROUTX,NRX,ROUTY,NRY,COST,REVEN,NFREQ,
     2 IDIST,ISET, PART0,IP0,PART1,IP1,INY,ISEAT,COSTM,FACTOR,YIELD1,
     3 YIELD2,NPART,NSIZE,SPEED1,SPEED2)
C                       !!!!!!!!!!
      GO TO 6000
C
C        CODE 51
C         IF ANY . EXISTS IN THE ITINERARY SUCH THAT IRESTR(.,K) IS 51,
C         CHECK THAT THE INTERMEDIATE STOPS ARE LEGAL
C
870   IF(IMMJ .NE. 51 .AND. IMMJ .NE. 5) GO TO 4000
C
C                  !!!!!!!!!!!
C
      CALL CODE51(MNUM,NR,LMID,LLIM,LL,IMM,I,J,KKK,IR,ROUT,MIDDLE,
     1   MLIMIT)
C
C                  !!!!!!!!!!!
C
3600  IF(IR .EQ. 0) GO TO 880
C
C        IR IS A SWITCH RETURNED FROM SUBROUTINE CODE51,
C             WHERE IR= 1 IF A ROUTE IS QUALIFIED
C                       0 OTHERWISE
C
C
C              880 = CONSIDER STORING PAX ROUTING, SINCE PRESENT (I,K)
C             BLOCK IS NOT QUALIFIED TO TAG ONTO J, ACCORDING TO
C             THE 51 RESTRICTION OF CITY PAIR (.,J)
C
      GO TO 4000
C
C
880   CALL CONNET(MMSTOP,MM,IROW,IROW1,IROW2,JROW1,JROW2,I,J,K,KKR,
     1 IPAX,ROUT,NR,ROUTX,NRX,ROUTY,NRY,COST,REVEN,NFREQ,
     2 IDIST,ISET, PART0,IP0,PART1,IP1,INY,ISEAT,COSTM,FACTOR,YIELD1,
     3 YIELD2,NPART,NSIZE,SPEED1,SPEED2)
C                       !!!!!!!!!!
      GO TO 6000
4000  CONTINUE
C
C              THE CONNECT ROUTING ALGORITHM REQUIRES THIS CHECK TO BE
C              DEFERRED UNTIL NOW
C
890   KJ=IENTRY(.TRUE.,K,J,IRESTR,NCITY)
      IF(KJ .EQ. 51 .OR. KJ .EQ. 5) GO TO 7000
      IF(KJ .EQ. 2) GO TO 7000
C
C              ROUTE DISTANCE
C
C             CHECK CIRCUITY
C
      ID= IDIST(IROW1,MM)+IDIST(IROW2,1)
C
C++++++++++    ONLY THE SHORTEST ROUTE CONSIDERED
C
      IF(ID .GE. IDIST(IROW,MMAX)) GO TO 6000
C
C              RECORD ROUTE DISTANCE
C
      IDIST(IROW,MMAX)=ID
C
C              KEEP VITAL INFORMATION FOR FUTURE TABULATION
C              IN THE EVENT THIS ROUTE IS INDEED THE SHORTEST ROUTE
C
C
C              KROW/JTEMP/ITEMP/MTEMP DEFINED FOR IROW/J/I/MM  TO
C              FACILITATE THE SHORTEST ROUTE ALGORITHM
C
      KROW=IROW
      KROW1=IROW1
      KROW2=IROW2
      JTEMP=J
      ITEMP=I
      MTEMP=MM
C
C        IF QUALIFIED, SYNTHESIZE (M+1)STOP ROUTE AND STORE IN TEMPORARY
C        ARRAY KROUT
C
      DO 900 KDUM=1,MM
      KKDUM=KDUM+KKK-MM
      KKROUT(KDUM+1) = ROUT(I,KKDUM)
900   KROUT(KDUM)=ROUT(I,KKDUM)
      KKROUT(1) = I
      KKROUT(MM+2)=J
      KROUT(MM+1)=J
C
C
C             LOOPING AROUND EACH ROUTE BLOCK (I,K)
C
6000  CONTINUE
C
C              SET LOWER LIMIT IN ROW ROUT(I) FOR SEARCHING A MATCHING
C              ROUTE BLOCK (I,...,K) TO THE NEW PIVOT K
C
6900  KMIN=KK
C
C        LOOPING AROUND CONNECTION CITY K
C
7000  CONTINUE
C
C              THE FOLLOWING 'IF' STATEMENT IS SPECIFIC TO MM=2
C                FOR MM .GT. 2, CHANGE CODING IN KFORE & KKFORE
C
      IF(MM .LT. 2) GO TO 7500
C
C        LOOPING AROUND TERMINATION CITY J
C
7500  CONTINUE
C
C        LOOPING AROUND ORIGIN CITY I
C
8000  CONTINUE
      RETURN
      END
      SUBROUTINE TAB(I,J,ITEMP,JTEMP,MTEMP,KROW,KROW1,KROW2,MMSTOP,
     1 IY0,IY1,IY2,IP0,IP1,INY,KROUT,KKROUT,ISIZE,ROUT0,ROUT1,ROUT2,
     2 IPAX,ISEAT,COSTM,FACTOR,YIELD1,YIELD2,NPART,IRESTR,IDIST,
     3 PART0,PART1,NSIZE,ISET,NFREQ,SPEED1,SPEED2,COST,REVEN)
C
C              THIS SUBROUTINE IS WRITTEN TO FACILITATE THE TABULATION
C              PROCEDURE OF THE SHORTEST ROUTE ALGORITHM.
C              IT IS CALLED BY (1)ROUTES, & (2)ARCS.
C              IT CALLS  OTHER SUBROUTINES TO TABULATE ROUTM,ISET,
C                PART0,PART1 ETC.FOR THE SHORTEST ROUTE.
C
C                  OUTPUT : COST,REVEN
C                  I & O : ISET,NFREQ,PART0,PART1,NDIST,ROUT,ROUT1/2
C                  INPUT : THE REST
C              NTYPE    NO OF A/C TYPES IN FLEET
C              ITYPE    SEQUENCE NO OF A/C TYPE UNDER CONSIDERATION
C              SPEED1/2 ARRAYS STORING THE PAIR OF SPEED COEFF'S FOR
C                       EACH A/C TYPE
C              YIELD1/2 ARRAYS STORING COEFF'S FOR THE YIELD EQNS
C              NPART    NO OF SEGMENTS IN YIELD EQUATION
C
      COMMON NCITY, NROW
      COMMON /FLEET/NTYPE,ITYPE
      DOUBLE PRECISION RPM,ASM
      COMMON /SYSTEM/RPM,ASM
      DIMENSION ISEAT(NTYPE),COSTM(NTYPE),SPEED1(NTYPE),SPEED2(NTYPE)
      DIMENSION                    COST(NROW,MMSTOP),REVEN(NROW,MMSTOP)
      DIMENSION YIELD1(NPART),YIELD2(NPART)
      LOGICAL DECIDE,D,NEW
      INTEGER   IRESTR(NCITY,NCITY)
      INTEGER   ISET(NROW,MMSTOP)
      INTEGER   PART0(NROW,IP0),PART1(NROW,IP1)
      INTEGER   KROUT(5),KKROUT(5),IROUT(5),ISIZE(NCITY,MMSTOP)
      INTEGER   ROUT0(NCITY,IY0)
      INTEGER                  ROUT1(NCITY,IY1),ROUT2(NCITY,IY2)
      INTEGER   NSIZE(NROW,INY),IPAX(NCITY,NCITY),
     1 IDIST(NROW,MMSTOP),NFREQ(NROW,MMSTOP)
      INTEGER   LIST(7,2),MINDEX(8)
      LOGICAL ITEST(7)
C
C              THE FOLLOWING STATEMENTS ( UP TO STAT.NO.(960-1) )
C              ARE FOR TABULATING THE SHORTEST ROUTE FOUND IN THE
C              LAST LOOP OF I-J
C
C
C
C              TO WAIVE THE CIRCUITY SCREENING,
C               1. TURN INTO COMMENT STATEMENTS MARKED BY ++++++++++
C               2. EQUATE KROW/ITEMP/JTEMP/MTEMP TO IROW/I/J/MM BELOW
C
C++++++++++    TO TABULATE THE TABLES ROUT., ISET, ... ONLY AS NECESSARY
C
      IF (JTEMP .EQ. J .AND. ITEMP .EQ. I) GO TO 960
C
C              THE FOLLOWING CHECK IS SPECIFICALLY DESIGNED FOR
C              PREVENTING A ROUTE CANDIDATE FROM BEING REDUNDANTLY
C              TABULATED
C
      IF(KKROUT(1) .EQ. 0) GO TO 960
C
C              960 = STILL SEARCHING AMONG K AND KK FOR THE
C                    SHORTEST ROUTE I-.-K-J
C
C              THE FOLLOWING STEPS  EXECUTED ONLY WHEN AFTER
C              SHORTEST ROUTE FOUND
C
C
C              TO FLIP THE ROUTE CANDIDATE IN KKROUT OVER
C
C
C                  !!!!!!!!!!
C
      CALL MIRROR(MTEMP,KKROUT,IROUT)
C
C                  !!!!!!!!!!
C
C
C        STORE SYNTHESIZED ROUTE IN ROUT (M+1)
C
C
C              IMAX DEFINED TO FACILITATE MIN-PATH ALGORITHM
C
      IMAX=MTEMP+1
950   GO TO (1000,2000), MTEMP
C
C
C              1000/2000 = SYNTHESIZING 1/2 -STOP ROUTES
C
1000  K1=IMAX*ISIZE(ITEMP,IMAX)
      K10=IMAX*ISIZE(JTEMP,IMAX)
      DO 1100 KK1=1,IMAX
      KK1DUM=K1+KK1
      KK10=K10+KK1
      ROUT1(JTEMP,KK10)=IROUT(KK1+1)
1100  ROUT1(ITEMP,KK1DUM)=KROUT(KK1)
      ISIZE(ITEMP,IMAX)=ISIZE(ITEMP,IMAX)+1
      ISIZE(JTEMP,IMAX)=ISIZE(JTEMP,IMAX)+1
1500  GO TO 4900
2000  K2=IMAX*ISIZE(ITEMP,IMAX)
      K20=IMAX*ISIZE(JTEMP,IMAX)
      DO 1200 KK2=1,IMAX
      KK2DUM=K2+KK2
      KK20=K20+KK2
      ROUT2(JTEMP,KK20)=IROUT(KK2+1)
1200  ROUT2(ITEMP,KK2DUM)=KROUT(KK2)
      ISIZE(ITEMP,IMAX)=ISIZE(ITEMP,IMAX)+1
      ISIZE(JTEMP,IMAX)=ISIZE(JTEMP,IMAX)+1
C
C              KTEMP DEFINED FOR CALLING FORE, KFORE AND BACK
C
4900  KTEMP=KKROUT(IMAX)
C ..........
C
C              CHECK ROUTE RESTRICTION CODE 4
C
      IF(IRESTR(ITEMP,JTEMP) .EQ. 4) GO TO 700
C
C              FALL THROUGH = LEGAL ROUTE
C              700 = ILLEGAL ROUTE
C
C ..........
C
C
C              LOGICAL VARIABLE SET TO DENOTE THAT THIS IS THE FIRST
C              TIME A ROUTE IS EVALUATED - NEED NOT CALL ASSESS TO
C              ASCERTAIN REAL COVERAGE
C
      NEW=.TRUE.
C
      CALL COSREV(NEW,ISEAT,COSTM,FACTOR,ITEMP,JTEMP,KROW,MTEMP,IMAX,
     1 ISET,KKROUT,PART0,IP0,PART1,IP1,YIELD1,YIELD2,NPART,IPAX,IDIST,
     2 NSIZE,INY,       KFREQ,MLL,LIST,ITEST,MINDEX,COS,REV,PM,SM)
C
C                            !!!!!!!!!!
C
      D=DECIDE(COS,REV)
      IF (D) GO TO 600
C
C              TO SEE IF IT IS NECESSARY TO RECORD THE UNPROFITABLE
C              ROUTE AS A CONNECT ROUTING
C
C
700   CALL KFORE(MMSTOP,MTEMP,KROW,KROW1,KROW2,ITEMP,JTEMP,KTEMP,
     1 IPAX,ROUT0,ROUT1,ROUT2,IY0,IY1,IY2,COST,REVEN,NFREQ,IDIST,
     2 ISET,PART0,IP0,PART1,IP1,       INY,       ISEAT,COSTM,FACTOR,
     3 YIELD1,YIELD2,NPART,SPEED1,SPEED2,NSIZE)
C                       !!!!!!!!!!
C
      IF(MTEMP .EQ. 1) GO TO 800
C
C              TO RECORD THE 'OTHER' TRANSFER STATION : I-(KRR)-.-J
C
      KKR=KTEMP
      IT=ITEMP
      JT=JTEMP
      KT=KKR
      JROW1=MMROW(JT,KT)
      JROW2=MMROW(KT,IT)
C
      CALL KFORE(MMSTOP,MTEMP,KROW,JROW1,JROW2,JTEMP,ITEMP,KKR,
     1 IPAX,ROUT0,ROUT1,ROUT2,IY0,IY1,IY2,COST,REVEN,NFREQ,IDIST,
     2 ISET,PART0,IP0,PART1,IP1,       INY,       ISEAT,COSTM,FACTOR,
     3 YIELD1,YIELD2,NPART,SPEED1,SPEED2,NSIZE)
C                       !!!!!!!!!!
      GO TO 800
C
C              600 = ROUTE ACCEPTED
C              800 = REJECTED
C
600   NFREQ(KROW,IMAX)=KFREQ
      COST(KROW,IMAX)=COS
C
C              *** REVEN FOR TEMPORARY USE ONLY ***
C
      REVEN(KROW,IMAX)=REV
C
C              KEEP RUNNING SUM OF SYSTEM RPM & ASM
C
      RPM=RPM+PM
      ASM=ASM+SM
C
C              TABULATE THE ACCEPTED ROUTE
C
C
      CALL TABLE(.TRUE.,MMSTOP,MLL,MTEMP,IMAX,KROW,ITEMP,JTEMP,ISET,
     1 ISIZE,NSIZE,INY,NFREQ,REVEN,COST,ITEST,LIST,MINDEX,IP0,IP1,PART0,
     2 PART1,IRESTR)
C                            !!!!!!!!!!
C
C              TO SIGNIFY A ROUTE CANDIDATE KKROUT HAS BEEN CONSIDERED
C              SO THAT THE TABULATION PROCESS WILL NOT BE REPEATED
C
800   KKROUT(1)=0
960   RETURN
      END
      SUBROUTINE ASSESS(IPART,IROUTE,IROW,MM,   KROW,KCOL,ILEFT,IRIGHT,
     1 JIL,JIR,       LOOK)
C
C              GIVEN A 'COVERED' CITY PAIR FROM A PRIMITIVE ROUTE,
C              THIS SUBROUTINE ASSESES THE EXACT WAY IN WHICH THE CITY
C              PAIR IS COVERED. THE LOGICAL TREE OF THIS ROUTINE IS:
C
C             IF COVERED BY A >> RTE  -  CONFIRMED COVERED
C                             >> RTE BLK -  IF CONTAINED IN
C                                > THE PRIMITIVE RTE - CONFIRMED NOT
C                                                      COVERED
C                                > A RTE OTHER THAN THE PRIMITIVE -
C                                                      CONFIRMED COVERED
C
C                  OUTPUT: LOGICAL VARIABLE , LOOK = .T. IF CONFIRMED
C                                                        COVERED
C                                                    .F.  OTHERWISE
C                  INPUT:  ALL  THE REST
C
      COMMON NCITY,NROW
      LOGICAL LOOK,CHECK,C
      INTEGER   ILEFT(NROW,JIL),IRIGHT(NROW,JIR)
C
      IF(IPART .GT. IROUTE) GO TO 900
C
C              900 = COVERED BY A ROUTE
C              FALL THROUGH = COVERED BY A RTE BLK
C
      MMAX=MM+1
C
      C=CHECK(IROW,MMAX,   KROW, KCOL,ILEFT,IRIGHT,JIL,JIR)
C                            !!!!!!!!!!
      IF( .NOT. C) GO TO 900
C
C              FALL THROUGH = CITY PAIR COVERED BY PRIMITIVE RTE
C              900 = CITY PAIR COVERED BY OTHER RTES
C
      LOOK=.FALSE.
800   RETURN
900   LOOK=.TRUE.
1000  RETURN
      END
      SUBROUTINE BACK(IP0,IP1,INY,MM,IJROW,MMK,K1,K2,PART0,PART1,NSIZE)
C
C              GIVEN AN MMK-STOP ROUTE BLOCK (K1,K2) FROM AN MM-STOP
C              PARENT ROUTE IJROW, THIS SUBROUTINE TABULATES THE BACK
C              POINTER FOR THE RTE BLK MMK-(K1,K2), POINTING TO THE
C              PARENT RTE MM-IJROW
C
C              INPUT:  IP0,IP1,INY,IJROW,MM,K1,K2
C              I & O:  PART0,PART1,NSIZE
C
      COMMON NCITY,NROW
      INTEGER   PART0(NROW,IP0),PART1(NROW,IP1)
      INTEGER   NSIZE(NROW,INY)
      INTEGER   IENTRY,JENTRY
C
C              IENTRY IS DEFINED TO BE 2-BYTE IN ORDER TO CALL STORE
C
      MMAX=MM+1
      LROW=IJROW*10
      IENTRY=LROW+MMAX
C
C              THE 2-BYTE ENTRY FOR THE (K1,K2) ENTRY IN PART0/1
C                     5    4    3    2    1
C                  !----!----!----!----!----!
C                          IJROW        MMAX
C              NOTE -  THE LARGEST NO. THAT CAN BE STORED IN IJROW IS
C                  3276, CORRESPONDING TO AN 80 CITY SYSTEM. MAKE USE
C                  OF THE MINUS SIGN FOR A LARGER SYSTEM.
C
      KMAX=MMK+1
      IX=MMROW(K1,K2)
C
C              THE FOLLOWING FEW STATEMENTS ARE TO MAKE SURE A ROUTE
C              BLOCK DOES NOT GET TABULATED TWICE IN PART0/1 FOR THE
C              SAME ROUTE
C
C -----
      JY=NSIZE(IX,KMAX)
      IF(JY .EQ. 0) GO TO 500
C
C              500 = RTE BLOCK COULD NOT HAVE BEEN TABULATED BEFORE IF
C                  PART0/1 IS EMPTY, SO GO AHEAD WITH TABULATION
C              F.T. = CHECK TO MAKE SURE SINCE THERE ARE ENTRIES IN
C                  PART0/1
C
      GO TO (100,200), KMAX
100   JENTRY=PART0(IX,JY)
      GO TO 300
200   JENTRY=PART1(IX,JY)
300   IF(IENTRY .EQ. JENTRY) GO TO 400
C
C              400 = THE RTE BLK HAS BEEN TABULATED FOR THE PARENT RTE
C              F. T. = TABULATE RTE BLOCK
C
C -----
C
C              DUMMY VARIABLE DEFINED FOR CALLING STORE
C
500   NX=NROW
C
      CALL STORE(IX,KMAX,IENTRY,1,NX,NSIZE,INY,PART0,IP0,PART1,IP1)
C                            !!!!!!!!!!
C
400   RETURN
      END
      LOGICAL FUNCTION CHECK(IROW,ICOL,   KROW,KCOL,ILEFT,IRIGHT,
     1 JIL,JIR)
C
C              GIVEN A ROUTE BLOCK IN ILEFT/IRIGHT AND A ROUTE,
C              THIS SUBROUTINE CHECKS WHETHER THE RTE BLK IS CONTAINED
C              IN THE RTE
C                  CHECK = .TRUE. IF YES
C                          = .FALSE. OTHERWISE
C
      COMMON NCITY,NROW
      INTEGER   ILEFT(NROW,JIL),IRIGHT(NROW,JIR)
C
C              FORM RTE CHECK LABEL
C
      LABEL=IROW*10+ICOL
C
C              IDENTIFIER FROM ILEFT/IRIFHT
C
      GO TO (100,200), KCOL
100   ID=ILEFT(KROW,KCOL)
      GO TO 300
200   ID=IRIGHT(KROW,KCOL)
C
C              SEE IF ID AND LABEL MATCH
C
300   IF(LABEL .EQ. ID) GO TO 400
      CHECK=.FALSE.
      RETURN
400   CHECK=.TRUE.
      RETURN
      END
      SUBROUTINE CITIES(LK1,LK2,KKROUT,IP,JQ,IJ,MP,NQ,MN)
C
C              THIS SUBROUTINE EXTRACTS FROM KKROUT
C              THE TWO (MM-1)STOP O-D PAIRS OF A MM-STOP ROUTE
C
C                  OUTPUT: IP,JQ,IJ,MP,NQ,MN
C                  INPUT: THE REST
C
      LOGICAL IJ,MN
      INTEGER   KKROUT(5)
C
C              IJ,MN ARE SWITCHES TO INDICATE A CITY PAIR IS REVERSED
C
      IJ=.FALSE.
      MN=.FALSE.
C
      ILEFT=KKROUT(LK1+1)
      IRIGHT=KKROUT(LK2)
      IF(ILEFT .GT. IRIGHT) GO TO 100
      IP=ILEFT
      JQ=IRIGHT
      GO TO 200
C
C              INDICATING (IP,JQ) REVERSED
C
100   IJ=.TRUE.
      IP=IRIGHT
      JQ=ILEFT
200   IRIGHT=KKROUT(LK2-1)
      ILEFT=KKROUT(LK1)
      IF(IRIGHT .GT. ILEFT) GO TO 300
C
C              INDICATING (MP,NQ) REVERSED
C
      MN=.TRUE.
      MP=IRIGHT
      NQ=ILEFT
      GO TO 400
300   MP=ILEFT
      NQ=IRIGHT
400   RETURN
      END
      SUBROUTINE CODE51(MNUM,IY,LMID,LLIM,LL,IMM,I,J,KKK,IR,ROUT,
     1   MIDDLE,MLIMIT)
C
C
C
      COMMON NCITY, NROW
      INTEGER   ROUT(NCITY,IY),MIDDLE(LMID),MLIMIT(LLIM)
C
C      > THIS SUBROUTINE CHECKS THE INTERMEDIATE CITIES OF A ROUTE
C        SERVING A CITY PAIR (IMM,J) RESTRICTED BY CODE 51.
C      > BEFORE THIS SUBROUTINE IS ENTERED, THE CALLING PROGRAM ROUTES
C        IS IN THE PROCESS OF TAGGING (K,J) ONTO THE ROUTE BLOCK (I,K),
C        WHICH IS CONTAINED IN THE ITH ROW OF ROUT. THE CITY IMM WAS
C        LOCATED IN (I,K) (AT THE LLTH POSITION OF THE ITH ROW OF ROUT)
C        SUCH THAT CITY PAIR IMM-J IS RESTRICTED BY CODE 51.
C      > IN THIS SUBROUTINE , CODE51, EACH SPECIFIED INTERMEDIATE CITY
C        IN ONE OF THE 'OR' BLOCKS STORED IN ARRAY MIDDLE BETWEEN
C        THE POSITIONS SPECIFIED IN MLIMIT (AN ARRAY MNUM*2 LONG)
C        FOR THE RESTRICTED CITY PAIR (IMM,J) IS TO MATCH AGAINST
C        THE CITIES BETWEEN IMM AND J (BETWEEN POSITIONS NLLOW AND KKK)
C        IN THE ROUTE BLOCK (I,K).
C      > THE PROPOSED TAG-ON PROCEDURE (I,K).(K,J) WOULD EITHER BE
C        PROVEN TO BE FEASIBLE, IR=1, OR OTHERWISE, DEPENDING ON WHETHER
C        A MATCH WAS FOUND BETWEEN THE INTERMEDIATE CITIES.
C
C        IR = SWITCH TO DENOTE WHETHER A ROUTE IS QUALIFIED
C             1 - QUALIFIED
C             0 - NOT QUALIFIED
C
500   IR=0
      NLLOW=LL+1
      MMNUM=MNUM*2
C
C              FLIP CITY PAIR IMM-J OVER IN CASE IMM IS GREATER THAN J
C
      IF (IMM .GT. J) GO TO 700
      IMMJ=IMM*100+J
      GO TO 750
700   IMMJ=100*J+IMM
C
C        LOCATE THE POSITION OF INTERMEDIATE CITY RESTRICTION
C        FOR CITY PAIR (IMM,J)
C
750   DO 1000 N1=1,MMNUM,2
      IJ=MLIMIT(N1)
      IF(IMMJ .NE. IJ) GO TO 1000
      NLOW=MLIMIT(N1+1)
      NHIGH=MLIMIT(N1+3)-1
C
      IJ=0
800   GO TO 1500
1000  CONTINUE
1500  IOR=0
C
C        IOR IS INITIALIZED TO ZERO TO START OUT WITH.
C        AS SOON AS THE FIRST MIDDLE(NN1) IS ENCOUNTERED
C        FOR WHICH THERE IS NO MATCH, IOR IS PUT ON AN 'ALARM'
C        STATUS (I.E. SET TO UNITY). AS LONG AS IOR IS STILL UNITY,
C        WE KEEP ON SKIPPING THE NEXT MIDDLE(.) UNTIL A BLANK
C        IS ENCOUNTERED. AT THAT TIME WE ARE IN A NEW 'OR'
C        BLOCK OF MIDDLE. WE SET IOR=0 AGAIN AND START
C        THE MATCH COMPARISON AFRESH.
C
C        FIND A MATCH BETWEEN EACH INTERMEDIATE CITY SPECIFIED AND SOME
C        OF THE CITIES IN THE PROPOSED ROUTE
C
      DO 2000 NN1=NLOW,NHIGH
      IF(MIDDLE(NN1) .NE. 0     ) GO TO 2200
      IF(IOR .NE. 1) GO TO 5000
C
C        500 = THE PROPOSED ROUTE IS QUALIFIED
C
      IOR=0
      GO TO 2000
2200  IF(IOR .EQ. 1) GO TO 2000
C
C        AS LONG AS IOR IS ON (I.E. IOR=1), STILL HAVE TO LOOK FOR A
C        MATCH
C
C        2000 = MOVE TO A NEW BLOCK OF INTERMEDIATE CITIES IN MIDDLE
C
C        LOOPING THROUGH ALL INTERMEDIATE CITIES IN THE PROPOSED ROUTE
C        TO FIND A MATCH FOR MIDDLE(NN1)
C
2400     DO 3000 NLL=NLLOW,KKK
	 IF(ROUT(I,NLL) .EQ. MIDDLE(NN1)) GO TO 2000
C
C             2000=A MATCH HAS TO BE FOUND FOR THE NEXT CITY
C             IN THE CURRENT BLOCK OF MIDDLE
C
3000     CONTINUE
2600  IOR=1
2000  CONTINUE
      IF(IOR .EQ. 1) GO TO 4000
C
C        4000=FAILURE TO FIND A MATCH, GO AND LOOK FOR ANOTHER ROUTE
C        SEGMENT IN (.,J) WITH RESTRICTION CODE 51
C
5000   IR=1
4000  RETURN
      END
      SUBROUTINE CODES(KCODE,NN,ICODE,NCITY,LCODE)
C
C              GIVEN NN CITIES IN NUMBER CODES, THIS SUBROUTINE CONVERTS
C              THEM INTO ALPHAMERIC AIRPORT CODES
C
C              OUTPUT:
C                  LCODE     ARRAY NN LONG CONTAINING ALPHA CITY CODES
C
C              INPUT:
C                  KCODE     ARRAY NN LONG CONTAINING NUMERIC CODES
C                  ICODE     ARRAY NCITY LONG CONTAINING ALL ALPHA CITY
C                            CODES IN ORDER
C
      DIMENSION KCODE(NN), ICODE(NCITY), LCODE(NN)
      DATA JUNK/' * '/
      DO 100 I1=1,NN
      II=KCODE(I1)
      IF(II .LE. 0) GO TO 200
C
C              200 = NO CITY CODE WOULD CORRESPOND TO A ZERO OR MINUS
C                  NUMBER CODE
C              F.T. = REASONABLE NUMBER CODE
C
      LCODE(I1)=ICODE(II)
      GO TO 100
200   LCODE(I1)=JUNK
100   CONTINUE
      RETURN
      END
      SUBROUTINE COVER(IROW,LIM,ISET,PART0,IP0,PART1,IP1,       SKIP,
     1 NSIZE,INY,       IPART,IROUTE,ITRANS,IFLAG,   JCOL)
C
C              GIVEN A CITY PAIR, IROW, IT SEARCHES THROUGH ISET/PART0/
C              PART1/NSIZE TO SEE WHETHER THE CITY PAIR HAS BEEN
C              COVERED BY ROUTES/PORTIONS OF ROUTES/CONNECT ROUTINGS
C              OF FEWER THAN MM-STOPS.
C              > IF COVERED, IFLAG .EQ. A LARGE NUMBER, AND
C              IPART/IROUTE/ITRANS .EQ. THE COLUMN GROUP IN ISET/
C              PART0,PART1/NSIZE WHERE THE ROUTE/ROUTE-BLOCK/ROUTING
C              IS FOUND
C              > OTHERWISE, IFLAG/IPART/IROUTE/ITRANS .EQ. ZERO
C
C                  OUTPUT: IPART,IROUTE,IFLAG,LR,JCOL ( AND ITRANS IF
C                          ENTRY PORTION IS EXECUTED)
C                  INPUT: THE REST
C
C              -- NOTE --
C                  CHANGE STATEMENT 100 AND THAT MARKED BY +++++
C                  IF MORE THAN 2-STOPS ARE GENERATED
C
      COMMON NCITY,NROW
      LOGICAL SKIP
      INTEGER   ISET(NROW,LIM)
      INTEGER   PART0(NROW,IP0),PART1(NROW,IP1)
      INTEGER   NSIZE(NROW,INY)
C
C              IF THE GIVEN CITY PAIR IS COVERED,
C              IPART/IROUTE TAKE ON VALUES (M+1) TO SIGNIFY
C              THE M-STOP ROUTE-BLOCK/ROUTE COVERING THE CITY PAIR
C
      IPART=0
      IROUTE=0
      ITRANS=0
C
      DO 300 KOL=1,LIM
C
C              CHECK WHETHER CITY PAIR IROW IS COVERED BY A ROUTE
C
      IF(ISET(IROW,KOL) .EQ. 0) GO TO 100
C
C              FALL THROUGH = THE CITY PAIR IS COVERED BY A ROUTE
C
      IROUTE=KOL
C
C              JCOL IS THE PHYSICAL COLUMN IN WHICH THE RTE IS STORED
C
      JCOL=KOL
C
C              IPART/ITRANS ARBITRARILY SET TO A LARGE NO. TO FACILATE
C              MIN(INTERMEDIATE STOPS) CHECK IN SUBROUTINE KFORE
C
      IPART=30000
      ITRANS=30000
      GO TO 500
C
C              CHECK WHETHER CITY PAIR IROW IS COVERED BY PORTION OF
C              A ROUTE
C
C
C +++++ ASSUMPTION
C              ONLY CHECK THE 1ST RTE BLK. CORRECT STATEMENT  100
C              IF ASSUMPTION IS RELAXED
C
100   JI=1
      GO TO (110,120), KOL
110   IF(PART0(IROW,JI) .NE. 0) GO TO 250
C
C              250 = COVERED BY 1-STOP RTE BLK
C              FALL THROUGH = NOT COVERED BY 1-STOP
C
      GO TO 300
120   IF(PART1(IROW,JI) .EQ. 0) GO TO 300
C
C              300 = NOT COVERED
C              FALL THROUGH = COVERED BY 2-STOP RTE BLK
C
C
C              CITY PAIR COVERED
C
250   IPART=KOL
C
C              JCOL IS THE PHYSICAL COLUMN IN WHICH THE RTE BLK IS
C              STORED
C
      JCOL=JI
C
C              TO FACILITATE THE MIN(INTERMEDIATE STOP) CHECK IN KFORE
C
      IROUTE=30000
      ITRANS=30000
C
C
      GO TO 500
300   CONTINUE
C
C              EXITTING FROM A COMPLETE DO LOOP MEANS CITY PAIR NOT
C              COVERED
C
      IF(SKIP) GO TO 500
C
C              SKIP = .TRUE. MEANS CHECKING DIRECT ROUTES/RTGS ONLY
C                   = .FALSE. MEANS CHECKING BOTH DIRECT & CONNECT RTGS
C
      ENTRY CCOVER(IROW,LIM,IP0,IP1,NSIZE,INY,       IPART,IROUTE,
     1 ITRANS,JCOL,IFLAG)
C
C              THIS PORTION OF THE SUBPROGRAM CHECKS WHETHER A CITY
C              PAIR HAS BEEN SERVED BY CONNECT ROUTING OF FEWER STOPS
C
C                  OUTPUT: IFLAG AND ITRANS ONLY, PLUS JCOL
C                  INPUT: ALL THE REST (NOTICE IPART/IROUTE ARE PASSED
C                          TO ENTRY CCOVER AS ZEROS)
C
      ITRANS=0
      DO 400 L=1,LIM
      JCOL=L
      IF(NSIZE(IROW,JCOL) .EQ. 0) GO TO 400
      ITRANS=L
      IROUTE=30000
      IPART=30000
      GO TO 500
400   CONTINUE
C
500   IFLAG=IROUTE+IPART+ITRANS
      RETURN
      END
      LOGICAL FUNCTION DECIDE(COS,REV)
C
C              GIVEN THE COST AND REVENUE FIGURES OF A ROUTE,
C              THIS LOGICAL FUNCTION DECIDES ON PROFITABILITY GROUND
C              WHETHER THE ROUTE SHOULD BE FLOWN. A .TRUE. VALUE IS
C              RETURNED IF THE ROUTE IS ACCEPTED AND .FALSE. OTHERWISE.
C
      COMMON /EARN/GAIN
C
C              INPUT:
C              GAIN     PROFIT MARGIN IN% ABOVE D.O.C.
C
      PROFIT=REV-COS
C
C              TARGET PROFIT MARGIN
C
      TARGET=(GAIN*COS)/100.
C
      IF(PROFIT-TARGET) 100,100,200
C
C              100 = BELOW OR EQUAL TO TARGET PROFIT MARGIN
C              200 = ABOVE TARGET
C
C              << NOTE >>
C              PROFIT .EQ. TARGET MUST BE CONSIDERED AS A REJECTED
C              ROUTE TO HANDLE THE CASE OF ZERO REV AND ZERO COS
C
C
100   DECIDE=.FALSE.
      RETURN
200   DECIDE=.TRUE.
300   RETURN
      END
      SUBROUTINE DIFFER(IROW,MMAX,COS,COST,REV,REVEN,DCOS,DREV)
C
C              GIVEN THE NEW ROUTE COST/REVENUE CAUSED BY A NEW TRAFFIC
C              PATTERN, THIS SUBROUTINE COMPUTES THE INCREASE/DECREASE
C              IN ROUTE COST/REVENUE
C
C                  OUTPUT:  DCOS,DREV
C                  INPUT:  ALL THE REST
C
      COMMON NCITY,NROW
      DIMENSION COST(NROW,MMAX),REVEN(NROW,MMAX)
C
C              CONVENTION:  D = (NEW VALUE) - (OLD VALUE)
C                  HENCE -  D .GT. 0 = INCREASE
C                           D .LT. 0 = DECREASE
C
      DCOS=COS-COST(IROW,MMAX)
      DREV=REV-REVEN(IROW,MMAX)
      RETURN
      END
      FUNCTION FARE(I,J,IPAX,YIELD1,YIELD2,NPART)
C
C              THIS SUBPROBRAM COMPUTES YIELD FROM CITY PAIR DISTANCE
C
C              NPART    NO OF SEGMENTS IN YIELD EQUATION
C              YIELD1/2 ARRAYS STORING COEFF'S FOR THE YIELD EQNS
C
      COMMON NCITY,NROW
      DIMENSION YIELD1(NPART),YIELD2(NPART)
      INTEGER   IPAX(NCITY,NCITY)
C
C              THE FOLLOWING CHECK IS FOR DEBUGGING PURPOSES ONLY
C
      IF(I .GT. J) GO TO 100
C
C
C              THE LOWER TRIANGLE OF IPAX CONTAINS INTERCITY DISTANCES
C
      DIST=IENTRY(.FALSE.,I,J,IPAX,NCITY)
C
C              ARBITRARILY SET TO 1ST SEGMENT OF YIELD EQUATION
C              - TO BE MODIFIED LATER -
C
      IPART=1
      FARE=YIELD1(IPART)+YIELD2(IPART)*DIST
      RETURN
C
100   WRITE(3,200) I,J
200   FORMAT(' IN FARE, I=',I4, ' .GT.  J=',I4)
      RETURN
C
      END
      SUBROUTINE FIND(MMSTOP,   IROW1,IPART1,IWORD,ISET,PART0,IP0,
     1 PART1,IP1,ROUT0,IY0,ROUT1,IY1,ROUT2,IY2,MMR,I,J,IROW,ICOL,
     2 KKROUT)
C
C              GIVEN A CONNECT SEGMENT, THIS SUBROUTINE FINDS THE
C              ROUTE WHICH CONTAINS THE CONNECT SEGMENT
C
C                  OUTPUT:  MMR,I,J,IROW,ICOL,KKROUT
C                  INPUT:  ALL THE REST
C
      COMMON NCITY,NROW
      INTEGER   ISET(NROW,MMSTOP)
      INTEGER   PART0(NROW,IP0),PART1(NROW,IP1),KKROUT(5)
      INTEGER   ROUT1(NCITY,IY1),ROUT2(NCITY,IY2),ROUT0(NCITY,IY0)
C
C             EXTRACT ROUTE FROM PART
C
      GO TO (1000,2000), IPART1
C
1000  IROW=PART0(IROW1,IWORD)/10
      ICOL=(PART0(IROW1,IWORD)-IROW*10)
      GO TO 200
2000  IROW=PART1(IROW1,IWORD)/10
      ICOL=PART1(IROW1,IWORD)-IROW*10
C
200   CALL PAIR(IROW,I,J)
C                            !!!!!!!!!!
      II=I
      JJ=J
      IIROW=IROW
      IICOL=ICOL
      GO TO 300
C
C
      ENTRY FIND1(II1,JJ1,IIROW1,IICOL1,ISET,MMSTOP,ROUT0,IY0,ROUT1,
     1 IY1,ROUT2,IY2,MMR,KKROUT)
C
C              THIS PORTION OF THE SUBROUTINE IS CALLED IF A CITY PAIR
C              IS SERVED BY A RTE INSTEAD OF A RTE BLK
C                  OUTPUT:  MMR,KKROUT
C                  INPUT:  ALL THE REST
C
      II=II1
      JJ=JJ1
      IIROW=IIROW1
      IICOL=IICOL1
C
300   MMR=IICOL-1
C
C              DEFINE KKROUT
C
      GO TO (900,1100,2200), IICOL
C
900   CALL STRING(II,IIROW,IICOL,ISET,ROUT0,IY0,KKROUT)
      RETURN
C
1100  CALL STRING(II,IIROW,IICOL,ISET,ROUT1,IY1,KKROUT)
C                            !!!!!!!!!!
      RETURN
C
2200  CALL STRING(II,IIROW,IICOL,ISET,ROUT2,IY2,KKROUT)
C                            !!!!!!!!!!
      RETURN
      END
      SUBROUTINE FLOW(MMAX,IX,IY,K1,K2,IPAX,ISEG)
C
C              GIVEN A ROUTE BLOCK (IX,IY) IN A ROUTE OF MMAX SEGMENTS,
C              THIS SUBROUTINE ACCUMULATES THE FLOW FROM IX TO IY
C              ON EVERY SEGMENT OF THE ROUTE
C
C                  OUTPUT: ISEG
C                  INPUT: ALL THE REST
C
      COMMON NCITY,NROW
      INTEGER   ISEG(MMAX),IPAX(NCITY,NCITY)
      DO 100 K=K1,K2
C
100   ISEG(K)=ISEG(K)+IPAX(IX,IY)
      RETURN
      END
      SUBROUTINE FORE (MMAX,IROW,I,     ISET,ISIZE)
C
C
C             THIS SUBROUTINE SIMPLY STORES A 'QUALIFIED' ROUTE IN THE
C              SET COVERING TABLEAU ISET
C
C              INPUT:  MM,MMAX,IROW,ISIZE,I
C              I & O:  ISET
C                    -          -          -
C
C
C
      COMMON NCITY, NROW
      INTEGER   ISET(NROW,MMAX)
      INTEGER   ISIZE(NCITY,MMAX)
C
C             POINTER TO ROUTE(I,J) IN ROUT-MM
C
      NUM1=ISIZE(I,MMAX)
      ISET(IROW,MMAX)=NUM1
200   RETURN
      END
      FUNCTION IENTRY(UPDOWN,IN1,IN2,MATRIX,N)
C
C              DEPENDING ON WHETHER THE INDICATOR UPDOWN = .T. OR .F.,
C              A REFERENCE TO I-J IS INTERPRETED AS THE APPROPRIATE
C              ENTRY IN THE UPPER/LOWER HALF OF THE MATRIX IF I  IS
C              .GT./.LT.  J
C                  UPDOWN = .TRUE. - DATA STORED IN UPPER TRIANGLE
C                          .FALSE. - DATA STORED IN LOWER TRIANGLE
C
      LOGICAL UPDOWN
      INTEGER   MATRIX(N,N)
      IF(IN1 .GT. IN2) GO TO 100
C
C              100 = IN1 .GT. IN2
C              FALL THROUGH =  IN1 .LT. IN2
C
      IF(UPDOWN) GO TO 200
C
C              200 = NO SWITCH NECESSARY
C              FALL THROUGH = SWITCH
C
      IOUT1=IN2
      IOUT2=IN1
      GO TO 300
200   IOUT1=IN1
      IOUT2=IN2
      GO TO 300
C
100   IF(UPDOWN) GO TO 400
C
C              400 = SWITCH
C              FALL THROUGH = NO SWITCH
C
      IOUT1=IN1
      IOUT2=IN2
      GO TO 300
400   IOUT2=IN1
      IOUT1=IN2
C
C
300   IENTRY=MATRIX(IOUT1,IOUT2)
      RETURN
      END
      SUBROUTINE INPUT1(              MTYPE,MCITY,NTYPE,KTYPE,ISEAT,
     1 MSTOP,FACTOR,COSTM,SPEED1,SPEED2,RANGE,ICODE,ITYPE,YIELD1,YIELD2,
     1 NPART,LEVEL,MART)
C
C              THIS SUBROUTINE INPUTS RUN PARAMETERS AND AIRPORT CODES
C
C                  INPUT:  MCITY
C
C                  OUTPUT:  ALL OTHERS, WITH NCITY, NROW, & GAIN PASSED
C                  BACK IN COMMON
C
C
C              GAIN     PROFIT MARGIN IN % ABOVE D.O.C.
      DIMENSION FORM1(18),FORM2(18),FORM3(18),FORM4(18)
C
C              MART     TYPE OF MARKET -  0 = NONCOMPETITIVE
C
C              LEVEL    TARGET PROFIT MARGIN IM % OF D.O.C.
C
C                                         1 = COMPETITIVE
C              OBJECT TIME FORMAT
C
C              NOTE -
C                  MTYPE MUST BE .GE. (NTYPE+1) AND .GE. (NPART+1)
C
      COMMON NCITY, NROW
      COMMON /SET/IREAD,IREAD1,IREAD2,IWRITE
      COMMON /EARN/GAIN
C
      DIMENSION KTYPE(MTYPE),ISEAT(MTYPE),SPEED1(MTYPE),SPEED2(MTYPE),
     1 RANGE(MTYPE),COSTM(MTYPE),YIELD1(MTYPE),YIELD2(MTYPE)
      INTEGER   ICODE(MCITY), BLANK
C
      DATA BLANK/'    '/
C
C
C              AIRCRAFT DATA
      READ(IREAD1,100) FORM1
100   FORMAT(18A4)
C
      NT=1
 110   READ(IREAD2,FORM1) KTYPE(NT),ISEAT(NT),SPEED1(NT),SPEED2(NT),
     1 RANGE(NT),CHR
      IF(CHR .EQ. 0) GO TO 120
C
C              120 = END OF AIRCRAFT DATA
C              F.T. = MORE AIRCRAFT DATA TO BE READ
C
C
C              COST PER MINUTE FROM COST PER BLOCK HOUR
C
      COSTM(NT)=CHR/60.
      NT=NT+1
      GO TO 110
C
C              NTYPE = NO. OF AIRCRAFT TYPE
C
120   NTYPE=NT-1
C
C              SYSTEM DATA
C
C
C              OBJECT TIME FORMAT
C
      READ(IREAD1,100) FORM2
      READ(IREAD1,FORM2) ITYPE,MSTOP,LEVEL,MART,FACTOR,GAIN
C
C              AIRPORT DATA
C
C
C              OBJECT TIME FORMAT
C
      READ(IREAD1,100) FORM3
C
C              NCITY = NO. OF CITIES IN THE SYSTEM
C
      NCITY=0
200   READ(IREAD2,FORM3) KCODE,ITYPE1,ITYPE2,ITYPE3,ITYPE4,ITYPE5,ITYPE6
      IF(KCODE .EQ. BLANK) GO TO 500
C
C              500 = END OF AIRPORT CODE INPUT STREAM
C              F.T. = MORE AIRPORTS TO BE READ
C
C
C              PICK CITIES SERVED BY THE AIRCRAFT TYPE UNDER
C              CONSIDERATION
C
      GO TO (1000,2000,3000,4000,5000,6000), ITYPE
1000  JTYPE=ITYPE1
      GO TO 400
2000  JTYPE=ITYPE2
      GO TO 400
3000  JTYPE=ITYPE3
      GO TO 400
4000  JTYPE=ITYPE4
      GO TO 400
5000  JTYPE=ITYPE5
      GO TO 400
6000  JTYPE=ITYPE6
C
400   IF(JTYPE .EQ. 0) GO TO 200
C
C              200 = CITY NOT SERVED BY GIVEN AIRCRAFT TYPE
C              F.T. = CITY SERVED
C
      NCITY=NCITY+1
      ICODE(NCITY)=KCODE
      GO TO 200
C
C              INITIALIZE ROW DIMENSION
C
500   NROW=NCITY*(NCITY-1)/2
C
C              YIELD DATA
C
      READ(IREAD1,100) FORM4
      NP=1
700   READ(IREAD1,FORM4) YIELD1(NP),YIELD2(NP)
      IF(YIELD1(NP)  .EQ. 0.) GO TO 600
C
C              600 = END OF YIELD DATA
C              F.T. = MORE YIELD DATA TO READ
C
      NP=NP+1
      GO TO 700
600   NPART=NP-1
      RETURN
      END
      SUBROUTINE INPUT2(LEVEL,MART,   ITYPE,SPEED1,SPEED2,NTYPE,LMID,
     1 LLIM,     ICODE,      IPAX,IRESTR, MIDDLE,MLIMIT,IP,IPOINT,IDIST,
     2 *)
C
C              THIS SUBROUTINE READS THE BULK OF THE CITY PAIR DATA.
C              THE DATA INCLUDES FROM O-D DEMAND TO COMPETITION
C              REQUIREMENT OF THE SEGMENT TO INTERMEDIATE CITY
C              RESTRICTIONS.
C
C              INPUT:  IREAD1/2,ITYPE,LMID,LLIM,LTEM,ICODE,LEVEL,MART
C              SPEED1/2 ARRAYS STORING SPEED COEFF'S
C              NTYPE    NO. OF A/C TYPES UNDER CONSIDERATION
C              LEVEL    DEGREE OF OPTIMISM IN DEMAND FORECAST
C              MART     TYPE OF MARKET( COMPETITIVE - 1
C                                       NONCOMPETITIVE - 0 )
C
C              OUTPUT:  IPAX,IRESTR,MIDDLE,MLIMIT,IP(COUNTER OF THE NO.
C                  OF CITIES RESTRICTED BY CODE 5),IPOINT(POINTER TO
C                  INDICATE HOW FAR MIDDLE IS FILLED)
C              NEITHER I NOR O:  ITEMP
C
      COMMON NCITY,NROW
      COMMON /SET/IREAD,IREAD1,IREAD2,IWRITE
      DIMENSION ITEMP(15  ),ICODE(NCITY)
      DIMENSION SPEED1(NTYPE),SPEED2(NTYPE)
      DIMENSION FORM2(18)
      INTEGER   IPAX(NCITY,NCITY),IRESTR(NCITY,NCITY)
      INTEGER   MIDDLE(LMID),MLIMIT(LLIM),IDIST(NROW,1)
      DATA LTEM/15/
C
C              OBJECT TIME FORMAT FOR THE DATA READ IN THIS SUBROUTINE
C
C              REMEMBER TO REDEFINE LTEM IF THE FORMAT PERTAINING
C              INTERMEDIATE CITIES IS CHANGED
C
C
      READ(IREAD1,50) FORM2
50    FORMAT(18A4)
C
      LCITY=NCITY-1
C
C              INITIALIZE COUNTER IP, POINTER IPOINT, AND DELIMITER
C              ARRAY MLIMIT
C
      IP=0
      IPOINT=0
      MLIMIT(2)=1
C
C              MAIN INPUT STREAM
C
      DO 100 I=1,LCITY
      LLCITY=I+1
      READ(IREAD2,FORM2) IDUMMY
      IF(IDUMMY .NE. 0) GO TO 300
C
C              300 = ERROR IN INPUT STREAM
C              F.T. = INPUT STREAM IN CORRECT FORMAT
C
      DO 100 J=LLCITY,NCITY
      READ(IREAD2,FORM2) IPAX(J,I),IRESTR(I,J),IRESTR(J,I),IPAX1,IPAX2,
     1 IPAX3,IPAX4,IPAX5,IPAX6,(ITEMP(IT),IT=1,LTEM),ICLASS
C
C              CONVERT DISTANCE TO BLOCK TIME
C
      IROW=MROW(I,J)
      IDIST(IROW,1)=MTIME(ITYPE,SPEED1,SPEED2,NTYPE,IPAX,I,J,NCITY)
C
C              CHECK THE TYPE OF MARKET
C
      IF(MART .GT. 0) GO TO 70
C
C              70 = READ ALL DEMAND SINCE DEALING WITH COMPETITIVE
C                  MARKET
C              F.T. = READ ONLY THE NONCOMPETITIVE CITY PAIR MARKET
C
      IF(IRESTR(J,I) .NE. 9) GO TO 150
C
C              150 = NEGLECT COMPETITIVE MARKET SINCE THIS IS A
C                  NONCOMPETITIVE RUN
C              <<NOTE>> - A NONCOMPETITIVE CITY PAIR IS MARKED BY A
C                       COMPETITIVE CODE OF 9 IN THE INPUT STREAM
C              F.T. = RECORD NONCOMPETITIVE CITY PAIR DEMAND
C
C
C              CHECK LEVEL OF OPTIMISM IN DEMAND FORECAST
C
70    IF(ICLASS .GT. LEVEL) GO TO 150
C
C              150 = DEMAND NOT ACCEPTED ACCORDING TO THE INPUT LEVEL
C                  OF OPTIMISM. ICLASS/LEVEL RANGES FROM 0 (LEAST
C                  OPTIMISTIC TO 3 (MOST OPTIMISTIC)
C              F.T. = DEMAND ACCEPTED
C
C
C              RECORD THE PAX DEMAND CORRESPONDING TO THE FLEET TYPE
C
      GO TO (1000,2000,3000,4000,5000,6000), ITYPE
C
C              1000/2000/3000/4000/5000/6000 = STORE IPAX1/2/3/4/5/6 IN
C              IPAX
C
1000  IPAX(I,J)=IPAX1
      GO TO 200
2000  IPAX(I,J)=IPAX2
      GO TO 200
3000  IPAX(I,J)=IPAX3
      GO TO 200
4000  IPAX(I,J)=IPAX4
      GO TO 200
5000  IPAX(I,J)=IPAX5
      GO TO 200
6000  IPAX(I,J)=IPAX6
      GO TO 200
C
150   IPAX(I,J)=0
C
C              STORE INTERMEDIATE CITY RESTRICTION IF NECCESSARY
C
200   IF(IRESTR(I,J) .NE. 5) GO TO 100
C
C              100 = NO NEED TO READ INTERMEDIATE CITY RESTRICTION
C              F.T. = RECORD INTERMEDIATE CITY RESTRICTION
C
C              INCREMENT THE COUNTER FOR THE NO. OF CITIES RESTRICTED
C              BY CODE 5
C
      IP=IP+1
C
      CALL VISIT(IP,I,J,ITEMP,LTEM,LMID,LLIM,ICODE,IPOINT,MIDDLE,MLIMIT)
C                            !!!!!!!!!!
100   CONTINUE
C
      RETURN
C
C              MESSAGE FOR INPUT STREAM ERROR
C
300   ICODE1=ICODE(I)
      ICODE2=ICODE(LLCITY)
      ICOUNT = MROW(I,LLCITY)+I-1
      WRITE(3,400) ICOUNT,ICODE1,ICODE2
400   FORMAT(/ ' >>> IN INPUT2 - ERROR IN RECORD NO.',I6, ' OF THE INPUT
     1 STREAM RIGHT BEFORE REFERRING TO CITY PAIR ',A4, ' - ',A4 / )
      RETURN 1
      END
      SUBROUTINE MARK(MMK,K1,K2,IRESTR)
C
C              EACH TIME A PROFITABLE ROUTE IS TABULATED,
C              THIS SUBROUTINE MARKS THOSE CITY PAIRS K1-K2 WHOSE
C              COMPETITION REQUIREMENT IS SATISFIED DUE TO THE
C              COVERAGE OF ROUTE BLOCK MMK:K1-K2.
C
C              INPUT:  MMK,K1,K2
C              I & O:  IRESTR
C
      COMMON NCITY,NROW
      INTEGER   IRESTR(NCITY,NCITY)
C
C              SEE IF THE CITY PAIR IS RESTRICTED COMPETITION-WISE
C
      ICELL=IENTRY(.FALSE.,K1,K2,IRESTR,NCITY)
      IF(ICELL) 200,200,100
C
C              100 = .GT. 0 - EXAMINE IT
C              200 = .EQ. 0 - CITY PAIR NOT RESTRICTED, SKIP
C                    .LT. 0 -ALREADY COVERED, SKIP
C
100   IF(ICELL .LT. MMK) GO TO 200
C
C              200 = ROUTE BLOCK DOES NOT SATISFY COMPETITION
C                  RESTRICTION
C              FALL THROUGH = RESTRICTION SATISFIED,
C                  MARK CITY PAIR BY A '-' SIGN
C
      IMARK=ICELL*(-1)
C
      IF(K1 .LT. K2) GO TO 300
C
C              300 = SWITCH TO RIGHT ENTRY IN IRESTR
C              FALL THROUGH = NO SWITCH NECESSARY
C
      IRESTR(K1,K2) = IMARK
      RETURN
300   IRESTR(K2,K1)=IMARK
200   RETURN
      END
      SUBROUTINE MIRROR(MM,KKROUT,IROUT)
C
C
      INTEGER   KKROUT(5), IROUT(5)
      LENGTH = MM +2
      DO 100 M=1,LENGTH
      L=M-1
100   IROUT(LENGTH-L)=KKROUT(M)
      RETURN
      END
      FUNCTION MMROW(M,N)
C
C              CONVERSION FORMULA TO RELATE, ELEMENT  BY ELEMENT,
C              THE ENTRIES OF A HALF NCITY*NCITY SQUARE MATRIX TO THOSE
C              IN A 1-DIMENSIONAL ARRAY
C
      COMMON NCITY,NROW
C
C              TO REVERSE M-N INTO AN ORDERED PAIR IF NECESSARY
C
      IF(M .LT. N) GO TO 100
C
C              FALL THROUGH = REVERSE M AND N
C
      MN=N
      N1=M
      M1=MN
      GO TO 200
C
C
100   M1=M
      N1=N
      GO TO 200
C
      ENTRY MROW(M2,N2)
      M1=M2
      N1=N2
200   MROW=NCITY*(M1-1)-(M1*(M1+1))/2+N1
      MMROW=MROW
      RETURN
      END
      FUNCTION MTIME(ITYPE,SPEED1,SPEED2,NTYPE,IPAX,I,J,NCITY)
C
C              THIS FUNCTION SUBPROGRAM COMPUTES BLOCK TIME IN MINUTES
C              FROM DISTANCE IN MILES
C
C              INPUT:
C                  ITYPE - AIRCRAFT TYPE
C                  SPEED1/2 & NTYPE - INTERCEPT & SLOPE ARRAYS OF BLOCK
C                       TIME VS. DISTANCE EQUATION.
C                       EACH ARRAY IS NTYPE LONG.
C                  IPAX - INTERCITY DISTANCES STORED IN LOWER HALF OF
C                       THE IPAX SQUARE MATRIX
C                  I-J - CITY PAIR
C                  NCITY - NO. OF CITIES IN THE SYSTEM
C
      DIMENSION SPEED1(NTYPE), SPEED2(NTYPE)
      INTEGER   IPAX(NCITY,NCITY)
C
C              INTERCEPT
C
      C1=SPEED1(ITYPE)
C
C              SLOPE
C
      C2=SPEED2(ITYPE)
C
C              INDEPENDENT VARIABLE
C
      DIST=IPAX(J,I)
C
C              COMPUTE BLOCK TIME ( ROUND OFF )
C
      MTIME=C1+C2*DIST+.5
C
      RETURN
      END
      SUBROUTINE NUMBER(IALPHA,ICODE,N,NUM)
C
C              THIS SUBROUTINE TRANSLATES AN ALPHAMERIC CHARACTER CODE
C              INTO THE CORRESPONDING NUMBER CODE
C              A NUMBER CODE OF ZERO IS RETURNED IF THERE IS NO MATCH
C              BETWEEN THE INPUT CHARACTER IALPHA, AND THE INTERNAL
C              ARRAY ICODE.
C
C              INPUT:  ICODE,N,IALPHA
C              OUTPUT:  NUM
C
      DIMENSION ICODE(N)
      DO 100 I=1,N
      IF(ICODE(I) .NE. IALPHA) GO TO 100
C
C              100 = NO MATCH YET
C              F.T. = THE CORRESPONDING NUMBER FOR THE ALPHAMERIC CODE
C                  FOUND - MISSION COMPLETED
C
      NUM=I
      GO TO 200
C
C              200 = NUMBER FOUND - BRANCH OUT OF DO LOOP
C
100   CONTINUE
C
C              NO MATCH OF ALPHAMERIC CODE AT ALL
C
      NUM=0
C
200   RETURN
      END
      SUBROUTINE PAIR(IROW,I,J)
C
C              GIVEN THE 1-DIMENSIONALIZED POSITION OF A CITY PAIR,
C              THIS SUBROUTINE CONVERTS IT TO THE O-D CITY PAIR I-J.
C
C                  INPUT: IROW
C                  OUTPUT:  I,J
C
      COMMON NCITY,NROW
      LCITY=NCITY-1
      NUM=LCITY
      LENGTH=IROW
      DO 2000 L=1,LCITY
      LENGTH=LENGTH-NUM
      IF (LENGTH) 1000,1000,2000
C
C              1000 = I FOUND
C              2000 = NOT YET FOUND
C
2000  NUM=NUM-1
1000  I=L
      J=NCITY+LENGTH
      RETURN
      END
      SUBROUTINE PRINT2(       ICODE,IDIST,IPAX,IRESTR,MIDDLE,MLIMIT,
     1 LMID,LLIM)
C
C              THIS SUBROUTINE ECHO PRINTS THE INFORMATION READ IN
C              INPUT2
C
C              THE ENTIRE PARAMETER LIST IS PASSED INTO THIS SUBROUTINE
C              TO BE PRINTED OUT
C
C              IDIST    AN ARRAY,ITS 1ST COLUMN STORES DIST IN MINUTES
C              IPAX     SQUARE ARRAY - UPPER/LOWER HALF=DEMAND/DISTANCES
C              ICODE    ARRAY STORING ALPHAMERIC AIRPORT CODES
C              IRESTR   SQ ARRAY - UPPER/LOWER HALF=RESTR CODE/COMP'T'N
C              MIDDLE   ARRAY STORING INTERMEDIATE CITY NO. CODES
C              MLIMIT   ARRAY STORING DELIMITER FOR MIDDLE
C              LMID     PHYSICAL LENGTH OF MIDDLE
C              LLIM     PHYSICAL LENGTH OF MLIMIT
C
      COMMON NCITY,NROW
      COMMON /SET/IREAD,IREAD1,IREAD2,IWRITE
C
C              IWRITE   OUTPUT DATA SET NO.
C
      DIMENSION ICODE(NCITY)
      INTEGER ALPHA(25)
      INTEGER   OR/' OR '/,AND/'AND '/
      INTEGER    IPAX(NCITY,NCITY),MIDDLE(LMID),MLIMIT(LLIM)
      INTEGER   IDIST(NROW,1),IRESTR(NCITY,NCITY)
C
C              TABLE HEADING
C
      WRITE(IWRITE,100)
100   FORMAT( // 30X, 'DISTANCE/ BLOCK TIME/ RESTRICTION CODE/ MAXIMUM
     1NO. OF STOPS ALLOWED/ O-D DEMAND' //)
      LCITY=NCITY-1
C
C              N = COUNTER FOR MLIMIT ARRAY
C
      N=2
      DO 200 L1=1,LCITY
      WRITE(IWRITE,300) ICODE(L1)
300   FORMAT(// 2X, A4,' TO -' /)
      LOW=L1+1
      DO 200 L2=LOW,NCITY
      IROW=MROW(L1,L2)
      WRITE(IWRITE,400) ICODE(L2),IPAX(L2,L1),IDIST(IROW,1),
     1 IRESTR(L1,L2),IRESTR(L2,L1),IPAX(L1,L2)
400   FORMAT(15X,A4,8X,I10,I10,6X,I10,15X,I10,10X,I10)
      IF(IRESTR(L1,L2) .NE. 5) GO TO 200
C
C              200 = NO INTERMEDIATE STOP SPECIFICATION
C              F.T. = PRINT OUT INTERMEDIATE STOPS
C
C              IA= COUNTER FOR ALPHA ARRAY
C
      IA=0
C
C              LIM1/2 = LOWER & UPPER LIMIT FOR THE STRING OF CITIES
C                  IN MIDDLE
C
      LIM1=MLIMIT(N)
      LIM2=MLIMIT(N+2)-1
C
C ----------   LOOP THROUGH THE STRING OF INTERMEDIATE CITIES
C
      DO 600 IL=LIM1,LIM2
      IA=IA+1
      NCODE=MIDDLE(IL)
      IF(NCODE .EQ. 0) GO TO 700
C
C              700 = INSERT 'OR' SYMBOL IN ALPHA
C              F.T. = INSERT'(CITY CODE) AND' IN ALPHA
C
      ALPHA(IA)=ICODE(NCODE)
      IA=IA+1
      ALPHA(IA)=AND
      GO TO 600
C
C              600 = CONSIDER NEXT ENTRY IN MIDDLE
C
C
C              'OR' PUT IN THE PLACE OF 'AND'
C
700   IA=IA-1
      ALPHA(IA  )=OR
600   CONTINUE
C ----------
C
C              LENA = COUNTER FOR HOW FULL ALPHA IS
C
      LENA=IA-1
      WRITE(IWRITE,900) (ALPHA(IAL),IAL=1,LENA)
900   FORMAT(20X, 'MUST VISIT ',25A4)
C
C              UPDATE MLIMIT COUNTER FOR THE NEXT STRING OF INTERMEDIATE
C              CITIES
C
      N=N+2
200   CONTINUE
      RETURN
      END
      FUNCTION REVENU( YIELD1,YIELD2,NPART,IPAX,I,J)
C
C              GIVEN THE YIELD/PAX INFORMATION AND THE NO. OF O-D PAX,
C              THIS SUBPROGRAM COMPUTES THE INCREMENTAL CONTRIBUTION
C              TO ROUTE REVENUE DUE TO THE O-D PAIR UNDER CONSIDERATION
C
C              YIELD1/2 ARRAYS STORING COEFF'S FOR THE YIELD EQNS
C              NPART    NO OF SEGMENTS IN YIELD EQUATION
C
      COMMON NCITY,NROW
      DIMENSION YIELD1(NPART),YIELD2(NPART)
      INTEGER   IPAX(NCITY,NCITY)
      REV=FARE(I,J,IPAX,YIELD1,YIELD2,NPART)
      REVENU=REV*IPAX(I,J)
      RETURN
      END
      SUBROUTINE STORE(I,M,IVEC,L,MX,NTAB,NY,ITAB1,NY1,ITAB2,NY2)
C
C              GIVEN AN L-LONG VECTOR IVEC, THIS SUBROUTINE STORES IT IN
C              THE ITH ROW  IN THE TABLES ITAB1/ITAB2
C              , EACH OF DIMENSION MX BY NY1/2,   DEPENDING ON WHETHER
C              THE VALUE OF  M  IS 1/2  . THE COUNTERS IN TABLE NTAB,
C              MEASURED MX BY NY, IS ALSO INCREMENTED IN THE MTH
C              COLUMN.
C
C                  INPUT: I,M,IVEC,L,MX,NY,NY1/2
C                  I & O:  NTAB,ITAB1/2
C
C                    NOTE - ALL ARRAYS AND VECTORS ARE 2-BYTE INTEGERS
C
      INTEGER   IVEC(L)
      INTEGER   NTAB(MX,NY),ITAB1(MX,NY1),ITAB2(MX,NY2)
C
C              K = THE PHYSICAL POSITION TO STORE THE NEXT ENTRY
C
      K= L*NTAB(I,M)
      DO 500  KK=1,L
      KKK=K+KK
      GO TO (100,200), M
C
C              STORE IN ITAB1/2   DEPENDING ON M BEING 1/2
C
100   ITAB1(I,KKK)=IVEC(KK)
      GO TO 500
200   ITAB2(I,KKK)=IVEC(KK)
500   CONTINUE
C
C              INCREMENT COUNTER
C
      NTAB(I,M)=NTAB(I,M)+1
      RETURN
      END
      SUBROUTINE STRING(I,IROW,ICOL,ISET,ROUT,IY,KKROUT)
C
C              GIVEN THE O-D CITIES OF AN MM-STOP ROUTE, THIS SUBROUTINE
C              TRACES OUT THE ENTIRE STRING OF CITIES IN THE ROUTE
C
C                  INPUT:  I,IROW,ICOL,ISET,ROUT,IY
C                  OUTPUT:  KKROUT
C
      LOGICAL EXIST
      COMMON NCITY,NROW
      INTEGER   ISET(NROW,ICOL)
      INTEGER   ROUT(NCITY,IY),KKROUT(5)
C
C              GETTING THE POINTER FROM ISET
C
      NUM= ISET(IROW,ICOL)
C
C              GETTING THE STRING OF CITIES FROM ROUT
C
      GO TO 200
C
      ENTRY SEARCH(I,J,ICOL,ROUT,IY,EXIST,KKROUT)
C
C              THIS ENTRY POINT OF THE SUBPROGRAM IS USED WHEN WE
C              HAVE TO SEARCH FOR THE ROUTE MM-I,J IN ROUT-MM
C
C
C              SEARCHING A ROUTE ORIGINATING AT I AND TERMINATING
C              AT J
C
      DO 300 JJ=1,J
      JJJ=JJ*ICOL
      IF(ROUT(I,JJJ) .LT. J) GO TO 300
C
C              300 = STILL SEARCHING FOR J
C              FALL THROUGH = EITHER NO J OR J FOUND
C
      IF(ROUT(I,JJJ) .NE. J) GO TO 400
C
C              400 = NO ROUTE I-J
C              FALL THROUGH = ROUTE I-J FOUND
C
      NUM=JJ
      GO TO 500
300   CONTINUE
400   EXIST=.FALSE.
      RETURN
500   EXIST=.TRUE.
C
200   LOW=(NUM-1)*ICOL
      DO 100 L=1,ICOL
100   KKROUT(L+1)=ROUT(I,LOW+L)
      KKROUT(1)=I
      RETURN
      END
       SUBROUTINE TABLE(ERASE,MMSTOP,MLL,MTEMP,IMAX,KROW,ITEMP,JTEMP,
     1 ISET,ISIZE,NSIZE,INY,NFREQ,REVEN,COST,ITEST,LIST,MINDEX,IP0,IP1,
     2 PART0,PART1,IRESTR)
C
C              THIS SUBPROGRAM TABULATES A PROFITABLE ROUTE:
C                  - ROUTE STORED IN ISET
C                  - ROUTE BLOCKS IN PART0/1
C                  - AN OPTION IS AVAILABLE TO ERASE DOMINATED
C                       CONNECT ROUTINGS
C
C              I & O:  ISET,PART0,PART1,NFREQ,REVEN,COST
C              INPUT:  THE REST
C
      COMMON NCITY,NROW
      LOGICAL ERASE
      DIMENSION REVEN(NROW,MMSTOP),COST(NROW,MMSTOP)
      INTEGER   ISET(NROW,MMSTOP),ISIZE(NCITY,MMSTOP)
      INTEGER   IRESTR(NCITY,NCITY)
      INTEGER   NSIZE(NROW,INY),NFREQ(NROW,MMSTOP)
      INTEGER   PART0(NROW,IP0),PART1(NROW,IP1)
      INTEGER   LIST(7,2),MINDEX(8)
      LOGICAL ITEST(7)
C
C             STORE 'QUALIFIED' ROUTE IN SET COVERING FORMAT
C
C
      CALL FORE(IMAX,KROW,ITEMP,         ISET,ISIZE)
C                  !!!!!!!!!!!
C
C
C              RECORD, IF NECESSARY, THAT A CITY PAIR IS COVERED
C              COMPETITIONWISE
C
      CALL MARK(MTEMP,ITEMP,JTEMP,IRESTR)
C                            !!!!!!!!!!
C
C              THE STATEMENTS MARKED BY ----- ARE DESIGNED TO ERASE
C              CONNECT ROUTINGS SINCE DIRECT ROUTINGS EXIST
C
C
C              --- NOTE ---
C              NSIZE, AND ONLY NSIZE AMONG THE CONNECT RTG STATISTICS,
C              IS STORED AS A (-) VALUE TO FACILITATE THE FOLLOWING
C              ERASING PROCEDURE
C
      IF( .NOT. ERASE) GO TO 50
C
C              50 = SKIP ERASING DOMINATED CONNECT RTG
C              F.T. = ERASE
C
C -----
C
C              ERASING THE MTEMP-STOP CONNECT RTG, SINCE THE CITY PAIR
C              KROW IS NOW SERVED BY A DIRECT MTEMP-STOP ROUTE
C                  NOTE -   M-STOP CONNECT RTG DISTANCES ARE STORED IN
C                       THE COLUMN WHERE WE STORE (M-1)-STOP RTE FREQ.
C
C
      IF(NSIZE(KROW,MTEMP) .GE. 0) GO TO 50
C
C              50 = SKIP ERASING - MIGHT UNINTENTIONALLY WIPE OUT A
C                  DIRECT ROUTE
C              F.T. = CERTAIN THE ONE TO BE ERASED IS A CONNECT ROUTE
C
      NSIZE(KROW,MTEMP)=0
      NFREQ(KROW,MTEMP  )=0
      COST(KROW, MTEMP)=0.
      REVEN(KROW, MTEMP)=0.
C -----
C
C              TABULATE ALL BACK POINTERS OF (I,K)/(IR,KR) IN
C                    PART0/PART1
C
C
C              GIVEN A PROFITABLE ROUTE, THE DIRECT ROUTINGS OF THE
C              ROUTE ARE ESTABLISHED IN PART0 AND PART1 BY TRACING
C              THROUGH ALL DECOMPOSED O-D PAIRS IN LIST
C
C
C              TRACING THROUGH ALL DECOMPOSED O-D PAIRS
C
50    DO 100 IL=1,MLL,2
      IF(ITEST(IL+1)) GO TO 200
C
C              200 = CITY PAIR REVERSED
C              FALL THROUGH = CITY PAIR IN RIGHT ORDER
C
      KTEM=LIST(IL+1,2)
      ITEM=LIST(IL+1,1)
      GO TO 300
200   ITEM=LIST(IL+1,2)
      KTEM=LIST(IL+1,1)
C
300   LROW1=MMROW(ITEM,KTEM)
C
      IF(ITEST(IL)) GO TO 400
      JTEM=LIST(IL,2)
      KR=LIST(IL,1)
      GO TO 500
400   JTEM=LIST(IL,1)
      KR=LIST(IL,2)
500   LROW2=MMROW(KR,JTEM)
C
C              THE SAME MTEM IS STORED IN MINDEX( (IL+1)/(IL+2) )
C              CORRESPONDING TO THE PAIR OF ROUTE BLOCKS IN
C              LIST( (IN)/(IL+1) ). WE COULD HAVE REPLACED THE
C              FOLLOWING STATEMENT BY MTEM=MINDEX(IL+1)-1
C
C
      MTEM=MINDEX(IL+2)-1
      IJROW=MMROW(ITEM,JTEM)
C
      IF(.NOT. ERASE) GO TO 700
C
C              700 = SKIP ERASING DOMINATED CONNECT RTG
C              F.T. = ERASE
C
C -----
C
C              ERASING THE  (.GE.MTEM)-STOP CONNECT RTG, SINCE THE
C              CITY PAIRS LROW1/2 ARE NOW SERVED BY MTEM-STOP ROUTE BLKS
C              NOTICE THAT CONNECT ROUTES OF UP TO MTEMP STOPS MIGHT
C              HAVE BEEN GENERATED TO SERVE THE CITY PAIRS LROW1/2,
C              THEREFORE ALL (.GE. MTEM)-STOP (UP TO MTEMP STOPS),
C              NOT JUST MTEM-STOP, CONNECT RTGS NEED TO BE ERASED.
C
C
      IMIN=MINDEX(IL+2)
C
      DO 650 MT=IMIN,MTEMP
C
      IF(NSIZE(LROW1,MT  ) .GE. 0) GO TO 600
C
      NSIZE(LROW1, MT  )=0
      NFREQ(LROW1, MT  )=0
      COST(LROW1, MT  )=0.
      REVEN(LROW1, MT  )=0.
C
C
600   IF(NSIZE(LROW2,MT  ) .GE. 0) GO TO 650
C
      NSIZE(LROW2, MT  )=0
      NFREQ(LROW2, MT  )=0
      COST(LROW2, MT  )=0.
      REVEN(LROW2, MT  )=0.
650   CONTINUE
C -----
700   CALL BACK(IP0,IP1,INY,MTEMP, KROW,MTEM,ITEM,KTEM,
     1 PART0,PART1,NSIZE)
C                  !!!!!!!!!!
C
C              RECORD COMPETITION COVERAGE
C
      CALL MARK(MTEM,ITEM,KTEM,IRESTR)
C                            !!!!!!!!!!
C
      CALL BACK(IP0,IP1,INY,MTEMP, KROW,MTEM,JTEM, KR, PART0,
     1 PART1,NSIZE)
C                  !!!!!!!!!!
C
      CALL MARK(MTEM,JTEM,KR,IRESTR)
C                            !!!!!!!!!!
C
100   CONTINUE
C
      RETURN
      END
      SUBROUTINE VISIT(IP,I,J,ITEMP,LTEM,LMID,LLIM,ICODE,IPOINT,MIDDLE,
     1 MLIMIT)
C
C              THIS SUBROUTINE STORES THE INTERMEDIATE CITIES TO BE
C              VISITED IF AN O-D PAIR I-J IS SERVED
C
C              INPUT:  IP,LMID,LLIM,ITEMP,LTEM,I,J,ICODE
C              I & O:  MIDDLE,MLIMIT,IPOINT
C
      COMMON NCITY,NROW
      DIMENSION ICODE(NCITY)
      INTEGER ITEMP(LTEM)
      INTEGER   MIDDLE(LMID),MLIMIT(LLIM)
      DATA IBLANK/'    '/
C
C        IPOINT = POINTER TO INDICATE HOW FAR THE ARRAY MIDDLE IS FILLED
C
C
      MM=0
C
C        MM = A SWITCH, WHICH WHEN ASSUMING A VALUE OF 2, INDICATES
C             THE END OF INTERMEDIATE CITY SPECIFICATION ON A CARD
C
C
C        IP = COUNTER OF HALF OF THE NO. OF CITY PAIRS RESTRICTED
C             BY CODE 5, ASSUMING A SYMMETRIC RESTRICTION MATRIX.
C           IT IS ALSO THE NO. OF THE SPECIAL RESTRICTION CARD THAT
C              HAVE BEEN PROCESSED
C
C
C
      IJ=I*100+J
C
      IPP=2*IP-1
C
450   MLIMIT(IPP)=IJ
      DO 600 M=1,LTEM
      IF(ITEMP(M) .NE. IBLANK) GO TO 550
C
C              550 = A BLOCK OF CITIES TO BE READ
C              F.T. = A BLANK ENCOUNTERED
C
      MM=MM+1
      IF(MM .LT. 2) GO TO 600
C
C        600 = NOT END OF INTERMEDIATE CITY SPECIFICATION YET
C
      GO TO 700
C
C        700 = ALL INTERMEDIATE CITIES HAVE BEEN READ,
C             TRANSFER OUT OF DO LOOP
C
550   MM=0
600   CONTINUE
700   LIM=M-2
      ILOW=IPOINT+1
      IHIGH=IPOINT+LIM
C
C        THE INTERMEDIATE CITIES INFORMATION CONTAINED IN THE CURRENT
C             CARD IS TO BE STORED IN MIDDLE FROM THE LOCATION
C             ILOW TO IHIGH
C
      DO 800 IM=1,LIM
      IMM=IM+IPOINT
C
C              TO TRANSLATE ALPHAMERIC CITY CODES INTO NUMBER CODES
C              BEFORE STORAGE
C
      CALL NUMBER(ITEMP(IM),ICODE,NCITY,NUM)
C                            !!!!!!!!!!
800   MIDDLE(IMM)=NUM
C
C        UPDATE THE POINTER FOR MIDDLE
C
      IPOINT=IHIGH
C
C        DELIMIT THE INTERMEDIATE CITIES IN MIDDLE BY CITY PAIRS
C
      IDUM=2*(IP+1)
      MLIMIT(IDUM)=IPOINT+1
C
      RETURN
      END
      SUBROUTINE INTOUT(MM,IY0,IY1,IY2,      IDIST,       ROUT0,
     1  ISIZE,ISET,ROUT1,ROUT2,PART0,PART1,NSIZE,           COST,NFREQ,
     2        MMYY,  REVEN,IP0,IP1,INY,ICODE,KCODE,LCODE)
C
C
C
C     SUBROUTINE INTOUT  PRODUCES AN INTERPRETED VERSION
C     OF THE OUTPUT PRODUCED BY SUBROUTINE OUTPUT
C     ALL PARAMETERS ARE INPUT
      COMMON NCITY, NROW
      COMMON /SET/IREAD,IREAD1,IREAD2,IWRITE
      DOUBLE PRECISION RPM,ASM
      COMMON /SYSTEM/RPM,ASM
C
C
      DIMENSION REVEN(NROW,MMYY  ),COST(NROW,MMYY  )
      DIMENSION ICODE(NCITY),KCODE(IY2),LCODE(IY2)
C
C              THE DIMENSION OF IY2 IS CHOSEN SO THAT A FULL SIZE ROW
C              OF ALPHA CODES CAN CORRESPOND TO A FULL SIZE ROW OF
C              ROUT0/1/2.
C
      INTEGER ISET(NROW,MMYY)
      INTEGER PART0(NROW,IP0),PART1(NROW,IP1)
      INTEGER ROUT0(NCITY,IY0),ROUT1(NCITY,IY1),ROUT2(NCITY,IY2)
      INTEGER NSIZE(NROW,INY),ISIZE(NCITY,MMYY  ),IDIST(NROW,MMYY )
      INTEGER NFREQ(NROW,MMYY)
      INTEGER COL
      COL=MM+1
      IF(COL.EQ.1) THEN
100   CALL HEAD1(COL)
      CALL PAGE1(LCODE,KCODE,ICODE,NCITY,IY2,ROUT0,NCITY,IY0,
     2           IDIST,NROW,MMYY,ISIZE,COL)
      CALL HEAD2(COL)
      CALL NONSTP(IDIST,ISET,NFREQ,COST,REVEN,NROW,MMYY,
     2            ICODE,KCODE,LCODE,NCITY,IY2,COL)
      RETURN
200   ELSE
      CALL HEAD1(COL)
      IF(COL.EQ.2) THEN
      CALL PAGE1(LCODE,KCODE,ICODE,NCITY,IY2,ROUT1,NCITY,IY1,
     2           IDIST,NROW,MMYY,ISIZE,COL)
250   ELSE
      CALL PAGE1(LCODE,KCODE,ICODE,NCITY,IY2,ROUT2,NCITY,IY2,
     2           IDIST,NROW,MMYY,ISIZE,COL)
300   ENDIF
      CALL HEAD2(COL)
      CALL NSTOPS(NSIZE,PART0,PART1,NROW,INY,IP0,IP1,ICODE,
     2                   KCODE,LCODE,NCITY,IY2,MMYY,ISET,IDIST,MM,
     3                   COST,REVEN,NFREQ,ROUT0,ROUT1,ROUT2,IY0,IY1)
      RETURN
400   ENDIF
      END
C
C
C
      SUBROUTINE HEAD1(NHEAD)
C
C
C     HEAD1 PRINTS THE HEADING FOR PAGE 1
      INTEGER NHEAD,ISTOPS
      ISTOPS=NHEAD-1
      IF(NHEAD.EQ.1) THEN
10    WRITE(3,15)
15    FORMAT(////,21X,'NON STOP ROUTES AND ROUTINGS'//,
     28X,'THE FOLLOWING ARE THE POSSIBLE NON STOP ROUTES'/)
      RETURN
20    ELSE
      WRITE(3,25) ISTOPS,ISTOPS
25    FORMAT(////,21X,I1,'-STOP ROUTES AND ROUTINGS'//,
     28X,'THE FOLLOWING ARE THE POSSIBLE CANDIDATE ',I1,
     3'-STOP ROUTES'/)
      RETURN
30    ENDIF
      END
C
C
C
      SUBROUTINE PAGE1(LCODE,KCODE,ICODE,NCITY,IY2,ARROUT,R,C,
     2                 IDIST,NROW,MMYY,ISIZE,COL)
C
C    PAGE1 PRINTS TABLE OF CANDIDATE ROUTES AND THEIR
C    CORRESPONDING TRAVEL TIME OR DISTANCE
C
C     INPUT
C
C     ARROUT = ARRAY CONTAING THE CANDIDATE ROUTE
C     R,C = ROW AND COLUMN OF ARROUT
C
C     VARIABLES
C
C     IORIG = INTERGER CODE OF ORIGIN CITY
C     ORIG = CHARACTER CODE OF ORIGIN CITY
C     IDEST = INTEGER CODE OF FINAL DESTINATION
C     DIST = CANDIDATE ROUTE DISTANCE
      DIMENSION ICODE(NCITY),KCODE(IY2),LCODE(IY2)
      INTEGER R,C
      INTEGER ARROUT(R,C)
      INTEGER IDIST(NROW,MMYY),ISIZE(NCITY,MMYY)
      INTEGER IORIG,ORIG,IDEST,COL,DIST,OTEMP,DTEMP,ROWNUM
      DO 100 I=1,NCITY
C     GET ORIGIN CODES
      LR0=ISIZE(I,COL)
      KCODE(1)=I
      IORIG=KCODE(1)
      CALL CODES(KCODE,1,ICODE,NCITY,LCODE)
      ORIG=LCODE(1)
C
C     LR0 MUST BE AT LEAST 1
      IF (LR0.EQ.0) LR0=1
C     GET CITY CODES FOR DESTINATIONS
      LR1=LR0*COL
      DO 300 K=1,LR1
300   KCODE(K)=ARROUT(IORIG,K)
      CALL CODES(KCODE,LR1,ICODE,NCITY,LCODE)
C
C     PRINT ALL CANDIDATE ROUTES FROM ORIGIN
      DO 200 J=1,LR0
C     GET CANDIDATE ROUTE FINAL DESTINATION CODE
      IDEST=ARROUT(I,J*COL)
C     GET ROW NUMBER OF CANDIDATE ROUTE
C     SWAP ORIG-DEST PAIR IF NECESSARY TO FIND ROWNUM
      IF (IDEST .LT. IORIG) THEN
      OTEMP=IDEST
      DTEMP=IORIG
      CALL GETROW(OTEMP,DTEMP,NCITY,ROWNUM)
50    ELSE
      CALL GETROW(IORIG,IDEST,NCITY,ROWNUM)
      ENDIF
      IF(ROWNUM.NE.0) DIST=IDIST(ROWNUM,COL)
C
C     PRINT ROUTE
      CALL PRINTC(LCODE,ROWNUM,IY2,ORIG,DIST,COL,J)
200   CONTINUE
100   CONTINUE
      RETURN
      END
C
C
      SUBROUTINE GETROW(IORIG,IDEST,NCITY,ROW)
C
C     GETROW RETURNS THE ROW NUMBER OF THE ORIGIN DEST. PAIR
C
      INTEGER IORIG,IDEST,NCITY,ROW,ORG,DE
C
C     INPUT: IORIG,IDEST,NCITY
C
C     OUTPUT: ROW
      ROW=1
      DO 10 ORG=1,NCITY-1
      DE=ORG+1
      IF (ORG.EQ.IORIG) THEN
      DO 20 J=1,NCITY-ORG
      IF (DE .EQ.IDEST) THEN
      RETURN
25    ELSE
      DE=DE+1
      ROW=ROW+1
      ENDIF
20    CONTINUE
15    ELSE
      ROW=ROW+(NCITY-ORG)
      ENDIF
10    CONTINUE
C    NO CANDIDATE ROUTE
      ROW=0
      RETURN
      END
C
C
      SUBROUTINE PRINTC(LCODE,ROWNUM,IY2,ORIG,DIST,COL,ROUTE)
C
C     PRINTC PRINT THE CANDIDATE ROUTE FROM IORIG
      DIMENSION LCODE(IY2)
      INTEGER ORIG,DIST,COL,ROUTE,ROWNUM
C
C
C
C     PRINT CANDIDATE ROUTE
      IF( ROWNUM.EQ.0) THEN
      WRITE(3,20) ORIG
20    FORMAT(///,11X,A4,4X,'TO',3X,'NO CANDIDATE ROUTES')
25    ELSE
      IF(ROUTE.EQ.1) THEN
      WRITE(3,100) ORIG
      WRITE(3,150) LCODE(ROUTE*COL-COL+1)
30    ELSE
      WRITE(3,200) LCODE(ROUTE*COL-COL+1)
40    ENDIF
50    WRITE(3,250) (LCODE(I),I=ROUTE*COL-COL+2,ROUTE*COL)
      WRITE(3,300) DIST
60    ENDIF
      RETURN
100   FORMAT(///,11X,A4,4X,'TO',3X)
150   FORMAT('+',23X,A4)
200   FORMAT(24X,A4)
250   FORMAT('+',28X,3('- ',A4))
300   FORMAT('+',46X,'DISTANCE =',I4)
      END
C
C
C
      SUBROUTINE HEAD2(COL)
C
C     SUBROUTINE HEAD2 PRINTS THE HEADING FOR PAGE 2
C     OF THE INTERPRETED OUTPUT
C
      INTEGER COL
      IF(COL.EQ.1) THEN
10    WRITE(3,20)
20    FORMAT(/// 28X,'THE FOLLOWING ARE ALL ACCEPTABLE ROUTES'/
     221X,'AND ROUTINGS TO SERVE EACH ORIGIN-DESTINATION PAIR'////,
     311X,'ORIGIN-DESTINATION'/,17X,'PAIR')
      RETURN
30    ELSE
      WRITE(3,40)
40    FORMAT(/// 18X,'THE FOLLOWING ARE ALL ACCEPTABLE ROUTES'/
     211X,'AND ROUTINGS TO SERVE EACH ORIGIN-DESTINATION PAIR'////,
     31X,'ORIGIN-DESTINATION'/,7X,'PAIR')
      RETURN
50    ENDIF
      END
C
C
C
      SUBROUTINE ORGDES(ROW,ICODE,KCODE,LCODE,NCITY,IY2,IORIG,
     2                  IDEST,ORIG,DEST)
C
C     SUBROUTINE ORGDES RETURNS THE ORIGIN-DESTINATION
C     INTEGER CODES (IORIG,IDEST) AND THEIR COORESPONDING
C     CHARACTER CODES
C
C     OUTPUT:IORIG,IDEST,ORIG,DEST
C     INPUT:THE REST
C
      DIMENSION ICODE(NCITY),KCODE(IY2),LCODE(IY2)
      INTEGER IORIG,IDEST,ORIG,DEST,ROW
C
      CALL PAIR(ROW,I1,J2)
      IORIG=I1
      IDEST=J2
      KCODE(1)=I1
      KCODE(2)=J2
      CALL CODES(KCODE,2,ICODE,NCITY,LCODE)
      ORIG=LCODE(1)
      DEST=LCODE(2)
      RETURN
      END
C
C
C
      SUBROUTINE NONSTP(IDIST,ISET,NFREQ,COST,REVEN,NROW,MMYY,
     2                  ICODE,KCODE,LCODE,NCITY,IY2,COL)
C
C     SUBROUTINE NONSTP PRINTS THE NONSTOP ROUTINGS
C
C
C      INPUT : ALL
      DIMENSION REVEN(NROW,MMYY),COST(NROW,MMYY)
      DIMENSION ICODE(NCITY),KCODE(IY2),LCODE(IY2)
      INTEGER ISET(NROW,MMYY),IDIST(NROW,MMYY)
      INTEGER NFREQ(NROW,MMYY)
      INTEGER IORIG,IDEST,ORIG,DEST,COL
C
C
      DO 10 I=1,NROW
      CALL ORGDES(I,ICODE,LCODE,KCODE,NCITY,IY2,
     2            IORIG,IDEST,ORIG,DEST)
      IF (ISET(I,COL).GT. 0) THEN
20    WRITE(3,30) ORIG,DEST,IDIST(I,COL),NFREQ(I,COL),
     2              COST(I,COL),REVEN(I,COL)
30    FORMAT(16X,A4,'- ',A4,9X,'HAS A NONSTOP ROUTE WITH THE FOLLOWING'/
     235X,'CHARACTERISTICS:'//,37X,'DIST =',I4,', FREQ =',I2,
     3', COST =$',F10.3,',' /,37X,'REVENUE =$',F10.3 ///)
35    ELSE
40    WRITE(3,50) ORIG,DEST
50    FORMAT(16X,A4,'- ',A4,9X,'HAS NO ROUTES OR ROUTINGS')
      ENDIF
10    CONTINUE
      RETURN
      END
C
C
      SUBROUTINE CRINFO(CCODE,PTYPE1,PTYPE2,CPOINT)
C
C     CRINFO RETURNS THE CONNECTING ROUTE PATH TYPES
C     AND THE CONNECT POINT
C
C     INPUT:CCODE - CONNECTING ROUTE CODE
C
C     OUTPUT:PTYPE1,PTYPE2 - CONNECT ROUTE PATH TYPES
C           :CPOINT - CONNECT POINT
C
C     TYPES: 1=NONSTOP WITHIN A 1-STOP ROUTE
C            2= 1-STOP ROUTE
      INTEGER CCODE,CODE,PTYPE1,PTYPE2,CPOINT
C
      CODE=CCODE
      ITEMP=-10000
      PTYPE1=0
10    IF(CODE.GT.ITEMP) THEN
      CODE=CODE-ITEMP-10000
20    ELSE
      PTYPE1=PTYPE1+1
      ITEMP=ITEMP-10000
      GO TO 10
30    ENDIF
C
C
      PTYPE2=0
      ITEMP=-100
40    IF(CODE.GT.ITEMP) THEN
      CODE=CODE-ITEMP-100
50    ELSE
      PTYPE2=PTYPE2+1
      ITEMP=ITEMP-100
      GO TO 40
60    ENDIF
      CPOINT=-CODE
      RETURN
      END
C
C
      SUBROUTINE ROWCOL(PTR,ROW,COL)
C
C     ROWCOL CONVERTS POINTER IN PART0/PART1 INTO
C     A ROW AND COLUMN SUBSCRIPT
C
C      INPUT:PTR - POINTER VALUE
C
C     OUTPUT: ROW,COL
C
      INTEGER PTR,ROW,COL,TEMP
C
      TEMP=PTR
      ROW=0
10    IF (TEMP.GT.10) THEN
      ROW=ROW+1
      TEMP=TEMP-10
      GO TO 10
      ELSE
      COL=TEMP
      RETURN
      ENDIF
      END
C
C
      SUBROUTINE SWAPOD(ORG,DES)
C
C     SWAPOD SWAPS THE O-D PAIR
C
C     I/O : ORG,DES
C
      INTEGER ORG,DES,TEMP
C
      TEMP=ORG
      ORG=DES
      DES=TEMP
      RETURN
      END
C
C
C
      SUBROUTINE GETRTE(IORIG,RTE,COL,ARROUT,R,C,ICODE,KCODE,LCODE,
     2                  NCITY,IY2,ROUTE,ORIG)
C
C     GETRTE RETURNS THE ORIGIN-DESTINATION CODES OF THE
C     CONNECTING ROUTE
C
C     OUTPUT:ORIG - ORIGIN CHAR CODE
C           :ROUTE - ARRAY OF DESTINATION CODES
C
C     INPUT: ALL THE REST
C
      DIMENSION ICODE(NCITY),KCODE(IY2),LCODE(IY2)
      INTEGER IORIG,RTE,COL,R,C
      INTEGER ARROUT(R,C)
      INTEGER ROUTE(COL),ORIG
C
C     GET ORIG CODE
      KCODE(1)=IORIG
      CALL CODES(KCODE,1,ICODE,NCITY,LCODE)
      ORIG=LCODE(1)
C
C     GET DESTINATION CODES
      DO 10 I=1,COL
10    KCODE(I)=ARROUT(IORIG,RTE*COL-COL+I)
      CALL CODES(KCODE,COL,ICODE,NCITY,LCODE)
      DO 20 I=1,COL
20    ROUTE(I)=LCODE(I)
      RETURN
      END
C
C
C
      SUBROUTINE NSTOPS(NSIZE,PART0,PART1,NROW,INY,IP0,IP1,ICODE,
     2                   KCODE,LCODE,NCITY,IY2,MMYY,ISET,IDIST,MM,
     3                   COST,REVEN,NFREQ,ROUT0,ROUT1,ROUT2,IY0,IY1)
C
C     NSTOPS PRINTS ALL ACCEPTABLE N-STOP ROUTES (1 OR 2)
C
C     INPUT:ALL
C
C
      DIMENSION COST(NROW,MMYY),REVEN(NROW,MMYY)
      DIMENSION ICODE(NCITY),KCODE(IY2),LCODE(IY2)
      INTEGER PART0(NROW,IP0),PART1(NROW,IP1)
      INTEGER NSIZE(NROW,INY),ISET(NROW,MMYY),IDIST(NROW,MMYY)
      INTEGER NFREQ(NROW,MMYY),ROUT1(NCITY,IY1),ROUT2(NCITY,IY2)
      INTEGER ROUT0(NCITY,IY0)
C
C     VARIABLES
C
C     MM=NUMBER OF STOPS - 1 OR 2
C     IORIG,IDEST= INTEGER CODES OF O-D PAIR
C     ORIG,DEST = CHARACTER CODES OF O-D PAIR
C     PTYPE1,PTYPE2 = TYPE OF PATH TAKEN IN
C     CONNECT ROUTING - 1=NONSTOP,2=1-STOP
C     CPOINT= CONNECT POINT
C     CPCODE= CONNECT POINT CHARACTER CODE
C     CORIG1,CORIG2 = CONNECT ROUTE ORIGINS
C     CDEST1,CDEST2= CONNECT ROUTE ORIGINS
C     ORIG1,ORIG2= CHAR CODES OF CONNECT ROUTE ORIGINS
C     TEMP1,TEMP2= TEMPORARY STORAGE FOR SWAPPING O-D PAIRS
C
      INTEGER MM,IORIG,ORIG,IDEST,DEST,PTYPE1,PTYPE2
      INTEGER CPOINT,CPCODE,CORIG1,CORIG2,CDEST1,CDEST2
      INTEGER TEMP1,TEMP2
      INTEGER ROUTE1(3),ROUTE2(3)
      INTEGER RORG1,RORG2,ND1,ND2,RR1,RR2,ROW,COL
      INTEGER RORIG1,RDEST1,RTE,PTR
      LOGICAL NOROUT
C
C
      DO 10 I=1,NROW
C
C     SET NOROUT=.TRUE.
      NOROUT=.TRUE.
C
C     GET O-D PAIR AND THEIR CODES
C
      CALL ORGDES(I,ICODE,KCODE,LCODE,NCITY,IY2,IORIG,IDEST,
     2            ORIG,DEST)
C
C
C     CHECK FOR CONNECT ROUTING
      IF(NSIZE(I,MM).LT.0) THEN
C
C     SET NOROUT=.FALSE.
      NOROUT=.FALSE.
C     THERE IS CONNECT ROUTING
      CALL CRINFO(NSIZE(I,MM),PTYPE1,PTYPE2,CPOINT)
C
C     GET CPCODE
      KCODE(1)=CPOINT
      CALL CODES(KCODE,1,ICODE,NCITY,LCODE)
      CPCODE=LCODE(1)
C
C     WRITE CONNECT ROUTING HEADING
      WRITE(3,100) ORIG,DEST,CPCODE
C
C     GET CONNECT ROUTING O'S AND D'S
      CORIG1=IORIG
      CDEST1=CPOINT
      CORIG2=CPOINT
      CDEST2=IDEST
C
C     PRINT CONNECTING ROUTES 1 AND 2
      TEMP1=CORIG1
      TEMP2=CDEST1
      IF(TEMP1.GT.TEMP2) CALL SWAPOD(TEMP1,TEMP2)
C
C     PRINT ROUTE 1
      CALL PRCONN(1,TEMP1,TEMP2,PTYPE1,PART0,PART1,
     2                  NROW,IP0,IP1,ROUT0,ROUT1,ROUT2,IY0,IY1,
     3                  IY2,NCITY,ICODE,KCODE,LCODE,ISET,NFREQ,
     4                  MMYY,ROUTE1,ND1,RORG1,RR1)
C
C
      TEMP1=CORIG2
      TEMP2=CDEST2
      IF(TEMP1.GT.TEMP2) CALL SWAPOD(TEMP1,TEMP2)
      CALL PRCONN(2,TEMP1,TEMP2,PTYPE2,PART0,PART1,
     2                  NROW,IP0,IP1,ROUT0,ROUT1,ROUT2,IY0,IY1,
     3                  IY2,NCITY,ICODE,KCODE,LCODE,ISET,NFREQ,
     4                  MMYY,ROUTE2,ND2,RORG2,RR2)
C
C     PRINT CONNECT ROUTE SUMMARY
      WRITE(3,200) NFREQ(I,MM),COST(I,MM),REVEN(I,MM)
C
C     PRINT PATHS TAKEN IN CONNECT ROUTING
C
       CALL PPATH(CORIG1,CDEST1,RORG1,ROUTE1,ND1,PTYPE1,RR1,MM,ICODE,
     2            KCODE,LCODE,NCITY,IY2,IDIST,COST,REVEN,NROW,MMYY)
       CALL PPATH(CORIG2,CDEST2,RORG2,ROUTE2,ND2,PTYPE2,RR2,MM,ICODE,
     2            KCODE,LCODE,NCITY,IY2,IDIST,COST,REVEN,NROW,MMYY)
      ELSE
      ENDIF
C
C
C     PRINT ALL ROUTES USING NSIZE ENTRIES
      DO 1000 I2=1,MM
C
C
      IF (NSIZE(I,I2).GT.0) THEN
C     DETERMINE THE NUMBER OF VALID POINTER ENTRIES
C     IN PART0/PART1 AND THE SUBSCRIPT OF THE FIRST
C     VALID ENTRY
C
C     M= NUMBER OF VALID ENTRIES
C     N = SUBSCRIPT OF FIRST VALID ENTRY
      M=NSIZE(I,I2)
      N=1
      DO 5 J=1,NSIZE(I,I2)
      IF(I2.EQ.1) THEN
      PTR=PART0(I,J)
7     ELSE
      PTR=PART1(I,J)
8     ENDIF
      CALL ROWCOL(PTR,ROW,COL)
      IF(COL.LE.MM) THEN
      M=M-1
      N=N+1
9     ELSE
11    ENDIF
5     CONTINUE
      IF(M.GT.0) THEN
C
C     VALID ROUTE
C     SET FLAG NOROUT TO FALSE
      NOROUT=.FALSE.
      IF (I2.EQ.1) THEN
C     NONSTOP ROUTE WITHIN MM-STOP ROUTE
      WRITE(3,300) ORIG,DEST,M,MM
15    ELSE
C     MSTOP STOP ROUTE WITHIN MM-STOP ROUTE
      MSTOP=I2-1
      WRITE(3,400) ORIG,DEST,MSTOP,M,MM
20    ENDIF
25    ELSE
27    ENDIF
C
C     PRINT EACH ROUTE USING POINTER IN PART0 OR PART1
C
      DO 30 J=N,NSIZE(I,I2)
      IF(I2.EQ.1) THEN
      PTR=PART0(I,J)
40    ELSE
      PTR=PART1(I,J)
50    ENDIF
C
C     GET ROW AND COL FROM PTR
      CALL ROWCOL(PTR,ROW,COL)
C
C     GET NEW ORIGIN
      CALL PAIR(ROW,RORIG1,RDEST1)
C
      RTE=ISET(ROW,COL)
C
C    GET AND PRINT ROUTE
      IF(MM.EQ.1) THEN
      CALL GETRTE(RORIG1,RTE,2,ROUT1,NCITY,IY1,ICODE,KCODE,LCODE,
     2            NCITY,IY2,ROUTE1,RORG1)
60    ELSE
      CALL GETRTE(RORIG1,RTE,3,ROUT2,NCITY,IY2,ICODE,KCODE,
     2            LCODE,NCITY,IY2,ROUTE1,RORG1)
70    ENDIF
      WRITE(3,500) RORG1
75    WRITE(3,600) (ROUTE1(K),K=1,MM+1)
      WRITE(3,700) IDIST(ROW,COL),NFREQ(ROW,COL),
     2 COST(ROW,COL),REVEN(ROW,COL)
30    CONTINUE
      ELSE
      ENDIF
1000  CONTINUE
C
C
C     CHECK 1-STOP ROUTE OR 2-STOP ROUTE (MM-STOP ROUTE)
C
      IF(ISET(I,MM+1).GT.0) THEN
C     SET FLAG NOROUT
      NOROUT=.FALSE.
      COL=MM+1
      RTE=ISET(I,COL)
      IF (MM.EQ.1) THEN
C
C     1-STOP ROUTE
C
      CALL GETRTE(IORIG,RTE,COL,ROUT1,NCITY,IY1,ICODE,KCODE,
     2             LCODE,NCITY,IY2,ROUTE1,RORG1)
80    ELSE
      CALL GETRTE(IORIG,RTE,COL,ROUT2,NCITY,IY2,ICODE,KCODE,
     2             LCODE,NCITY,IY2,ROUTE1,RORG1)
90    ENDIF
      WRITE(3,750) ORIG,DEST,MM,RORG1
85    WRITE(3,600) (ROUTE1(K),K=1,COL)
      WRITE(3,700) IDIST(I,COL),NFREQ(I,COL),
     2 COST(I,COL),REVEN(I,COL)
      ELSE
      ENDIF
C
C
C     CHECK FOR NO ROUTING
C
      IF(NOROUT) WRITE(3,800) ORIG,DEST
10    CONTINUE
      RETURN
C
C PRINT FORMATS
C
100   FORMAT(//1X,A4,'- ',A4,'HAS THE FOLLOWING CONNECT ROUTING,',
     2 1X,'CONNECTING AT ',A4,'USING THE FOLLOWING:'//)
200   FORMAT(//5X,'COMBINED DISTANCE =',I4,' ADDITIONAL COST',
     1 1X,'DUE TO CONNECT TRAFFIC =$',
     2 F10.2,/5X,'ADDITIONAL REVENUE FROM THE CONNECT TRAFFIC =$',
     3 F10.2 //)
300   FORMAT(//1X,A4,'- ',A4,'IS A NONSTOP ROUTE WITHIN THE',
     2 1X,'FOLLOWING',I2,1X,I2,'-STOP ROUTES')
400   FORMAT(//1X,A4,'- ',A4,'IS A',I2,'-STOP ROUTE WITHIN THE',
     2 1X,'FOLLOWING',I2,1X,I2,'-STOP ROUTES')
500   FORMAT(//11X,A4)
600   FORMAT('+',15X,3('- ',A4))
700   FORMAT(//11X,'DISTANCE =',I4,', FREQ =',
     2 I2,', COST =$',F10.2,', REVENUE =$',F10.2)
750   FORMAT(//1X,A4,'- ',A4,'IS A',I2,'-STOP ROUTE',
     2 1X,'THE FOLLOWING CHARACTERISTICS'//,11X,A4)
800   FORMAT(//1X,A4,'- ',A4,'HAS NO ROUTES OR ROUTINGS')
      END
C
C
C
      SUBROUTINE PRCONN(RNUM,IORIG,IDEST,TYPE,PART0,PART1,
     2                  NROW,IP0,IP1,ROUT0,ROUT1,ROUT2,IY0,IY1,
     3                  IY2,NCITY,ICODE,KCODE,LCODE,ISET,NFREQ,
     4                  MMYY,ROUTE,NDEST,RORIG,RROW)
C
C
C     PRCONN PRINTS THE CONNECTING ROUTE
C
C     INPUT:RNUM - ROUTE NUMBER (1 OR 2)
C          :IORIG,IDEST -CONNECTING ROUTE O-D
C           :TYPE - ROUTE TYPE
C
C
C     OUTPUT:ROUTE - DESTINATION CODES OF ROUTE EXCLUDING
C                    ORIGIN
C           :RORIG- CHAR CTER CODE OF ROUTE ORIGIN
C           :RROW - ROW NUMBER OF ROUTE
C           :NDEST - NUMBER OF CODES IN ARRAY ROUTE
C
C     ALL OTHERS ARE INPUT
C
      DIMENSION ICODE(NCITY),LCODE(IY2),KCODE(IY2)
      INTEGER PART0(NROW,IP0),PART1(NROW,IP1)
      INTEGER ROUT0(NCITY,IY0),ROUT1(NCITY,IY1),ROUT2(NCITY,IY2)
      INTEGER NFREQ(NROW,MMYY),ISET(NROW,MMYY)
      INTEGER RNUM,IORIG,IDEST,TYPE,PTR,COL,RTE
      INTEGER ROUTE(NDEST),RORIG,RROW,PORIG,PDEST
C
C     GET ROW NUMBER FOR O-D PAIR
      CALL GETROW(IORIG,IDEST,NCITY,RROW)
C
C     CHECK FOR POINTER IN PART0,PART1
      IF(TYPE.EQ.1) THEN
      PTR=PART0(RROW,1)
10    ELSE
      PTR=PART1(RROW,1)
20    ENDIF
C
C     GET AND PRINT ROUTE USING POINTER
C
      IF(PTR.NE.0) THEN
      CALL ROWCOL(PTR,RROW,COL)
      RTE=ISET(RROW,COL)
C
C     GET NEW ORIGIN FROM POINTER ROW
      CALL PAIR(RROW,PORIG,PDEST)
C     NONSTOP ROUTE WITHIN 1-STOP ROUTE
      IF(TYPE.EQ.1) THEN
      NDEST=2
      CALL GETRTE(PORIG,RTE,NDEST,ROUT1,NCITY,IY1,ICODE,KCODE,
     2            LCODE,NCITY,IY2,ROUTE,RORIG)
30    ELSE
C     1-STOP ROUTE  WITHIN 2-STOP ROUTE
      NDEST=3
      CALL GETRTE(PORIG,RTE,NDEST,ROUT2,NCITY,IY2,ICODE,KCODE,
     2            LCODE,NCITY,IY2,ROUTE,RORIG)
40    ENDIF
50    ELSE
C     NO POINTER - NONSTOP ROUTE USING ISET(RROW,TYPE)
      COL=TYPE
      RTE=ISET(RROW,TYPE)
      IF(TYPE.EQ.1) THEN
      NDEST=1
      CALL GETRTE(IORIG,RTE,NDEST,ROUT0,NCITY,IY0,ICODE,KCODE,
     2            LCODE,NCITY,IY2,ROUTE,RORIG)
60    ELSE
C
C     1-STOP ROUTE
      NDEST=2
      CALL GETRTE(IORIG,RTE,NDEST,ROUT1,NCITY,IY1,ICODE,KCODE,
     2            LCODE,NCITY,IY2,ROUTE,RORIG)
70    ENDIF
80    ENDIF
C     PRINT ROUTE
      WRITE(3,100) RNUM,RORIG
77    WRITE(3,150) (ROUTE(I),I=1,NDEST)
      WRITE(3,200) NFREQ(RROW,COL)
      RETURN
C
C     PRINT FORMATS
100   FORMAT(11X,'ROUTE',I2,':  ',A4)
150   FORMAT('+',25X,3('- ',A4))
200   FORMAT('+',47X,'FREQ =',I2)
      END
C
C
      SUBROUTINE PPATH(IORIG,IDEST,ORIG,ROUTE,NDEST,TYPE,ROW,MM,ICODE,
     2                 KCODE,LCODE,NCITY,IY2,IDIST,COST,REVEN,NROW,MMYY)
C
C     SUBROUTINE PPATH PRINTS A PATH TAKEN IN THE CONNECT ROUTING
C     AND PRINTS THE ROUTE CONTAINING THE PATH
C
      DIMENSION ICODE(NCITY),KCODE(IY2),LCODE(IY2)
      DIMENSION COST(NROW,MMYY),REVEN(NROW,MMYY)
      INTEGER ROUTE(NDEST),IDIST(NROW,MMYY)
      INTEGER IORIG,IDEST,ORIG,NDEST,TYPE,ROW,MM
C
C     INPUT: IORIG,IDEST - O-D PAIR OF PATH
C          : ORIG - CODE OF PATH ORIGIN
C          : ROUTE - ARRAY OF PATH ROUTE DESTINATIONS
C          : NDEST - NUMBER OF ROUTE DESTINATIONS
C                   EXCLUDING ORIGIN
C          : TYPE - TYPE OF PATH TAKEN
C          : ROW - ROW NUMBER OF PATH ROUTE
C          : MM - TYPE OF CONNECTING ROUTE
C
C     ALL OTHERS ARE INPUT
C
C     GET O-D PAIR CODES
      KCODE(1)=IORIG
      KCODE(2)=IDEST
      CALL CODES(KCODE,2,ICODE,NCITY,LCODE)
C     PRINT PATH AND ROUTE
      IF(TYPE.EQ. 1) THEN
      WRITE(3,15) LCODE(1),LCODE(2),MM,ORIG
20    ELSE
      M=NDEST-1
      WRITE(3,25) LCODE(1),LCODE(2),M,MM,ORIG
30    ENDIF
40    WRITE(3,35) (ROUTE(I),I=1,NDEST)
      WRITE(3,45) IDIST(ROW,NDEST),COST(ROW,NDEST),
     2 REVEN(ROW,NDEST)
      RETURN
15    FORMAT(6X,A4,'- ',A4,'IS A NONSTOP ROUTE WITHIN',
     2 1X,'THE FOLLOWING TO ACCOMMODATE THE ABOVE'/,16X,
     3 'CONNECT TRAFFIC',I2,'-STOP ROUTE'//,11X,A4)
25    FORMAT(6X,A4,'- ',A4,'IS A',I2,'-STOP ROUTE',1X,
     2 'WITHIN THE FOLLOWING TO ACCOMMODATE THE ABOVE',
     3 //16X,'CONNECT TRAFFIC',I2,'-STOP ROUTE:'//,11X,
     4 A4)
35    FORMAT('+',15X,3('- ',A4))
45    FORMAT(//11X,'DISTANCE =',I4,
     2 ', COST =$',F10.2,', REVENUE =$',F10.2//)
      END
