C Originally coded by S.F. BAKER                             
C MINIMAL SPANNING FOREST PROGRAM              
C FOR DCS PROBLEM SET                          
C                       
C VARIABLE EXPLANATION:                 
C N: # OF NODES                       
C NDEP: # OF DEPOTS TO BE SELECTED              
C       (NOT INCLUDING FIXED DEPOTS)            
C NFXDEP: # OF FIXED DEPOTS                     
C NDPCAN: # OF DEPOT CANDIDATES                 
C         (NOT INCLUDING FIXED)                 
C NMND: N-NTDEP, OR NODES                
C       MINUS TOTAL DEPOTS                      
C NTDEP: TOTAL DEPOTS (NDEP+NFXDEP)            
C LAT,LONG: COORDINATES OF NODE                 
C LATR,LONGR: COORDINATES IN RADIANS            
C W: DISTANCE MATRIX                        
C FREQ: FREQUENCY OF DEMAND                     
C D1-D9: LOOP INDEX OF SELECTED DEPOTS            
C NEAR: SELECTED NODE WHICH IS CLOSEST            
C       TO INDEXED NODE                       
C DIST: DISTANCE BETWEEN NEAR AND ITS INDEX            
C TCOUNT: COUNTER OF SELECTED EDGES                    
C V: DUMMY VAR TO HOLD A CANDIDATE NODE             
C DEPOT: DEPOT ASSOCIATED WITH A BRANCH
C TEDGE1: EMINENT NODE OF AN EDGE                   
C TEDGE2: INCIDENT NODE OF AN EDGE                  
C TWGT: SUMMED WEIGHTS OF A FOREST                  
C TW: DISTANCE FROM DEPOT TO NODE *                 
C     SERVICING FREQUENCY                       
C BESTW: BEST TWGT OF DEPOT ITERATIONS            
C EBST1,EBST2: BEST OF TEDGE1,TEDGE2              
C ID,INF: DUMMY VARS TO HOLD MIN EDGES            
C                        
* WHEN ALTERING PROBLEMS, THE FOLLOWING            
* MUST BE CHANGED TO ACCOMODATE:           
* SUCH CHANGES ARE FLAGGED BY AN ASTERIK           
* IN A NEARBY COMMENT LINE                   
C 1) PARAMETER LINE AT TOP OF PROGRAM              
C 2) LOOP 30, WHICH MUST REFLECT ALL POSSIBLE            
C    COMBINATIONS OF POTENTIAL DEPOTS. THERE             
C    WILL BE NDEP DO STATEMENTS.        
C 3) THE DATA FILE MUST INCLUDE THE FIXED DEPOTS            
C    FIRST, FOLLOWED BY THE POTENTIAL DEPOTS,            
C    FOLLOWED BY THE REMAINING DEMANDS                   
C 4) THE OPEN STATEMENTS IN DECLARATION SEGMENT
C    MUST REFLECT DESIRED INPUT AND OUTPUT FILENAMES
C                      
C DECLARATIONS                                      
*           
      PARAMETER(N=181,NDEP=8,NFXDEP=3,               
     1 NDPCAN=27,NMND=170,NTDEP=11)             
      REAL LAT(N),LONG(N)                           
      DOUBLE PRECISION LATR(N),LONGR(N)             
      INTEGER W(N,N),FREQ(N),D(NTDEP),D1,D2,           
     1 NEAR(N),DIST(N),TCOUNT,V,                           
     2 TEDGE1(NMND),TEDGE2(NMND),TWGT,TW(N),               
     3 BESTW,EBST1(NMND),EBST2(NMND),ID, 
     4 D3,D4,D5,D6,D7,D8,D9,IDEP(NTDEP),DEPOT(N)                 
*
       OPEN(4,FILE='CON22.DAT',STATUS='OLD')                 
       OPEN(6,FILE='CON8A.OUT',STATUS='NEW')           
      INF=3000                                             
      BESTW=5000000                                  
C                                                      
C INPUT LOCATIONS                                      
C                                                      
      DO 5 I=1,N                                       
       READ(4,100) LAT(I),LONG(I),FREQ(I)              
*
* INCLUDE IF INPUT ECHO IS DESIRED
*       WRITE(6,100) LAT(I),LONG(I),FREQ(I)             
C                                                      
C CONVERT TO RADIANS                                   
C                                                      
      LATR(I)=((LAT(I)-AINT(LAT(I)))/.6                
     1           +AINT(LAT(I)))*3.141592653/180            
      LONGR(I)=((LONG(I)-AINT(LONG(I)))/.6                 
     1           +AINT(LONG(I)))*3.141592653/180            
5     CONTINUE                                              
C                                                     
C COMPUTE DISTANCE MATRIX                             
C                                                     
      DO 10 I=1,N                                     
       DO 10 J=1,I                                    
        IF (I.EQ.J) THEN   
         W(I,J)=0   
        ELSE   
        W(I,J)=INT(3956.013*ACOS(SIN(LATR(I))            
     1         *SIN(LATR(J))+COS(LATR(I))*COS(LATR(J))          
     2         *COS(ABS(LONGR(J)-LONGR(I)))))+150           
        W(J,I)=W(I,J)      
        ENDIF                      
10    CONTINUE                                
C      DO 20 I=1,N                        
C       WRITE(6,200) (W(I,J),J=1,N)            
20    CONTINUE                        
C                  
C DEFINE FIXED DEPOTS                  
C                  
      DO 21 I=1,NFXDEP  
       D(I)=I  
21    CONTINUE      
C                              
C LOOP FOR DEPOT CHOICE ITERATIONS            
C                                              
*
      DO 30 D1=NFXDEP+1,NFXDEP+NDPCAN-NDEP+1            
       D(NFXDEP+1)=D1                                 
       DO 30 D2=D1+1,NFXDEP+NDPCAN-NDEP+2                
        D(NFXDEP+2)=D2                              
        DO 30 D3=D2+1,NFXDEP+NDPCAN-NDEP+3            
         D(NFXDEP+3)=D3                  
         DO 30 D4=D3+1,NFXDEP+NDPCAN-NDEP+4           
          D(NFXDEP+4)=D4        
          DO 30 D5=D4+1,NFXDEP+NDPCAN-NDEP+5       
           D(NFXDEP+5)=D5       
           DO 30 D6=D5+1,NFXDEP+NDPCAN-NDEP+6 
            D(NFXDEP+6)=D6 
            DO 30 D7=D6+1,NFXDEP+NDPCAN-NDEP+7 
             D(NFXDEP+7)=D7 
             DO 30 D8=D7+1,NFXDEP+NDPCAN-NDEP+8 
              D(NFXDEP+8)=D8 
C                                               
C RESET COUNTERS BETWEEN ITERATIONS             
C INDENTS RESTARTED IN CODE                     
C                                      
      ID=3000                 
      V=0                     
      TCOUNT=0                
      TWGT=0                   
      DO 35 J=1,N              
       TW(J)=0                 
35    CONTINUE                 
C                             
C SET NEAR EQUAL TO NEAREST DEPOT             
C                                 
      DO 40 J=1,N                 
       ID=3000                   
       DO 40 I=1,NFXDEP+NDEP             
        IF (W(D(I),J).LT.ID) THEN             
         NEAR(J)=D(I)    
         DEPOT(J)=NEAR(J)              
         DIST(J)=W(D(I),J)             
         ID=W(D(I),J)                 
        ENDIF                          
      CONTINUE                         
40    CONTINUE                         
C                                   
C SET DEPOTS NEAR NOTHING IMPLYING             
C CURRENT INCLUSION INTO FOREST                
C                                    
      DO 45 I=1,NFXDEP+NDEP            
         NEAR(D(I))=0    
         DEPOT(D(I))=D(I)                
45    CONTINUE                          
C                                       
C SELECT MINIMUM EDGE                   
C                                      
50    IF (TCOUNT.LT.NMND) THEN             
       MIN=INF                             
       DO 60 J=1,N                         
C CHECK FOR QUALIFIED EDGE                 
        IF ((NEAR(J).GT.0).AND.             
     1     (DIST(J).LT.MIN).AND.            
     2     (W(DEPOT(NEAR(J)),J).LT.1000)) THEN             
C IF BEST AND QUALIFIED, SELECT              
         V=J                                 
         MIN=DIST(J)               
        ENDIF                       
60     CONTINUE            
C             
C PENALTY FOR INFEASIBILITY            
C            
       IF (MIN.EQ.INF) DIST(V)=1000000              
C                            
C UPDATE FOREST WITH NEW BRANCH            
C                                      
       TCOUNT=TCOUNT+1                   
       TEDGE1(TCOUNT)=NEAR(V)             
       TEDGE2(TCOUNT)=V                   
       TW(V)=TW(NEAR(V))+DIST(V)             
       TWGT=TWGT+TW(V)*FREQ(V)  
       DEPOT(V)=DEPOT(NEAR(V))            
       NEAR(V)=0                           
C                                       
C UPDATE NEAR                        
C                                     
       DO 70 J=1,N                   
        IF (NEAR(J).NE.0) THEN             
         IF (W(J,NEAR(J)).GT.W(J,V) 
     1   .AND.(W(DEPOT(V),J).LT.1000)) THEN             
          DIST(J)=W(J,V)                
          NEAR(J)=V                     
         ENDIF                          
        ENDIF                           
70     CONTINUE                        
       GO TO 50                        
      ENDIF                            
C                                       
C STORE FOREST AS BEST IF APPLICABLE            
C                                          
      IF (TWGT.LT.BESTW) THEN              
       BESTW=TWGT                       
       DO 80 J=1,NMND                   
        EBST1(J)=TEDGE1(J)              
        EBST2(J)=TEDGE2(J)                    
80     CONTINUE                         
       DO 81 J=1,NTDEP 
        IDEP(J)=D(J) 
81     CONTINUE 
      ENDIF                              
30    CONTINUE                          
C           
C WRITE RESULTS           
C           
      WRITE(6,*)'BEST WEIGHT=',BESTW            
      WRITE(6,*)'DEPOTS=' 
      WRITE(6,200) (IDEP(I), I=1,NTDEP)        
      WRITE(6,*)'EMINATING NODES ON TOP'              
      WRITE(6,*) 'INCIDENT NODES BELOW'             
      JU=NMND       
      JL=1       
90    IF (JU.LE.10) THEN       
       WRITE(6,300) (EBST1(J), J=JL,NMND)             
       WRITE(6,300) (EBST2(J), J=JL,NMND)       
       WRITE(6,*)       
       STOP             
      ELSE       
       WRITE(6,300) (EBST1(J), J=JL,JL+9)       
       WRITE(6,300) (EBST2(J), J=JL,JL+9)       
       WRITE(6,*)       
      ENDIF       
      JU=JU-10       
      JL=JL+10       
      GO TO 90       
100   FORMAT(1X,F5.2,3X,F6.2,2X,I2)            
200   FORMAT(1X,11I5)               
300   FORMAT(1X,10I5)                 
      END              
