C CAPT S.F. BAKER              
C MODIFIED CLARKE-WRIGHT ALGORITHM          
C MODIFIED BY BRAD SMITH 7/95
C   MODIFIED TO WORK WITH ANY DATA SET
C   AND HANDLE FILE ERRORS
C
C VARIABLE EXPLANATION:          
C N: NUMBER OF DEMAND POINTS (NODES OTHER       
C    THAN DEPOT WITH          
C    FREQUENCY 2 COUNTS AS 2)          
C MAX: MAXIMUM N VALUE ALLOWABLE FOR THIS COMPILATION.
C       MAY NEED TO BE ADJUSTED FOR A VERY LARGE DATA
C       SET OR FOR A COMPUTER WITH VERY LITTLE MEMORY.
C LAT,LONG: LATITUDE AND LONGITUDE OF NODE          
C LATR,LONGR: LAT AND LONG IN RADIANS          
C DEP: NUMBER OF EDGES A NODE SHARES WITH DEPOT          
C C: DEMAND FREQUENCY OF A NODE          
C W: DISTANCE BETWEEN 2 NODES          
C S: POTENTIAL SAVINGS FROM ROUTE CONSOLIDATION          
C NCV: NODES INCLUDED (J) IN SAME TOUR AS I          
C R: DISTANCE FROM ORIGIN OF A NODE IF 1          
C    ORIGIN EDGE IS SEVERED           
C NC: TOUR ASSOCIATED WITH NODE I          
C U,V: DUMMY VARS HOLDING CURRENT          
C      CONSOLIDATION OPTION          
C CI,IRIJ,ICV: DUMMY VARS HOLDING CURRENT          
C     C,R,NC          
C MIN: BEST KNOWN SAVINGS IN ITERATION          
C TOT: MILEAGE TOTAL         
C          
C REQUIREMENTS FOR ALTERING DATA SET          
C 1) CHANGE THE FIRST LINE OF THE DATA FILE
C     TO AN INTEGER EQUAL TO THE NUMBER OF
C     TOTAL DEMANDS (N) (DEPOT COUNTS AS          
C     1 ALWAYS, OTHER NODES COUNT AS THEIR          
C     DEMAND FREQUENCY)          
C 2) INSURE DEPOT IS FIRST IN DATA SET          
C 3) COMMENT OUT DISTANCE MATRIX ECHO          
C     IF N IS LARGE (>15)          
C                
C DECLARATIONS            
C                        
      PARAMETER(MAX=100)           
      REAL LAT(MAX),LONG(MAX)           
      DOUBLE PRECISION LATR(MAX),LONGR(MAX)           
      INTEGER DEP(MAX),C(MAX),W(MAX,MAX),S(MAX,MAX),          
     1 NCV(MAX,MAX),R(MAX),U,V,CI,NC(MAX),TOT,N              
      CHARACTER*12 INFILENAME,OUTFILENAME
      WRITE(*,'(A\)') ' ENTER THE NAME OF THE DATA FILE: '
      READ(*,'(A)') INFILENAME
      WRITE(*,'(A\)') ' ENTER THE NAME OF THE OUTPUT FILE: '
      READ(*,'(A)') OUTFILENAME
      OPEN(4,FILE=INFILENAME,STATUS='OLD',ERR=997)          
      OPEN(6,FILE=OUTFILENAME,STATUS='UNKNOWN',ERR=998)          
C                                   
C OUTPUT SETUP                     
C AND INPUT LOCATIONS              
C                        
      READ(4,400) N
      WRITE(6,*)'INPUT LAT, LONG, CLUSTER'          
      I=1                            
2     IF (I.LE.N) THEN            
       READ(4,100) LAT(I),LONG(I),C(I)           
       CI=C(I)                        
C WRITE LAT, LONG C IF DEPOT          
       IF (I.EQ.1) WRITE(6,100,ERR=999) LAT(I),LONG(I),C(I)           
C DUPLICATE NODES IF NECESSARY TO REFLECT DEMAND          
        IF (I.GT.1) THEN            
         DO 5 J=0,CI-1              
          LAT(I+J)=LAT(I)            
          LONG(I+J)=LONG(I)          
          C(I+J)=C(I)                 
          WRITE(6,100,ERR=999) LAT(I+J),LONG(I+J),C(I+J)          
C LOAD INITIAL TOUR NUMBERS, TOUR LOADS          
          DO 5 K=0,CI-1                
           NC(I+J)=I+J                  
           NCV(NC(I+J),I+K)=1           
5        CONTINUE             
        ELSE                   
         CONTINUE              
        ENDIF                  
C INCREMENT I TO NEXT NODE          
        I=I+CI                 
        GOTO 2                
       ELSE                   
        CONTINUE              
       ENDIF                   
C CONVERT TO RADIANS           
      DO 8 I=1,N          
      LATR(I)=((LAT(I)-AINT(LAT(I)))/.6           
     1       +AINT(LAT(I)))*3.141592653/180          
      LONGR(I)=((LONG(I)-AINT(LONG(I)))/.6           
     1       +AINT(LONG(I)))*3.141592653/180          
8     CONTINUE                   
C                                 
C INITIALIZE ARRAYS AND          
C COMPUTE DISTANCE MATRIX           
C                                   
      DO 10 I=1,N                  
       DEP(I)=2                    
C SET DISTANCE TO 0 IF IDENTICAL LOCATION          
       DO 10 J=1,I                  
        DIFLAT=ABS(LAT(I)-LAT(J))           
        DIFLON=ABS(LONG(I)-LONG(J))           
        IF ((DIFLAT.LT..01).OR.(DIFLON.LT..01)) THEN           
          W(I,J)=0           
        ELSE                 
        W(I,J)=INT(3956.013*ACOS(SIN(LATR(I))           
     1        *SIN(LATR(J))+COS(LATR(I))*COS(LATR(J))           
     2        *COS(ABS(LONGR(J)-LONGR(I)))))+150          
C INITIAL R AND SAVINGS CALCULATION          
        R(I)=W(I,1)                           
        S(I,J)=W(I,1)+W(J,1)-W(I,J)            
        ENDIF                
10    CONTINUE                
C                             
C OUTPUT DISTANCE HALF MATRIX          
C AND SETUP OUTPUT                      
C                                   
      DO 20 I= 1,N                      
C COMMENT OUT IF N IS LARGE          
       WRITE(6,200,ERR=999) (W(I,J),J=1,I)           
20    CONTINUE                      
      WRITE(6,*)'ARCS IN THE SOLUTION'           
C                                   
C FIND GREATEST SAVINGS                
C DISQUALIFY IF                        
C 1) NODE IS INTERNAL TO A ROUTE           
C 2) SAVINGS NOT THE BEST                  
C 3) RANGE EXCEEDED                        
C 4) TOUR INCLUDES > 1 VISITS/CLUSTER          
C                                   
40    DO 50 I=2,N                  
       DO 50 J=1,I-1               
        IF ((DEP(I).LE.0).OR.(DEP(J).LE.0)) GOTO 70           
        IF (S(I,J).LE.MIN) GOTO 70            
        IRIJ=R(I)+R(J)+W(I,J)                 
        IF (IRIJ.GT.2600) GOTO 70              
        DO 60 K=1,N                           
         NCVI=NCV(NC(I),K)+NCV(NC(J),K)           
         IF (NCVI.GT.1) GOTO 70             
60       CONTINUE                     
C                                   
C HOLD BEST SAVINGS IN PASS           
C                                   
        MIN =S(I,J)            
        U=I                   
        V=J                    
70     CONTINUE                
C                              
C UPDATE ARRAYS AND WRITE NEW ARC          
C                                   
50    CONTINUE                       
C QUIT IF NO QUALIFIED CONSOLIDATION          
      IF(MIN.EQ.0) GOTO 80           
C UPDATE CONSOLIDATED NODE ARRAYS          
      DEP(U)=DEP(U)-1                
      DEP(V)=DEP(V)-1                
C UPDATE RANGE VARS   
      IRU=R(U)  
      IRV=R(V)  
      DO 55 J=1,N   
       IF (NC(J).EQ.NC(U))   
     1   R(J)=R(J)+W(U,V)+IRV-W(U,1)  
       IF (NC(J).EQ.NC(V))   
     1   R(J)=R(J)+W(U,V)+IRU-W(V,1)  
55    CONTINUE   
      S(U,V)=0             
      ICV=NC(V)           
      DO 65 J=1,N          
       NCV(NC(U),J)=NCV(NC(U),J)+NCV(NC(V),J)          
65    CONTINUE          
C CONSOLIDATE TOUR LOADING ARRAYS INTO ONE TOUR           
      DO 68 J=1,N                
       IF (NC(J).EQ.ICV) NC(J)=NC(U)          
68    CONTINUE                      
C ADD NEW LEG TO TOTAL   
      TOT=TOT+W(U,V)         
C WRITE NEW LINK AND RETURN          
      WRITE(6,300,ERR=999) U,V           
      MIN=0                      
      GOTO 40             
80    CONTINUE                   
C                                
C WRITE REMAINING DEPOT CONNECTIONS           
C                                   
      DO 90 I=2,N                     
       IF(DEP(I).EQ.1) THEN         
        TOT=TOT+W(I,1)         
        WRITE(6,500,ERR=999) I                
       ELSEIF (DEP(I).EQ.2) THEN         
        TOT=TOT+2*W(I,1)           
        WRITE(6,600,ERR=999) I          
       ELSE                      
       CONTINUE                 
       ENDIF                    
90    CONTINUE         
C WRITE TOTAL COST         
      WRITE(6,*,ERR=999) 'THE TOTAL COST='         
      WRITE(6,400,ERR=999) TOT              
100   FORMAT(1X,F5.2,3X,F6.2,2X,I2)           
200   FORMAT(1X,15I4)           
300   FORMAT(1X,2I3)            
400   FORMAT(1X,I6)            
500   FORMAT(1X,I3,'  1')           
600   FORMAT(1X,I3,'  1 TWICE')           
      GOTO 1000
997   WRITE(*,*) 'ERROR OPENING ',INFILENAME
      WRITE(*,*) 'MAKE SURE THAT THE NAME OF THE DATA FILE IS' 
      WRITE(*,*) 'SPELLED CORRECTLY.'
      GOTO 1000
998   WRITE(*,*) 'ERROR OPENING ',OUTFILENAME
      WRITE(*,*) 'MAKE SURE YOU HAVE WRITE PERMISSION IN'
      WRITE(*,*) 'THIS DIRECTORY.'
      GOTO 1000
999   WRITE(*,*) 'ERROR WRITING TO ',OUTFILENAME
      WRITE(*,*) 'DISK MAY BE FULL OR WRITE-PROTECTED.'
1000  END   
