C Originally coded by S.F. BAKER                                 
C MODIFIED BY BRAD SMITH 7/95
C   MODIFIED TO WORK WITH ANY DATA SET
C   AND HANDLE FILE ERRORS
C
C MINIMAL SPANNING FOREST PROGRAM                  
C MODEL ALTERED TO INCLUDE TWO FIXED DEPOTS   
C                           
C VARIABLE EXPLANATION:                     
C N: # OF NODES (CLUSTERS COUNT AS 1)                           
C NDEP: # OF DEPOTS TO BE SELECTED                  
C       (NOT INCLUDING FIXED DEPOTS)                
C NFXDEP: # OF FIXED DEPOTS                         
C NDPCAN: # OF DEPOT CANDIDATES                     
C         (NOT INCLUDING FIXED)                     
C NMND: N-NTDEP, OR NODES                    
C       MINUS TOTAL DEPOTS                          
C NTDEP: TOTAL DEPOTS (NDEP+NFXDEP)                
C LAT,LONG: COORDINATES OF NODE                     
C LATR,LONGR: COORDINATES IN RADIANS                
C W: DISTANCE MATRIX                            
C FREQ: FREQUENCY OF DEMAND                         
C D1-D9: LOOP INDEX OF SELECTED DEPOTS                
C NEAR: SELECTED NODE WHICH IS CLOSEST                
C       TO INDEXED NODE                           
C DIST: DISTANCE BETWEEN NEAR AND ITS INDEX                
C TCOUNT: COUNTER OF SELECTED EDGES                        
C V: DUMMY VAR TO HOLD A CANDIDATE NODE                 
C TEDGE1: EMINENT NODE OF AN EDGE                       
C TEDGE2: INCIDENT NODE OF AN EDGE                      
C TWGT: SUMMED WEIGHTS OF A FOREST                      
C TW: DISTANCE FROM DEPOT TO NODE *                     
C     SERVICING FREQUENCY                           
C BESTW: BEST TWGT OF DEPOT ITERATIONS                
C EBST1,EBST2: BEST OF TEDGE1,TEDGE2                  
C ID,INF: DUMMY VARS TO HOLD MIN EDGES                
C MAXN,MAXNTDEP,MAXNMND: MAXIMUM ALLOWABLE
C   VALUES OF N, NTDEP, AND NMND FOR THIS
C   COMPILATION.  USED TO ALLOCATE MEMORY FOR
C   ARRAYS, WHICH CANNOT BE DONE AT RUN-TIME.
C
C WHEN ALTERING PROBLEMS, THE FOLLOWING                
C MUST BE CHANGED TO ACCOMODATE:               
C SUCH CHANGES ARE FLAGGED BY AN ASTERISK             
C IN A NEARBY COMMENT LINE                       
C 1) PARAMETERS IN TOP LINE OF DATA FILE
C    PARAMETERS ARE IN THE ORDER OF:
C    N,NDEP,NFXDEP,NDPCAN,NMND,NTDEP,D(1),D(2)
C 2) BESTW (BELOW DECLARATIONS) IF                     
C    TOTAL COST IS EXPECTED TO BE LARGE                
C 3) LOOP 30, WHICH MUST REFLECT ALL POSSIBLE                
C    COMBINATIONS OF POTENTIAL DEPOTS. THERE                 
C    WILL BE NDEP DO STATEMENTS. DECLARE                     
C    ADDITIONAL D VALUES ASSOCIATED WITH               
C    EITHER FIXED OR VARIABLE DEPOTS (D=NDEP)               
C    THIS IS DONE IN THE DECLARATIONS AND THE                
C    FIXED DEPOT ASSIGNMENT STATEMENTS JUST                
C    ABOVE LOOP 30               
C 4) FORMAT STATEMENTS TO ACCOMODATE NEW OUTPUT                
C 5) THE DATA FILE MUST INCLUDE THE FIXED DEPOTS                
C    FIRST, FOLLOWED BY THE POTENTIAL DEPOTS,                
C    FOLLOWED BY THE REMAINING DEMANDS                       
C 6) PARAMETER LINE JUST BELOW.  THE MAXIMUM VALUES
C      MAY NEED TO BE ADJUSTED FOR LARGE DATA SETS OR
C      FOR MACHINES WITH LITTLE MEMORY.
C                          
C DECLARATIONS
*
      PARAMETER(MAXN=100,MAXNTDEP=100,MAXNMND=100)
      REAL LAT(MAXN),LONG(MAXN)                               
      DOUBLE PRECISION LATR(MAXN),LONGR(MAXN)                 
* INSURE THE # OF D'S EQUALS NDEP               
      INTEGER W(MAXN,MAXN),FREQ(MAXN),D(MAXNTDEP),D1,D2,  
     1 NEAR(MAXN),DIST(MAXN),TCOUNT,V,                   
     2 TEDGE1(MAXNMND),TEDGE2(MAXNMND),TWGT,TW(MAXN),        
     3 BESTW,EBST1(MAXNMND),EBST2(MAXNMND),ID                     
      
      CHARACTER*12 INFILENAME,OUTFILENAME
      WRITE(*,'(A\)') ' ENTER DATA FILE NAME: '
      READ(*,'(A)') INFILENAME
      WRITE(*,'(A\)') ' ENTER OUTPUT FILE NAME: '
      READ(*,'(A)') OUTFILENAME
      OPEN(4,FILE=INFILENAME,STATUS='OLD',ERR=997)       
      OPEN(6,FILE=OUTFILENAME,STATUS='UNKNOWN',ERR=998)
      READ(4,400,ERR=999) N,NDEP,NFXDEP,NDPCAN,NMND,  
     1 NTDEP
*
      INF=3000                                            
      BESTW=5000000                                      
C                                                          
C INPUT LOCATIONS                                          
C                                                          
      DO 5 I=1,N                                           
       READ(4,100) LAT(I),LONG(I),FREQ(I)                  
       WRITE(6,100) LAT(I),LONG(I),FREQ(I)                 
C                                                          
C CONVERT TO RADIANS                                       
C                                                          
      LATR(I)=((LAT(I)-AINT(LAT(I)))/.6                    
     1           +AINT(LAT(I)))*3.141592653/180                
      LONGR(I)=((LONG(I)-AINT(LONG(I)))/.6                     
     1           +AINT(LONG(I)))*3.141592653/180                
5     CONTINUE                                                  
C                                                         
C COMPUTE DISTANCE MATRIX                                 
C                                                         
      DO 10 I=1,N                                         
       DO 10 J=1,I                                        
        IF (I.EQ.J) THEN       
         W(I,J)=0       
        ELSE       
        W(I,J)=INT(3956.013*ACOS(SIN(LATR(I))                
     1         *SIN(LATR(J))+COS(LATR(I))*COS(LATR(J))     
     2         *COS(ABS(LONGR(J)-LONGR(I)))))+150               

        W(J,I)=W(I,J)          
        ENDIF                          
10    CONTINUE                                    
      DO 20 I=1,N                            
       WRITE(6,200) (W(I,J),J=1,N)                
20    CONTINUE
C                                                   
C DEFINE FIXED DEPOTS
*
      D(1)=1
      D(2)=2
C
C RESET COUNTERS BETWEEN ITERATIONS                 
C INDENTS RESTARTED IN CODE                         
C                                          
      ID=3000                     
      V=0                         
      TCOUNT=0                    
      TWGT=0                       
      DO 35 J=1,N                  
       TW(J)=0                     
35    CONTINUE                     
C                                 
C SET NEAR EQUAL TO NEAREST DEPOT                 
C                                     
      DO 40 J=1,N                     
       ID=3000                       
       DO 40 I=1,NFXDEP+NDEP                 
        IF (W(D(I),J).LT.ID) THEN                 
         NEAR(J)=D(I)                     
         DIST(J)=W(D(I),J)                 
         ID=W(D(I),J)                     
        ENDIF                              
      CONTINUE                             
40    CONTINUE                             
C                                       
C SET DEPOTS NEAR NOTHING IMPLYING                 
C CURRENT INCLUSION INTO FOREST                    
C                                        
      DO 45 I=1,NFXDEP+NDEP                
         NEAR(D(I))=0                       
45    CONTINUE                              
C                                           
C SELECT MINIMUM EDGE                       
C                                          
50    IF (TCOUNT.LT.NMND) THEN                 
       MIN=INF                                 
       DO 60 J=1,N                             
C CHECK FOR QUALIFIED EDGE                     
        IF ((NEAR(J).GT.0).AND.                 
     1     (DIST(J).LT.MIN).AND.                
     2     (2*(DIST(J)+TW(J)).LT.2600)) THEN                 
C IF BEST AND QUALIFIED, SELECT                  
         V=J                                     
         MIN=DIST(J)                   
        ENDIF                           
60     CONTINUE                
C                 
C PENALTY FOR INFEASIBILITY                
C                
       IF (MIN.EQ.INF) DIST(V)=1000000                  
C                                
C UPDATE FOREST WITH NEW BRANCH                
C                                          
       TCOUNT=TCOUNT+1                       
       TEDGE1(TCOUNT)=NEAR(V)                 
       TEDGE2(TCOUNT)=V                       
       TW(V)=TW(NEAR(V))+DIST(V)                 
       TWGT=TWGT+TW(V)*FREQ(V)                 
C       IF (TWGT.GT.BESTW) GOTO 29     
       NEAR(V)=0                               
C                                           
C UPDATE NEAR                            
C                                         
       DO 70 J=1,N                       
        IF (NEAR(J).NE.0) THEN                 
         IF (W(J,NEAR(J)).GT.W(J,V)) THEN                 
          DIST(J)=W(J,V)                    
          NEAR(J)=V                         
         ENDIF                              
        ENDIF                               
70     CONTINUE                            
       GO TO 50                            
      ENDIF                                
C                                           
C STORE FOREST AS BEST IF APPLICABLE                
C                                              
      IF (TWGT.LT.BESTW) THEN                  
       BESTW=TWGT                           
       DO 80 J=1,NMND                       
        EBST1(J)=TEDGE1(J)                  
        EBST2(J)=TEDGE2(J)                  
80     CONTINUE                             
      ENDIF     
29    CONTINUE                      
30    CONTINUE                              
C               
C WRITE RESULTS               
C               
      WRITE(6,*)'BEST WEIGHT=',BESTW                
      WRITE(6,*)'EMINATING NODES ON TOP'                  
      WRITE(6,*) 'INCIDENT NODES BELOW'                 
      JU=NMND           
      JL=1           
90    IF (JU.LE.10) THEN           
       WRITE(6,300) (EBST1(J), J=JL,NMND)                 
       WRITE(6,300) (EBST2(J), J=JL,NMND)           
       WRITE(6,*)           
       STOP                 
      ELSE           
       WRITE(6,300) (EBST1(J), J=JL,JL+9)           
       WRITE(6,300) (EBST2(J), J=JL,JL+9)           
       WRITE(6,*)           
      ENDIF           
      JU=JU-10           
      JL=JL+10           
      GO TO 90           
*               
100   FORMAT(1X,F5.2,3X,F6.2,2X,I2)       
200   FORMAT(1X,11I5)                   
300   FORMAT(1X,10I5)                     
400   FORMAT(1X,I3,1X,I3,1X,I3,1X,I3,1X,I3,1X,I3)
997   WRITE(*,*) 'ERROR OPENING ',INFILENAME
      WRITE(*,*) 'MAKE SURE THAT THE NAME OF THE DATA FILE IS' 
      WRITE(*,*) 'SPELLED CORRECTLY.'
      GOTO 1000
998   WRITE(*,*) 'ERROR OPENING ',OUTFILENAME
      WRITE(*,*) 'MAKE SURE YOU HAVE WRITE PERMISSION IN'
      WRITE(*,*) 'THIS DIRECTORY.'
      GOTO 1000
999   WRITE(*,*) 'ERROR WRITING TO ',OUTFILENAME
      WRITE(*,*) 'DISK MAY BE FULL OR WRITE-PROTECTED.'
      GOTO 1000
1000  END
