C   ********** THIS PROGRAM REPLICATES MULTIPLIERS A AND F ***********
C   ************************ FROM BASE YEAR DATA *********************
C   ************************ OCT. 25, 1985 ***************************
C
C MODIFIED TO USE A PART OF THE BASIC LINEAR ALGEBRA SUBROUTINE DGEMM
C (Double precision, GEneral, Matrix Multiply)
C MODIFIED FOR THE MICROSOFT FORTRAN COMPILER FOR DOS
C LAST MODIFIED 8/8/96
C WRITTEN BY BRAD SMITH
C
        INTEGER ID(50),AD,DIM
        REAL*8 CALINR(50,50),FOREINR(50,50),RE(50),RN(50)
	REAL*8 BASEP(50),CALP(50),CALE(50),BASER(50),CALR(50)
        REAL*8 SA(50,50),SF(50,50),T(50,50),U(50,50),E(50)
        REAL*8 BASESE(50),CALSE(50),CALER(50),BASEEE(50)
        REAL*8 AH(50),BASEN(50),BASEE(50),BASEBE(50)
        REAL*8 CALAU(50),CALTOL(50),CALAB(50),FOREBE(50)
        REAL*8 RCOND,Z(50),TMP1(50),TMP2(50),TMP,DET(50)
        REAL*8 H(50,50),G(50,50),FA(50),FORENC(50)
        REAL*8 DINT(50),DINU(50)
        CHARACTER*20 FILENA
        INTEGER IPVT(50),I,J,TUOUT,MRT
C
C THE VARIABLES ABOVE ARE DESCRIBED IN THE DATA FILES LMBI4.DAT
C   AND LMBI42.DAT
C
C THE FOLLOWING VARIABLES ARE CALCULATED IN THE PROGRAM :
C T AND U ARE THE BASIC ACCESSIBILITY FUNCTIONS
C F AND A ARE THE DISAGGREGATE MULTIPLIERS (DIAGONAL MATRICES)
C RCOND, Z, DET, AND IPVT ARE VARIABLES USED BY THE LINPACK MATRIX
C   INVERSION ROUTINES
C
C NOTE: THE VARIABLE AD REPRESENTS THE MAXIMUM DATA SET ARRAY DIMENSION
C AVAILABLE FOR THIS COMPILATION.  IT SHOULD BE SET TO THE SAME VALUE
C THAT IS IN PARENTHESES IN ALL OF THE REAL*8 DECLARATIONS AND THE IPVT
C DECLARATION AT THE TOP OF THE PROGRAM.  THE VALUE OF AD MUST BE SET 
C AT COMPILE TIME.  TO RUN THE PROGRAM WITH A DATA SET LARGER THAN THE
C CURRENT VALUE OF AD YOU MUST RECOMPILE WITH THE NEW VALUE OF AD SET
C AND UPDATED DECLARATIONS. WARNING!: AS AD GROWS LARGER THE PROGRAM 
C WILL USE EXPONENTIALLY MORE MEMORY AND RUN SLOWER.
        AD=50
C
C NOTE: DUE TO THE DIFFERENCES IN THE WAY DOS-BASED AND VMS-BASED
C   MACHINES READ IN MATRICES YOU MAY NEED TO ALTER THE SECTION OF
C   CODE THAT READS THE MATRICES FROM THE DATA FILE TO GET THE
C   PROGRAM TO RUN CORRECTLY ON A VMS MACHINE.  IF YOU FIND THAT YOU
C   ARE ACTUALLY GETTING THE TRANSPOSE OF A MATRIX ON A NON-DOS
C   MACHINE, TRY REVERSING THE ORDER OF THE INDICES LIKE THIS:
C       READ(2,*) ((T(J,I),J=1,DIM),I=1,DIM)
C       READ(2,*) ((U(J,I),J=1,DIM),I=1,DIM)
C
C   THE EQUATIONS USED IN THIS PROGRAM ARE:
C     1: SF = BASEN/(BASEE.T)
C     2: SA = BASEEE/(BASEN.U)
C
C BEGIN INITIALIZATION SECTION
C
C GET THE DATA FILENAME FROM THE USER
        WRITE (*,'(A)')' ENTER THE NAME OF THE INPUT FILE: '
        READ (*,'(A)') FILENA
        OPEN (2, FILE = FILENA, STATUS = 'OLD')
C
C GET THE OUTPUT FILENAME FROM THE USER
        WRITE (*,'(A)')' ENTER THE NAME OF THE OUTPUT FILE: '
        READ (*,'(A)') FILENA
        OPEN (3, FILE = FILENA, STATUS = 'UNKNOWN')
C
C READ IN THE DATA FILE VALUES
        READ (2,*) DIM
        READ (2,*) ((H(I,J),G(I,J),J=1,DIM),I=1,DIM)
        READ (2,*) ((CALINR(I,J),J=1,DIM),I=1,DIM)
	READ (2,*) (BASEP(I),BASEE(I),CALP(I),CALE(I),I=1,DIM)
        READ (2,*) (BASER(I),CALR(I),BASESE(I),CALSE(I),I=1,DIM)
        READ (2,*) (BASEN(I),BASEBE(I),BASEE(I),I=1,DIM)
        READ (2,*) (SF(I,I),SA(I,I),I=1,DIM)
        READ (2,*) ((FOREINR(I,J),J=1,DIM),I=1,DIM)
        READ (2,*) (FOREBE(I),I=1,DIM)
        READ (2,*) (FORENC(I),I=1,DIM)
        READ (2,*) MRT
        READ (2,*) TUOUT
C BEGIN MAIN PROGRAM
        IF (DIM .LT. (AD + 1)) GOTO 10
        WRITE (3, '(A)')'ERROR: DATA SET IS TOO LARGE FOR THIS'
        WRITE (3, '(A)')'COMPILATION.  TO USE THIS DATA SET YOU'
        WRITE (3, '(A)')'MUST RECOMPILE.  INSTRUCTIONS ARE IN'
        WRITE (3, '(A)')'THE SOURCE CODE.'
        GOTO 1200
10      DO 15 I=1,DIM
           RE(I)=BASER(I)+BASESE(I)
           RN(I)=BASEP(I)
           DO 15 J=1,DIM
             T(I,J)=H(I,J)
             U(I,J)=G(I,J)
15      CONTINUE
C CALCULATE T AND U
18      DO 20 I=1,DIM
           DINT(I)=0.
           DINU(I)=0.
           DO 20 J=1,DIM
           IF (U(I,J).LT.0.)  U(I,J)=0.
           IF (T(I,J).LT.0.)  T(I,J)=0.
              DINT(I)=DINT(I)+RN(J)*T(I,J)
              DINU(I)=DINU(I)+RE(J)*U(I,J)
20      CONTINUE
        DO 30 I=1,DIM
           DO 30 J=1,DIM
           T(I,J)=RN(J)*T(I,J)/DINT(I)
           U(I,J)=RE(J)*U(I,J)/DINU(I)
30      CONTINUE
        IF (TUOUT .EQ. 0) GOTO 500
        WRITE(3,'(A)') '      T                   U '
        WRITE(3,'(A)') '-------------------------------- '
        DO 310 I=1,DIM
           DO 310 J=1,DIM
              WRITE(3,400) T(I,J),U(I,J)
310     CONTINUE
        WRITE (3,*)
400     FORMAT (1X,F10.8,10X,F10.8)
C
C CALCULATE A AND F
500     WRITE (3,'(A)')'     SF                SA    '
        WRITE (3,'(A)')' ---------------------------- '
        CALL DGEMM (1,DIM,DIM,1.0D+0,BASEP,1,U,AD,0.0D+0,TMP1,1)
        CALL DGEMM (1,DIM,DIM,1.0D+0,BASEE,1,T,AD,0.0D+0,TMP2,1)
        DO 700 I=1,DIM
           DO 700 J=1,DIM
             IF ( J .NE. I) GO TO 650
             IF (TMP1(J) .EQ. 0.0) GO TO 620
             SA(I,J)=(BASER(J)+BASESE(J))/TMP1(J)
             GO TO 630
620          SA(I,J)=0.0
630          IF (TMP2(J) .EQ. 0.0) GO TO 640
             SF(I,J)=BASEP(J)/TMP2(J)
             GO TO 700
640          SF(I,J)=0.0
             GO TO 700
650          SA(I,J)=0.
             SF(I,J)=0.
700     CONTINUE
800     FORMAT (1X,F9.6,10X,F9.6)
900     CONTINUE
        DO 1100 I=1,DIM
1100         WRITE(3,800) SF(I,I),SA(I,I)
1200     STOP
        END
C
        SUBROUTINE DGEMM (M,N,K,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
        INTEGER            M, N, K, LDA, LDB, LDC
        DOUBLE PRECISION   ALPHA, BETA
        DOUBLE PRECISION   A( LDA, * ), B( LDB, * ), C( LDC, * )
        INTRINSIC          MAX
        INTEGER            I, J, L
        DOUBLE PRECISION   TEMP
        DOUBLE PRECISION   ONE         , ZERO
        PARAMETER        ( ONE = 1.0D+0, ZERO = 0.0D+0 )
C           Form  C := alpha*A*B + beta*C.
C
        DO 13090, J = 1, N
          IF( BETA.EQ.ZERO )THEN
          DO 13050, I = 1, M
            C( I, J ) = ZERO
13050     CONTINUE
          ELSE IF( BETA.NE.ONE )THEN
          DO 13060, I = 1, M
            C( I, J ) = BETA*C( I, J )
13060     CONTINUE
          END IF
          DO 13080, L = 1, K
            IF( B( L, J ).NE.ZERO )THEN
            TEMP = ALPHA*B( L, J )
            DO 13070, I = 1, M
              C( I, J ) = C( I, J ) + TEMP*A( I, L )
13070       CONTINUE
            END IF
13080     CONTINUE
13090   CONTINUE
C
        RETURN
C
C     End of DGEMM .
C
        END
