
C
C***********************************************************
C      LOWRY, IRA SOUTH       PITTSBURGH MODEL         MARK VI - PSU MOD 1
C***********************************************************
C
      DIMENSION A(5),C(5),EC(5),ZS(5),P1(5),P3(5),ZH(50),AT(50),AU(50),
     1AB(50),AR(50),AH(50),E(50),EB(50),ER(50),ES(50),DPOP(50,50),
     2PH(50),HDENS(50),D(50,50),RING(50,50),DRET(50,50,5),POP(3,3),
     3CAP(3,3),ABLE(3,3),P2(5),NUM(50)
      COMMON K6,L5,K1,MAX,NZONE
      CHARACTER*30 HEADER
      CHARACTER*64 FILENAME
      CHARACTER*64 OUTFILE
      LOGICAL*1 AST/'*'/,PACE(120)
      LOGICAL*1 TITLE(30)
      EBT = 0.
      K1 = 1
      K6 = 0
      DO 1 J=1,120
      PACE(J)=AST
    1 CONTINUE
C     ********************************************
C
C        M    NUMBER OF ZONES
C        N    NUMBER OF TRADE CLASES
C       FC    HOUSEHOLDS/EMPLOYEE
C       PE    POTENTIAL  FUNCTION EXPONENT
C
C    "PUNCH" COMMAND LINES COMMENTED (*) OUT REPLACED BY "CONTINUE"
C
C       L7    =0   NO PUNCHING OF CARDS AT THE END OF MAIN PROGRAM.
C             =1  PUNCH CARDS AT THE END OF THE MAIN PROGRAM.
C
C     ********************************************
C
      WRITE (*, '(A\)') ' ENTER THE NAME OF DATA INPUT FILE: '
      READ (*,'(A)') FILENAME 
      OPEN(3, FILE = FILENAME, STATUS = 'OLD' )
      WRITE (*, '(A\)') ' ENTER THE NAME OF THE OUTPUT FILE: '
      READ (*,'(A)') OUTFILE
      OPEN (7, FILE = OUTFILE, STATUS = 'NEW' )
      READ (3,100) L1,L2,L3,L4,L5,L6,M,N,KARD,RUN1,RUN2,L7,MAX
      NZONE=M
      IF (N-5)  1010,1010,1000
 1000 PRINT 1005,N
 1005 FORMAT (/19HN IS TOO LARGE, N =,I5)
      STOP
 1010 CONTINUE
C
C     ********************************************
C
C     DEFINITIONS OF THE INPUT VARIABLES
C
C        A    EMPLOYMENT PER HOUSEHOLD
C        C    RES. WT. FAC.
C       EC    EMPLOYMENT PER 100. SQ. FEET
C       ZS   MINIMUM EFFICIENT SIZE
C       P1    POTENTIAL FUNCTION A
C       P2    POTENTIAL FUNCTION B
C       P3    POTENTIAL FUNCTION C
C     ********************************************
C
      DO 3 I = 1,N
      READ (3,101) K,V,W,X,Y,Z1,Z2,Z3
      A(K) = V
      C(K) = W
      EC(K) = X
      ZS(K) = Y
      P1(K)=Z1
      P2(K)=Z2
    3 P3(K)=Z3
      READ (3,102) FC, PE,COEF
      DO 4 K=1,M
      READ(3,137) AT(K),AU(K),AB(K),AR(K),EB(K),ER(K),PH(K),ZH(K)
  137 FORMAT(6X,F7.0,3F6.0,13X,2F7.0,F6.0,6X,F6.3)
      EBT=EBT+EB(K)
    4 CONTINUE
C
C     *********************************
C     LIST INPUT PARAMETERS AND VARIABLES
C     *********************************
C
      WRITE (7,104) FC,PE
      DO 5 K=1,N
    5 WRITE (7,109) K,ZS(K),A(K),C(K),EC(K),P1(K),P2(K),P3(K)
      IF (L1) 6,15,6
C
C
C     *********************************
C     THE FOLLOWING IS WRITEED IF  L1 IS POSITIVE
C     *********************************
C
C
C     *********************************
C
C       AT    TOTAL LAND
C       AU    UNUSUABLE LAND
C       AB    BASIC LANDUSE
C       EB    BASIC EMPLOYMENT
C       ZH    MAXIMUM RESIDENTIAL DENSITY
C
C     *********************************
C
    6 WRITE (7,128) K1
      CALL PNT(AT,TITLE,'                   TOTAL LAND ')
C   AT=TOTAL LAND
   11 WRITE (7,129) K1
      CALL PNT(AU,TITLE,'                UNUSABLE LAND ')
C   AU=UNUSABLE LAND
      WRITE (7,127) K1
      CALL PNT(AB,TITLE,'                   BASIC LAND ')
C   AB=BASIC LAND USE
      WRITE (7,110) K1
      CALL PNT(EB,TITLE,'             BASIC EMPLOYMENT ')
C   EB=BASIC EMPLOYMENT
      WRITE (7,120) EBT
   13 WRITE (7,118) K1
      K6 = 1
      CALL PNT(ZH,TITLE,'  MAXIMUM RESIDENTIAL DENSITY ')
C   ZH=MAX RESIDENTIAL DENSITY
C
   15 K6=0
      K4 = 1
C
C     *********************************
C     COMPUTE RETAIL EMPLOYMENT MULTIPLIER
C     *********************************
C
      RM = 0.
      DO 17 K=1,N
   17 RM = RM + A(K)
      RM = FC * RM
      IF (1.-RM) 18,18,19
   18 WRITE (7,180) RM
  180 FORMAT (/,41HRETAIL/TOTAL EMP GREATER THAN UNITY.  RM=, F3.3)
      STOP
   19 PHT = FC * (EBT/(1.-RM))
      DO 20 K=1,NZONE
      E(K)=EB(K)+ER(K)
      AH(K)=AT(K)-AU(K)-AB(K)-AR(K)
   20 CONTINUE
C
C     *********************************
C     COMPUTE DISTRIBUTION FUNCTIONS
C     *********************************
C
C
C      READ IN TIME MATRIX
C
      DO 502 I=1,NZONE
      M2=0
  501 M1=M2+1
      M2=M1+21
      IF(M2.GT.NZONE)M2=NZONE
      READ (3,503) (D(I,J),J=M1,M2)
      DO 510 J=M1,M2
      IF(D(I,J).LE.0.)D(I,J)=0.25
  510 CONTINUE
      IF(M2.NE.NZONE)GO TO 501
  502 CONTINUE
  503 FORMAT (10X,22F3.1)
C
C  READ IN RING FUNCTION SETS
C
      DO 5106 I=1,NZONE
      READ (3,2106) (RING(I,J),J=1,MAX)
      DO 5106 J=1,MAX
      IF(RING(I,J).LE.0.)RING(I,J)=0.01
 5106 CONTINUE
 2106 FORMAT(29F2.0)
C
C      COMPUTE DISTRIBUTION FUNCTIONS
C
      DO 208 I=1,NZONE
      DO 208 J=1,NZONE
      L=D(I,J)
      IF(L.LE.0)L=1
      DPOP(I,J)=(COEF*(D(I,J)**PE)*RING(I,L))
      DO 206 K=1,N
      DRET(I,J,K)=(P1(K)-P2(K)*D(I,J)+P3(K)*D(I,J)*D(I,J))*RING(I,L)
      IF(DRET(I,J,K).GE.100000.)DRET(I,J,K)=100000.
  206 CONTINUE
      IF(DPOP(I,J).GE.100000.)DPOP(I,J)=100000.
  208 CONTINUE
      IF (L1) 2080,2090,2080
C
C     *********************************
C     THE FOLLOWING IS WRITEED IF  L1 IS POSITIVE
C     *********************************
C
C
C      WRITE OUT DPOP MATRIX
C
 2080 CONTINUE
      DO 1901 I=1,NZONE
      NUM(I)=I
 1901 CONTINUE
      M2=0
 1940 M1=M2+1
      M2=M1+11
      IF(M2.GT.NZONE)M2=NZONE
      WRITE (7,5000)
      WRITE (7,1140) (NUM(I),I=M1,M2)
      WRITE (7,1200) (PACE(MMM),MMM=1,120)
      WRITE (7,1141)
      WRITE (7,1142)
      DO 1910 I=1,NZONE
      WRITE (7,1143) I,(DPOP(I,J),J=M1,M2)
 1910 CONTINUE
      IF(M2.NE.NZONE)GO TO 1940
 5000 FORMAT(/,38X,
     155HDENOMINATOR OF THE POPULATION POTENTIAL FUNCTION, DPOP.)
 1140 FORMAT(1H ,3X,7H*  ZONE,12(4X,I2,4X))
 1141 FORMAT(1H ,6X,1H*)
 1142 FORMAT(1H ,3X,7HZONE  *)
 1143 FORMAT(4X,I2,3X,1H*,12F10.2)
C
C     WRITE OUT DRET MATRIX FOR EACH INDUSTRIAL GROUP
C
      DO 2150 K=1,N
      M2=0
 2940 M1=M2+1
      M2=M1+11
      IF(M2.GT.NZONE)M2=NZONE
      WRITE (7,5010) K
      WRITE (7,1140) (NUM(I),I=M1,M2)
      WRITE (7,1200) (PACE(MMM),MMM=1,120)
      WRITE (7,1141)
      WRITE (7,1142)
      DO 2910 I=1,NZONE
      WRITE (7,1143) I,(DRET(I,J,K),J=M1,M2)
 2910 CONTINUE
      IF(M2.NE.NZONE)GO TO 2940
 2150 CONTINUE
 5010 FORMAT(/,35X,
     160HDENOMINATOR OF THE POTENTIAL FUNCTION OF RETAIL TRADE NUMBER,
     11X,I1,1X,1H.)
 1200 FORMAT(1H ,10X,120A1)
C
C
C     *********************************
C     BEGINNING OF GRAND LOOP
C     EXECUTE THIS LOOP  (TO STATEMENT 76) L4 TIMES
C     *********************************
C
C
 2090 IF (L6-2) 21,37,21
C
C     *********************************
C      THIS SECTION IS REACHED IF L6 IS EQUAL TO 0,1,3,....9
C     COMPUTE POPULATION POTENTIALS
C     *********************************
C
   21 K3 = 0
      ZTOT = 0.
   22 K3 = K3+1
      DO 23 K=1,NZONE
      Z=0.
      DO 24 I=1,NZONE
      Z=Z+E(I)/DPOP(I,K)
   24 CONTINUE
      PH(K)=Z
      ZTOT=ZTOT+Z
   23 CONTINUE
      G = PHT/ZTOT
      ZTOT = 0.
      DO 301 I=1,NZONE
      PH(I)=PH(I)*G
      ZTOT=ZTOT+PH(I)
  301 CONTINUE
C
C       PH    POPULATION POTENTIALS
C
      WRITE (7,113) K1
      CALL PNT(PH,TITLE,'         NUMBER OF HOUSEHOLDS ')
      WRITE (7,120) ZTOT
C
C     *********************************
C     BEGIN POPULATION LOOP
C     THIS LOOP IS EXECUTED  L3 TIMES
C     *********************************
C
   30 WRITE (7,144)
  144 FORMAT (/)
C
C     *********************************
C     APPLY MAX DENSITY CONSTRAINT
C     *********************************
C
      ZTOT = 0.
      DO 28 I=1,NZONE
C
C     *********************************
C     PMAX IS MAX RESIDENTIAL DENSITY TIMES LAND AVAILABLE FOR HOUSING USE.
C     *********************************
C
   25 PMAX=ZH(I)*AH(I)
      IF(PH(I)-(.95*PMAX))27,26,26
   26 WRITE (7,145) I,PMAX,PH(I)
  145 FORMAT(1H ,23HEXCESS DENSITY IN TRACT,I3,8H.  PMAX=,F6.0,22H NUMBE
     1R OF HOUSEHOLDS=,F6.0)
      PH(I)=0.95*PMAX
C
C     *********************************
C     TOTAL  = TOTAL OF ALL HOUSEHOLDS IN TRACT(I,J)
C     *********************************
C
   27 ZTOT=ZTOT+PH(I)
   28 CONTINUE
      G = PHT/ZTOT
       ZTOT = 0.
      DO 281 I=1,NZONE
      PH(I)=PH(I)*G
      ZTOT=ZTOT+PH(I)
  281 CONTINUE
C
C       PH    POPULATION DISTRIBUTION
C
      WRITE (7,115) K1, K3
      CALL PNT(PH,TITLE,'         NUMBER OF HOUSEHOLDS ')
      WRITE (7,120) ZTOT
      IF (K3-L3) 29,36,36
   29 K3 = K3 + 1
      GO TO 30
C     END OF POPULATION LOOP
   36 CONTINUE
   37 IF (L6) 38,80,38
C
C     *********************************
C     THIS SECTION IS RECHED IF L6 IS POSITIVE
C     *********************************
C
   38 K2 = 0
C
C     *********************************
C     BEGIN EMPLOYMENT LOOP
C      THIS LOOP IS EXECUTED L2 TIMES
C     *********************************
C
   39 K2 = K2 + 1
      DO 40 I=1,NZONE
      ER(I)=0.
      AR(I)=0.
   40 CONTINUE
      ERTT = 0.
      K = 0
C
C     *********************************
C     BEGIN LOOP FOR RETAIL TRADE K
C    THIS LOOP IS EXECUTED  N TIMES (TO STATEMENT 494
C     *********************************
C
   85 K = K + 1
      EST = 0.
      DO 41 KK=1,NZONE
      ES(KK)=(1.0-C(K))*E(KK)
      DO 45 I=1,NZONE
      ES(KK)=ES(KK)+(C(K)*PH(I)/DRET(I,KK,K))
   45 CONTINUE
      EST=EST+ES(KK)
   41 CONTINUE
      WRITE (7,146) K1,K
C
  146 FORMAT (/,6HTABLE ,I2,36H  MARKET POTENTIALS FOR RETAIL TRADE,
     1I2)
C
      CALL PNT(ES,TITLE,' TEMPORARY TOTAL-RETAIL TRADE ')
      WRITE (7,120) EST
      DEST = A(K)*PHT
C
C     *********************************
C     BEGIN RESCALING LOOP FOR RETAIL TRADE K
C     TO STATEMENT 493
C     *********************************
C
      K5 = 1
      ZSK = ZS(K)*0.02
   50 G = DEST/EST
      DO 46 I=1,NZONE
      ES(I)=ES(I)*G
   46 CONTINUE
      EST = DEST
      IF (K5-50) 47,47,51
C     APPLY MINIMUM EFFICIENT SIZE CONSTRAINT
   47 DO 49 I=1,NZONE
      IF(ES(I)-ZSK)48,49,49
   48 EST=EST-ES(I)
      ES(I)=0.
   49 CONTINUE
      IF (EST) 491,491,492
  491 WRITE (7,147) K
  147 FORMAT (/,19HCONSTRAINT ON TRADE,I2,13H IS TOO HIGH.)
      GO TO 494
  492 ZSK = ZSK+(ZS(K)*0.02)
  493 K5 = K5+1
      GO TO 50
   51 CONTINUE
   52 DO 55 I=1,NZONE
      ER(I)=ER(I)+ES(I)
      AR(I)=AR(I)+ES(I)/EC(K)
   55 CONTINUE
      ERTT = ERTT + EST
C
C     *********************************
C       EMPLOYMENT IN RETAIL TRADE 3 AFTER 1 ITERATION
C     *********************************
C
   56 WRITE (7,130) K1, K, K2
      CALL PNT(ES,TITLE,' TEMPORARY TOTAL-RETAIL TRADE ')
   54 WRITE (7,120) EST
  494 IF(K-N)85,81,81
   81 CONTINUE
C
C     END OF RETAIL TRADE LOOP
C
C
C     *********************************
C       ERTOTAL RETAIL EMPLOYMENT AFTER 1 ITERATION
C     *********************************
C
      WRITE (7,121) K1,K2
      CALL PNT(ER,TITLE,'      TOTAL RETAIL EMPLOYMENT ')
      WRITE (7,120) ERTT
      DO 59 I=1,NZONE
      E(I)=EB(I)+ER(I)
   59 CONTINUE
      ET = EBT + ERTT
      IF (K2-L2) 39,58,58
C
C     WRITE FINAL RESULTS OF EMPLOYMENT LOOP
C
C
C        E    TOTAL EMPLOYMENT
C
   58 WRITE (7,122) K1
      CALL PNT(E,TITLE,'             TOTAL EMPLOYMENT ')
   66 WRITE (7,120) ET
C
C     *********************************
C     END OF EMPLOYMENT LOOP
C     *********************************
C
C     *********************************
C     COMPUTE AND WRITE RETAIL AND RESIDENTIAL LAND USE
C     ********************************************
C
      AHT = 0.
      ART = 0.
      DO 67 I=1,NZONE
      AH(I)=AT(I)-AU(I)-AB(I)
      IF(AH(I)-AR(I))68,68,69
   68 AR(I)=AH(I)
      AH(I)=0.
      GO TO 70
   69 AH(I)=AH(I)-AR(I)
   70 AHT=AHT+AH(I)
      ART=ART+AR(I)
   67 CONTINUE
C
C     *********************************
C       AR    RETAIL LAND USE
C       AH    HOUSING LAND USE
C     *********************************
C
      WRITE (7,123) K1
      CALL PNT(AR,TITLE,'            TOTAL RETAIL LAND ')
   72 WRITE (7,120) ART
      WRITE (7,124) K1
      CALL PNT(AH,TITLE,'     LAND FOR RESIDENTIAL USE ')
   74 WRITE (7,120) AHT
      IF(K4-L4)75,76,76
   75 K4 = K4 +1
      WRITE (7,125) K4
      GO TO 21
C
C
C     *********************************
C     END OF GRAND LOOP
C     *********************************
C
C
   76 CONTINUE
C
C     *********************************
C     COMPUTE AND WRITE HOUSEHOLD DENSITY
C     *********************************
C
      K6 = 1
   78 DO 79 I=1,NZONE
      IF(AH(I))82,82,83
   82 HDENS(I)=-0.0001
      GO TO 79
C
C     *********************************
C     HDENS= NO. OF HOUSEHOLDS/AVAILABLE LAND FOR HOUSING USE.
C     *********************************
C
   83 HDENS(I)=PH(I)/AH(I)
   79 CONTINUE
C
C    HDENS    ACTUAL RESIDENTIAL DENSITY
C
      CALL PNT(HDENS,TITLE,'            HOUSEHOLD DENSITY ')
   80 IF (L7 .EQ.0) GOTO 90
*     DO 801 I=1,NZONE
*     PUNCH 138,KARD,I,AT(I),AU(I),AB(I),AR(I),AH(I),E(I),EB(I),ER(I),
*    1PH(I),HDENS(I),ZH(I),RUN1,RUN2
* 138 FORMAT(2I2,5F6.0,3F7.0,F6.0,2F6.3,A4,A1)
* 801 CONTINUE
   90 WRITE (7,132)
      STOP
  100 FORMAT(6I1,I3,I2,I2,A4,A1,I1,I3)
  101 FORMAT(I2,2F4.3,F5.3,F5.0,3F7.4)
  102 FORMAT(F5.3,2F5.4)
  104 FORMAT (/,37X,22HRESIDENTIAL PARAMETERS/
     11H ,F5.3,50H HOUSEHOLDS/EMPLOYEE, POTENTIAL FUNCTION POWER OF ,
     2F4.2 /1H ,34X,23HRETAIL TRADE PARAMETERS/
     3113H TRADE     MIN. EFFICIENT SIZE   EMPLOYMENT PER   RESIDENCE WE
     4IGHT   EMPLOYEES PER   POTENTIAL FUNCTION CONSTANTS/
     51H ,16X, 9HEMPLOYEES,10X,9HHOUSEHOLD,10X,6HFACTOR,8X,15HTHOUS. SQU
     6. FT.,6X,1HA,8X,1HB,8X,1HC//)
  105 FORMAT (6X,26F2.0)
  106 FORMAT (25F3.0)
  109 FORMAT (1H ,I4,F18.0,3F18.3,8X,3F9.4)
  110 FORMAT(/,6HTABLE ,I2, 18H  BASIC EMPLOYMENT)
  113 FORMAT (/,6HTABLE ,I2,23H  POPULATION POTENTIALS)
  115 FORMAT(/,6HTABLE ,I2, 31H POPULATION DISTRIBUTION AFTER ,I2, 
     113H   ITERATIONS)
  116 FORMAT (1H ,I3)
  118 FORMAT(/,6HTABLE ,I2, 29H  MAXIMUM RESIDENTIAL DENSITY)
  119 FORMAT(/,6HTABLE ,I2, 29H  EMPLOYMENT IN RETAIL TRADE ,I2)
  120 FORMAT (1H ,7HTOTAL =,F10.0)
  121 FORMAT(/,6HTABLE ,I2, 31H  TOTAL RETAIL EMPLOYMENT AFTER,I2,
     112HITERATIONS  )
  122 FORMAT(/,6HTABLE ,I2, 18H  TOTAL EMPLOYMENT)
  123 FORMAT(/,6HTABLE ,I2, 17H  RETAIL LAND USE)
  124 FORMAT(/,6HTABLE ,I2, 18H  HOUSING LAND USE)
  125 FORMAT (1H ,11HGRAND LOOP ,I2,5H NEXT)
  127 FORMAT(/,6HTABLE ,I2, 16H  BASIC LAND USE)
  128 FORMAT(/,6HTABLE ,I2, 12H  TOTAL LAND)
  129 FORMAT(/,6HTABLE ,I2, 15H  UNUSABLE LAND)
  130 FORMAT(/,6HTABLE ,I2, 28H  EMPLOYMENT IN RETAIL TRADE,I2,
     17HAFTER  ,I2,11H ITERATIONS)
  131 FORMAT(/,6HTABLE ,I2, 28H  ACTUAL RESIDENTIAL DENSITY)
  132 FORMAT (15H END OF PROBLEM)
  136 FORMAT(/,10HLOOP ON I1)
      END
      SUBROUTINE PNT(A,TITLE,HEADER)
      CHARACTER*30 HEADER
      DIMENSION A(50)
      COMMON K6,L5,K1,MAX,NZONE
      LOGICAL*1 TITLE(30)
      WRITE (7,1010) K1,HEADER
      WRITE (7,1000) HEADER
      DO 96 I=1,NZONE
      IF(K6-1)90,91,90
   91 WRITE (7,1133) I,A(I)
      GO TO 96
   90 WRITE (7,1112) I,A(I)
   96 CONTINUE
      IF(L5-1)99,98,99
   98 CONTINUE
*  98 PUNCH 1116,K1
      DO 199 I=1,NZONE
      IF(K6-1)89,94,89
   94 CONTINUE
*  94 PUNCH 1135,A(I)
      GO TO 199
   89 CONTINUE
*  89 PUNCH 1117,A(I)
  199 CONTINUE
   99 K1=K1+1
      RETURN
 1117 FORMAT(10X,F10.0)
 1135 FORMAT(10X,F10.3)
 1000 FORMAT(1H ,38X,11HZONE NUMBER,A30,8HPER ZONE)
 1010 FORMAT(1H ,45X,6HTABLE ,I2,1H:,A30)
 1112 FORMAT(1H ,43X,I2,26X,F9.0)
 1133 FORMAT(1H ,43X,I2,26X,F9.3)
 1116 FORMAT(I3)
      END
