function varargout = imgkmed(varargin)
% IMGKMED M-file for imgkmed.fig
%      IMGKMED, by itself, creates a new IMGKMED or raises the existing
%      singleton*.
%
%      H = IMGKMED returns the handle to a new IMGKMED or the handle to
%      the existing singleton*.
%
%      IMGKMED('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in IMGKMED.M with the given input arguments.
%
%      IMGKMED('Property','Value',...) creates a new IMGKMED or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before imgkmed_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to imgkmed_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help imgkmed

% Last Modified by GUIDE v2.5 18-Mar-2009 08:37:09

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @imgkmed_OpeningFcn, ...
                   'gui_OutputFcn',  @imgkmed_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before imgkmed is made visible.
function imgkmed_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to imgkmed (see VARARGIN)

% Choose default command line output for imgkmed
handles.output = hObject;

set(handles.iterationsedit,'String','5');
set(handles.kvalue,'String',num2str(get(handles.kslider,'Value')));

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes imgkmed wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = imgkmed_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function iterationsedit_Callback(hObject, eventdata, handles)
% hObject    handle to iterationsedit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of iterationsedit as text
%        str2double(get(hObject,'String')) returns contents of iterationsedit as a double

if isnan(str2num(get(hObject,'String')))
    set(hObject,'String','30');
end

guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function iterationsedit_CreateFcn(hObject, eventdata, handles)
% hObject    handle to iterationsedit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on slider movement.
function proximityslider_Callback(hObject, eventdata, handles)
% hObject    handle to proximityslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


% --- Executes during object creation, after setting all properties.
function proximityslider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to proximityslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function redslider_Callback(hObject, eventdata, handles)
% hObject    handle to redslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


% --- Executes during object creation, after setting all properties.
function redslider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to redslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function greenslider_Callback(hObject, eventdata, handles)
% hObject    handle to greenslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


% --- Executes during object creation, after setting all properties.
function greenslider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to greenslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on slider movement.
function blueslider_Callback(hObject, eventdata, handles)
% hObject    handle to blueslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider


% --- Executes during object creation, after setting all properties.
function blueslider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to blueslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on button press in loadbutton.
function loadbutton_Callback(hObject, eventdata, handles)
% hObject    handle to loadbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

[filename,pathname,filetype]=uigetfile({'*.bmp';'*.jpg';'*.png';'*.jpeg';'*.gif'});
fmt={'bmp';'jpg';'png';'jpeg';'gif'};
handles.img = imread([pathname filename],fmt{filetype});
handles.image=[];

if max(size(size(handles.img))) == 3
    handles.image=handles.img;
else
    handles.image(:,:,1)=handles.img(:,:);
end

axes(handles.origimage);
imshow(handles.img);

guidata(hObject, handles);

% --- Executes on slider movement.
function kslider_Callback(hObject, eventdata, handles)
% hObject    handle to kslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider

set(handles.kvalue,'String',num2str(get(handles.kslider,'Value')));
guidata(hObject, handles);

% --- Executes during object creation, after setting all properties.
function kslider_CreateFcn(hObject, eventdata, handles)
% hObject    handle to kslider (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end



function kvalue_Callback(hObject, eventdata, handles)
% hObject    handle to kvalue (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of kvalue as text
%        str2double(get(hObject,'String')) returns contents of kvalue as a double


% --- Executes during object creation, after setting all properties.
function kvalue_CreateFcn(hObject, eventdata, handles)
% hObject    handle to kvalue (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in clusterbutton.
function clusterbutton_Callback(hObject, eventdata, handles)
% hObject    handle to clusterbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

weights=[get(handles.proximityslider,'Value');get(handles.redslider,'Value');get(handles.greenslider,'Value');get(handles.blueslider,'Value')];
k=get(handles.kslider,'Value');
maxiter=str2double(get(handles.iterationsedit,'String'));
channels=size(handles.image,3);
mask =kmedg(k,handles.image,maxiter,weights(1:(channels+1)));

axes(handles.redimage);
imshow(applymask(handles.img,mask,1));

if k >= 2
    axes(handles.greenimage);
    imshow(applymask(handles.img,mask,2));
end

if k >= 3
    axes(handles.blueimage);
    imshow(applymask(handles.img,mask,3));
end

    
