C       PROGRAM FOR AGGREGATE AND DISAGGREGATE CASE
C	VARIATION FOR 25MPH PERSONAL RAPID TRANSIT SYSTEM ALTERNATIVE
C
C	MODIFIED TO USE A PART OF THE BASIC LINEAR ALGEBRA SUBROUTINE DGEMM
C	(Double precision, GEneral, Matrix Multiply)
C	MODIFIED FOR THE MICROSOFT FORTRAN COMPILER FOR DOS
C       LAST MODIFIED 8/14/96
C
C	VARIABLE DECLARATIONS
C	DESCRIPTIONS OF THESE VARIABLES MAY BE FOUND AT THE END
C       OF THE DATA FILES LMBI4.DAT AND LMBI42.DAT.
C       THE PREFIXES BASE, CAL, AND FORE REFER TO BASE YEAR,
C       CALIBRATION YEAR, AND FORECAST YEAR
C
        INTEGER ID(50),AD,DIM,MRT,TUOUT
        REAL*8 CALINR(50,50),FOREINR(50,50),CALH(50,50),CALG(50,50)
	REAL*8 BASEP(50),CALP(50),CALE(50),BASER(50),CALR(50)
        REAL*8 LIM1(50),LIM2(50),BB(50,50),AA(50,50),POP(10,50)
	REAL*8 SA(50,50),SF(50,50),T(50,50),U(50,50),R(50,50),DENO(50)
        REAL*8 D(50,50),F(50,50),A(50,50),P(50,50),SERI(50,50)
        REAL*8 EO(10,50),EE(10,50),BE(50),RN(50),DINT(50),DINU(50)
        REAL*8 E(10,50),RE(50),LL(10,50),PSRE(50),ZR
        REAL*8 BASESE(50),CALSE(50),BASEN(50),BASEE(50),BASEBE(50)
        REAL*8 FOREBE(50),FA(50),FORENC(50),FOREH(50,50),FOREG(50,50)
C       FILENAME DECLARATION
        CHARACTER*20 FILENA
C
C NOTE: THE VARIABLE AD REPRESENTS THE MAXIMUM DATA SET ARRAY DIMENSION
C AVAILABLE FOR THIS COMPILATION.  IT SHOULD BE SET TO THE SAME VALUE
C THAT IS IN PARENTHESES IN ALL OF THE REAL*8 DECLARATIONS.
C THE VALUE OF AD MUST BE SET
C AT COMPILE TIME.  TO RUN THE PROGRAM WITH A DATA SET LARGER THAN THE
C CURRENT VALUE OF AD YOU MUST RECOMPILE WITH THE NEW VALUE OF AD SET
C AND UPDATED DECLARATIONS. WARNING!: AS AD GROWS LARGER THE PROGRAM 
C WILL USE EXPONENTIALLY MORE MEMORY AND RUN SLOWER.
        AD=50
C
C
C       GET INPUT FILE NAME
        WRITE (*,'(A)')' ENTER THE NAME OF THE INPUT FILE: '
        READ (*,'(A)') FILENA
        OPEN (2, FILE = FILENA, STATUS = 'OLD')
C
C       GET OUTPUT FILE NAME
        WRITE (*,'(A)')' ENTER THE NAME OF THE OUTPUT FILE: '
        READ (*,'(A)') FILENA
        OPEN (3, FILE = FILENA, STATUS = 'UNKNOWN')
C
C
C       READ IN INPUT VALUES
        READ (2,*) DIM
        READ (2,*) ((CALH(I,J),CALG(I,J),J=1,DIM),I=1,DIM)
        READ (2,*) ((CALINR(I,J),J=1,DIM),I=1,DIM)
	READ (2,*) (BASEP(I),BASEE(I),CALP(I),CALE(I),I=1,DIM)
        READ (2,*) (BASER(I),CALR(I),BASESE(I),CALSE(I),I=1,DIM)
        READ (2,*) (BASEN(I),BASEBE(I),BASEE(I),I=1,DIM)
        READ (2,*) (SF(I,I),SA(I,I),I=1,DIM)
        READ (2,*) ((FOREINR(I,J),J=1,DIM),I=1,DIM)
        READ (2,*) (FOREBE(I),I=1,DIM)
        READ (2,*) (FORENC(I),I=1,DIM)
        READ (2,*) MRT
        READ (2,*) TUOUT
        READ (2,*) ((FOREH(I,J),FOREG(I,J),J=1,DIM),I=1,DIM)
        READ (2,*) (SF(I,I),SA(I,I),I=1,DIM)
C
C
C	PRINT PROGRAM DESCRIPTION
        WRITE (3, '(A)') 'COMPUTER PROGRAM FOR AGGREGATE AND DISAGGREGAT
     1E CASE '
        WRITE (3, '(A)') 'VARIATION FOR 25MPH PRT SYSTEM'
	WRITE (3,*)
C
C	INITIALIZE INTERNAL VARIABLES
        LOOP=1
        K=0
        CALI=1.
        CRIT=0.
        SPOP=0.
        SEMP=0.
        SRE=0.
        BASESPOP=0.
        BASESEMP=0.
        BASESRE=0.
        EXT=0.
        ZR=5.
        ACCE=0.
        DO 3 I=1,DIM
           ID(I)=0
           FA(I)=SF(I,I)*SA(I,I)
           RE(I)=CALR(I)+CALSE(I)
           RN(I)=CALP(I)
           PSRE(I)=0.
           EE(2,I)=0.
           SPOP=SPOP+RN(I)
           SEMP=SEMP+CALE(I)
           SRE=SRE+RE(I)
           EE(1,I)=FOREBE(I)
           E(1,I)=EE(1,I)
           E(2,I)=0.
            IF (E(1,I) .GE. 0.) GO TO 1
               WRITE (3,970)
1            DO 2 J=1,2
2              POP(J,I)=0.
3	CONTINUE
        AVF=SPOP/SEMP
        AVA=SRE/SPOP
        DO 8 I=1,DIM
           DO 8 J=1,DIM
           T(I,J)=FOREH(I,J)
           U(I,J)=FOREG(I,J)
           R(I,J)=FOREINR(I,J)
           IF (J.EQ.I) GO TO 5
           SERI(I,J)=0.
           P(I,J)=0.
           SF(I,J)=0.
           SA(I,J)=0.
           GO TO 8
5          SERI(I,I)=1.
           P(I,I)=1.
8       CONTINUE
        WRITE (3,915)
        WRITE (3,*)
        DO 15 J=1,DIM
C	  ECHO PRINT F, A, AND FA
          WRITE (3,920) J,SF(J,J),J,SA(J,J),J,FA(J)
15         CONTINUE
        DO 16 I=1,4 
16         WRITE (3,*)
        DO 17 I=1,DIM
           BE(I)=CALE(I)-RE(I)
17      WRITE (3,925) I,FOREBE(I),BE(I)
        WRITE (3,*)
        WRITE (3,930) SEMP
        WRITE (3,935) SRE
        WRITE (3,940) SPOP
        DO 20 I=1,DIM
           DINT(I)=0.
           DINU(I)=0.
           DO 20 J=1,DIM
           IF (U(I,J).LT.0.)  U(I,J)=0.
           IF (T(I,J).LT.0.)  T(I,J)=0.
              DINT(I)=DINT(I)+RN(J)*T(I,J)
              DINU(I)=DINU(I)+RE(J)*U(I,J)
20      CONTINUE
        ITER=1
        DO 50 I=1,3
50         WRITE (3,*)
        WRITE (3,1080)
        WRITE (3,*)
        DO 250 I=1,DIM
           DO 250 J=1,DIM
           T(I,J)=RN(J)*T(I,J)/DINT(I)
           U(I,J)=RE(J)*U(I,J)/DINU(I)
           AA(I,J)=T(I,J)
           BB(I,J)=U(I,J)
250     CONTINUE
260     CALL DGEMM (DIM,DIM,DIM,1.0D+0,T,AD,SF,AD,0.0D+0,F,AD)
270     CALL DGEMM (2,DIM,DIM,1.0D+0,EE,10,F,AD,0.0D+0,LL,10)
280     CALL DGEMM (DIM,DIM,DIM,1.0D+0,U,AD,SA,AD,0.0D+0,A,AD)
305     CALL DGEMM (2,DIM,DIM,1.0D+0,LL,10,A,AD,0.0D+0,EO,10)
           DO 320 I=1,DIM
              IF (EO(1,I) .GE.0.) GO TO 310
              WRITE (3,875) I,EO(1,I),CALI,LOOP,K
                 GO TO 870
310            IF (EO(1,I) .GE. ZR .OR. PSRE(I) .GE. ZR) GO TO 315
               PSRE(I)=EO(1,I)
                  GO TO 320
315            PSRE(I)=PSRE(I)+EO(1,I)
320        CONTINUE
335     DO 380 I=1,DIM
           IF (PSRE(I) .GE. ZR .OR. PSRE(I) .LT. 0.001) GO TO 380
340        DO 370 J=1,DIM
             IF (PSRE(J) .GE. ZR) GO TO 350
             LIM2(J)=0.
                GO TO 370
350          LIM2(J)=1.
370        CONTINUE
              GO TO 385
380     CONTINUE
              GO TO 420
385     DO 400 I=1,DIM
           SUM=0.
           DO 390 J=1,DIM
             U(I,J)=BB(I,J)
390          SUM=SUM+U(I,J)*LIM2(J)
             IF (SUM .EQ. 0.) SUM=0.000001
           DO 395 JJ=1,DIM
395          U(I,JJ)=U(I,JJ)*LIM2(JJ)/SUM
400        CONTINUE
        CALI=CALI+1.
        IF (CALI .GT. 2.) GO TO 800
           GO TO 280
420     CALL DGEMM (DIM,DIM,DIM,1.0D+0,F,AD,A,AD,0.0D+0,D,AD)
        CALL DGEMM (DIM,DIM,DIM,1.0D+0,P,AD,D,AD,0.0D+0,P,AD)
        CALL ADD (SERI,P,SERI,DIM,DIM)
        CALL ADDD (E,EO,E,2,DIM)
        CALL ADDD (POP,LL,POP,2,DIM)
        DO 425 I=1,DIM
           DO 425 J=1,DIM
           IF (P(I,J) .LT. 100.) GO TO 424
              GO TO 870
424        CONTINUE
           IF (P(I,J) .LT. 0.000001) GO TO 425
               GO TO 428
425     CONTINUE
          GO TO 485
428     LOOP=LOOP+1
        CALI=1.
        IF (LOOP .GT. 20) GO TO 800
        DO 440 I=1,DIM
429        LIM1(I)=1.-POP(1,I)/(FORENC(I))
           IF (LIM1(I) .GT. 1.) GO TO 800
           IF (LIM1(I) .GE. 0.) GO TO 440
           EXT=EXT+(POP(1,I)-FORENC(I))
           POP(1,I)=FORENC(I)
           LIM1(I)=0.
430        ID(I)=I
           K=K+1
440     CONTINUE
        DO 443 J=1,DIM
443      ACCE=ACCE+LIM1(J)
         DO 445 I=1,DIM
         IF (I .EQ. ID(I)) GO TO 445
         POP(1,I)=POP(1,I)+EXT*LIM1(I)/ACCE
445      CONTINUE
        DO 460 I=1,DIM
           SUM=0.
           DO 450 J=1,DIM
           T(I,J)=AA(I,J)
450        SUM=SUM+T(I,J)*LIM1(J)
           IF (SUM .EQ. 0.) SUM=0.000001
           DO 452 JJ=1,DIM
452              T(I,JJ)=T(I,JJ)*LIM1(JJ)/SUM
460     CONTINUE
        DO 480 I=1,DIM
           EE(1,I)=EO(1,I)
           DO 480 J=1,DIM
480        U(I,J)=BB(I,J)
           ACCE=0.
           EXT=0.
               GO TO 260
485     DO 490 I=1,DIM
490	   WRITE(3,950) I,E(1,I),BASEE(I)
           DO 493 I=1,3
493           WRITE(3,*)
        DO 495 I=1,DIM
           FORESPOP=FORESPOP+POP(1,I)
           FORESRE=FORESRE+(E(1,I)-FOREBE(I))
           FORESEMP=FORESEMP+E(1,I)
495        WRITE(3,1000) I,POP(1,I),CALP(I)
           WRITE (3,*)
           WRITE (3,930) FORESEMP
           WRITE (3,935) FORESRE
           WRITE (3,940) FORESPOP
           WRITE (3,*)
           WRITE (3,1050) LOOP
        IF (ITER .EQ. 2) GO TO 870
        DO 500 I=1,DIM
           SF(I,I)=AVF
           SA(I,I)=AVA
           EE(1,I)=FOREBE(I)
           E(1,I)=EE(1,I)
           PSRE(I)=0.
           POP(1,I)=0.
           DO 500 J=1,DIM
              T(I,J)=AA(I,J)
              U(I,J)=BB(I,J)
              IF (J .EQ. I) GO TO 498
                 P(I,J)=0.
                 SERI(I,J)=0.
                   GO TO 500
498              P(I,I)=1.
                 SERI(I,I)=1.
500     CONTINUE
        DO 505 I=1,4
505     WRITE (3,*)
        WRITE (3,1070) AVF,AVA
        WRITE (3,*)
        ITER=ITER+1
        LOOP=1
        CALI=1.
        ACCE=0.
        EXT=0.
        FORESPOP=0.
        FORESRE=0.
        FORESEMP=0.
            GO TO 260
800     WRITE(3,895) CALI,LOOP
           GO TO 870
820     WRITE (3,960)
870     STOP
875       FORMAT (15X,'THE',I5,'TH ZONE WITH NEGATIVE RE=',F10.1,
     1      F5.0,I5,I4)
890       FORMAT (10X,'THE',I2,'TH ROW--THE',I2,'TH COLUMN ENTRY IS',
     1       F10.2,'  BIFURCATION AT LOOP =',I3)
895       FORMAT (20X,'SYSTEM ERROR IN CALIBRATION  ',F4.0,' AT LOOP  ',
     1       I3)
915       FORMAT (20X,'CALIBRATED FJ AND AJ USED IN SYSTEM')
920       FORMAT (10X, 'F',I2,' = ',F8.3,5X,'A',I2,' = ',F8.3,5X,'FA',
     1          I3,' =',F8.3)
925       FORMAT ('FORECAST YEAR BASIC EMPLOY. OF ZONE',I3,' =',
     1     F6.0,'  BASE YEAR DATA IS ',F6.0)
930        FORMAT (20X,'TOTAL EMPLOYMENT   = ',F20.0)
935        FORMAT (20X,'TOTAL RETAIL EMPLOYMENT  =',F15.0)
940       FORMAT (20X,'TOTAL POPULATION  = ',F22.0)
950       FORMAT ('FORECAST EMPLOY. OF ZONE',I4,' =',F10.0,
     1      '  BASE YEAR DATA IS',F9.0)
960       FORMAT  (15X,'RETAIL EMPLOY. AT ZONE',I3,' EXPLODES, LAND
     1      IS NOT ENOUGH')
970       FORMAT (20X,'INITIAL E(I) NEGATIVE')
1000      FORMAT ('FORECAST POPU. OF ZONE',I4,' =',F10.0,
     1      '  BASE YEAR DATA IS',F8.0)
1050      FORMAT (20X,'THE PROGRAM ENDS AT LOOP ',I15)
1070      FORMAT (12X , 'FOR AGGREGATION CASE WITH F =  ',
     1   F6.4,' AND A =  ',F6.4)
1080      FORMAT (15X ,'FOR DISAGGREGATION CASE WITH DIFFERENT A AND F')
          END
C
C
         SUBROUTINE ADD (G,B,C,M,N)
         REAL*8 G(50,50),B(50,50),C(50,50)
         DO 1100 I=1,M
            DO 1100 J=1,N
            C(I,J)=G(I,J)+B(I,J)
1100      CONTINUE
         RETURN
         END
C
C
        SUBROUTINE ADDD (G,H,C,M,N)
        REAL*8 G(10,50),H(10,50),C(10,50)
        DO 1200 I=1,M
           DO 1200 J=1,N
           C(I,J)=G(I,J)+H(I,J)
1200    CONTINUE
        RETURN
        END
C
C
        SUBROUTINE DGEMM (M,N,K,ALPHA,A,LDA,B,LDB,BETA,C,LDC)
        INTEGER            M, N, K, LDA, LDB, LDC
        DOUBLE PRECISION   ALPHA, BETA
        DOUBLE PRECISION   A( LDA, * ), B( LDB, * ), C( LDC, * )
        INTRINSIC          MAX
        INTEGER            I, J, L
        DOUBLE PRECISION   TEMP
        DOUBLE PRECISION   ONE         , ZERO
        PARAMETER        ( ONE = 1.0D+0, ZERO = 0.0D+0 )
C           Form  C := alpha*A*B + beta*C.
C
        DO 13090, J = 1, N
          IF( BETA.EQ.ZERO )THEN
          DO 13050, I = 1, M
            C( I, J ) = ZERO
13050     CONTINUE
          ELSE IF( BETA.NE.ONE )THEN
          DO 13060, I = 1, M
            C( I, J ) = BETA*C( I, J )
13060     CONTINUE
          END IF
          DO 13080, L = 1, K
            IF( B( L, J ).NE.ZERO )THEN
            TEMP = ALPHA*B( L, J )
            DO 13070, I = 1, M
              C( I, J ) = C( I, J ) + TEMP*A( I, L )
13070       CONTINUE
            END IF
13080     CONTINUE
13090   CONTINUE
C
        RETURN
C
C     End of DGEMM .
C
        END
